/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity.GTMetaTileEntity;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import goodgenerator.client.GUI.NeutronSensorGUIClient;
import goodgenerator.common.container.NeutronSensorGUIContainer;
import goodgenerator.main.GoodGenerator;
import goodgenerator.network.MessageOpenNeutronSensorGUI;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.render.TextureFactory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class NeutronSensor
extends GT_MetaTileEntity_Hatch {
    private static final IIconContainer textureFont = new Textures.BlockIcons.CustomIcon("icons/NeutronSensorFont");
    private static final IIconContainer textureFont_Glow = new Textures.BlockIcons.CustomIcon("icons/NeutronSensorFont_GLOW");
    protected String texts = "";
    boolean isOn = false;

    public NeutronSensor(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, "Detect Neutron Kinetic Energy.", new ITexture[0]);
    }

    public NeutronSensor(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    public String[] getDescription() {
        return new String[]{"Can be installed in Neutron Activator.", "Output Redstone Signal according to the Neutron Kinetic Energy.", "Right click to open the GUI and setting."};
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.texts = aNBT.func_74779_i("mBoxContext");
        super.loadNBTData(aNBT);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74778_a("mBoxContext", this.texts);
        super.saveNBTData(aNBT);
    }

    public void initDefaultModes(NBTTagCompound aNBT) {
        this.getBaseMetaTileEntity().setActive(true);
    }

    public boolean isValidSlot(int aIndex) {
        return false;
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new NeutronSensorGUIClient(aPlayerInventory, aBaseMetaTileEntity, "GoodGenerator:textures/gui/NeutronSensorGUI.png", this.texts);
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new NeutronSensorGUIContainer(aPlayerInventory, aBaseMetaTileEntity);
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        if (aSide == aBaseMetaTileEntity.getFrontFacing() && aPlayer instanceof EntityPlayerMP) {
            GoodGenerator.CHANNEL.sendTo((IMessage)new MessageOpenNeutronSensorGUI(aBaseMetaTileEntity, this.texts), (EntityPlayerMP)aPlayer);
            return true;
        }
        return false;
    }

    public void setText(String text) {
        this.texts = text == null ? "" : text;
    }

    public String getText() {
        return this.texts == null ? "" : this.texts;
    }

    public void outputRedstoneSignal() {
        this.isOn = true;
    }

    public void stopOutputRedstoneSignal() {
        this.isOn = false;
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)textureFont), TextureFactory.builder().addIcon(new IIconContainer[]{textureFont_Glow}).glow().build()};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)textureFont)};
    }

    public boolean allowGeneralRedstoneOutput() {
        return true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.isOn) {
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                aBaseMetaTileEntity.setInternalOutputRedstoneSignal(i, (byte)15);
            }
        } else {
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                aBaseMetaTileEntity.setInternalOutputRedstoneSignal(i, (byte)0);
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new NeutronSensor(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }
}

