/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.util;

import codechicken.nei.PositionedStack;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MyRecipeAdder {
    public static final MyRecipeAdder instance = new MyRecipeAdder();
    public final liquidMentalFuelMapper NqGFuels = new liquidMentalFuelMapper(new HashSet<GT_Recipe>(50), "gg.recipe.naquadah_reactor", StatCollector.func_74838_a((String)"tile.recipe.naquadah_reactor"), null, "goodgenerator:textures/gui/naquadah_reactor", 0, 0, 0, 1, 1, StatCollector.func_74838_a((String)"value.naquadah_reactor") + " ", 1, " EU/t", false, true);
    public final NaqFuelRefineMapper FRF = new NaqFuelRefineMapper(new HashSet<GT_Recipe>(50), "gg.recipe.naquadah_fuel_refine_factory", StatCollector.func_74838_a((String)"tile.naquadah_fuel_refine_factory"), null, "gregtech:textures/gui/basicmachines/FusionReactor", 6, 0, 0, 1, 1, StatCollector.func_74838_a((String)"value.naquadah_fuel_refine_factory.0") + " ", 1, StatCollector.func_74838_a((String)"value.naquadah_fuel_refine_factory.1"), true, true);
    public final NeutronActivatorMapper NA = new NeutronActivatorMapper(new HashSet<GT_Recipe>(150), "gg.recipe.neutron_activator", StatCollector.func_74838_a((String)"tile.neutron_activator"), null, "goodgenerator:textures/gui/neutron_activator", 6, 6, 0, 0, 0, null, 0, null, false, false);
    public final ExtremeHeatExchangerMapper XHE = new ExtremeHeatExchangerMapper(new HashSet<GT_Recipe>(50), "gg.recipe.extreme_heat_exchanger", StatCollector.func_74838_a((String)"tile.extreme_heat_exchanger"), null, "goodgenerator:textures/gui/extreme_heat_exchanger", 0, 0, 0, 0, 0, null, 0, null, false, false);
    public final PreciseAssemblerMapper PA = new PreciseAssemblerMapper(new HashSet<GT_Recipe>(120), "gg.recipe.precise_assembler", StatCollector.func_74838_a((String)"tile.precise_assembler"), null, "goodgenerator:textures/gui/precise_assembler", 4, 1, 1, 0, 1, StatCollector.func_74838_a((String)"value.precise_assembler.0"), 1, StatCollector.func_74838_a((String)"value.precise_assembler.1"), true, false);
    public static HashMap<Fluid, ExtremeHeatExchangerRecipe> mXHeatExchangerFuelMap = new HashMap();

    public void addLiquidMentalFuel(FluidStack input, FluidStack output, int EUt, int ticks) {
        this.NqGFuels.addFuel(input, output, EUt, ticks);
    }

    public void addNaquadahFuelRefineRecipe(FluidStack[] input1, ItemStack[] input2, FluidStack output, int EUt, int ticks, int tier) {
        this.FRF.addNaqFuelRefineRecipe(input1, input2, output, EUt, ticks, tier);
    }

    public void addNeutronActivatorRecipe(FluidStack[] input1, ItemStack[] input2, FluidStack[] output1, ItemStack[] output2, int ticks, int maxNKE, int minNKE) {
        if (maxNKE <= 0) {
            maxNKE = 1;
        }
        if (maxNKE >= 1100) {
            maxNKE = 1100;
        }
        if (minNKE < 0) {
            minNKE = 0;
        }
        if (minNKE >= maxNKE) {
            minNKE = maxNKE - 1;
        }
        this.NA.addNARecipe(input1, input2, output1, output2, ticks, maxNKE * 10000 + minNKE);
    }

    public void addExtremeHeatExchangerRecipe(FluidStack HotFluid, FluidStack ColdFluid, FluidStack WorkFluid, FluidStack HeatedWorkFluid, FluidStack OverHeatedWorkFluid, int Threshold) {
        this.XHE.addRecipe(false, null, null, null, null, new FluidStack[]{HotFluid, WorkFluid}, new FluidStack[]{HeatedWorkFluid, OverHeatedWorkFluid, ColdFluid}, 0, 0, Threshold);
    }

    public void addPreciseAssemblerRecipe(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, ItemStack aOutput, int aEUt, int aDuration, int aTier) {
        if (aOutput == null) {
            return;
        }
        this.PA.addRecipe(false, aItemInputs, new ItemStack[]{aOutput}, null, null, aFluidInputs, null, aDuration, aEUt, aTier);
    }

    public static class PreciseAssemblerRecipe
    extends GT_Recipe {
        public PreciseAssemblerRecipe(ItemStack[] input1, FluidStack[] input2, ItemStack output, int EUt, int ticks, int tier) {
            super(false, input1, new ItemStack[]{output}, null, null, input2, null, ticks, EUt, tier);
        }

        public ArrayList<PositionedStack> getInputPositionedStacks() {
            int index;
            ArrayList<PositionedStack> inputStacks = new ArrayList<PositionedStack>();
            if (this.mFluidInputs != null) {
                index = 0;
                for (FluidStack fluidStack : this.mFluidInputs) {
                    if (fluidStack == null) continue;
                    inputStacks.add(new PositionedStack((Object)GT_Utility.getFluidDisplayStack((FluidStack)fluidStack, (boolean)true), 4 + index * 18, 38));
                    ++index;
                }
            }
            if (this.mInputs != null) {
                index = 0;
                for (FluidStack fluidStack : this.mInputs) {
                    if (fluidStack == null) continue;
                    inputStacks.add(new PositionedStack((Object)fluidStack, 4 + index * 18, 3));
                    ++index;
                }
            }
            return inputStacks;
        }

        public ArrayList<PositionedStack> getOutputPositionedStacks() {
            ArrayList<PositionedStack> outputStacks = new ArrayList<PositionedStack>();
            if (this.mOutputs != null && this.mOutputs.length > 0) {
                outputStacks.add(new PositionedStack((Object)this.mOutputs[0], 111, 20));
            }
            return outputStacks;
        }
    }

    public static class PreciseAssemblerMapper
    extends GT_Recipe.GT_Recipe_Map {
        public PreciseAssemblerMapper(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        public GT_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            PreciseAssemblerRecipe tRecipe = new PreciseAssemblerRecipe(aInputs, aFluidInputs, aOutputs[0], aEUt, aDuration, aSpecialValue);
            return this.addRecipe(tRecipe);
        }
    }

    public static class ExtremeHeatExchangerRecipe
    extends GT_Recipe {
        public ExtremeHeatExchangerRecipe(FluidStack[] input, FluidStack[] output, int special) {
            super(false, null, null, null, null, input, output, 0, 0, special);
        }

        public ArrayList<PositionedStack> getInputPositionedStacks() {
            ArrayList<PositionedStack> inputStacks = new ArrayList<PositionedStack>();
            if (this.mFluidInputs != null && this.mFluidInputs.length == 2) {
                inputStacks.add(new PositionedStack((Object)GT_Utility.getFluidDisplayStack((FluidStack)this.mFluidInputs[0], (boolean)true), 22, 3));
                inputStacks.add(new PositionedStack((Object)GT_Utility.getFluidDisplayStack((FluidStack)this.mFluidInputs[1], (boolean)true), 22, 27));
            }
            return inputStacks;
        }

        public ArrayList<PositionedStack> getOutputPositionedStacks() {
            ArrayList<PositionedStack> outputStacks = new ArrayList<PositionedStack>();
            if (this.mFluidOutputs != null && this.mFluidOutputs.length == 3) {
                outputStacks.add(new PositionedStack((Object)GT_Utility.getFluidDisplayStack((FluidStack)this.mFluidOutputs[0], (boolean)true), 124, 3));
                outputStacks.add(new PositionedStack((Object)GT_Utility.getFluidDisplayStack((FluidStack)this.mFluidOutputs[1], (boolean)true), 124, 21));
                outputStacks.add(new PositionedStack((Object)GT_Utility.getFluidDisplayStack((FluidStack)this.mFluidOutputs[2], (boolean)true), 124, 44));
            }
            return outputStacks;
        }

        public int getMaxHotFluidConsume() {
            if (this.mFluidInputs != null) {
                return this.mFluidInputs[0].amount;
            }
            return 0;
        }

        public Fluid getNormalSteam() {
            if (this.mFluidOutputs != null) {
                return this.mFluidOutputs[0].getFluid();
            }
            return null;
        }

        public Fluid getHeatedSteam() {
            if (this.mFluidOutputs != null) {
                return this.mFluidOutputs[1].getFluid();
            }
            return null;
        }

        public Fluid getCooledFluid() {
            if (this.mFluidOutputs != null) {
                return this.mFluidOutputs[2].getFluid();
            }
            return null;
        }

        public int getEUt() {
            if (this.getNormalSteam() != null) {
                switch (this.getNormalSteam().getName()) {
                    case "steam": {
                        int tVal = this.mFluidInputs[1].amount * 4;
                        if (tVal < 0) {
                            tVal = -tVal;
                        }
                        return tVal;
                    }
                    case "ic2superheatedsteam": {
                        int tVal = this.mFluidInputs[1].amount * 8;
                        if (tVal < 0) {
                            tVal = -tVal;
                        }
                        return tVal;
                    }
                    case "supercriticalsteam": {
                        int tVal = this.mFluidInputs[1].amount * 800;
                        if (tVal < 0) {
                            tVal = -tVal;
                        }
                        return tVal;
                    }
                }
                return 0;
            }
            return 0;
        }
    }

    public static class ExtremeHeatExchangerMapper
    extends GT_Recipe.GT_Recipe_Map {
        public ExtremeHeatExchangerMapper(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        public GT_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            ExtremeHeatExchangerRecipe tRecipe = new ExtremeHeatExchangerRecipe(aFluidInputs, aFluidOutputs, aSpecialValue);
            mXHeatExchangerFuelMap.put(aFluidInputs[0].getFluid(), tRecipe);
            return this.addRecipe(tRecipe);
        }
    }

    public static class NeutronActivatorMapper
    extends GT_Recipe.GT_Recipe_Map {
        public NeutronActivatorMapper(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        public void addNARecipe(FluidStack[] input1, ItemStack[] input2, FluidStack[] output1, ItemStack[] output2, int ticks, int special) {
            super.addRecipe(false, input2, output2, null, input1, output1, ticks, 0, special);
        }
    }

    public static class NaqFuelRefineMapper
    extends GT_Recipe.GT_Recipe_Map {
        public NaqFuelRefineMapper(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        public void addNaqFuelRefineRecipe(FluidStack[] input1, ItemStack[] input2, FluidStack output, int EUt, int ticks, int tier) {
            super.addRecipe(false, input2, null, null, input1, new FluidStack[]{output}, ticks, EUt, tier);
        }
    }

    public static class liquidMentalFuelMapper
    extends GT_Recipe.GT_Recipe_Map_Fuel {
        public liquidMentalFuelMapper(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        public void addFuel(FluidStack input, FluidStack output, int EUt, int ticks) {
            super.addRecipe(true, null, null, null, new FluidStack[]{input}, new FluidStack[]{output}, ticks, 0, EUt);
        }
    }
}

