/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.github.bartimaeusnek.bartworks.common.loaders.ItemRegistry;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.blocks.tileEntity.GTMetaTileEntity.YOTTAHatch;
import goodgenerator.client.GUI.YOTTankGUIClient;
import goodgenerator.common.container.YOTTankGUIContainer;
import goodgenerator.loader.Loaders;
import goodgenerator.util.CharExchanger;
import goodgenerator.util.DescTextLocalization;
import goodgenerator.util.StructureHelper;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

public class YottaFluidTank
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable {
    private static final IIconContainer textureFontOn = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QTANK");
    private static final IIconContainer textureFontOn_Glow = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QTANK_GLOW");
    private static final IIconContainer textureFontOff = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QCHEST");
    private static final IIconContainer textureFontOff_Glow = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QCHEST_GLOW");
    protected IStructureDefinition<YottaFluidTank> multiDefinition = null;
    protected final ArrayList<YOTTAHatch> mYottaHatch = new ArrayList();
    public BigInteger mStorage = new BigInteger("0", 10);
    public BigInteger mStorageCurrent = new BigInteger("0", 10);
    public String mFluidName = "";
    protected int glassMeta;
    protected int maxCell;
    protected final String YOTTANK_BOTTOM = this.mName + "buttom";
    protected final String YOTTANK_MID = this.mName + "mid";
    protected final String YOTTANK_TOP = this.mName + "top";

    public YottaFluidTank(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public YottaFluidTank(String name) {
        super(name);
    }

    public int getMeta() {
        return this.glassMeta;
    }

    public void setMeta(int meta) {
        this.glassMeta = meta;
    }

    public String getCap() {
        return this.mStorage.toString(10);
    }

    public String getStored() {
        return this.mStorageCurrent.toString(10);
    }

    public String getFluidName() {
        if (this.mFluidName == null || this.mFluidName.equals("") || FluidRegistry.getFluidStack((String)this.mFluidName, (int)1) == null) {
            return "Empty";
        }
        return FluidRegistry.getFluidStack((String)this.mFluidName, (int)1).getLocalizedName();
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        String tAmount = aNBT.func_74779_i("mStorage");
        String tAmountCurrent = aNBT.func_74779_i("mStorageCurrent");
        if (tAmount == null || tAmount.equals("")) {
            tAmount = "0";
        }
        if (tAmountCurrent == null || tAmountCurrent.equals("")) {
            tAmountCurrent = "0";
        }
        this.mStorage = new BigInteger(tAmount, 10);
        this.mStorageCurrent = new BigInteger(tAmountCurrent, 10);
        this.mFluidName = aNBT.func_74779_i("mFluidName");
        super.loadNBTData(aNBT);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74778_a("mStorage", this.mStorage.toString(10));
        aNBT.func_74778_a("mStorageCurrent", this.mStorageCurrent.toString(10));
        aNBT.func_74778_a("mFluidName", this.mFluidName);
        super.saveNBTData(aNBT);
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        this.mEUt = 0;
        this.mMaxProgresstime = 20;
        return true;
    }

    public boolean reduceFluid(int amount) {
        BigInteger tmp = new BigInteger(amount + "");
        if (this.mStorageCurrent.compareTo(tmp) < 0) {
            return false;
        }
        this.mStorageCurrent = this.mStorageCurrent.subtract(tmp);
        return true;
    }

    public boolean addFluid(int amount) {
        BigInteger tmp = new BigInteger(amount + "");
        if (this.mStorage.subtract(this.mStorageCurrent).compareTo(tmp) < 0) {
            return false;
        }
        this.mStorageCurrent = this.mStorageCurrent.add(tmp);
        return true;
    }

    private int calGlassTier(int meta) {
        if (meta >= 1 && meta <= 6) {
            return meta;
        }
        if (meta >= 7 && meta <= 12) {
            return 1;
        }
        return 3;
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mStorage = BigInteger.ZERO;
        this.glassMeta = 0;
        this.mYottaHatch.clear();
        if (!this.structureCheck_EM(this.YOTTANK_BOTTOM, 2, 0, 0)) {
            return false;
        }
        int cnt = 0;
        while (this.structureCheck_EM(this.YOTTANK_MID, 2, cnt + 1, 0)) {
            ++cnt;
        }
        if (cnt > 15 || cnt < 1) {
            return false;
        }
        if (!this.structureCheck_EM(this.YOTTANK_TOP, 2, cnt + 2, 0)) {
            return false;
        }
        if (this.mMaintenanceHatches.size() == 1 && this.maxCell + 1 <= this.calGlassTier(this.glassMeta)) {
            if (this.mStorage.compareTo(this.mStorageCurrent) < 0) {
                this.mStorageCurrent = this.mStorage;
            }
            if (FluidRegistry.getFluidStack((String)this.mFluidName, (int)1) == null) {
                this.mStorageCurrent = BigInteger.ZERO;
                this.mFluidName = "";
            }
            return true;
        }
        return false;
    }

    public IStructureDefinition<YottaFluidTank> getStructure_EM() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.YOTTANK_BOTTOM, StructureUtility.transpose((String[][])new String[][]{{"MM~MM", "MCCCM", "MCCCM", "MCCCM", "MMMMM"}, {"     ", " OOO ", " OOO ", " OOO ", "     "}})).addShape(this.YOTTANK_MID, StructureUtility.transpose((String[][])new String[][]{{"GGGGG", "GRRRG", "GRRRG", "GRRRG", "GGGGG"}})).addShape(this.YOTTANK_TOP, StructureUtility.transpose((String[][])new String[][]{{"FFFFF", "F   F", "F   F", "F   F", "FFFFF"}, {"CCCCC", "CIIIC", "CIIIC", "CIIIC", "CCCCC"}})).addElement(Character.valueOf('C'), StructureUtility.ofBlock((Block)Loaders.yottaFluidTankCasing, (int)0)).addElement(Character.valueOf('G'), StructureHelper.addTieredBlock(ItemRegistry.bw_realglas, YottaFluidTank::setMeta, YottaFluidTank::getMeta, 12)).addElement(Character.valueOf('R'), (IStructureElement)StructureUtility.ofChain(this.cells(10))).addElement(Character.valueOf('F'), StructureHelper.addFrame(Materials.Steel)).addElement(Character.valueOf('I'), GT_StructureUtility.ofHatchAdderOptional(YottaFluidTank::addInput, (int)1537, (int)1, (Block)Loaders.yottaFluidTankCasing, (int)0)).addElement(Character.valueOf('M'), GT_StructureUtility.ofHatchAdderOptional(GT_MetaTileEntity_MultiblockBase_EM::addClassicMaintenanceToMachineList, (int)1537, (int)2, (Block)Loaders.yottaFluidTankCasing, (int)0)).addElement(Character.valueOf('O'), GT_StructureUtility.ofHatchAdderOptional(YottaFluidTank::addOutput, (int)1537, (int)3, (Block)Loaders.yottaFluidTankCasing, (int)0)).build();
        }
        return this.multiDefinition;
    }

    public List<IStructureElement<YottaFluidTank>> cells(int num) {
        ArrayList<IStructureElement<YottaFluidTank>> out = new ArrayList<IStructureElement<YottaFluidTank>>();
        for (int i = 0; i < num; ++i) {
            int finalI = i;
            out.add((IStructureElement<YottaFluidTank>)StructureUtility.onElementPass(x -> {
                x.mStorage = x.mStorage.add(this.calStorage(finalI));
                x.maxCell = Math.max(x.maxCell, finalI);
            }, (IStructureElement)StructureUtility.ofBlock((Block)Loaders.yottaFluidTankCell, (int)i)));
        }
        return out;
    }

    public final boolean addInput(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        return false;
    }

    public final boolean addOutput(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof YOTTAHatch) {
            if (!this.mYottaHatch.isEmpty()) {
                return false;
            }
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((YOTTAHatch)aMetaTileEntity).setTank(this);
            return this.mYottaHatch.add((YOTTAHatch)aMetaTileEntity);
        }
        return false;
    }

    public String[] getInfoData() {
        return new String[]{StatCollector.func_74838_a((String)"scanner.info.YOTTank.0") + " " + EnumChatFormatting.GREEN + CharExchanger.formatNumber(this.getCap()) + EnumChatFormatting.RESET + " L", StatCollector.func_74838_a((String)"scanner.info.YOTTank.1") + " " + EnumChatFormatting.YELLOW + CharExchanger.formatNumber(this.getFluidName()) + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"scanner.info.YOTTank.2") + " " + EnumChatFormatting.BLUE + CharExchanger.formatNumber(this.getStored()) + EnumChatFormatting.RESET + " L"};
    }

    public String[] getDescription() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Fluid Tank").addInfo("Controller block for the YOTTank.").addInfo("The max output speed is decided by the amount of stored liquid and the output hatch's capacity.").addInfo("The max fluid cell tier is limited by the glass tier.").addInfo("HV glass for T1, EV glass for T2, IV glass for T3. . .").addInfo("The max height of the cell blocks is 15.").addInfo("The structure is too complex!").addInfo(DescTextLocalization.BLUE_PRINT_INFO).addSeparator().beginVariableStructureBlock(5, 5, 1, 15, 5, 5, false).addController("Front of the second layer").addInputHatch("Hint block with dot 1").addMaintenanceHatch("Hint block with dot 2").addOutputHatch("Hint block with dot 3").toolTipFinisher("Good Generator");
        if (!Keyboard.isKeyDown((int)42)) {
            return tt.getInformation();
        }
        return tt.getStructureInformation();
    }

    public BigInteger calStorage(int meta) {
        StringBuilder cap = new StringBuilder();
        cap.append("1000000");
        for (int i = 0; i < meta; ++i) {
            cap.append("00");
        }
        return new BigInteger(cap.toString());
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new YOTTankGUIClient(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "EMDisplay.png");
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new YOTTankGUIContainer(aPlayerInventory, aBaseMetaTileEntity);
    }

    public boolean onRunningTick(ItemStack aStack) {
        super.onRunningTick(aStack);
        if (this.getBaseMetaTileEntity().isServerSide()) {
            ArrayList tStore = this.getStoredFluids();
            for (FluidStack tFluid : tStore) {
                if (tFluid == null || this.mFluidName != null && !this.mFluidName.equals("") && !tFluid.getFluid().getName().equals(this.mFluidName)) continue;
                if (this.mFluidName == null || this.mFluidName.equals("")) {
                    this.mFluidName = tFluid.getFluid().getName();
                }
                if (this.mStorageCurrent.add(new BigInteger(tFluid.amount + "")).compareTo(this.mStorage) < 0) {
                    this.mStorageCurrent = this.mStorageCurrent.add(new BigInteger(tFluid.amount + ""));
                    tFluid.amount = 0;
                    continue;
                }
                BigInteger delta = this.mStorage.subtract(this.mStorageCurrent);
                this.mStorageCurrent = this.mStorageCurrent.add(delta);
                tFluid.amount -= delta.intValue();
            }
            BigInteger outputAmount = this.mStorageCurrent.divide(new BigInteger("100", 10));
            if (outputAmount.compareTo(new BigInteger("2147483647", 10)) > 0) {
                outputAmount = new BigInteger("2147483647");
            }
            if (outputAmount.compareTo(BigInteger.ONE) <= 0) {
                outputAmount = new BigInteger("1", 10);
            }
            if (this.mStorageCurrent.compareTo(BigInteger.ZERO) <= 0) {
                this.mFluidName = "";
            }
            if (this.mFluidName != null && !this.mFluidName.equals("")) {
                for (GT_MetaTileEntity_Hatch outputHatch : this.mOutputHatches) {
                    int leftSpace;
                    FluidStack tHatchFluid = outputHatch.mFluid;
                    FluidStack tOutput = FluidRegistry.getFluidStack((String)this.mFluidName, (int)outputAmount.intValue());
                    if (tHatchFluid != null && tHatchFluid.isFluidEqual(tOutput)) {
                        leftSpace = outputHatch.getCapacity() - tHatchFluid.amount;
                        if (leftSpace < tOutput.amount) {
                            if (!this.reduceFluid(leftSpace)) continue;
                            tHatchFluid.amount += leftSpace;
                            continue;
                        }
                        if (!this.reduceFluid(tOutput.amount)) continue;
                        tHatchFluid.amount += tOutput.amount;
                        continue;
                    }
                    if (tHatchFluid != null) continue;
                    leftSpace = outputHatch.getCapacity();
                    if (leftSpace < tOutput.amount) {
                        if (!this.reduceFluid(leftSpace)) continue;
                        outputHatch.fill(FluidRegistry.getFluidStack((String)this.mFluidName, (int)leftSpace), true);
                        continue;
                    }
                    if (!this.reduceFluid(tOutput.amount)) continue;
                    outputHatch.fill(tOutput, true);
                }
            }
        }
        return true;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(this.YOTTANK_BOTTOM, 2, 0, 0, stackSize, hintsOnly);
        int height = stackSize.field_77994_a;
        if (height > 15) {
            height = 15;
        }
        this.structureBuild_EM(this.YOTTANK_TOP, 2, height + 2, 0, stackSize, hintsOnly);
        while (height > 0) {
            this.structureBuild_EM(this.YOTTANK_MID, 2, height, 0, stackSize, hintsOnly);
            --height;
        }
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return DescTextLocalization.addText("YOTTank.hint", 8);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new YottaFluidTank(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)1537), TextureFactory.of((IIconContainer)textureFontOn), TextureFactory.builder().addIcon(new IIconContainer[]{textureFontOn_Glow}).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)1537), TextureFactory.of((IIconContainer)textureFontOff), TextureFactory.builder().addIcon(new IIconContainer[]{textureFontOff_Glow}).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)1537)};
    }
}

