/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import goodgenerator.blocks.tileEntity.base.GT_MetaTileEntity_LargeTurbineBase;
import goodgenerator.loader.Loaders;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class SupercriticalFluidTurbine
extends GT_MetaTileEntity_LargeTurbineBase {
    private boolean looseFit = false;
    private static final IIconContainer turbineOn = new Textures.BlockIcons.CustomIcon("icons/turbines/TURBINE_05");
    private static final IIconContainer turbineOff = new Textures.BlockIcons.CustomIcon("icons/turbines/TURBINE_15");
    private static final IIconContainer turbineEmpty = new Textures.BlockIcons.CustomIcon("icons/turbines/TURBINE_25");

    public SupercriticalFluidTurbine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public SupercriticalFluidTurbine(String aName) {
        super(aName);
    }

    @Override
    public int fluidIntoPower(ArrayList<FluidStack> aFluids, int aOptFlow, int aBaseEff) {
        if (this.looseFit) {
            aOptFlow *= 4;
            double pow = Math.pow(1.1f, (float)(aBaseEff - 7500) / 10000.0f * 20.0f);
            if (aBaseEff > 10000) {
                aOptFlow = (int)((double)aOptFlow * pow);
                aBaseEff = 7500;
            } else if (aBaseEff > 7500) {
                aOptFlow = (int)((double)aOptFlow * pow);
                aBaseEff = (int)((float)aBaseEff * 0.75f);
            } else {
                aBaseEff = (int)((float)aBaseEff * 0.75f);
            }
        }
        int tEU = 0;
        int totalFlow = 0;
        int flow = 0;
        int remainingFlow = GT_Utility.safeInt((long)((long)((float)aOptFlow * 1.25f)));
        this.realOptFlow = aOptFlow;
        this.storedFluid = 0;
        FluidStack tSCSteam = FluidRegistry.getFluidStack((String)"supercriticalsteam", (int)1);
        for (int i = 0; i < aFluids.size() && remainingFlow > 0; ++i) {
            FluidStack aFluidStack = aFluids.get(i);
            if (tSCSteam.isFluidEqual(aFluidStack)) {
                flow = Math.min(aFluidStack.amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluidStack, flow));
                this.storedFluid += aFluidStack.amount;
                remainingFlow -= flow;
                totalFlow += flow;
                continue;
            }
            if (!GT_ModHandler.isAnySteam((FluidStack)aFluidStack)) continue;
            this.depleteInput(new FluidStack(aFluidStack, aFluidStack.amount));
        }
        if (totalFlow <= 0) {
            return 0;
        }
        tEU = totalFlow;
        this.addOutput(GT_ModHandler.getSteam((long)totalFlow));
        if (totalFlow == aOptFlow) {
            tEU = GT_Utility.safeInt((long)((long)tEU * (long)aBaseEff / 100L));
        } else {
            float efficiency = 1.0f - Math.abs((float)(totalFlow - aOptFlow) / (float)aOptFlow);
            tEU = (int)((float)tEU * efficiency);
            tEU = Math.max(1, GT_Utility.safeInt((long)((long)tEU * (long)aBaseEff / 10000L)));
        }
        return tEU;
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aSide == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.looseFit ^= true;
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(this.looseFit ? this.trans("500", "Fitting: Loose - More Flow") : this.trans("501", "Fitting: Tight - More Efficiency")));
        }
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return this.looseFit ? 0 : 10;
    }

    @Override
    public String[] getInfoData() {
        ((GT_MetaTileEntity_LargeTurbineBase)this).looseFit = this.looseFit;
        return super.getInfoData();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("turbineFitting", this.looseFit);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.looseFit = aNBT.func_74767_n("turbineFitting");
    }

    @Override
    public Block getCasingBlock() {
        return Loaders.supercriticalFluidTurbineCasing;
    }

    @Override
    public int getCasingMeta() {
        return 0;
    }

    @Override
    public int getCasingTextureIndex() {
        return 1538;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Supercritical Steam Turbine").addInfo("Controller block for Supercritical Fluid Turbine").addInfo("Needs a Turbine, place inside controller").addInfo("Use Supercritical Steam to generate power.").addInfo("Outputs Steam as well as producing power").addInfo("1L Supercritical Steam = 100 EU").addInfo("Extreme Heated Steam will cause more damage to the turbine.").addInfo("Power output depends on turbine and fitting").addInfo("Use screwdriver to adjust fitting of turbine").addSeparator().beginStructureBlock(3, 3, 4, true).addController("Front center").addCasingInfo("SC Turbine Casing", 24).addDynamoHatch("Back center", new int[]{1}).addMaintenanceHatch("Side centered", new int[]{2}).addMufflerHatch("Side centered", new int[]{2}).addInputHatch("Supercritical Fluid, Side centered", new int[]{2}).toolTipFinisher("Good Generator");
        return tt;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new SupercriticalFluidTurbine(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.BlockIcons.getCasingTextureForId((int)1538);
        iTextureArray[1] = aFacing == aSide ? (aActive ? TextureFactory.of((IIconContainer)turbineOn) : (this.hasTurbine() ? TextureFactory.of((IIconContainer)turbineOff) : TextureFactory.of((IIconContainer)turbineEmpty))) : Textures.BlockIcons.getCasingTextureForId((int)1538);
        return iTextureArray;
    }
}

