/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.blocks.tileEntity.GTMetaTileEntity.NeutronAccelerator;
import goodgenerator.blocks.tileEntity.GTMetaTileEntity.NeutronSensor;
import goodgenerator.client.GUI.NeutronActivatorGUIClient;
import goodgenerator.common.container.NeutronActivatorGUIContainer;
import goodgenerator.loader.Loaders;
import goodgenerator.util.CharExchanger;
import goodgenerator.util.DescTextLocalization;
import goodgenerator.util.ItemRefer;
import goodgenerator.util.MyRecipeAdder;
import goodgenerator.util.StructureHelper;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import ic2.core.Ic2Items;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.RandomUtils;
import org.lwjgl.input.Keyboard;

public class NeutronActivator
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable {
    protected IStructureDefinition<NeutronActivator> multiDefinition = null;
    protected final ArrayList<NeutronAccelerator> mNeutronAccelerator = new ArrayList();
    protected final ArrayList<NeutronSensor> mNeutronSensor = new ArrayList();
    protected int casingAmount = 0;
    protected int height = 0;
    protected int eV = 0;
    protected int mCeil = 0;
    protected int mFloor = 0;
    private static final IIconContainer textureFontOn = new Textures.BlockIcons.CustomIcon("icons/NeutronActivator_On");
    private static final IIconContainer textureFontOn_Glow = new Textures.BlockIcons.CustomIcon("icons/NeutronActivator_On_GLOW");
    private static final IIconContainer textureFontOff = new Textures.BlockIcons.CustomIcon("icons/NeutronActivator_Off");
    private static final IIconContainer textureFontOff_Glow = new Textures.BlockIcons.CustomIcon("icons/NeutronActivator_Off_GLOW");
    protected final String NA_BOTTOM = this.mName + "buttom";
    protected final String NA_MID = this.mName + "mid";
    protected final String NA_TOP = this.mName + "top";

    public NeutronActivator(String name) {
        super(name);
    }

    public NeutronActivator(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        int j;
        int i;
        this.mEfficiency = 10000;
        ArrayList tFluids = this.getStoredFluids();
        ArrayList tItems = this.getStoredInputs();
        Collection tRecipes = MyRecipeAdder.instance.NA.mRecipeList;
        block0: for (i = 0; i < tFluids.size() - 1; ++i) {
            for (j = i + 1; j < tFluids.size(); ++j) {
                if (!GT_Utility.areFluidsEqual((FluidStack)((FluidStack)tFluids.get(i)), (FluidStack)((FluidStack)tFluids.get(j)))) continue;
                if (((FluidStack)tFluids.get((int)i)).amount >= ((FluidStack)tFluids.get((int)j)).amount) {
                    tFluids.remove(j--);
                    continue;
                }
                tFluids.remove(i--);
                continue block0;
            }
        }
        block2: for (i = 0; i < tItems.size() - 1; ++i) {
            for (j = i + 1; j < tItems.size(); ++j) {
                if (!GT_Utility.areStacksEqual((ItemStack)((ItemStack)tItems.get(i)), (ItemStack)((ItemStack)tItems.get(j)))) continue;
                if (((ItemStack)tItems.get((int)i)).field_77994_a >= ((ItemStack)tItems.get((int)j)).field_77994_a) {
                    tItems.remove(j--);
                    continue;
                }
                tItems.remove(i--);
                continue block2;
            }
        }
        FluidStack[] inFluids = tFluids.toArray(new FluidStack[0]);
        ItemStack[] inItems = tItems.toArray(new ItemStack[0]);
        for (GT_Recipe recipe : tRecipes) {
            int minNKE = recipe.mSpecialValue % 10000 * 1000000;
            int maxNKE = recipe.mSpecialValue / 10000 * 1000000;
            if (!recipe.isRecipeInputEqual(true, inFluids, inItems)) continue;
            this.mFloor = minNKE;
            this.mCeil = maxNKE;
            this.mMaxProgresstime = Math.max((int)((double)recipe.mDuration * Math.pow(0.9, this.height - 4)), 1);
            if (this.eV <= maxNKE && this.eV >= minNKE) {
                this.mOutputFluids = recipe.mFluidOutputs;
                this.mOutputItems = recipe.mOutputs;
            } else {
                this.mOutputFluids = null;
                this.mOutputItems = new ItemStack[]{ItemRefer.Radioactive_Waste.get(4)};
            }
            return true;
        }
        return false;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new NeutronActivatorGUIClient(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "EMDisplay.png");
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new NeutronActivatorGUIContainer(aPlayerInventory, aBaseMetaTileEntity);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.eV = aNBT.func_74762_e("mKeV");
        this.mCeil = aNBT.func_74762_e("mCeil");
        this.mFloor = aNBT.func_74762_e("mFloor");
        this.height = aNBT.func_74762_e("height");
        super.loadNBTData(aNBT);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mKeV", this.eV);
        aNBT.func_74768_a("mCeil", this.mCeil);
        aNBT.func_74768_a("mFloor", this.mFloor);
        aNBT.func_74768_a("height", this.height);
        super.saveNBTData(aNBT);
    }

    public String[] getDescription() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Neutron Activator").addInfo("Controller block for the Neutron Activator").addInfo("Superluminal-velocity Motion.").addInfo("The minimum height of the Speeding Pipe Casing is 4.").addInfo("Per extra Speeding Pipe Casing will give time discount.").addInfo("But it will reduce the Neutron Accelerator efficiency.").addInfo("You need to input energy to the Neutron Accelerator to get it running.").addInfo("It will output correct products with Specific Neutron Kinetic Energy.").addInfo("Otherwise it will output trash.").addInfo("The Neutron Kinetic Energy will decrease 72KeV/s when no Neutron Accelerator is running.").addInfo("It will explode when the Neutron Kinetic Energy is over" + EnumChatFormatting.RED + " 1200MeV" + EnumChatFormatting.GRAY + ".").addInfo("Inputting Graphite/Beryllium dust can reduce 10MeV per dust immediately.").addInfo("The structure is too complex!").addInfo(DescTextLocalization.BLUE_PRINT_INFO).addSeparator().addController("Front bottom").addInputHatch("Hint block with dot 1").addInputBus("Hint block with dot 1").addOutputHatch("Hint block with dot 2").addOutputBus("Hint block with dot 2").addMaintenanceHatch("Hint block with dot 2").addOtherStructurePart("Neutron Accelerator", "Hint block with dot 2").addOtherStructurePart("Neutron Sensor", "Hint block with dot 2").addCasingInfo("Clean Stainless Steel Machine Casing", 7).toolTipFinisher("Good Generator");
        if (!Keyboard.isKeyDown((int)42)) {
            return tt.getInformation();
        }
        return tt.getStructureInformation();
    }

    public IStructureDefinition<NeutronActivator> getStructure_EM() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.NA_TOP, StructureUtility.transpose((String[][])new String[][]{{"CCCCC", "CDDDC", "CDDDC", "CDDDC", "CCCCC"}})).addShape(this.NA_MID, StructureUtility.transpose((String[][])new String[][]{{"F   F", " GGG ", " GPG ", " GGG ", "F   F"}})).addShape(this.NA_BOTTOM, StructureUtility.transpose((String[][])new String[][]{{"XX~XX", "XDDDX", "XDDDX", "XDDDX", "XXXXX"}})).addElement(Character.valueOf('C'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addClassicInputToMachineList, (int)49, (int)1), StructureUtility.onElementPass(x -> ++x.casingAmount, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1))})).addElement(Character.valueOf('D'), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)6)).addElement(Character.valueOf('F'), StructureHelper.addFrame(Materials.Steel)).addElement(Character.valueOf('G'), StructureUtility.ofBlock((Block)Block.func_149634_a((Item)Ic2Items.reinforcedGlass.func_77973_b()), (int)0)).addElement(Character.valueOf('P'), StructureUtility.ofBlock((Block)Loaders.speedingPipe, (int)0)).addElement(Character.valueOf('X'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addClassicOutputToMachineList, (int)49, (int)2), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addMaintenanceToMachineList, (int)49, (int)2), GT_StructureUtility.ofHatchAdder(NeutronActivator::addAcceleratorAndSensor, (int)49, (int)2), StructureUtility.onElementPass(x -> ++x.casingAmount, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1))})).build();
        }
        return this.multiDefinition;
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.casingAmount = 0;
        this.mNeutronAccelerator.clear();
        this.mNeutronSensor.clear();
        if (!this.structureCheck_EM(this.NA_BOTTOM, 2, 0, 0)) {
            return false;
        }
        this.height = 0;
        while (this.structureCheck_EM(this.NA_MID, 2, this.height + 1, 0)) {
            ++this.height;
        }
        if (this.height < 4) {
            return false;
        }
        return this.structureCheck_EM(this.NA_TOP, 2, this.height + 1, 0) && this.casingAmount >= 7;
    }

    public final boolean addAcceleratorAndSensor(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof NeutronAccelerator) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mNeutronAccelerator.add((NeutronAccelerator)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof NeutronSensor) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mNeutronSensor.add((NeutronSensor)aMetaTileEntity);
        }
        return false;
    }

    public int maxNeutronKineticEnergy() {
        return 1200000000;
    }

    public int getCurrentNeutronKineticEnergy() {
        return this.eV;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new NeutronActivator(this.mName);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        boolean anyWorking = false;
        if (this.getBaseMetaTileEntity().isServerSide()) {
            for (ItemStack itemStack : this.getStoredInputs()) {
                if (!itemStack.func_77969_a(Materials.Graphite.getDust(1)) && !itemStack.func_77969_a(Materials.Beryllium.getDust(1))) continue;
                int consume = Math.min(this.eV / 10000000, itemStack.field_77994_a);
                this.depleteInput(GT_Utility.copyAmount((long)consume, (Object[])new Object[]{itemStack}));
                this.eV -= 10000000 * consume;
            }
            for (NeutronAccelerator neutronAccelerator : this.mNeutronAccelerator) {
                if (!neutronAccelerator.isRunning || this.getRepairStatus() != this.getIdealStatus()) continue;
                anyWorking = true;
                this.eV = (int)((double)this.eV + Math.max((double)(RandomUtils.nextInt((int)neutronAccelerator.getMaxEUConsume(), (int)(neutronAccelerator.getMaxEUConsume() * 2 + 1)) * 10) * Math.pow(0.95, this.height - 4), 10.0));
            }
            if (!anyWorking) {
                if (this.eV >= 72000 && aTick % 20L == 0L) {
                    this.eV -= 72000;
                } else if (this.eV > 0 && aTick % 20L == 0L) {
                    this.eV = 0;
                }
            }
            if (this.eV < 0) {
                this.eV = 0;
            }
            if (this.eV > this.maxNeutronKineticEnergy()) {
                this.doExplosion(128L);
            }
            for (NeutronSensor neutronSensor : this.mNeutronSensor) {
                String tText = neutronSensor.getText();
                if (!CharExchanger.isValidCompareExpress(this.rawProcessExp(tText))) continue;
                if (CharExchanger.compareExpression(this.rawProcessExp(tText), this.eV)) {
                    neutronSensor.outputRedstoneSignal();
                    continue;
                }
                neutronSensor.stopOutputRedstoneSignal();
            }
            if (this.mProgresstime < this.mMaxProgresstime && (this.eV > this.mCeil || this.eV < this.mFloor)) {
                this.mOutputFluids = null;
                this.mOutputItems = new ItemStack[]{ItemRefer.Radioactive_Waste.get(4)};
            }
        }
    }

    protected String rawProcessExp(String exp) {
        StringBuilder ret = new StringBuilder();
        for (char c : exp.toCharArray()) {
            if (exp.length() - ret.length() == 3) {
                if (Character.isDigit(c)) {
                    ret.append(c);
                    break;
                }
                if (c == 'K' || c == 'k') {
                    ret.append("000");
                }
                if (c != 'M' && c != 'm') break;
                ret.append("000000");
                break;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        int heights;
        this.structureBuild_EM(this.NA_BOTTOM, 2, 0, 0, stackSize, hintsOnly);
        this.structureBuild_EM(this.NA_TOP, 2, heights + 1, 0, stackSize, hintsOnly);
        for (heights = stackSize.field_77994_a + 3; heights > 0; --heights) {
            this.structureBuild_EM(this.NA_MID, 2, heights, 0, stackSize, hintsOnly);
        }
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return DescTextLocalization.addText("NeutronActivator.hint", 7);
    }

    public String[] getInfoData() {
        int currentNKEInput = 0;
        boolean anyWorking = false;
        for (NeutronAccelerator tHatch : this.mNeutronAccelerator) {
            if (!tHatch.isRunning) continue;
            currentNKEInput = (int)((double)currentNKEInput + (double)(RandomUtils.nextInt((int)tHatch.getMaxEUConsume(), (int)(tHatch.getMaxEUConsume() * 2 + 1)) * 10) * Math.pow(0.95, this.height - 4));
            anyWorking = true;
        }
        if (!anyWorking) {
            currentNKEInput = -72000;
        }
        return new String[]{"Progress:", EnumChatFormatting.GREEN + Integer.toString(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + this.mMaxProgresstime / 20 + EnumChatFormatting.RESET + " s", "Current Neutron Kinetic Energy Input: " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)currentNKEInput) + EnumChatFormatting.RESET + "eV", StatCollector.func_74838_a((String)"scanner.info.NA") + " " + EnumChatFormatting.LIGHT_PURPLE + GT_Utility.formatNumbers((long)this.getCurrentNeutronKineticEnergy()) + EnumChatFormatting.RESET + "eV"};
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49), TextureFactory.of((IIconContainer)textureFontOn), TextureFactory.builder().addIcon(new IIconContainer[]{textureFontOn_Glow}).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49), TextureFactory.of((IIconContainer)textureFontOff), TextureFactory.builder().addIcon(new IIconContainer[]{textureFontOff_Glow}).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49)};
    }
}

