/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.github.bartimaeusnek.bartworks.common.loaders.ItemRegistry;
import goodgenerator.blocks.tileEntity.base.LargeFusionComputer;
import goodgenerator.loader.Loaders;
import goodgenerator.util.DescTextLocalization;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Keyboard;

public class LargeFusionComputer3
extends LargeFusionComputer {
    private static final ITexture textureOverlay = TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FUSION3}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FUSION3_GLOW}).extFacing().glow().build()});

    public LargeFusionComputer3(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public LargeFusionComputer3(String name) {
        super(name);
    }

    public String[] getDescription() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Fusion Reactor").addInfo("Millions of nuclear.").addInfo("Controller block for the Compact Fusion Reactor MK-III.").addInfo("1,572,864EU/t and 20M EU capacity per Energy Hatch").addInfo("If the recipe has a startup cost greater than the").addInfo("number of energy hatches * cap, you can't do it").addInfo("Make sure the whole structure is built in the 3x3").addInfo("chuck area of the ring center (not controller).").addInfo("Startup < 160,000,000 EU: 192x Parallel").addInfo("Startup < 320,000,000 EU: 128x Parallel").addInfo("Startup < 640,000,000 EU: 64x Parallel").addInfo("Support" + EnumChatFormatting.BLUE + " Tec" + EnumChatFormatting.DARK_BLUE + "Tech" + EnumChatFormatting.GRAY + " Energy/Laser Hatches!").addInfo("The structure is too complex!").addInfo(DescTextLocalization.BLUE_PRINT_INFO).addSeparator().addCasingInfo("Fusion Machine Casing MK II", 1666).addCasingInfo("Advanced Compact Fusion Coil", 558).addCasingInfo("Neutronium Frame Box", 128).addCasingInfo("Osmium Reinforced Borosilicate Glass Block", 63).addEnergyHatch("1-32, Hint block with dot 3", new int[]{3}).addInputHatch("2-16, Hint block with dot 1", new int[]{1}).addOutputHatch("1-16, Hint block with dot 2", new int[]{2}).addStructureInfo("ALL Hatches must be UV or better").toolTipFinisher("Good Generator");
        if (!Keyboard.isKeyDown((int)42)) {
            return tt.getInformation();
        }
        return tt.getStructureInformation();
    }

    @Override
    public long maxEUStore() {
        return 640060000L * (long)Math.min(32, this.mEnergyHatches.size() + this.eEnergyMulti.size()) / 32L;
    }

    @Override
    public Block getCasingBlock() {
        return GregTech_API.sBlockCasings4;
    }

    @Override
    public int getCasingMeta() {
        return 8;
    }

    @Override
    public Block getCoilBlock() {
        return Loaders.compactFusionCoil;
    }

    @Override
    public int getCoilMeta() {
        return 2;
    }

    @Override
    public Block getGlassBlock() {
        return ItemRegistry.bw_realglas;
    }

    @Override
    public int getGlassMeta() {
        return 5;
    }

    @Override
    public int hatchTier() {
        return 8;
    }

    @Override
    public Materials getFrameBox() {
        return Materials.Neutronium;
    }

    @Override
    public int getMaxPara() {
        return 64;
    }

    @Override
    public int extraPara(int startEnergy) {
        return startEnergy < 160000000 ? 3 : (startEnergy < 320000000 ? 2 : 1);
    }

    @Override
    public ITexture getTextureOverlay() {
        return textureOverlay;
    }

    @Override
    public int tierOverclock() {
        return 4;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return DescTextLocalization.addText("LargeFusion3.hint", 9);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new LargeFusionComputer3(this.mName);
    }
}

