/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.util;

import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Cable;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Fluid;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_RecipeBuilder;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_Utility;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CrackRecipeAdder {
    static float[] coe1 = new float[]{1.25f, 1.2f, 1.1f, 0.9f, 0.85f, 0.8f, 0.75f};
    static float[] coe2 = new float[]{1.4f, 1.25f, 1.2f, 0.8f, 0.75f, 0.7f, 0.65f};
    static float[] coe3 = new float[]{1.6f, 1.5f, 1.45f, 0.7f, 0.6f, 0.55f, 0.45f};

    public static void crackerAdder(FluidStack inputFluid, FluidStack cracker, FluidStack[] outputFluids, ItemStack outputItem, int num, int EUt, int Duration) {
        int tmp2;
        Fluid tmp1;
        FluidStack[] actOutput = new FluidStack[num];
        String name = inputFluid.getFluid().getName().replaceAll(" ", "");
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)1)}).fluidInputs(new FluidStack[]{inputFluid, cracker}).fluidOutputs(new FluidStack[]{FluidRegistry.getFluidStack((String)("lightlycracked" + name), (int)1000)}).duration(Math.max((long)((double)Duration * 0.8), 1L) * 1L).eut(EUt).addTo((IRecipeMap)RecipeMaps.crackingRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)2)}).fluidInputs(new FluidStack[]{inputFluid, cracker}).fluidOutputs(new FluidStack[]{FluidRegistry.getFluidStack((String)("moderatelycracked" + name), (int)1000)}).duration(Math.max((long)Duration, 1L) * 1L).eut(EUt).addTo((IRecipeMap)RecipeMaps.crackingRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)3)}).fluidInputs(new FluidStack[]{inputFluid, cracker}).fluidOutputs(new FluidStack[]{FluidRegistry.getFluidStack((String)("heavilycracked" + name), (int)1000)}).duration(Math.max((long)((double)Duration * 1.2), 1L) * 1L).eut(EUt).addTo((IRecipeMap)RecipeMaps.crackingRecipes);
        int i = num - 1;
        int j = 0;
        while (i >= 0) {
            tmp1 = outputFluids[i].getFluid();
            tmp2 = (int)((float)outputFluids[i].amount * coe1[i]);
            actOutput[j] = new FluidStack(tmp1, tmp2);
            --i;
            ++j;
        }
        CrackRecipeAdder.addUniversalDistillationRecipe(FluidRegistry.getFluidStack((String)("lightlycracked" + name), (int)1000), actOutput, outputItem, Duration / 2, EUt / 3);
        i = num - 1;
        j = 0;
        while (i >= 0) {
            tmp1 = outputFluids[i].getFluid();
            tmp2 = (int)((float)outputFluids[i].amount * coe2[i]);
            actOutput[j] = new FluidStack(tmp1, tmp2);
            --i;
            ++j;
        }
        CrackRecipeAdder.addUniversalDistillationRecipe(FluidRegistry.getFluidStack((String)("moderatelycracked" + name), (int)1000), actOutput, outputItem, Duration / 2, EUt / 3);
        i = num - 1;
        j = 0;
        while (i >= 0) {
            tmp1 = outputFluids[i].getFluid();
            tmp2 = (int)((float)outputFluids[i].amount * coe3[i]);
            actOutput[j] = new FluidStack(tmp1, tmp2);
            --i;
            ++j;
        }
        CrackRecipeAdder.addUniversalDistillationRecipe(FluidRegistry.getFluidStack((String)("heavilycracked" + name), (int)1000), actOutput, outputItem, Duration / 2, EUt / 3);
    }

    public static void reAddBlastRecipe(Werkstoff material, int duration, int EUt, int level, boolean gas) {
        ItemStack output;
        ItemStack input = material.get(OrePrefixes.dust, 1);
        ItemStack itemStack = output = level > 1750 ? material.get(OrePrefixes.ingotHot, 1) : material.get(OrePrefixes.ingot, 1);
        if (gas) {
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{input, GT_Utility.getIntegratedCircuit((int)11)}).fluidInputs(new FluidStack[]{Materials.Helium.getGas(1000L)}).itemOutputs(new ItemStack[]{output}).duration(duration * 1).eut(EUt).metadata(GT_RecipeConstants.COIL_HEAT, (Object)level).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
        } else {
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{input, GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{output}).duration(duration * 1).eut(EUt).metadata(GT_RecipeConstants.COIL_HEAT, (Object)level).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
        }
    }

    public static void addUniversalDistillationRecipewithCircuit(FluidStack aInput, ItemStack[] aCircuit, FluidStack[] aOutputs, ItemStack aOutput2, int aDuration, long aEUt) {
        for (int i = 0; i < Math.min(aOutputs.length, 11); ++i) {
            GT_RecipeBuilder buildDistillation = GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)(i + 1))});
            if (aOutput2 != GT_Values.NI) {
                buildDistillation.itemOutputs(new ItemStack[]{aOutput2});
            }
            buildDistillation.fluidInputs(new FluidStack[]{aInput}).fluidOutputs(new FluidStack[]{aOutputs[i]}).duration(2 * aDuration).eut(aEUt / 4L).addTo((IRecipeMap)RecipeMaps.distilleryRecipes);
        }
        GT_RecipeBuilder buildDT = GT_Values.RA.stdBuilder().itemInputs(aCircuit);
        if (aOutput2 != GT_Values.NI) {
            buildDT.itemOutputs(new ItemStack[]{aOutput2});
        }
        buildDT.fluidInputs(new FluidStack[]{aInput}).fluidOutputs(aOutputs).duration(aDuration).eut(aEUt).addTo((IRecipeMap)RecipeMaps.distillationTowerRecipes);
    }

    public static void addUniversalDistillationRecipe(FluidStack aInput, FluidStack[] aOutputs, ItemStack aOutput2, int aDuration, long aEUt) {
        for (int i = 0; i < Math.min(aOutputs.length, 11); ++i) {
            GT_RecipeBuilder buildDistillation = GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)(i + 1))});
            if (aOutput2 != GT_Values.NI) {
                buildDistillation.itemOutputs(new ItemStack[]{aOutput2});
            }
            buildDistillation.fluidInputs(new FluidStack[]{aInput}).fluidOutputs(new FluidStack[]{aOutputs[i]}).duration(2 * aDuration).eut(aEUt / 4L).addTo((IRecipeMap)RecipeMaps.distilleryRecipes);
        }
        GT_RecipeBuilder buildDT = GT_Values.RA.stdBuilder();
        if (aOutput2 != GT_Values.NI) {
            buildDT.itemOutputs(new ItemStack[]{aOutput2});
        }
        buildDT.fluidInputs(new FluidStack[]{aInput}).fluidOutputs(aOutputs).duration(aDuration).eut(aEUt).addTo((IRecipeMap)RecipeMaps.distillationTowerRecipes);
    }

    public static FluidStack copyFluidWithAmount(FluidStack fluid, int amount) {
        if (fluid == null || amount <= 0) {
            return null;
        }
        return new FluidStack(fluid.getFluid(), amount);
    }

    public static void registerPipe(int ID, Werkstoff material, int flow, int temp, boolean gas) {
        String unName = material.getDefaultName().replace(" ", "_");
        String Name = material.getDefaultName();
        GT_OreDictUnificator.registerOre((Object)OrePrefixes.pipeTiny.get((Object)material.getBridgeMaterial()), (ItemStack)new GT_MetaPipeEntity_Fluid(ID, "GT_Pipe_" + unName + "_Tiny", "Tiny " + Name + " Fluid Pipe", 0.25f, material.getBridgeMaterial(), flow / 6, temp, gas).getStackForm(1L));
        GT_OreDictUnificator.registerOre((Object)OrePrefixes.pipeSmall.get((Object)material.getBridgeMaterial()), (ItemStack)new GT_MetaPipeEntity_Fluid(ID + 1, "GT_Pipe_" + unName + "_Small", "Small " + Name + " Fluid Pipe", 0.375f, material.getBridgeMaterial(), flow / 3, temp, gas).getStackForm(1L));
        GT_OreDictUnificator.registerOre((Object)OrePrefixes.pipeMedium.get((Object)material.getBridgeMaterial()), (ItemStack)new GT_MetaPipeEntity_Fluid(ID + 2, "GT_Pipe_" + unName, Name + " Fluid Pipe", 0.5f, material.getBridgeMaterial(), flow, temp, gas).getStackForm(1L));
        GT_OreDictUnificator.registerOre((Object)OrePrefixes.pipeLarge.get((Object)material.getBridgeMaterial()), (ItemStack)new GT_MetaPipeEntity_Fluid(ID + 3, "GT_Pipe_" + unName + "_Large", "Large " + Name + " Fluid Pipe", 0.75f, material.getBridgeMaterial(), flow * 2, temp, gas).getStackForm(1L));
        GT_OreDictUnificator.registerOre((Object)OrePrefixes.pipeHuge.get((Object)material.getBridgeMaterial()), (ItemStack)new GT_MetaPipeEntity_Fluid(ID + 4, "GT_Pipe_" + unName + "_Huge", "Huge " + Name + " Fluid Pipe", 0.875f, material.getBridgeMaterial(), flow * 4, temp, gas).getStackForm(1L));
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.ingot, 1), ItemList.Shape_Extruder_Pipe_Tiny.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.pipeTiny, 2)}).duration(material.getStats().getMass() * 1L).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.extruderRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.ingot, 1), ItemList.Shape_Extruder_Pipe_Small.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.pipeSmall, 1)}).duration(material.getStats().getMass() * 2L * 1L).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.extruderRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.ingot, 3), ItemList.Shape_Extruder_Pipe_Medium.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.pipeMedium, 1)}).duration(material.getStats().getMass() * 6L * 1L).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.extruderRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.ingot, 6), ItemList.Shape_Extruder_Pipe_Large.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.pipeLarge, 1)}).duration(material.getStats().getMass() * 12L * 1L).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.extruderRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.ingot, 12), ItemList.Shape_Extruder_Pipe_Huge.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.pipeHuge, 1)}).duration(material.getStats().getMass() * 24L * 1L).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.extruderRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Pipe_Tiny.get(0L, new Object[0])}).fluidInputs(new FluidStack[]{material.getMolten(72)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.pipeTiny, 1)}).duration(material.getStats().getMass() * 1L).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Pipe_Small.get(0L, new Object[0])}).fluidInputs(new FluidStack[]{material.getMolten(144)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.pipeSmall, 1)}).duration(material.getStats().getMass() * 2L * 1L).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Pipe_Medium.get(0L, new Object[0])}).fluidInputs(new FluidStack[]{material.getMolten(432)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.pipeMedium, 1)}).duration(material.getStats().getMass() * 6L * 1L).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Pipe_Large.get(0L, new Object[0])}).fluidInputs(new FluidStack[]{material.getMolten(864)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.pipeLarge, 1)}).duration(material.getStats().getMass() * 12L * 1L).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Pipe_Huge.get(0L, new Object[0])}).fluidInputs(new FluidStack[]{material.getMolten(1728)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.pipeHuge, 1)}).duration(material.getStats().getMass() * 24L * 1L).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
    }

    public static void registerWire(int ID, Werkstoff material, int aAmperage, int aVoltage, int aLoss, boolean cover) {
        String unName = material.getDefaultName().replace(" ", "_").toLowerCase();
        String Name = material.getDefaultName();
        String aTextWire1 = "wire.";
        String aTextCable1 = "cable.";
        String aTextWire2 = " Wire";
        String aTextCable2 = " Cable";
        int aLossInsulated = aLoss / 4;
        GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.wireGt01, (Object)material.getBridgeMaterial(), (ItemStack)new GT_MetaPipeEntity_Cable(ID + 0, aTextWire1 + unName + ".01", "1x " + Name + aTextWire2, 0.125f, material.getBridgeMaterial(), (long)aLoss, 1L * (long)aAmperage, (long)aVoltage, false, true).getStackForm(1L));
        GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.wireGt02, (Object)material.getBridgeMaterial(), (ItemStack)new GT_MetaPipeEntity_Cable(ID + 1, aTextWire1 + unName + ".02", "2x " + Name + aTextWire2, 0.25f, material.getBridgeMaterial(), (long)aLoss, 2L * (long)aAmperage, (long)aVoltage, false, true).getStackForm(1L));
        GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.wireGt04, (Object)material.getBridgeMaterial(), (ItemStack)new GT_MetaPipeEntity_Cable(ID + 2, aTextWire1 + unName + ".04", "4x " + Name + aTextWire2, 0.375f, material.getBridgeMaterial(), (long)aLoss, 4L * (long)aAmperage, (long)aVoltage, false, true).getStackForm(1L));
        GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.wireGt08, (Object)material.getBridgeMaterial(), (ItemStack)new GT_MetaPipeEntity_Cable(ID + 3, aTextWire1 + unName + ".08", "8x " + Name + aTextWire2, 0.5f, material.getBridgeMaterial(), (long)aLoss, 8L * (long)aAmperage, (long)aVoltage, false, true).getStackForm(1L));
        GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.wireGt12, (Object)material.getBridgeMaterial(), (ItemStack)new GT_MetaPipeEntity_Cable(ID + 4, aTextWire1 + unName + ".12", "12x " + Name + aTextWire2, 0.625f, material.getBridgeMaterial(), (long)aLoss, 12L * (long)aAmperage, (long)aVoltage, false, true).getStackForm(1L));
        GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.wireGt16, (Object)material.getBridgeMaterial(), (ItemStack)new GT_MetaPipeEntity_Cable(ID + 5, aTextWire1 + unName + ".16", "16x " + Name + aTextWire2, 0.75f, material.getBridgeMaterial(), (long)aLoss, 16L * (long)aAmperage, (long)aVoltage, false, true).getStackForm(1L));
        if (cover) {
            GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.cableGt01, (Object)material.getBridgeMaterial(), (ItemStack)new GT_MetaPipeEntity_Cable(ID + 6, aTextCable1 + unName + ".01", "1x " + Name + aTextCable2, 0.25f, material.getBridgeMaterial(), (long)aLossInsulated, 1L * (long)aAmperage, (long)aVoltage, true, false).getStackForm(1L));
            GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.cableGt02, (Object)material.getBridgeMaterial(), (ItemStack)new GT_MetaPipeEntity_Cable(ID + 7, aTextCable1 + unName + ".02", "2x " + Name + aTextCable2, 0.375f, material.getBridgeMaterial(), (long)aLossInsulated, 2L * (long)aAmperage, (long)aVoltage, true, false).getStackForm(1L));
            GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.cableGt04, (Object)material.getBridgeMaterial(), (ItemStack)new GT_MetaPipeEntity_Cable(ID + 8, aTextCable1 + unName + ".04", "4x " + Name + aTextCable2, 0.5f, material.getBridgeMaterial(), (long)aLossInsulated, 4L * (long)aAmperage, (long)aVoltage, true, false).getStackForm(1L));
            GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.cableGt08, (Object)material.getBridgeMaterial(), (ItemStack)new GT_MetaPipeEntity_Cable(ID + 9, aTextCable1 + unName + ".08", "8x " + Name + aTextCable2, 0.625f, material.getBridgeMaterial(), (long)aLossInsulated, 8L * (long)aAmperage, (long)aVoltage, true, false).getStackForm(1L));
            GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.cableGt12, (Object)material.getBridgeMaterial(), (ItemStack)new GT_MetaPipeEntity_Cable(ID + 10, aTextCable1 + unName + ".12", "12x " + Name + aTextCable2, 0.75f, material.getBridgeMaterial(), (long)aLossInsulated, 12L * (long)aAmperage, (long)aVoltage, true, false).getStackForm(1L));
            GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.cableGt16, (Object)material.getBridgeMaterial(), (ItemStack)new GT_MetaPipeEntity_Cable(ID + 11, aTextCable1 + unName + ".16", "16x " + Name + aTextCable2, 0.875f, material.getBridgeMaterial(), (long)aLossInsulated, 16L * (long)aAmperage, (long)aVoltage, true, false).getStackForm(1L));
        }
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.ingot, 1), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.wireGt01, 2)}).duration(100).eut(4).addTo((IRecipeMap)RecipeMaps.wiremillRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.ingot, 1), GT_Utility.getIntegratedCircuit((int)2)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.wireGt02, 1)}).duration(150).eut(4).addTo((IRecipeMap)RecipeMaps.wiremillRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.ingot, 2), GT_Utility.getIntegratedCircuit((int)4)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.wireGt04, 1)}).duration(200).eut(4).addTo((IRecipeMap)RecipeMaps.wiremillRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.ingot, 4), GT_Utility.getIntegratedCircuit((int)8)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.wireGt08, 1)}).duration(250).eut(4).addTo((IRecipeMap)RecipeMaps.wiremillRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.ingot, 6), GT_Utility.getIntegratedCircuit((int)12)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.wireGt12, 1)}).duration(300).eut(4).addTo((IRecipeMap)RecipeMaps.wiremillRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.ingot, 8), GT_Utility.getIntegratedCircuit((int)16)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.wireGt16, 1)}).duration(350).eut(4).addTo((IRecipeMap)RecipeMaps.wiremillRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.stick, 1), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.wireGt01, 1)}).duration(50).eut(4).addTo((IRecipeMap)RecipeMaps.wiremillRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.stick, 2), GT_Utility.getIntegratedCircuit((int)2)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.wireGt02, 1)}).duration(100).eut(4).addTo((IRecipeMap)RecipeMaps.wiremillRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.stick, 4), GT_Utility.getIntegratedCircuit((int)4)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.wireGt04, 1)}).duration(150).eut(4).addTo((IRecipeMap)RecipeMaps.wiremillRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.stick, 8), GT_Utility.getIntegratedCircuit((int)8)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.wireGt08, 1)}).duration(200).eut(4).addTo((IRecipeMap)RecipeMaps.wiremillRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.stick, 12), GT_Utility.getIntegratedCircuit((int)12)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.wireGt12, 1)}).duration(250).eut(4).addTo((IRecipeMap)RecipeMaps.wiremillRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.stick, 16), GT_Utility.getIntegratedCircuit((int)16)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.wireGt16, 1)}).duration(300).eut(4).addTo((IRecipeMap)RecipeMaps.wiremillRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.ingot, 1), GT_Utility.getIntegratedCircuit((int)3)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.wireFine, 8)}).duration(100).eut(4).addTo((IRecipeMap)RecipeMaps.wiremillRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.stick, 1), GT_Utility.getIntegratedCircuit((int)3)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.wireFine, 4)}).duration(50).eut(4).addTo((IRecipeMap)RecipeMaps.wiremillRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.wireGt01, 1), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.wireFine, 4)}).duration(200).eut(8).addTo((IRecipeMap)RecipeMaps.wiremillRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{material.get(OrePrefixes.ingot, 1), ItemList.Shape_Extruder_Wire.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{material.get(OrePrefixes.wireGt01, 2)}).duration(material.getStats().getMass() * 8L * 1L).eut(TierEU.RECIPE_HV).addTo((IRecipeMap)RecipeMaps.extruderRecipes);
    }
}

