/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity.GTMetaTileEntity;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkStorageEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import goodgenerator.blocks.tileEntity.YottaFluidTank;
import goodgenerator.loader.Loaders;
import goodgenerator.util.StackUtils;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class YOTTAHatch
extends GT_MetaTileEntity_Hatch
implements IGridProxyable,
IActionHost,
ICellContainer,
IMEInventory<IAEFluidStack>,
IMEInventoryHandler<IAEFluidStack> {
    private static final IIconContainer textureFont = new Textures.BlockIcons.CustomIcon("icons/YOTTAHatch");
    private YottaFluidTank host;
    private AENetworkProxy gridProxy = null;
    private int priority;
    private byte tickRate = (byte)20;
    private FluidStack lastFluid = null;
    private BigInteger lastAmt = BigInteger.ZERO;
    private AccessRestriction readMode = AccessRestriction.READ_WRITE;
    private final AccessRestriction[] AEModes = new AccessRestriction[]{AccessRestriction.NO_ACCESS, AccessRestriction.READ, AccessRestriction.WRITE, AccessRestriction.READ_WRITE};
    private static final BigInteger MAX_LONG_BIGINT = BigInteger.valueOf(Long.MAX_VALUE);
    private static final FluidTankInfo[] EMPTY_TANK_INFO = new FluidTankInfo[]{new FluidTankInfo(null, 0)};

    public YOTTAHatch(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, new String[]{"Special I/O port for AE2FC.", "Directly connected YOTTank with AE fluid storage system.", "Use screwdriver to set storage priority", "Use soldering iron to set read/write mode"}, new ITexture[0]);
    }

    public YOTTAHatch(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    public void setTank(YottaFluidTank te) {
        this.host = te;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mAEPriority", this.priority);
        aNBT.func_74768_a("mAEMode", this.readMode.ordinal());
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.priority = aNBT.func_74762_e("mAEPriority");
        this.readMode = this.AEModes[aNBT.func_74762_e("mAEMode")];
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack toolStack) {
        this.priority = aPlayer.func_70093_af() ? (this.priority -= 10) : (this.priority += 10);
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)String.format(StatCollector.func_74838_a((String)"yothatch.chat.0"), this.priority));
    }

    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack toolStack) {
        this.readMode = this.AEModes[(this.readMode.ordinal() + 1) % 4];
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)String.format(StatCollector.func_74838_a((String)"yothatch.chat.1"), this.readMode));
        return true;
    }

    public IGridNode getGridNode(ForgeDirection forgeDirection) {
        AENetworkProxy gp = this.getProxy();
        return gp != null ? gp.getNode() : null;
    }

    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return AECableType.SMART;
    }

    public void securityBreak() {
    }

    public AENetworkProxy getProxy() {
        if (this.gridProxy == null) {
            this.gridProxy = new AENetworkProxy((IGridProxyable)this, "proxy", Loaders.YFH, true);
            this.gridProxy.onReady();
            this.gridProxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        }
        return this.gridProxy;
    }

    public DimensionalCoord getLocation() {
        IGregTechTileEntity gtm = this.getBaseMetaTileEntity();
        return new DimensionalCoord(gtm.getWorld(), gtm.getXCoord(), (int)gtm.getYCoord(), gtm.getZCoord());
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        if (this.host == null || this.host.getBaseMetaTileEntity() == null || !this.host.getBaseMetaTileEntity().isActive()) {
            return out;
        }
        if (this.host.mFluid == null || this.host.mStorageCurrent.signum() <= 0) {
            return out;
        }
        long ready = this.host.mStorageCurrent.compareTo(MAX_LONG_BIGINT) >= 0 ? Long.MAX_VALUE : this.host.mStorageCurrent.longValue();
        out.add((IAEStack)StackUtils.createAEFluidStack(this.host.mFluid.getFluid(), ready));
        return out;
    }

    public IAEFluidStack injectItems(IAEFluidStack input, Actionable type, BaseActionSource src) {
        long amt = this.fill(null, input, false);
        if (amt == input.getStackSize()) {
            if (type.equals((Object)Actionable.MODULATE)) {
                this.fill(null, input, true);
            }
            return null;
        }
        return input;
    }

    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource src) {
        IAEFluidStack ready = this.drain(null, request, false);
        if (ready != null) {
            if (mode.equals((Object)Actionable.MODULATE)) {
                this.drain(null, ready, true);
            }
            return ready;
        }
        return null;
    }

    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.getProxy();
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.shouldTick(aTick)) {
            if (this.isChanged()) {
                IGrid grid;
                IGridNode node = this.getGridNode(null);
                if (node != null && (grid = node.getGrid()) != null) {
                    grid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                    IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
                    if (storageGrid == null) {
                        node.getGrid().postEvent((MENetworkEvent)new MENetworkStorageEvent(null, StorageChannel.FLUIDS));
                    } else {
                        node.getGrid().postEvent((MENetworkEvent)new MENetworkStorageEvent(storageGrid.getFluidInventory(), StorageChannel.FLUIDS));
                    }
                    node.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                }
                this.faster();
                this.update();
            } else {
                this.slower();
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public int getCapacity() {
        if (this.host == null || this.host.getBaseMetaTileEntity() == null || !this.host.getBaseMetaTileEntity().isActive()) {
            return 0;
        }
        if (this.host.mStorage.compareTo(YottaFluidTank.MAX_INT_BIGINT) >= 0) {
            return Integer.MAX_VALUE;
        }
        return this.host.mStorage.intValue();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.host == null || this.host.getBaseMetaTileEntity() == null || !this.host.getBaseMetaTileEntity().isActive()) {
            return 0;
        }
        if (this.host.mLockedFluid != null && !this.host.mLockedFluid.isFluidEqual(resource)) {
            return 0;
        }
        if (this.host.mFluid == null || this.host.mFluid.isFluidEqual(resource)) {
            int returned;
            if (this.host.mFluid == null) {
                this.host.mFluid = resource.copy();
                this.host.mFluid.amount = 1;
            }
            if (this.host.addFluid(resource.amount, doFill)) {
                return resource.amount;
            }
            if (this.host.getIsVoidExcessEnabled()) {
                returned = resource.amount;
            } else {
                BigInteger delta = this.host.mStorage.subtract(this.host.mStorageCurrent);
                returned = delta.intValueExact();
            }
            this.host.mStorageCurrent = this.host.mStorage;
            return returned;
        }
        return 0;
    }

    public long fill(ForgeDirection from, IAEFluidStack resource, boolean doFill) {
        if (this.host == null || this.host.getBaseMetaTileEntity() == null || !this.host.getBaseMetaTileEntity().isActive()) {
            return 0L;
        }
        if (this.host.mLockedFluid != null && this.host.mLockedFluid.getFluid() != resource.getFluid()) {
            return 0L;
        }
        if (this.host.mFluid == null || this.host.mFluid.getFluid() == resource.getFluid()) {
            long returned;
            if (this.host.mFluid == null) {
                this.host.mFluid = resource.getFluidStack();
                this.host.mFluid.amount = 1;
            }
            if (this.host.addFluid(resource.getStackSize(), doFill)) {
                return resource.getStackSize();
            }
            if (this.host.getIsVoidExcessEnabled()) {
                returned = resource.getStackSize();
            } else {
                BigInteger delta = this.host.mStorage.subtract(this.host.mStorageCurrent);
                returned = delta.longValueExact();
            }
            this.host.mStorageCurrent = this.host.mStorage;
            return returned;
        }
        return 0L;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.host == null || this.host.getBaseMetaTileEntity() == null || !this.host.getBaseMetaTileEntity().isActive()) {
            return null;
        }
        if (this.host.mFluid == null || this.host.mFluid.getFluid() != resource.getFluid()) {
            return null;
        }
        int ready = this.host.mStorageCurrent.compareTo(YottaFluidTank.MAX_INT_BIGINT) >= 0 ? Integer.MAX_VALUE : this.host.mStorageCurrent.intValue();
        ready = Math.min(ready, resource.amount);
        if (doDrain) {
            this.host.reduceFluid(ready);
        }
        return new FluidStack(resource.getFluid(), ready);
    }

    public IAEFluidStack drain(ForgeDirection from, IAEFluidStack resource, boolean doDrain) {
        if (this.host == null || this.host.getBaseMetaTileEntity() == null || !this.host.getBaseMetaTileEntity().isActive()) {
            return null;
        }
        if (this.host.mFluid == null || this.host.mFluid.getFluid() != resource.getFluid()) {
            return null;
        }
        long ready = this.host.mStorageCurrent.compareTo(MAX_LONG_BIGINT) > 0 ? Long.MAX_VALUE : this.host.mStorageCurrent.longValue();
        ready = Math.min(ready, resource.getStackSize());
        if (doDrain) {
            this.host.reduceFluid(ready);
        }
        IAEFluidStack copy = resource.copy();
        copy.setStackSize(ready);
        return copy;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.host == null || this.host.getBaseMetaTileEntity() == null || !this.host.getBaseMetaTileEntity().isActive()) {
            return null;
        }
        if (this.host.mFluid == null) {
            return null;
        }
        FluidStack drainStack = this.host.mFluid.copy();
        drainStack.amount = maxDrain;
        return this.drain(from, drainStack, doDrain);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.host == null || this.host.getBaseMetaTileEntity() == null || !this.host.getBaseMetaTileEntity().isActive()) {
            return EMPTY_TANK_INFO;
        }
        return this.host.getTankInfo(from);
    }

    public boolean canTankBeFilled() {
        return true;
    }

    public boolean canTankBeEmptied() {
        return true;
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)textureFont)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)textureFont)};
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new YOTTAHatch(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public IGridNode getActionableNode() {
        AENetworkProxy gp = this.getProxy();
        return gp != null ? gp.getNode() : null;
    }

    public AccessRestriction getAccess() {
        return this.readMode;
    }

    public boolean isPrioritized(IAEFluidStack input) {
        return true;
    }

    public boolean canAccept(IAEFluidStack input) {
        FluidStack rInput = input.getFluidStack();
        return this.fill(null, rInput, false) > 0;
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        ArrayList<IMEInventoryHandler> list = new ArrayList<IMEInventoryHandler>();
        if (channel == StorageChannel.FLUIDS) {
            list.add(this);
        }
        return list;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return true;
    }

    public void blinkCell(int slot) {
    }

    public void saveChanges(IMEInventory cellInventory) {
    }

    private boolean isChanged() {
        if (this.host == null) {
            return false;
        }
        return !this.lastAmt.equals(this.host.mStorageCurrent) || this.lastFluid != this.host.mFluid;
    }

    private void update() {
        if (this.host == null) {
            return;
        }
        this.lastAmt = this.host.mStorageCurrent;
        this.lastFluid = this.host.mFluid;
    }

    private void faster() {
        if (this.tickRate > 15) {
            this.tickRate = (byte)(this.tickRate - 5);
        }
    }

    private void slower() {
        if (this.tickRate < 100) {
            this.tickRate = (byte)(this.tickRate + 5);
        }
    }

    private boolean shouldTick(long tick) {
        if (this.host == null) {
            return false;
        }
        return tick % (long)this.tickRate == 0L;
    }
}

