/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity.GTMetaTileEntity;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkStorageEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import goodgenerator.blocks.tileEntity.YottaFluidTank;
import goodgenerator.loader.Loaders;
import goodgenerator.util.StackUtils;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class YOTTAHatch
extends GT_MetaTileEntity_Hatch
implements IGridProxyable,
IActionHost,
ICellContainer,
IMEInventory<IAEFluidStack>,
IMEInventoryHandler<IAEFluidStack> {
    private static final IIconContainer textureFont = new Textures.BlockIcons.CustomIcon("icons/YOTTAHatch");
    private YottaFluidTank host;
    private AENetworkProxy gridProxy = null;
    private int priority;
    private byte tickRate = (byte)20;
    private String lastFluid = "";
    private BigInteger lastAmt = BigInteger.ZERO;
    private AccessRestriction readMode = AccessRestriction.READ_WRITE;
    private final AccessRestriction[] AEModes = new AccessRestriction[]{AccessRestriction.NO_ACCESS, AccessRestriction.READ, AccessRestriction.WRITE, AccessRestriction.READ_WRITE};

    public YOTTAHatch(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, new String[]{"Special I/O port for AE2FC.", "Directly connected YOTTank with AE fluid storage system.", "Use screwdriver to set storage priority", "Use soldering iron to set read/write mode"}, new ITexture[0]);
    }

    public YOTTAHatch(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    public void setTank(YottaFluidTank te) {
        this.host = te;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mAEPriority", this.priority);
        aNBT.func_74768_a("mAEMode", this.readMode.ordinal());
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.priority = aNBT.func_74762_e("mAEPriority");
        this.readMode = this.AEModes[aNBT.func_74762_e("mAEMode")];
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.priority = aPlayer.func_70093_af() ? (this.priority -= 10) : (this.priority += 10);
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)String.format(StatCollector.func_74838_a((String)"yothatch.chat.0"), this.priority));
    }

    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.readMode = this.AEModes[(this.readMode.ordinal() + 1) % 4];
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)String.format(StatCollector.func_74838_a((String)"yothatch.chat.1"), this.readMode));
        return true;
    }

    public IGridNode getGridNode(ForgeDirection forgeDirection) {
        AENetworkProxy gp = this.getProxy();
        return gp != null ? gp.getNode() : null;
    }

    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return AECableType.SMART;
    }

    public void securityBreak() {
    }

    public AENetworkProxy getProxy() {
        if (this.gridProxy == null) {
            this.gridProxy = new AENetworkProxy((IGridProxyable)this, "proxy", Loaders.YFH, true);
            this.gridProxy.onReady();
            this.gridProxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        }
        return this.gridProxy;
    }

    public DimensionalCoord getLocation() {
        IGregTechTileEntity gtm = this.getBaseMetaTileEntity();
        return new DimensionalCoord(gtm.getWorld(), gtm.getXCoord(), (int)gtm.getYCoord(), gtm.getZCoord());
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        if (this.host == null || this.host.getBaseMetaTileEntity() == null || !this.host.getBaseMetaTileEntity().isActive()) {
            return out;
        }
        if (this.host.mFluidName == null || this.host.mFluidName.equals("") || this.host.mStorageCurrent.compareTo(BigInteger.ZERO) <= 0) {
            return out;
        }
        long ready = this.host.mStorageCurrent.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 ? Long.MAX_VALUE : this.host.mStorageCurrent.longValue();
        out.add((IAEStack)StackUtils.createAEFluidStack(FluidRegistry.getFluid((String)this.host.mFluidName), ready));
        return out;
    }

    public IAEFluidStack injectItems(IAEFluidStack input, Actionable type, BaseActionSource src) {
        long amt = this.fill(null, input, false);
        if (amt == input.getStackSize()) {
            if (type.equals((Object)Actionable.MODULATE)) {
                this.fill(null, input, true);
            }
            return null;
        }
        return input;
    }

    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource src) {
        IAEFluidStack ready = this.drain(null, request, false);
        if (ready != null) {
            if (mode.equals((Object)Actionable.MODULATE)) {
                this.drain(null, ready, true);
            }
            return ready;
        }
        return null;
    }

    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.getProxy();
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.shouldTick(aTick)) {
            if (this.isChanged()) {
                IGrid grid;
                IGridNode node = this.getGridNode(null);
                if (node != null && (grid = node.getGrid()) != null) {
                    grid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                    IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
                    if (storageGrid == null) {
                        node.getGrid().postEvent((MENetworkEvent)new MENetworkStorageEvent(null, StorageChannel.FLUIDS));
                    } else {
                        node.getGrid().postEvent((MENetworkEvent)new MENetworkStorageEvent(storageGrid.getFluidInventory(), StorageChannel.FLUIDS));
                    }
                    node.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                }
                this.faster();
                this.update();
            } else {
                this.slower();
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public int getCapacity() {
        if (this.host == null || this.host.getBaseMetaTileEntity() == null || !this.host.getBaseMetaTileEntity().isActive()) {
            return 0;
        }
        if (this.host.mStorage.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) >= 0) {
            return Integer.MAX_VALUE;
        }
        return this.host.mStorage.intValue();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.host == null || this.host.getBaseMetaTileEntity() == null || !this.host.getBaseMetaTileEntity().isActive()) {
            return 0;
        }
        if (this.host.mLockedFluidName != null && !this.host.mLockedFluidName.equals("") && !this.host.mLockedFluidName.equals(resource.getFluid().getName())) {
            return 0;
        }
        if (this.host.mFluidName == null || this.host.mFluidName.equals("") || this.host.mFluidName.equals(resource.getFluid().getName())) {
            this.host.mFluidName = resource.getFluid().getName();
            if (this.host.mStorage.subtract(this.host.mStorageCurrent).compareTo(BigInteger.valueOf(resource.amount)) >= 0) {
                if (doFill) {
                    this.host.addFluid(resource.amount);
                }
                return resource.amount;
            }
            int added = this.host.mStorage.subtract(this.host.mStorageCurrent).intValue();
            if (doFill) {
                this.host.addFluid(added);
            }
            return this.host.getIsVoidExcessEnabled() ? resource.amount : added;
        }
        return 0;
    }

    public long fill(ForgeDirection from, IAEFluidStack resource, boolean doFill) {
        if (this.host == null || this.host.getBaseMetaTileEntity() == null || !this.host.getBaseMetaTileEntity().isActive()) {
            return 0L;
        }
        if (this.host.mLockedFluidName != null && !this.host.mLockedFluidName.equals("") && !this.host.mLockedFluidName.equals(resource.getFluid().getName())) {
            return 0L;
        }
        if (this.host.mFluidName == null || this.host.mFluidName.equals("") || this.host.mFluidName.equals(resource.getFluid().getName())) {
            this.host.mFluidName = resource.getFluid().getName();
            if (this.host.mStorage.subtract(this.host.mStorageCurrent).compareTo(BigInteger.valueOf(resource.getStackSize())) >= 0) {
                if (doFill) {
                    this.host.addFluid(resource.getStackSize());
                }
                return resource.getStackSize();
            }
            long added = this.host.mStorage.subtract(this.host.mStorageCurrent).longValue();
            if (doFill) {
                this.host.addFluid(added);
            }
            return this.host.getIsVoidExcessEnabled() ? resource.getStackSize() : added;
        }
        return 0L;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.host == null || this.host.getBaseMetaTileEntity() == null || !this.host.getBaseMetaTileEntity().isActive()) {
            return null;
        }
        if (this.host.mFluidName == null || this.host.mFluidName.equals("") || !this.host.mFluidName.equals(resource.getFluid().getName())) {
            return null;
        }
        int ready = this.host.mStorageCurrent.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 ? Integer.MAX_VALUE : this.host.mStorageCurrent.intValue();
        ready = Math.min(ready, resource.amount);
        if (doDrain) {
            this.host.reduceFluid(ready);
        }
        return new FluidStack(resource.getFluid(), ready);
    }

    public IAEFluidStack drain(ForgeDirection from, IAEFluidStack resource, boolean doDrain) {
        if (this.host == null || this.host.getBaseMetaTileEntity() == null || !this.host.getBaseMetaTileEntity().isActive()) {
            return null;
        }
        if (this.host.mFluidName == null || this.host.mFluidName.equals("") || !this.host.mFluidName.equals(resource.getFluid().getName())) {
            return null;
        }
        long ready = this.host.mStorageCurrent.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 ? Long.MAX_VALUE : this.host.mStorageCurrent.longValue();
        ready = Math.min(ready, resource.getStackSize());
        if (doDrain) {
            this.host.reduceFluid(ready);
        }
        IAEFluidStack copy = resource.copy();
        copy.setStackSize(ready);
        return copy;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.host == null || this.host.getBaseMetaTileEntity() == null || !this.host.getBaseMetaTileEntity().isActive()) {
            return null;
        }
        if (this.host.mFluidName == null || this.host.mFluidName.equals("")) {
            return null;
        }
        return this.drain(from, FluidRegistry.getFluidStack((String)this.host.mFluidName, (int)maxDrain), doDrain);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] tankInfo = new FluidTankInfo[]{new FluidTankInfo(null, 0)};
        if (this.host == null || this.host.getBaseMetaTileEntity() == null || !this.host.getBaseMetaTileEntity().isActive()) {
            return tankInfo;
        }
        FluidStack fluid = null;
        if (this.host.mFluidName != null && !this.host.mFluidName.equals("")) {
            int camt = this.host.mStorageCurrent.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 ? Integer.MAX_VALUE : this.host.mStorageCurrent.intValue();
            fluid = FluidRegistry.getFluidStack((String)this.host.mFluidName, (int)camt);
        }
        tankInfo[0] = new FluidTankInfo(fluid, this.getCapacity());
        return tankInfo;
    }

    public boolean canTankBeFilled() {
        return true;
    }

    public boolean canTankBeEmptied() {
        return true;
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)textureFont)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)textureFont)};
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new YOTTAHatch(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public IGridNode getActionableNode() {
        AENetworkProxy gp = this.getProxy();
        return gp != null ? gp.getNode() : null;
    }

    public AccessRestriction getAccess() {
        return this.readMode;
    }

    public boolean isPrioritized(IAEFluidStack input) {
        return true;
    }

    public boolean canAccept(IAEFluidStack input) {
        FluidStack rInput = input.getFluidStack();
        return this.fill(null, rInput, false) > 0;
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        ArrayList<IMEInventoryHandler> list = new ArrayList<IMEInventoryHandler>();
        if (channel == StorageChannel.FLUIDS) {
            list.add(this);
        }
        return list;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return true;
    }

    public void blinkCell(int slot) {
    }

    public void saveChanges(IMEInventory cellInventory) {
    }

    private boolean isChanged() {
        if (this.host == null) {
            return false;
        }
        return !this.lastAmt.equals(this.host.mStorageCurrent) || !this.lastFluid.equals(this.host.mFluidName);
    }

    private void update() {
        if (this.host == null) {
            return;
        }
        this.lastAmt = this.host.mStorageCurrent;
        this.lastFluid = this.host.mFluidName;
    }

    private void faster() {
        if (this.tickRate > 15) {
            this.tickRate = (byte)(this.tickRate - 5);
        }
    }

    private void slower() {
        if (this.tickRate < 100) {
            this.tickRate = (byte)(this.tickRate + 5);
        }
    }

    private boolean shouldTick(long tick) {
        if (this.host == null) {
            return false;
        }
        return tick % (long)this.tickRate == 0L;
    }
}

