/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity.base;

import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_ExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GT_Utility;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public abstract class GT_MetaTileEntity_LongPowerUsageBase<T extends GT_MetaTileEntity_LongPowerUsageBase<T>>
extends GT_MetaTileEntity_ExtendedPowerMultiBlockBase<T> {
    protected GT_MetaTileEntity_LongPowerUsageBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    protected GT_MetaTileEntity_LongPowerUsageBase(String aName) {
        super(aName);
    }

    public void clearHatches() {
        this.mExoticEnergyHatches.clear();
        super.clearHatches();
    }

    public long getMaxInputVoltage() {
        long rVoltage = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            rVoltage += tHatch.maxEUInput();
        }
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mExoticEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            rVoltage += tHatch.maxEUInput();
        }
        return rVoltage;
    }

    public String[] getInfoData() {
        return this.getInfoDataArray((GT_MetaTileEntity_MultiBlockBase)this);
    }

    protected long getRealVoltage() {
        long rEnergy = 0L;
        if (this.mEnergyHatches.size() == 1 && this.mExoticEnergyHatches.isEmpty()) {
            return ((GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get(0)).getBaseMetaTileEntity().getInputVoltage();
        }
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_LongPowerUsageBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            rEnergy += tHatch.maxEUInput() * tHatch.maxAmperesIn();
        }
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mExoticEnergyHatches) {
            if (!GT_MetaTileEntity_LongPowerUsageBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            rEnergy += tHatch.maxEUInput() * (long)((GT_MetaTileEntity_Hatch_EnergyMulti)tHatch).Amperes;
        }
        return rEnergy;
    }

    public long getMaxInputAmps() {
        long rAmps = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            rAmps += tHatch.maxAmperesIn();
        }
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mExoticEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            rAmps += (long)((GT_MetaTileEntity_Hatch_EnergyMulti)tHatch).Amperes;
        }
        return rAmps;
    }

    protected String[] getInfoDataArray(GT_MetaTileEntity_MultiBlockBase multiBlockBase) {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            mPollutionReduction = Math.max(tHatch.calculatePollutionReduction(100), mPollutionReduction);
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mExoticEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        long nominalV = this.getRealVoltage();
        String tName = BW_Util.getTierNameFromVoltage((long)this.getMaxInputVoltage());
        if (tName.equals("MAX+")) {
            tName = EnumChatFormatting.OBFUSCATED + "MAX+";
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)(this.mProgresstime / 20)) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)(this.mMaxProgresstime / 20)) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)(-this.lEUt)) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*" + GT_Utility.formatNumbers((long)this.getMaxInputAmps()) + "A) = " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)nominalV) + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + tName + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %"};
    }
}

