/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DynamoMulti;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.blocks.tileEntity.EssentiaHatch;
import goodgenerator.blocks.tileEntity.base.GT_MetaTileEntity_TooltipMultiBlockBase_EM;
import goodgenerator.crossmod.thaumcraft.LargeEssentiaEnergyData;
import goodgenerator.items.MyMaterial;
import goodgenerator.loader.Loaders;
import goodgenerator.util.DescTextLocalization;
import goodgenerator.util.ItemRefer;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.config.ConfigBlocks;

public class LargeEssentiaGenerator
extends GT_MetaTileEntity_TooltipMultiBlockBase_EM
implements IConstructable,
ISurvivalConstructable {
    private IStructureDefinition<LargeEssentiaGenerator> multiDefinition = null;
    protected int mStableValue = 0;
    protected int mTierLimit = -1;
    protected long mLeftEnergy;
    private int mUpgrade = 1;
    final XSTR R = new XSTR();
    protected ArrayList<EssentiaHatch> mEssentiaHatch = new ArrayList();

    public LargeEssentiaGenerator(String name) {
        super(name);
    }

    public LargeEssentiaGenerator(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public void construct(ItemStack itemStack, boolean hintsOnly) {
        this.structureBuild_EM(this.mName, 4, 0, 4, itemStack, hintsOnly);
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mStableValue = 0;
        this.mEssentiaHatch.clear();
        return this.structureCheck_EM(this.mName, 4, 0, 4) && this.mDynamoHatches.size() + this.eDynamoMulti.size() == 1 && this.checkHatchTier() && this.updateEssentiaHatchState();
    }

    public boolean checkHatchTier() {
        for (GT_MetaTileEntity_Hatch_Input tHatch : this.mInputHatches) {
            if (tHatch.mTier <= this.mTierLimit) continue;
            return false;
        }
        for (GT_MetaTileEntity_Hatch_Input tHatch : this.mDynamoHatches) {
            if (tHatch.mTier <= this.mTierLimit) continue;
            return false;
        }
        for (GT_MetaTileEntity_Hatch_Input tHatch : this.eDynamoMulti) {
            if (tHatch.mTier <= this.mTierLimit) continue;
            return false;
        }
        return true;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mStableValue = aNBT.func_74762_e("mStableValue");
        this.mLeftEnergy = aNBT.func_74763_f("mLeftEnergy");
        this.mUpgrade = aNBT.func_74762_e("mUpgrade");
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mStableValue", this.mStableValue);
        aNBT.func_74772_a("mLeftEnergy", this.mLeftEnergy);
        aNBT.func_74768_a("mUpgrade", this.mUpgrade);
    }

    public boolean updateEssentiaHatchState() {
        for (EssentiaHatch hatch : this.mEssentiaHatch) {
            hatch.mState = this.mUpgrade;
        }
        return true;
    }

    public boolean onWrenchRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aWrenchingSide == 0 || aWrenchingSide == 1) {
            return false;
        }
        if (this.getBaseMetaTileEntity().isValidFacing(aWrenchingSide)) {
            this.getBaseMetaTileEntity().setFrontFacing(aWrenchingSide);
            return true;
        }
        return false;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        ItemStack tCurrentItem;
        if (this.getBaseMetaTileEntity().isServerSide() && (tCurrentItem = aPlayer.field_71071_by.func_70448_g()) != null && tCurrentItem.func_77973_b().equals(ItemRefer.Essentia_Upgrade_Empty.get(1).func_77973_b())) {
            int tMeta = tCurrentItem.func_77960_j();
            if ((this.mUpgrade & 1 << tMeta) == 0 && tMeta != 0) {
                --tCurrentItem.field_77994_a;
                this.mUpgrade |= 1 << tMeta;
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(tCurrentItem.func_82833_r() + StatCollector.func_74838_a((String)"largeessentiagenerator.chat")));
            }
            this.updateEssentiaHatchState();
            return true;
        }
        super.onRightclick(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    public IStructureDefinition<LargeEssentiaGenerator> getStructure_EM() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"A       A", "         ", "         ", "         ", "    ~    ", "         ", "         ", "         ", "A       A"}, {"T   C   T", "   CEC   ", "  CEEEC  ", " CEEEEEC ", "CEEEEEEEC", " CEEEEEC ", "  CEEEC  ", "   CEC   ", "T   C   T"}, {"T  TXT  T", "  TCXCT  ", " TCCXCCT ", "TCCCXCCCT", "XXXXXXXXX", "TCCCXCCCT", " TCCXCCT ", "  TCXCT  ", "T  TXT  T"}})).addElement('A', StructureUtility.ofBlock((Block)ConfigBlocks.blockCosmeticOpaque, (int)1)).addElement('T', StructureUtility.ofBlock((Block)ConfigBlocks.blockCosmeticSolid, (int)7)).addElement('C', StructureUtility.ofBlock((Block)Loaders.magicCasing, (int)0)).addElement('E', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(x -> {
                ++x.mStableValue;
                x.mTierLimit = Math.max(x.mTierLimit, 4);
            }, (IStructureElement)StructureUtility.ofBlock((Block)Loaders.essentiaCell, (int)0)), StructureUtility.onElementPass(x -> {
                x.mStableValue += 2;
                x.mTierLimit = Math.max(x.mTierLimit, 5);
            }, (IStructureElement)StructureUtility.ofBlock((Block)Loaders.essentiaCell, (int)1)), StructureUtility.onElementPass(x -> {
                x.mStableValue += 5;
                x.mTierLimit = Math.max(x.mTierLimit, 6);
            }, (IStructureElement)StructureUtility.ofBlock((Block)Loaders.essentiaCell, (int)2)), StructureUtility.onElementPass(x -> {
                x.mStableValue += 10;
                x.mTierLimit = Math.max(x.mTierLimit, 7);
            }, (IStructureElement)StructureUtility.ofBlock((Block)Loaders.essentiaCell, (int)3))})).addElement('X', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(LargeEssentiaGenerator.class).atLeast(new IHatchElement[]{GT_MetaTileEntity_MultiblockBase_EM.HatchElement.DynamoMulti.or((IHatchElement)GT_HatchElement.Dynamo), GT_HatchElement.Maintenance, GT_HatchElement.InputHatch}).casingIndex(1536).dot(1).build(), StructureUtility.ofBlock((Block)Loaders.magicCasing, (int)0), StructureUtility.ofTileAdder(LargeEssentiaGenerator::addEssentiaHatch, (Block)Loaders.magicCasing, (int)0)})).build();
        }
        return this.multiDefinition;
    }

    public final boolean addEssentiaHatch(TileEntity aTileEntity) {
        if (aTileEntity instanceof EssentiaHatch) {
            return this.mEssentiaHatch.add((EssentiaHatch)aTileEntity);
        }
        return false;
    }

    public final boolean addLargeEssentiaGeneratorList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mDynamoHatches.add((GT_MetaTileEntity_Hatch_Dynamo)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DynamoMulti) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eDynamoMulti.add((GT_MetaTileEntity_Hatch_DynamoMulti)aMetaTileEntity);
        }
        return false;
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        this.mEfficiency = 10000;
        this.mMaxProgresstime = 1;
        this.setEssentiaToEUVoltageAndAmp(this.getVoltageLimit(), this.getAmpLimit());
        return true;
    }

    public int getVoltageLimit() {
        long voltage = 0L;
        for (GT_MetaTileEntity_Hatch tHatch : this.eDynamoMulti) {
            voltage += tHatch.maxEUOutput();
        }
        for (GT_MetaTileEntity_Hatch tHatch : this.mDynamoHatches) {
            voltage += tHatch.maxEUOutput();
        }
        if (voltage > Integer.MAX_VALUE) {
            voltage = Integer.MAX_VALUE;
        }
        return (int)voltage;
    }

    public int getAmpLimit() {
        long amp = 0L;
        for (GT_MetaTileEntity_Hatch tHatch : this.eDynamoMulti) {
            amp += tHatch.maxAmperesOut();
        }
        for (GT_MetaTileEntity_Hatch tHatch : this.mDynamoHatches) {
            amp += tHatch.maxAmperesOut();
        }
        if (amp > Integer.MAX_VALUE) {
            amp = Integer.MAX_VALUE;
        }
        return (int)amp;
    }

    public long getPerAspectEnergy(Aspect aspect) {
        int type = LargeEssentiaEnergyData.getAspectTypeIndex(aspect);
        if (!this.isValidEssentia(aspect)) {
            return 0L;
        }
        switch (type) {
            case 0: {
                return this.normalEssentia(aspect);
            }
            case 1: {
                return this.airEssentia(aspect);
            }
            case 2: {
                return this.thermalEssentia(aspect);
            }
            case 3: {
                return this.unstableEssentia(aspect);
            }
            case 4: {
                return this.victusEssentia(aspect);
            }
            case 5: {
                return this.taintedEssentia(aspect);
            }
            case 6: {
                return this.mechanicEssentia(aspect);
            }
            case 7: {
                return this.spiritEssentia(aspect);
            }
            case 8: {
                return this.radiationEssentia(aspect);
            }
            case 9: {
                return this.electricEssentia(aspect);
            }
        }
        return 0L;
    }

    public long normalEssentia(Aspect aspect) {
        return LargeEssentiaEnergyData.getAspectFuelValue(aspect);
    }

    public long airEssentia(Aspect aspect) {
        long baseValue = LargeEssentiaEnergyData.getAspectFuelValue(aspect);
        double ceoOutput = 0.0;
        int ceoInput = (int)LargeEssentiaEnergyData.getAspectCeo(aspect) * 8;
        if (this.depleteInput(Materials.LiquidAir.getFluid((long)ceoInput))) {
            ceoOutput = 1.5;
        } else if (this.depleteInput(Materials.Air.getGas((long)ceoInput))) {
            ceoOutput = 1.0;
        }
        return (long)((double)baseValue * ceoOutput);
    }

    public long thermalEssentia(Aspect aspect) {
        long baseValue = LargeEssentiaEnergyData.getAspectFuelValue(aspect);
        double ceoOutput = 0.0;
        int ceoInput = (int)LargeEssentiaEnergyData.getAspectCeo(aspect) * 2;
        if (this.depleteInput(Materials.SuperCoolant.getFluid((long)ceoInput))) {
            ceoOutput = 9.0;
        } else if (this.depleteInput(FluidRegistry.getFluidStack((String)"cryotheum", (int)ceoInput))) {
            ceoOutput = 5.0;
        } else if (this.depleteInput(FluidRegistry.getFluidStack((String)"ic2coolant", (int)ceoInput))) {
            ceoOutput = 1.5;
        } else if (this.depleteInput(Materials.Ice.getSolid((long)ceoInput))) {
            ceoOutput = 1.2;
        } else if (this.depleteInput(FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)ceoInput))) {
            ceoOutput = 1.0;
        } else if (this.depleteInput(Materials.Water.getFluid((long)ceoInput))) {
            ceoOutput = 0.5;
        }
        return (long)((double)baseValue * ceoOutput);
    }

    public long unstableEssentia(Aspect aspect) {
        long baseValue = LargeEssentiaEnergyData.getAspectFuelValue(aspect);
        double ceoOutput = 0.0;
        int ceoInput = (int)LargeEssentiaEnergyData.getAspectCeo(aspect) * 4;
        if (this.depleteInput(WerkstoffLoader.Xenon.getFluidOrGas(ceoInput))) {
            ceoOutput = 4.0;
        } else if (this.depleteInput(WerkstoffLoader.Krypton.getFluidOrGas(ceoInput))) {
            ceoOutput = 3.0;
        } else if (this.depleteInput(Materials.Argon.getFluid((long)ceoInput))) {
            ceoOutput = 2.5;
        } else if (this.depleteInput(WerkstoffLoader.Neon.getFluidOrGas(ceoInput))) {
            ceoOutput = 2.2;
        } else if (this.depleteInput(Materials.Helium.getFluid((long)ceoInput))) {
            ceoOutput = 2.0;
        } else if (this.depleteInput(Materials.Nitrogen.getFluid((long)ceoInput))) {
            ceoOutput = 1.0;
        }
        return (long)((double)baseValue * ceoOutput);
    }

    public long victusEssentia(Aspect aspect) {
        long baseValue = LargeEssentiaEnergyData.getAspectFuelValue(aspect);
        double ceoOutput = 1.0;
        int ceoInput = (int)LargeEssentiaEnergyData.getAspectCeo(aspect) * 18;
        if (this.depleteInput(FluidRegistry.getFluidStack((String)"xpjuice", (int)ceoInput))) {
            ceoOutput = 2.0;
        } else if (this.depleteInput(FluidRegistry.getFluidStack((String)"lifeessence", (int)ceoInput))) {
            ceoOutput = 6.0;
        }
        return (long)((double)baseValue * ceoOutput);
    }

    public long taintedEssentia(Aspect aspect) {
        int tZ;
        int tX;
        World world;
        long baseValue = LargeEssentiaEnergyData.getAspectFuelValue(aspect);
        double ceoOutput = 1.0;
        int ceoInput = (int)LargeEssentiaEnergyData.getAspectCeo(aspect) * 3;
        int chance = 2000;
        if (this.depleteInput(FluidRegistry.getFluidStack((String)"fluidpure", (int)ceoInput))) {
            ceoOutput = 60.0;
            chance = 0;
        } else if (this.depleteInput(FluidRegistry.getFluidStack((String)"fluiddeath", (int)ceoInput))) {
            ceoOutput = Math.pow(25000.0 / (double)baseValue, 4.0);
            chance = 4000;
        }
        if (this.R.nextInt(10000) < chance && (world = this.getBaseMetaTileEntity().getWorld()).func_147437_c(tX = this.R.nextInt(4), 0, tZ = this.R.nextInt(4))) {
            world.func_147465_d(tX, 0, tZ, ConfigBlocks.blockFluxGas, this.R.nextInt(8), 3);
        }
        return (long)((double)baseValue * ceoOutput);
    }

    public long mechanicEssentia(Aspect aspect) {
        long baseValue = LargeEssentiaEnergyData.getAspectFuelValue(aspect);
        double ceoOutput = 0.0;
        int ceoInput = (int)LargeEssentiaEnergyData.getAspectCeo(aspect) * 20;
        if (this.depleteInput(Materials.Lubricant.getFluid((long)ceoInput))) {
            ceoOutput = 1.0;
        }
        return (long)((double)baseValue * ceoOutput);
    }

    public long spiritEssentia(Aspect aspect) {
        long baseValue = LargeEssentiaEnergyData.getAspectFuelValue(aspect);
        double ceoOutput = 1.0;
        int ceoInput = (int)LargeEssentiaEnergyData.getAspectCeo(aspect) * 2;
        if (this.depleteInput(FluidRegistry.getFluidStack((String)"witchery:fluidspirit", (int)ceoInput))) {
            ceoOutput = 10.0 * (1.0 + (double)this.mStableValue / 100.0);
        } else if (this.depleteInput(FluidRegistry.getFluidStack((String)"witchery:hollowtears", (int)ceoInput))) {
            ceoOutput = 15.0 * (1.0 + 100.0 / (double)this.mStableValue);
        }
        return (long)((double)baseValue * ceoOutput);
    }

    public long radiationEssentia(Aspect aspect) {
        long baseValue = LargeEssentiaEnergyData.getAspectFuelValue(aspect);
        double ceoOutput = 1.0;
        int ceoInput = (int)LargeEssentiaEnergyData.getAspectCeo(aspect) * 6;
        if (this.depleteInput(Materials.Caesium.getMolten((long)ceoInput))) {
            ceoOutput = 2.0;
        } else if (this.depleteInput(Materials.Uranium235.getMolten((long)ceoInput))) {
            ceoOutput = 3.0;
        } else if (this.depleteInput(Materials.Naquadah.getMolten((long)ceoInput))) {
            ceoOutput = 4.0;
        } else if (this.depleteInput(MyMaterial.atomicSeparationCatalyst.getMolten(ceoInput))) {
            ceoOutput = 16.0;
        }
        return (long)((double)baseValue * ceoOutput);
    }

    public long electricEssentia(Aspect aspect) {
        long baseValue = LargeEssentiaEnergyData.getAspectFuelValue(aspect);
        double ceoOutput = Math.pow(3.0, GT_Utility.getTier((long)this.getVoltageLimit()));
        return (long)((double)baseValue * ceoOutput);
    }

    public void setEssentiaToEUVoltageAndAmp(long voltageLimit, long ampLimit) {
        long EUt = this.mLeftEnergy;
        long EUVoltage = voltageLimit;
        long EUAmp = 1L;
        for (EssentiaHatch hatch : this.mEssentiaHatch) {
            AspectList aspects = hatch.getAspects();
            for (Aspect aspect : aspects.aspects.keySet()) {
                if (!this.isValidEssentia(aspect) || this.getPerAspectEnergy(aspect) == 0L) continue;
                while (EUt <= voltageLimit * ampLimit && aspects.getAmount(aspect) > 0) {
                    EUt += this.getPerAspectEnergy(aspect) * (long)this.mStableValue / 25L;
                    aspects.reduce(aspect, 1);
                    if (aspects.getAmount(aspect) != 0) continue;
                    aspects.remove(aspect);
                }
            }
            if (EUt != 0L || aspects.size() == 0 || !this.isValidEssentia(aspects.getAspects()[0]) || this.getPerAspectEnergy(aspects.getAspects()[0]) == 0L) continue;
            EUt += this.getPerAspectEnergy(aspects.getAspects()[0]) * (long)this.mStableValue / 25L;
            aspects.reduce(aspects.getAspects()[0], 1);
            if (aspects.getAmount(aspects.getAspects()[0]) != 0) continue;
            aspects.remove(aspects.getAspects()[0]);
        }
        if (EUt <= voltageLimit) {
            EUVoltage = EUt;
            EUAmp = 1L;
            this.mLeftEnergy = 0L;
        } else {
            while (EUVoltage * (EUAmp + 1L) <= EUt && EUAmp + 1L <= ampLimit) {
                ++EUAmp;
            }
            this.mLeftEnergy = EUt - EUVoltage * EUAmp;
        }
        this.mEUt = (int)EUVoltage;
        this.eAmpereFlow = (int)EUAmp;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return DescTextLocalization.addText("LargeEssentiaGenerator.hint", 6);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new LargeEssentiaGenerator(this.mName);
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Essentia Generator").addInfo("Controller block for the Large Essentia Generator").addInfo("Maybe some thaumaturages are upset by it. . .").addInfo("Transform essentia into energy!").addInfo("The Diffusion Cell determines the highest hatch tier that the LEG can accept.").addInfo("You can find more information about this generator in the Thaumonomicon.").addInfo("The structure is too complex!").addInfo(DescTextLocalization.BLUE_PRINT_INFO).addSeparator().addMaintenanceHatch("Hint block with dot 1").addInputHatch("Hint block with dot 1").addDynamoHatch("Hint block with dot 1").addOtherStructurePart("Essentia Input Hatch", "Hint block with dot 1").toolTipFinisher("Good Generator");
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)1536), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_DRAGONEGG), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.MACHINE_CASING_DRAGONEGG_GLOW}).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)1536), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_DRAGONEGG)};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)1536)};
    }

    public boolean isValidEssentia(Aspect aspect) {
        int type = LargeEssentiaEnergyData.getAspectTypeIndex(aspect);
        return type != -1 && (this.mUpgrade & 1 << type) != 0;
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 4, 0, 4, elementBudget, source, actor, false, true);
    }
}

