/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.github.bartimaeusnek.bartworks.util.Pair;
import com.github.bartimaeusnek.crossmod.tectech.TecTechEnabledMulti;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DynamoMulti;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyTunnel;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.blocks.tileEntity.base.GT_MetaTileEntity_TooltipMultiBlockBase_EM;
import goodgenerator.items.MyMaterial;
import goodgenerator.loader.Loaders;
import goodgenerator.main.GG_Config_Loader;
import goodgenerator.util.CrackRecipeAdder;
import goodgenerator.util.DescTextLocalization;
import goodgenerator.util.MyRecipeAdder;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MultiNqGenerator
extends GT_MetaTileEntity_TooltipMultiBlockBase_EM
implements TecTechEnabledMulti,
IConstructable,
ISurvivalConstructable {
    protected IStructureDefinition<MultiNqGenerator> multiDefinition = null;
    protected long leftEnergy = 0L;
    protected long trueOutput = 0L;
    protected int trueEff = 0;
    protected FluidStack lockedFluid = null;
    protected int times = 1;
    protected int basicOutput;
    private static final List<Pair<FluidStack, Integer>> excitedLiquid = Arrays.asList(new Pair((Object)MyMaterial.atomicSeparationCatalyst.getMolten(20), (Object)GG_Config_Loader.ExcitedLiquidCoe[0]), new Pair((Object)Materials.Naquadah.getMolten(20L), (Object)GG_Config_Loader.ExcitedLiquidCoe[1]), new Pair((Object)Materials.Uranium235.getMolten(180L), (Object)GG_Config_Loader.ExcitedLiquidCoe[2]), new Pair((Object)Materials.Caesium.getMolten(180L), (Object)GG_Config_Loader.ExcitedLiquidCoe[3]));
    private static final List<Pair<FluidStack, Integer>> coolant = Arrays.asList(new Pair((Object)FluidRegistry.getFluidStack((String)"cryotheum", (int)1000), (Object)GG_Config_Loader.CoolantEfficiency[0]), new Pair((Object)Materials.SuperCoolant.getFluid(1000L), (Object)GG_Config_Loader.CoolantEfficiency[1]), new Pair((Object)FluidRegistry.getFluidStack((String)"ic2coolant", (int)1000), (Object)GG_Config_Loader.CoolantEfficiency[2]));

    public void construct(ItemStack itemStack, boolean hintsOnly) {
        this.structureBuild_EM(this.mName, 3, 7, 0, itemStack, hintsOnly);
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return DescTextLocalization.addText("MultiNqGenerator.hint", 8);
    }

    public final boolean addToGeneratorList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            return this.mOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            return this.mDynamoHatches.add((GT_MetaTileEntity_Hatch_Dynamo)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DynamoMulti) {
            return this.eDynamoMulti.add((GT_MetaTileEntity_Hatch_DynamoMulti)aMetaTileEntity);
        }
        return false;
    }

    public IStructureDefinition<MultiNqGenerator> getStructure_EM() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"AAAAAAA", "AAAAAAA", "AAAAAAA", "AAAAAAA", "AAAAAAA", "AAAAAAA", "AAAAAAA"}, {"N     N", "       ", "  CCC  ", "  CPC  ", "  CCC  ", "       ", "N     N"}, {"N     N", "       ", "  CCC  ", "  CPC  ", "  CCC  ", "       ", "N     N"}, {"N     N", "       ", "  CCC  ", "  CPC  ", "  CCC  ", "       ", "N     N"}, {"N     N", "       ", "  CCC  ", "  CPC  ", "  CCC  ", "       ", "N     N"}, {"AAAAAAA", "A     A", "A CCC A", "A CPC A", "A CCC A", "A     A", "AAAAAAA"}, {"ANNNNNA", "N     N", "N CCC N", "N CPC N", "N CCC N", "N     N", "ANNNNNA"}, {"XXX~XXX", "XXXXXXX", "XXXXXXX", "XXXXXXX", "XXXXXXX", "XXXXXXX", "XXXXXXX"}})).addElement('X', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(MultiNqGenerator.class).atLeast(new IHatchElement[]{GT_MetaTileEntity_MultiblockBase_EM.HatchElement.DynamoMulti.or((IHatchElement)GT_HatchElement.Dynamo), GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.Maintenance}).casingIndex(44).dot(1).build(), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings3, (int)12)})).addElement('A', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings3, (int)12)).addElement('N', StructureUtility.ofBlock((Block)Loaders.radiationProtectionSteelFrame, (int)0)).addElement('C', StructureUtility.ofBlock((Block)Loaders.MAR_Casing, (int)0)).addElement('P', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)15)).build();
        }
        return this.multiDefinition;
    }

    public MultiNqGenerator(String name) {
        super(name);
    }

    public MultiNqGenerator(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.times = aNBT.func_74762_e("mTimes");
        this.leftEnergy = aNBT.func_74763_f("mLeftEnergy");
        this.basicOutput = aNBT.func_74762_e("mbasicOutput");
        this.lockedFluid = FluidRegistry.getFluid((String)aNBT.func_74779_i("mLockedFluidName")) != null ? new FluidStack(FluidRegistry.getFluid((String)aNBT.func_74779_i("mLockedFluidName")), aNBT.func_74762_e("mLockedFluidAmount")) : null;
        super.loadNBTData(aNBT);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mTimes", this.times);
        aNBT.func_74772_a("mLeftEnergy", this.leftEnergy);
        aNBT.func_74768_a("mbasicOutput", this.basicOutput);
        if (this.lockedFluid != null) {
            aNBT.func_74778_a("mLockedFluidName", this.lockedFluid.getFluid().getName());
            aNBT.func_74768_a("mLockedFluidAmount", this.lockedFluid.amount);
        }
        super.saveNBTData(aNBT);
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        ArrayList tFluids = this.getStoredFluids();
        block0: for (int i = 0; i < tFluids.size() - 1; ++i) {
            for (int j = i + 1; j < tFluids.size(); ++j) {
                if (!GT_Utility.areFluidsEqual((FluidStack)((FluidStack)tFluids.get(i)), (FluidStack)((FluidStack)tFluids.get(j)))) continue;
                if (((FluidStack)tFluids.get((int)i)).amount >= ((FluidStack)tFluids.get((int)j)).amount) {
                    tFluids.remove(j--);
                    continue;
                }
                tFluids.remove(i--);
                continue block0;
            }
        }
        GT_Recipe tRecipe = MyRecipeAdder.instance.NqGFuels.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), true, 0x40000000L, tFluids.toArray(new FluidStack[0]), new ItemStack[0]);
        if (tRecipe != null) {
            int pall;
            Pair<FluidStack, Integer> excitedInfo = this.getExcited(tFluids.toArray(new FluidStack[0]), false);
            int n = pall = excitedInfo == null ? 1 : (Integer)excitedInfo.getValue();
            if (this.consumeFuel(CrackRecipeAdder.copyFluidWithAmount(tRecipe.mFluidInputs[0], pall), tFluids.toArray(new FluidStack[0]))) {
                this.mOutputFluids = new FluidStack[]{CrackRecipeAdder.copyFluidWithAmount(tRecipe.mFluidOutputs[0], pall)};
                this.basicOutput = tRecipe.mSpecialValue;
                this.times = pall;
                this.lockedFluid = excitedInfo == null ? null : (FluidStack)excitedInfo.getKey();
                this.mMaxProgresstime = tRecipe.mDuration;
                return true;
            }
        }
        return false;
    }

    public boolean onRunningTick(ItemStack stack) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (this.mMaxProgresstime != 0 && this.mProgresstime % 20 == 0) {
                FluidStack[] input = this.getStoredFluids().toArray(new FluidStack[0]);
                int eff = 100;
                int time = 1;
                if (GG_Config_Loader.LiquidAirConsumptionPerSecond != 0 && !this.consumeFuel(Materials.LiquidAir.getFluid((long)GG_Config_Loader.LiquidAirConsumptionPerSecond), input)) {
                    this.mEUt = 0;
                    this.trueEff = 0;
                    this.trueOutput = 0L;
                    return true;
                }
                if (this.getCoolant(input, true) != null) {
                    eff = (Integer)this.getCoolant(input, false).getValue();
                }
                if (this.consumeFuel(this.lockedFluid, input)) {
                    time = this.times;
                }
                this.mEUt = this.basicOutput * eff * time / 100;
                this.trueEff = eff;
                this.trueOutput = (long)this.basicOutput * (long)eff * (long)time / 100L;
            }
            this.addAutoEnergy(this.trueOutput);
        }
        return true;
    }

    public String[] getInfoData() {
        String[] info = super.getInfoData();
        info[4] = "Probably makes: " + EnumChatFormatting.RED + Math.abs(this.trueOutput) + EnumChatFormatting.RESET + " EU/t";
        info[6] = "Problems: " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " Efficiency: " + EnumChatFormatting.YELLOW + this.trueEff + EnumChatFormatting.RESET + " %";
        return info;
    }

    public boolean consumeFuel(FluidStack target, FluidStack[] input) {
        if (target == null) {
            return false;
        }
        for (FluidStack inFluid : input) {
            if (inFluid == null || !inFluid.isFluidEqual(target) || inFluid.amount < target.amount) continue;
            inFluid.amount -= target.amount;
            return true;
        }
        return false;
    }

    public Pair<FluidStack, Integer> getExcited(FluidStack[] input, boolean isConsume) {
        for (Pair<FluidStack, Integer> fluidPair : excitedLiquid) {
            FluidStack tFluid = (FluidStack)fluidPair.getKey();
            for (FluidStack inFluid : input) {
                if (inFluid == null || !inFluid.isFluidEqual(tFluid) || inFluid.amount < tFluid.amount) continue;
                if (isConsume) {
                    inFluid.amount -= tFluid.amount;
                }
                return fluidPair;
            }
        }
        return null;
    }

    public Pair<FluidStack, Integer> getCoolant(FluidStack[] input, boolean isConsume) {
        for (Pair<FluidStack, Integer> fluidPair : coolant) {
            FluidStack tFluid = (FluidStack)fluidPair.getKey();
            for (FluidStack inFluid : input) {
                if (inFluid == null || !inFluid.isFluidEqual(tFluid) || inFluid.amount < tFluid.amount) continue;
                if (isConsume) {
                    inFluid.amount -= tFluid.amount;
                }
                return fluidPair;
            }
        }
        return null;
    }

    public void addAutoEnergy(long outputPower) {
        long outputAmperes;
        long power;
        long voltage;
        if (this.eDynamoMulti.size() > 0) {
            for (GT_MetaTileEntity_Hatch tHatch : this.eDynamoMulti) {
                voltage = tHatch.maxEUOutput();
                power = voltage * tHatch.maxAmperesOut();
                if (outputPower > power) {
                    this.doExplosion(8 * GT_Utility.getTier((long)power));
                }
                if (outputPower >= voltage) {
                    this.leftEnergy += outputPower;
                    outputAmperes = this.leftEnergy / voltage;
                    this.leftEnergy -= outputAmperes * voltage;
                    this.addEnergyOutput_EM(voltage, outputAmperes);
                    continue;
                }
                this.addEnergyOutput_EM(outputPower, 1L);
            }
        }
        if (this.mDynamoHatches.size() > 0) {
            for (GT_MetaTileEntity_Hatch tHatch : this.mDynamoHatches) {
                voltage = tHatch.maxEUOutput();
                power = voltage * tHatch.maxAmperesOut();
                if (outputPower > power) {
                    this.doExplosion(8 * GT_Utility.getTier((long)power));
                }
                if (outputPower >= voltage) {
                    this.leftEnergy += outputPower;
                    outputAmperes = this.leftEnergy / voltage;
                    this.leftEnergy -= outputAmperes * voltage;
                    this.addEnergyOutput_EM(voltage, outputAmperes);
                    continue;
                }
                this.addEnergyOutput_EM(outputPower, 1L);
            }
        }
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.structureCheck_EM(this.mName, 3, 7, 0) && this.mMaintenanceHatches.size() == 1 && this.mDynamoHatches.size() + this.eDynamoMulti.size() == 1;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MultiNqGenerator(this.mName);
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Naquadah Reactor").addInfo("Controller block for the Naquadah Reactor").addInfo("Environmental Friendly!").addInfo("Generate power with the High-energy liquid.").addInfo(String.format("Consume liquid air %d L/s to keep running, otherwise" + EnumChatFormatting.YELLOW + " it will void your fuel" + EnumChatFormatting.GRAY + ".", GG_Config_Loader.LiquidAirConsumptionPerSecond)).addInfo("Input liquid nuclear fuel or liquid naquadah fuel.").addInfo("The reactor will explode when there are more than" + EnumChatFormatting.RED + " ONE" + EnumChatFormatting.GRAY + " types of fuel in the hatch!").addInfo("Consume coolant 1000 L/s to increase the efficiency:").addInfo(String.format("IC2 Coolant %d%%, Super Coolant %d%%, Cryotheum %d%%", GG_Config_Loader.CoolantEfficiency[2], GG_Config_Loader.CoolantEfficiency[1], GG_Config_Loader.CoolantEfficiency[0])).addInfo("Consume excited liquid to increase the output power:").addInfo(String.format("molten caesium | %dx power | 180 L/s ", GG_Config_Loader.ExcitedLiquidCoe[3])).addInfo(String.format("molten uranium-235 | %dx power | 180 L/s", GG_Config_Loader.ExcitedLiquidCoe[2])).addInfo(String.format("molten naquadah | %dx power | 20 L/s", GG_Config_Loader.ExcitedLiquidCoe[1])).addInfo(String.format("molten Atomic Separation Catalyst | %dx power | 20 L/s", GG_Config_Loader.ExcitedLiquidCoe[0])).addInfo("The structure is too complex!").addInfo(DescTextLocalization.BLUE_PRINT_INFO).addSeparator().beginStructureBlock(7, 8, 7, true).addController("Front bottom").addDynamoHatch("Any bottom layer casing, only accept ONE!").addInputHatch("Any bottom layer casing").addOutputHatch("Any bottom layer casing").addMaintenanceHatch("Any bottom layer casing").toolTipFinisher("Good Generator");
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)44), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_FRONT_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_FRONT_ACTIVE_GLOW}).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)44), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_FRONT)};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)44)};
    }

    public List<GT_MetaTileEntity_Hatch_Energy> getVanillaEnergyHatches() {
        return this.mEnergyHatches;
    }

    public List<GT_MetaTileEntity_Hatch_EnergyTunnel> getTecTechEnergyTunnels() {
        return new ArrayList<GT_MetaTileEntity_Hatch_EnergyTunnel>();
    }

    public List<GT_MetaTileEntity_Hatch_EnergyMulti> getTecTechEnergyMultis() {
        return new ArrayList<GT_MetaTileEntity_Hatch_EnergyMulti>();
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 3, 7, 0, elementBudget, source, actor, false, true);
    }
}

