/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity.GTMetaTileEntity;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.GT_Mod;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicGenerator;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import net.minecraft.item.ItemStack;

public class DieselGenerator
extends GT_MetaTileEntity_BasicGenerator {
    public int mEfficiency;

    public DieselGenerator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, new String[]{"Requires liquid Fuel", "Causes " + (int)((double)GT_Mod.gregtechproxy.mPollutionBaseDieselGeneratorPerSecond * (1.1 - (double)aTier * 0.1)) + " Pollution per second"}, new ITexture[0]);
        this.mEfficiency = 100 - aTier * 10;
    }

    public DieselGenerator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        this.mEfficiency = 100 - aTier * 10;
    }

    public boolean isOutputFacing(byte aSide) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing();
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new DieselGenerator(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public GT_Recipe.GT_Recipe_Map getRecipes() {
        return GT_Recipe.GT_Recipe_Map.sDieselFuels;
    }

    public int getCapacity() {
        return 16000;
    }

    public int getEfficiency() {
        return this.mEfficiency;
    }

    public int getFuelValue(ItemStack aStack) {
        if (GT_Utility.isStackInvalid((Object)aStack) || this.getRecipes() == null) {
            return 0;
        }
        long rValue = Math.max(GT_ModHandler.getFuelCanValue((ItemStack)aStack) * 6 / 5, super.getFuelValue(aStack));
        if (ItemList.Fuel_Can_Plastic_Filled.isStackEqual((Object)aStack, false, true)) {
            rValue = Math.max(rValue, (long)GameRegistry.getFuelValue((ItemStack)aStack) * 3L);
        }
        if (rValue > Integer.MAX_VALUE) {
            throw new ArithmeticException("Integer LOOPBACK!");
        }
        return (int)rValue;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aTick % 100L == 0L && this.mFluid != null && this.mFluid.amount > this.getCapacity()) {
            GT_Log.err.println("Dupe Abuse: " + aBaseMetaTileEntity.getOwnerName() + " Coords: " + aBaseMetaTileEntity.getXCoord() + " " + aBaseMetaTileEntity.getYCoord() + " " + aBaseMetaTileEntity.getZCoord());
            aBaseMetaTileEntity.setToFire();
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{super.getFront(aColor)[0], TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_FRONT), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.DIESEL_GENERATOR_FRONT_GLOW}).glow().build()}), Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{super.getBack(aColor)[0], TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_BACK), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.DIESEL_GENERATOR_BACK_GLOW}).glow().build()})};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{super.getBottom(aColor)[0], TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_BOTTOM), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.DIESEL_GENERATOR_BOTTOM_GLOW}).glow().build()})};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{super.getTop(aColor)[0], TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_TOP), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.DIESEL_GENERATOR_TOP_GLOW}).glow().build()})};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{super.getSides(aColor)[0], TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_SIDE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.DIESEL_GENERATOR_SIDE_GLOW}).glow().build()})};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{super.getFrontActive(aColor)[0], TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_FRONT_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.DIESEL_GENERATOR_FRONT_ACTIVE_GLOW}).glow().build()}), Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
    }

    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{super.getBackActive(aColor)[0], TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_BACK_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.DIESEL_GENERATOR_BACK_ACTIVE_GLOW}).glow().build()})};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{super.getBottomActive(aColor)[0], TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_BOTTOM_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.DIESEL_GENERATOR_BOTTOM_ACTIVE_GLOW}).glow().build()})};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{super.getTopActive(aColor)[0], TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_TOP_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.DIESEL_GENERATOR_TOP_ACTIVE_GLOW}).glow().build()})};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{super.getSidesActive(aColor)[0], TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_SIDE_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.DIESEL_GENERATOR_SIDE_ACTIVE_GLOW}).glow().build()})};
    }

    public int getPollution() {
        return (int)((double)GT_Mod.gregtechproxy.mPollutionBaseDieselGeneratorPerSecond * (1.1 - (double)this.mTier * 0.1));
    }
}

