/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.items.nuclear;

import com.github.bartimaeusnek.bartworks.util.Pair;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import goodgenerator.items.nuclear.IsotopeMaterial;
import goodgenerator.main.GoodGenerator;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.GT_MetaGenerated_Item;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_OreDictUnificator;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;

public class NuclearMetaItemGenerator
extends GT_MetaGenerated_Item {
    public static final Pair<Integer, String>[] TYPE_OFFSET = new Pair[]{new Pair((Object)1000, (Object)"%s"), new Pair((Object)2000, (Object)"Tiny of %s"), new Pair((Object)3000, (Object)"%s Oxide"), new Pair((Object)4000, (Object)"Tiny of %s Oxide")};
    public static final Pair<Integer, String>[] OREPREFIX = new Pair[]{new Pair((Object)1000, (Object)"item%s"), new Pair((Object)2000, (Object)"itemTiny%s"), new Pair((Object)3000, (Object)"item%sOxide"), new Pair((Object)4000, (Object)"itemTiny%sOxide")};

    public NuclearMetaItemGenerator() {
        super("nuclearIsotopeMaterial", (short)32766, (short)0);
        this.func_77637_a(GoodGenerator.GG);
        for (IsotopeMaterial tIsotope : IsotopeMaterial.mIsotopeMaterial) {
            ItemStack tStack;
            String tOreName;
            int tOffset;
            for (Pair<Integer, String> tType : TYPE_OFFSET) {
                tOffset = (Integer)tType.getKey();
                tOreName = (String)tType.getValue();
                tStack = new ItemStack((Item)this, 1, tIsotope.mID + tOffset);
                GT_LanguageManager.addStringLocalization((String)(this.func_77667_c(tStack) + ".name"), (String)String.format(tOreName, tIsotope.mLocalizedName));
                GT_LanguageManager.addStringLocalization((String)(this.func_77667_c(tStack) + ".tooltip"), (String)(EnumChatFormatting.AQUA + String.format("%s's Isotope.", tIsotope.mMaterialName) + EnumChatFormatting.RESET));
            }
            for (Pair<Integer, String> tOreDict : OREPREFIX) {
                tOffset = (Integer)tOreDict.getKey();
                tOreName = (String)tOreDict.getValue();
                tStack = new ItemStack((Item)this, 1, tIsotope.mID + tOffset);
                GT_OreDictUnificator.registerOre((Object)String.format(tOreName, tIsotope.mName), (ItemStack)tStack);
            }
        }
    }

    public String func_77653_i(ItemStack aStack) {
        return GT_LanguageManager.getTranslation((String)(this.func_77667_c(aStack) + ".name"));
    }

    public IIconContainer getIconContainer(int aMetaData) {
        int tID = aMetaData % 1000;
        int tType = aMetaData / 1000 - 1;
        IsotopeMaterial tMaterial = IsotopeMaterial.mIDMap.get(tID);
        if (tMaterial != null) {
            return tMaterial.mTexture.mTextures[tType];
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item var1, CreativeTabs aCreativeTab, List aList) {
        for (IsotopeMaterial tIsotope : IsotopeMaterial.mIsotopeMaterial) {
            for (int i = 1; i <= 4; ++i) {
                ItemStack tStack = new ItemStack((Item)this, 1, tIsotope.mID + i * 1000);
                aList.add(tStack);
            }
        }
    }

    public short[] getRGBa(ItemStack aStack) {
        int tID = aStack.func_77960_j() % 1000;
        int tType = aStack.func_77960_j() / 1000;
        IsotopeMaterial tMaterial = IsotopeMaterial.mIDMap.get(tID);
        if (tMaterial != null) {
            if (tType == 1 || tType == 2) {
                return tMaterial.mRGB;
            }
            return tMaterial.mRGBO;
        }
        return null;
    }

    public final IIcon func_77617_a(int aMetaData) {
        return this.getIconContainer(aMetaData).getIcon();
    }
}

