/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import goodgenerator.crossmod.thaumcraft.LargeEssentiaEnergyData;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;

public class EssentiaHatch
extends TileEntity
implements IAspectContainer,
IEssentiaTransport {
    private Aspect mLocked;
    private AspectList current = new AspectList();
    public int mState = 0;

    public void setLockedAspect(Aspect aAspect) {
        this.mLocked = aAspect;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.mLocked = Aspect.getAspect((String)tagCompound.func_74779_i("mLocked"));
        this.mState = tagCompound.func_74762_e("mState");
        this.current = new AspectList();
        NBTTagList tlist = tagCompound.func_150295_c("Aspects", 10);
        for (int j = 0; j < tlist.func_74745_c(); ++j) {
            NBTTagCompound rs = tlist.func_150305_b(j);
            if (!rs.func_74764_b("key")) continue;
            this.current.add(Aspect.getAspect((String)rs.func_74779_i("key")), rs.func_74762_e("amount"));
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        Aspect[] aspectA;
        super.func_145841_b(tagCompound);
        tagCompound.func_74778_a("mLocked", this.mLocked == null ? "" : this.mLocked.getTag());
        tagCompound.func_74768_a("mState", this.mState);
        NBTTagList tlist = new NBTTagList();
        for (Aspect aspect : aspectA = this.current.getAspects()) {
            if (aspect == null) continue;
            NBTTagCompound f = new NBTTagCompound();
            f.func_74778_a("key", aspect.getTag());
            f.func_74768_a("amount", this.current.getAmount(aspect));
            tlist.func_74742_a((NBTBase)f);
        }
        tagCompound.func_74782_a("Aspects", (NBTBase)tlist);
    }

    public final Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.func_145839_a(nbt);
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        this.fillfrompipe();
    }

    public void fillfrompipe() {
        if (this.getEssentiaAmount(null) > 1000) {
            return;
        }
        TileEntity[] te = new TileEntity[ForgeDirection.VALID_DIRECTIONS.length];
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            Aspect readyInput;
            int type;
            te[i] = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (ForgeDirection)ForgeDirection.VALID_DIRECTIONS[i]);
            if (te[i] == null) continue;
            IEssentiaTransport pipe = (IEssentiaTransport)te[i];
            if (!pipe.canOutputTo(ForgeDirection.VALID_DIRECTIONS[i])) {
                return;
            }
            if (pipe.getEssentiaType(ForgeDirection.VALID_DIRECTIONS[i].getOpposite()) == null || pipe.getSuctionAmount(ForgeDirection.VALID_DIRECTIONS[i]) >= this.getSuctionAmount(ForgeDirection.VALID_DIRECTIONS[i]) || (type = LargeEssentiaEnergyData.getAspectTypeIndex(readyInput = pipe.getEssentiaType(ForgeDirection.VALID_DIRECTIONS[i].getOpposite()))) != -1 && (this.mState & 1 << type) == 0) continue;
            if (readyInput.equals(this.mLocked)) {
                this.addToContainer(this.mLocked, pipe.takeEssentia(this.mLocked, 1, ForgeDirection.VALID_DIRECTIONS[i]));
            }
            if (this.mLocked != null) continue;
            this.addToContainer(pipe.getEssentiaType(ForgeDirection.VALID_DIRECTIONS[i]), pipe.takeEssentia(pipe.getEssentiaType(ForgeDirection.VALID_DIRECTIONS[i]), 1, ForgeDirection.VALID_DIRECTIONS[i]));
        }
    }

    public AspectList getAspects() {
        return this.current;
    }

    public void setAspects(AspectList aspectList) {
        this.current.add(aspectList);
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return this.mLocked == null || this.mLocked.equals(aspect);
    }

    public int addToContainer(Aspect aspect, int i) {
        this.current.add(aspect, i);
        this.func_70296_d();
        return 0;
    }

    public boolean takeFromContainer(Aspect aspect, int i) {
        return false;
    }

    public boolean takeFromContainer(AspectList aspectList) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int i) {
        return this.current.aspects.containsKey(aspect) && i <= this.current.getAmount(aspect);
    }

    public boolean doesContainerContain(AspectList aspectList) {
        ArrayList<Boolean> ret = new ArrayList<Boolean>();
        for (Aspect a : aspectList.aspects.keySet()) {
            ret.add(this.current.aspects.containsKey(a));
        }
        return !ret.contains(false);
    }

    public int containerContains(Aspect aspect) {
        return this.current.aspects.containsKey(aspect) ? this.current.getAmount(aspect) : 0;
    }

    public boolean isConnectable(ForgeDirection forgeDirection) {
        return true;
    }

    public boolean canInputFrom(ForgeDirection forgeDirection) {
        return true;
    }

    public boolean canOutputTo(ForgeDirection forgeDirection) {
        return false;
    }

    public void setSuction(Aspect aspect, int i) {
    }

    public Aspect getSuctionType(ForgeDirection forgeDirection) {
        return this.mLocked;
    }

    public int getSuctionAmount(ForgeDirection forgeDirection) {
        return 256;
    }

    public int takeEssentia(Aspect aspect, int i, ForgeDirection forgeDirection) {
        return 0;
    }

    public int addEssentia(Aspect aspect, int i, ForgeDirection forgeDirection) {
        this.current.add(aspect, i);
        return 0;
    }

    public Aspect getEssentiaType(ForgeDirection forgeDirection) {
        return this.current.getAspects()[0];
    }

    public int getEssentiaAmount(ForgeDirection forgeDirection) {
        int ret = 0;
        for (Aspect A : this.current.aspects.keySet()) {
            ret += this.current.getAmount(A);
        }
        return ret;
    }

    public int getMinimumSuction() {
        return Integer.MAX_VALUE;
    }

    public boolean renderExtendedTube() {
        return true;
    }
}

