/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity.GTMetaTileEntity;

import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import net.minecraft.nbt.NBTTagCompound;

public class NeutronAccelerator
extends GT_MetaTileEntity_Hatch_Energy {
    public boolean isRunning;

    public NeutronAccelerator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public NeutronAccelerator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public int getMaxEUConsume() {
        return (int)(GT_Values.V[this.mTier] * 8L / 10L);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.isRunning = aNBT.func_74767_n("isRunning");
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("isRunning", this.isRunning);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new NeutronAccelerator(this.mName, this.mTier, this.getDescription(), this.mTextures);
    }

    public String[] getDescription() {
        return new String[]{"Input EU to Accelerate the Neutron!", "Max EU input: " + this.maxEUInput(), "Max EU consumption: " + this.getMaxEUConsume(), "Every EU can be transformed into 10~20 eV Neutron Kinetic Energy."};
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (aBaseMetaTileEntity.getStoredEU() >= (long)this.getMaxEUConsume() && aBaseMetaTileEntity.isAllowedToWork()) {
                this.setEUVar(aBaseMetaTileEntity.getStoredEU() - (long)this.getMaxEUConsume());
                this.isRunning = true;
            } else {
                this.isRunning = false;
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }
}

