/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.tile.machine.multi;

import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import galaxyspace.GalaxySpace;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.register.GSBlocks;
import galaxyspace.core.register.GSItems;
import galaxyspace.core.tile.machine.multi.GT_MetaTileEntity_EnhancedMultiBlockBase_EM;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.WorldProvider;

public class TileEntityDysonSwarm
extends GT_MetaTileEntity_EnhancedMultiBlockBase_EM {
    public static ItemStack instance;
    private static BiConsumer<List<ItemStack>, Integer> moduleDestroyer;
    private static IIconContainer OVERLAY_FRONT_GLOW;
    private static IIconContainer OVERLAY_FRONT_ACTIVE_GLOW;
    private static ITexture OVERLAY_FRONT;
    private static ITexture OVERLAY_FRONT_ACTIVE;
    private static Map<String, Float> powerFactors;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final int CASING_INDEX_CONTROL = 150;
    private static final int CASING_INDEX_TESLA = 151;
    private static final int CASING_INDEX_LAUNCH = 152;
    private static final int CASING_INDEX_FLOOR = 153;
    private static final IStructureDefinition<TileEntityDysonSwarm> STRUCTURE_DEFINITION;
    private long euPerTick = 0L;
    private float powerFactor = 0.0f;
    private int moduleCount = 0;

    public TileEntityDysonSwarm(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TileEntityDysonSwarm(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TileEntityDysonSwarm(this.mName);
    }

    public void onFirstTick_EM(IGregTechTileEntity aBaseMetaTileEntity) {
        this.powerFactor = this.getPowerFactor();
    }

    public void onServerStart() {
        this.powerFactor = this.getPowerFactor();
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(STRUCTURE_PIECE_MAIN, 10, 18, 3, hintsOnly, stackSize);
    }

    @Override
    public IStructureDefinition<? extends GT_MetaTileEntity_MultiblockBase_EM> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.structureCheck_EM(STRUCTURE_PIECE_MAIN, 10, 18, 3) && this.mMaintenanceHatches.size() == 1 && this.mInputBusses.size() > 0 && this.mInputHatches.size() > 0 && (this.mDynamoHatches.size() > 0 || this.eDynamoMulti.size() > 0);
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        ArrayList<ItemStack> modules = new ArrayList<ItemStack>();
        this.moduleCount = 0;
        for (GT_MetaTileEntity_Hatch_InputBus bus : this.mInputBusses) {
            if (!TileEntityDysonSwarm.isValidMetaTileEntity((MetaTileEntity)bus)) continue;
            for (int i = 0; i < bus.getBaseMetaTileEntity().func_70302_i_(); ++i) {
                ItemStack stack = bus.getBaseMetaTileEntity().func_70301_a(i);
                if (stack == null || stack.func_77973_b() != GSItems.DysonSwarmModule) continue;
                this.moduleCount += stack.field_77994_a;
                modules.add(stack);
            }
        }
        this.euPerTick = (long)((float)((long)this.moduleCount * (long)GSConfigCore.euPerModule) * this.powerFactor);
        if (this.moduleCount > 0 && this.depleteInput(GSConfigCore.coolantFluid)) {
            moduleDestroyer.accept(modules, this.moduleCount);
            this.mEfficiencyIncrease = 10000;
            this.mMaxProgresstime = 20;
            return true;
        }
        this.mEfficiency = 0;
        return false;
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.euPerTick > 0L) {
            this.addEnergyOutput_EM(this.euPerTick, 1L);
        }
        return true;
    }

    public boolean addEnergyOutput_EM(long EU, long Amperes) {
        return this.addEnergyOutput_EM(EU, Amperes, true);
    }

    public boolean addEnergyOutput_EM(long EU, long Amperes, boolean allowMixedVoltages) {
        long diff;
        if (EU < 0L) {
            EU = -EU;
        }
        if (Amperes < 0L) {
            Amperes = -Amperes;
        }
        long euVar = EU * Amperes;
        for (GT_MetaTileEntity_Hatch_Dynamo tHatch : this.mDynamoHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            if (tHatch.maxEUOutput() < euVar && !allowMixedVoltages) {
                this.explodeMultiblock();
            }
            if ((diff = tHatch.maxEUStore() - tHatch.getBaseMetaTileEntity().getStoredEU()) <= 0L) continue;
            if (euVar > diff) {
                tHatch.setEUVar(tHatch.maxEUStore());
                euVar -= diff;
                continue;
            }
            if (euVar > diff) continue;
            tHatch.setEUVar(tHatch.getBaseMetaTileEntity().getStoredEU() + euVar);
            return true;
        }
        for (GT_MetaTileEntity_Hatch_Dynamo tHatch : this.eDynamoMulti) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            if (tHatch.maxEUOutput() < euVar && !allowMixedVoltages) {
                this.explodeMultiblock();
            }
            if ((diff = tHatch.maxEUStore() - tHatch.getBaseMetaTileEntity().getStoredEU()) <= 0L) continue;
            if (euVar > diff) {
                tHatch.setEUVar(tHatch.maxEUStore());
                euVar -= diff;
                continue;
            }
            if (euVar > diff) continue;
            tHatch.setEUVar(tHatch.getBaseMetaTileEntity().getStoredEU() + euVar);
            return true;
        }
        this.explodeMultiblock();
        return false;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)150), TextureFactory.of((ITexture[])new ITexture[]{OVERLAY_FRONT_ACTIVE}), TextureFactory.builder().addIcon(new IIconContainer[]{OVERLAY_FRONT_ACTIVE_GLOW}).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)150), TextureFactory.of((ITexture[])new ITexture[]{OVERLAY_FRONT}), TextureFactory.builder().addIcon(new IIconContainer[]{OVERLAY_FRONT_GLOW}).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)150)};
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Dyson Swarm").addInfo("Controller Block for the Dyson Swarm Command Center").addInfo("Put Dyson Swarm Modules in the Input Hatch(es) to increase energy output by " + NumberFormat.getNumberInstance().format(GSConfigCore.euPerModule) + "EU/t per Item");
        if (GSConfigCore.destroyModuleChance > 0.0) {
            tt.addInfo(NumberFormat.getPercentInstance().format(GSConfigCore.destroyModuleChance) + " chance of destruction of a Dyson Swarm Module per second per Item");
        }
        tt.addInfo("Consumes " + NumberFormat.getNumberInstance().format(GSConfigCore.coolantConsumption) + "L of " + GSConfigCore.coolantFluid.getLocalizedName() + " per second").addSeparator().beginStructureBlock(16, 20, 16, false).addStructureInfo(EnumChatFormatting.ITALIC + "This structure is too complex to describe, use the Multiblock Structure Hologram Projector!").addDynamoHatch("Can use Single- and/or Multi-Amp Dynamo Hatches and/or Laser Source Hatches (1 - 12)", new int[]{1}).addMaintenanceHatch("1", new int[]{3}).addInputBus("1 - 11", new int[]{2}).addInputHatch("1 - 11", new int[]{2}).addStructureInfo("").addStructureInfo(EnumChatFormatting.ITALIC + "Additionally needed:").addStructureInfo("Energy Receiver Base Casing: 53 - 64 (depending on the amount of Dynamo Hatches)").addStructureInfo("Energy Receiver Dish Block: 81").addStructureInfo("Module Deployment Unit Base Casing: 62 - 72 (depending on the amount of Input Busses & Hatches)").addStructureInfo("Module Deployment Unit Core: 1").addStructureInfo("Module Deployment Unit Superconducting Magnet: 32").addStructureInfo("Control Center Base Casing: 139").addStructureInfo("Control Center Primary Windings: 20").addStructureInfo("Control Center Secondary Windings: 12").addStructureInfo("Ultra Hign Strenght Concrete Floor: 1").addStructureInfo("Awakened Draconium Coil Block: 9").addStructureInfo("Hermetic Casing X: 1").addStructureInfo("Titanium Frame Box: 16").addStructureInfo("HSS-S Frame Box: 23").addStructureInfo("Superconductor Base UHV Frame Box: 64").toolTipFinisher(EnumChatFormatting.DARK_PURPLE + "GalaxySpace");
        return tt;
    }

    public String[] getInfoData() {
        return new String[]{EnumChatFormatting.LIGHT_PURPLE + "Operational Data:" + EnumChatFormatting.RESET, "Modules: " + EnumChatFormatting.YELLOW + NumberFormat.getNumberInstance().format(this.moduleCount) + EnumChatFormatting.RESET, "Power Factor: " + (this.powerFactor < 1.0f ? EnumChatFormatting.RED : EnumChatFormatting.GREEN) + NumberFormat.getPercentInstance().format(this.powerFactor) + EnumChatFormatting.RESET, "Theoretical Output: " + EnumChatFormatting.YELLOW + NumberFormat.getNumberInstance().format((float)((long)this.moduleCount * (long)GSConfigCore.euPerModule) * this.powerFactor) + EnumChatFormatting.RESET + " EU/t", "Current Output: " + EnumChatFormatting.YELLOW + NumberFormat.getNumberInstance().format(this.euPerTick) + EnumChatFormatting.RESET + " EU/t", "Maintenance Status: " + (this.getRepairStatus() == this.getIdealStatus() ? EnumChatFormatting.GREEN + "Working perfectly" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "Has problems" + EnumChatFormatting.RESET), "---------------------------------------------"};
    }

    public float getPowerFactor() {
        WorldProvider provider = this.getBaseMetaTileEntity().getWorld().field_73011_w;
        if (provider instanceof IOrbitDimension) {
            return powerFactors.getOrDefault("SS_" + ((IOrbitDimension)provider).getPlanetToOrbit(), Float.valueOf(GSConfigCore.powerFactorDefault)).floatValue();
        }
        if (provider.getClass().getName().equals("zarkov.utilityworlds.UW_WorldProviderGarden")) {
            return powerFactors.getOrDefault("UW_Garden", Float.valueOf(GSConfigCore.powerFactorDefault)).floatValue();
        }
        if (provider.getClass().getName().equals("zarkov.utilityworlds.UW_WorldProviderMining")) {
            return powerFactors.getOrDefault("UW_Mining", Float.valueOf(GSConfigCore.powerFactorDefault)).floatValue();
        }
        if (provider.getClass().getName().equals("zarkov.utilityworlds.UW_WorldProviderVoid")) {
            return powerFactors.getOrDefault("UW_Void", Float.valueOf(GSConfigCore.powerFactorDefault)).floatValue();
        }
        return powerFactors.getOrDefault(String.valueOf(provider.field_76574_g), Float.valueOf(69.0f)).floatValue();
    }

    public static void initCommon() {
        instance = new TileEntityDysonSwarm(1337, "DysonSwarm", "Dyson Swarm Ground Unit").getStackForm(1L);
        powerFactors = new HashMap<String, Float>();
        for (String s : GSConfigCore.powerFactors) {
            String[] parts = s.split(":");
            try {
                powerFactors.put(parts[0], Float.valueOf(Float.parseFloat(parts[1])));
            }
            catch (Exception e) {
                GalaxySpace.error("Error while trying to parse \"" + s + "\"!");
                e.printStackTrace();
            }
        }
        moduleDestroyer = GSConfigCore.destroyModuleChance > 0.0 ? (stacks, amount) -> {
            int destructionAmount = (int)(TileEntityDysonSwarm.getRandom() * GSConfigCore.destroyModuleChance * (double)amount.intValue());
            for (int i = stacks.size() - 1; i >= 0; --i) {
                ItemStack moduleStack = (ItemStack)stacks.get(i);
                int diff = destructionAmount - moduleStack.field_77994_a;
                if (diff <= 0) {
                    moduleStack.field_77994_a -= destructionAmount;
                    return;
                }
                moduleStack = null;
                destructionAmount = diff;
            }
        } : (stacks, amount) -> {};
    }

    private static double getRandom() {
        double d = XSTR.XSTR_INSTANCE.nextGaussian() + 1.0;
        return d < 0.0 || d > 2.0 ? TileEntityDysonSwarm.getRandom() : d;
    }

    public static void initClient() {
        TileEntityDysonSwarm.initCommon();
        Textures.BlockIcons.setCasingTextureForId((int)150, (ITexture)TextureFactory.of((Block)GSBlocks.DysonSpherePart, (int)0));
        Textures.BlockIcons.setCasingTextureForId((int)152, (ITexture)TextureFactory.of((Block)GSBlocks.DysonSpherePart, (int)2));
        Textures.BlockIcons.setCasingTextureForId((int)151, (ITexture)TextureFactory.of((Block)GSBlocks.DysonSpherePart, (int)5));
        Textures.BlockIcons.setCasingTextureForId((int)153, (ITexture)TextureFactory.of((Block)GSBlocks.DysonSpherePart, (int)9));
        OVERLAY_FRONT = TextureFactory.of((IIconContainer)new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_FRONT_DYSONSPHERE"));
        OVERLAY_FRONT_ACTIVE = TextureFactory.of((IIconContainer)new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_FRONT_DYSONSPHERE_ACTIVE"));
        OVERLAY_FRONT_GLOW = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_FRONT_DYSONSPHERE_GLOW");
        OVERLAY_FRONT_ACTIVE_GLOW = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_FRONT_DYSONSPHERE_ACTIVE_GLOW");
    }

    static {
        STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----------", "     -----------", "      --------- ", "       -------  ", "        -----   ", "         ---    ", "  ttt           ", "  ttt        k  ", "  ttt       k k ", "             k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----------", "     -----------", "      --------- ", "       -------  ", "        -----   ", "  ttt    ---    ", " ttttt          ", " ttttt       k  ", " ttttt      k k ", "  ttt        k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----------", "     -----------", "      --------- ", "       -------  ", "        -----   ", "  ttt    ---    ", " ttttt          ", " ttttt       k  ", " ttttt      k k ", "  ttt        k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----------", "     -----------", "      --------- ", "       -------  ", "        -----   ", "  ttt    ---    ", " ttttt          ", " ttttt       k  ", " ttttt      k k ", "  ttt        k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----------", "     -----------", "      --------- ", "       -------  ", "        -----   ", "         ---    ", "  ttt           ", "  tst        k  ", "  ttt       k k ", "             k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----------", "     -----------", "      --------- ", "       -------  ", "        -----   ", "         ---    ", "                ", "   s         k  ", "            k k ", "             k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----h-----", "     -----------", "      --------- ", "       -------  ", "        -----   ", "  ttt    ---    ", " t g t          ", " tgsgt       k  ", " t g t      k k ", "  ttt        k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----f-----", "     -----------", "      --------- ", "       -------  ", "        -----   ", "         ---    ", "                ", "   s         k  ", "            k k ", "             k  ", "                "}, {"         ddd    ", "        d---d   ", "       d-----d  ", "      d-------d ", "     d---------d", "     d----f----d", "     d---------d", "      d-------d ", "       d-----d  ", "        d---d   ", "  ttt    ddd    ", " t g t          ", " tgsgt      kmk ", " t g t      m m ", "  ttt       kmk ", "                "}, {"                ", "         ddd    ", "        ddddd   ", "       dd---dd  ", "      dd-----dd ", "      dd--f--dd ", "      dd-----dd ", "       dd---dd  ", "        ddddd   ", "         ddd    ", "                ", "                ", "   s        kmk ", "            m m ", "            kmk ", "                "}, {"                ", "                ", "                ", "         ddd    ", "        ddddd   ", "        ddddd   ", "        ddddd   ", "         ddd    ", "                ", "                ", "  ttt           ", " t g t          ", " tgsgt      kmk ", " t g t      m m ", "  ttt       kmk ", "                "}, {"                ", "                ", "                ", "                ", "         f f    ", "                ", "         f f    ", "                ", "                ", "                ", "                ", "                ", "   s        kmk ", "            m m ", "            kmk ", "                "}, {"                ", "                ", "                ", "                ", "         f f    ", "                ", "         f f    ", "                ", "                ", "                ", "  ttt           ", " t g t          ", " tgsgt      kmk ", " t g t      m m ", "  ttt       kmk ", "                "}, {"                ", "                ", "                ", "                ", "         f f    ", "                ", "         f f    ", "                ", "                ", "                ", "                ", "                ", "   s        kmk ", "            m m ", "            kmk ", "                "}, {"                ", "                ", "                ", "                ", "         f f    ", "                ", "         f f    ", "                ", "                ", "                ", "                ", "                ", "   s        kmk ", "            m m ", "            kmk ", "                "}, {"                ", "                ", "                ", "                ", "         f f    ", "                ", "         f f    ", "                ", "                ", "                ", "  ppp           ", " p   p          ", " p s p      kmk ", " p   p      m m ", "  ppp       kmk ", "                "}, {"                ", "                ", "                ", "        xxxxx   ", "        xxxxx   ", "        xxxxx   ", "        xxxxx   ", "        xxxxx   ", "                ", "yyyyyyy         ", "yyyyyyy         ", "yypppyy    zzzzz", "yypypyy    zzzzz", "yypppyy    zzjzz", "yyyyyyy    zzzzz", "yyyyyyy    zzzzz"}, {"                ", "                ", "                ", "        xeeex   ", "        eccce   ", "        eccce   ", "        eccce   ", "        xeeex   ", "                ", "yyyyyyy         ", "yyyyyyy         ", "yyyyyyy    ziiiz", "yyyyyyy    izzzi", "yyyyyyy    izzzi", "yyyyyyy    izzzi", "yyyyyyy    ziiiz"}, {"                ", "                ", "                ", "        xx~xx   ", "        xxxxx   ", "        xxxxx   ", "        xxxxx   ", "        xxxxx   ", "                ", "yyyyyyy         ", "yyyyyyy         ", "yyyyyyy    zzzzz", "yyyyyyy    zzzzz", "yyyyyyy    zzzzz", "yyyyyyy    zzzzz", "yyyyyyy    zzzzz"}, {"bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbnbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb"}})).addElement(Character.valueOf('b'), StructureUtility.ofBlock((Block)GSBlocks.DysonSpherePart, (int)9)).addElement(Character.valueOf('c'), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings5, (int)8)).addElement(Character.valueOf('d'), StructureUtility.ofBlock((Block)GSBlocks.DysonSpherePart, (int)1)).addElement(Character.valueOf('e'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addDynamoToMachineList, (int)150, (int)1), StructureUtility.ofBlock((Block)GSBlocks.DysonSpherePart, (int)0)})).addElement(Character.valueOf('f'), GT_StructureUtility.ofFrame((Materials)Materials.HSSS)).addElement(Character.valueOf('g'), GT_StructureUtility.ofFrame((Materials)Materials.Titanium)).addElement(Character.valueOf('h'), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings6, (int)10)).addElement(Character.valueOf('i'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addInputToMachineList, (int)152, (int)2), StructureUtility.ofBlock((Block)GSBlocks.DysonSpherePart, (int)2)})).addElement(Character.valueOf('j'), StructureUtility.ofBlock((Block)GSBlocks.DysonSpherePart, (int)3)).addElement(Character.valueOf('k'), GT_StructureUtility.ofFrame((Materials)Materials.Longasssuperconductornameforuhvwire)).addElement(Character.valueOf('m'), StructureUtility.ofBlock((Block)GSBlocks.DysonSpherePart, (int)4)).addElement(Character.valueOf('n'), (IStructureElement)GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addMaintenanceToMachineList, (int)153, (int)3)).addElement(Character.valueOf('p'), StructureUtility.ofBlock((Block)GSBlocks.DysonSpherePart, (int)6)).addElement(Character.valueOf('s'), StructureUtility.ofBlock((Block)GSBlocks.DysonSpherePart, (int)7)).addElement(Character.valueOf('t'), StructureUtility.ofBlock((Block)GSBlocks.DysonSpherePart, (int)8)).addElement(Character.valueOf('x'), StructureUtility.ofBlock((Block)GSBlocks.DysonSpherePart, (int)0)).addElement(Character.valueOf('y'), StructureUtility.ofBlock((Block)GSBlocks.DysonSpherePart, (int)5)).addElement(Character.valueOf('z'), StructureUtility.ofBlock((Block)GSBlocks.DysonSpherePart, (int)2)).build();
    }
}

