/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.planets.mercury.dimension;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.SolarSystem.SolarSystemPlanets;
import galaxyspace.SolarSystem.planets.mercury.dimension.ChunkProviderMercury;
import galaxyspace.SolarSystem.planets.mercury.dimension.WorldChunkManagerMercury;
import galaxyspace.core.world.GSWorldProviderSpace;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityLandingBalloons;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;

public class WorldProviderMercury
extends GSWorldProviderSpace
implements IExitHeight,
ISolarLevel,
ITeleportType {
    public boolean canSpaceshipTierPass(int tier) {
        return tier >= SolarSystemPlanets.planetMercury.getTierRequirement();
    }

    public double getHorizon() {
        return 44.0;
    }

    public float getFallDamageModifier() {
        return 0.16f;
    }

    public double getFuelUsageMultiplier() {
        return 0.8;
    }

    public float getGravity() {
        return 0.048f;
    }

    public double getMeteorFrequency() {
        return 3.0;
    }

    public float getSoundVolReductionAmount() {
        return Float.MAX_VALUE;
    }

    public float getThermalLevelModifier() {
        return 3.0f;
    }

    public float getWindLevel() {
        return 0.0f;
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public CelestialBody getCelestialBody() {
        return SolarSystemPlanets.planetMercury;
    }

    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return ChunkProviderMercury.class;
    }

    public long getDayLength() {
        return 182000L;
    }

    public boolean hasBreathableAtmosphere() {
        return false;
    }

    public Vector3 getFogColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public boolean func_76561_g() {
        return false;
    }

    public Class<? extends WorldChunkManager> getWorldChunkManagerClass() {
        return WorldChunkManagerMercury.class;
    }

    public boolean hasSunset() {
        return false;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    public double getSolarEnergyMultiplier() {
        return 1.2;
    }

    public double getYCoordinateToTeleport() {
        return 800.0;
    }

    public Vector3 getEntitySpawnLocation(WorldServer arg0, Entity arg1) {
        return new Vector3(arg1.field_70165_t, ConfigManagerCore.disableLander ? 250.0 : 900.0, arg1.field_70161_v);
    }

    public Vector3 getParaChestSpawnLocation(WorldServer arg0, EntityPlayerMP arg1, Random arg2) {
        if (ConfigManagerCore.disableLander) {
            double x = (arg2.nextDouble() * 2.0 - 1.0) * 5.0;
            double z = (arg2.nextDouble() * 2.0 - 1.0) * 5.0;
            return new Vector3(x, 220.0, z);
        }
        return null;
    }

    public Vector3 getPlayerSpawnLocation(WorldServer arg0, EntityPlayerMP arg1) {
        if (arg1 != null) {
            GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)arg1);
            return new Vector3(stats.coordsTeleportedFromX, ConfigManagerCore.disableLander ? 250.0 : 900.0, stats.coordsTeleportedFromZ);
        }
        return null;
    }

    public void onSpaceDimensionChanged(World arg0, EntityPlayerMP player, boolean arg2) {
        if (player != null && GCPlayerStats.get((EntityPlayerMP)player).teleportCooldown <= 0) {
            if (player.field_71075_bZ.field_75100_b) {
                player.field_71075_bZ.field_75100_b = false;
            }
            EntityLandingBalloons lander = new EntityLandingBalloons(player);
            if (!arg0.field_72995_K) {
                arg0.func_72838_d((Entity)lander);
            }
            GCPlayerStats.get((EntityPlayerMP)player).teleportCooldown = 10;
        }
    }

    public boolean useParachute() {
        return ConfigManagerCore.disableLander;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.field_76579_a.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 0.5f + 0.3f;
    }

    public IRenderHandler getCloudRenderer() {
        return new CloudRenderer();
    }

    public void setupAdventureSpawn(EntityPlayerMP player) {
    }

    @Override
    public int AtmosphericPressure() {
        return 0;
    }

    @Override
    public boolean SolarRadiation() {
        return true;
    }
}

