/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import galaxyspace.SolarSystem.moons.callisto.dimension.WorldProviderCallisto;
import galaxyspace.SolarSystem.moons.deimos.dimension.WorldProviderDeimos;
import galaxyspace.SolarSystem.moons.enceladus.dimension.WorldProviderEnceladus;
import galaxyspace.SolarSystem.moons.europa.dimension.WorldProviderEuropa;
import galaxyspace.SolarSystem.moons.ganymede.dimension.WorldProviderGanymede;
import galaxyspace.SolarSystem.moons.io.dimension.WorldProviderIo;
import galaxyspace.SolarSystem.moons.miranda.dimension.WorldProviderMiranda;
import galaxyspace.SolarSystem.moons.oberon.dimension.WorldProviderOberon;
import galaxyspace.SolarSystem.moons.phobos.dimension.WorldProviderPhobos;
import galaxyspace.SolarSystem.moons.proteus.dimension.WorldProviderProteus;
import galaxyspace.SolarSystem.moons.titan.dimension.WorldProviderTitan;
import galaxyspace.SolarSystem.moons.triton.dimension.WorldProviderTriton;
import galaxyspace.SolarSystem.planets.ceres.dimension.TeleportTypeCeres;
import galaxyspace.SolarSystem.planets.ceres.dimension.WorldProviderCeres;
import galaxyspace.SolarSystem.planets.haumea.dimension.TeleportTypeHaumea;
import galaxyspace.SolarSystem.planets.haumea.dimension.WorldProviderHaumea;
import galaxyspace.SolarSystem.planets.kuiperbelt.dimension.WorldProviderKuiper;
import galaxyspace.SolarSystem.planets.makemake.dimension.TeleportTypeMakemake;
import galaxyspace.SolarSystem.planets.makemake.dimension.WorldProviderMakemake;
import galaxyspace.SolarSystem.planets.mercury.dimension.WorldProviderMercury;
import galaxyspace.SolarSystem.planets.pluto.dimension.WorldProviderPluto;
import galaxyspace.SolarSystem.planets.venus.dimension.WorldProviderVenus;
import galaxyspace.SolarSystem.satellites.mars.dimension.WorldProviderMarsSS;
import galaxyspace.SolarSystem.satellites.venus.dimension.WorldProviderVenusSS;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.config.GSConfigDimensions;
import galaxyspace.core.register.GSBlocks;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.world.gen.OverworldGenerator;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;

public class SolarSystemPlanets {
    public static Planet planetMercury;
    public static Planet planetVenus;
    public static Planet planetCeres;
    public static Planet planetJupiter;
    public static Planet planetSaturn;
    public static Planet planetUranus;
    public static Planet planetNeptune;
    public static Planet planetPluto;
    public static Planet planetKuiperBelt;
    public static Planet planetHaumea;
    public static Planet planetMakemake;
    public static Planet planetEris;
    public static Planet planetZTest;
    public static Moon phobosMars;
    public static Moon deimosMars;
    public static Moon ioJupiter;
    public static Moon europaJupiter;
    public static Moon ganymedeJupiter;
    public static Moon callistoJupiter;
    public static Moon mimasSaturn;
    public static Moon enceladusSaturn;
    public static Moon tethysSaturn;
    public static Moon dioneSaturn;
    public static Moon rheyaSaturn;
    public static Moon titanSaturn;
    public static Moon iapetusSaturn;
    public static Moon mirandaUranus;
    public static Moon arielUranus;
    public static Moon umbrielUranus;
    public static Moon titaniaUranus;
    public static Moon oberonUranus;
    public static Moon proteusNeptune;
    public static Moon tritonNeptune;
    public static Moon charonPluto;
    public static Satellite marsSpaceStation;
    public static Satellite venusSpaceStation;

    public static void init() {
        planetMercury = new Planet("mercury").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetMercury.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetMercury.setPhaseShift(1.45f);
        planetMercury.setTierRequired(4);
        planetMercury.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f));
        planetMercury.setRelativeOrbitTime(0.24096386f);
        planetMercury.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/mercury.png"));
        planetMercury.setDimensionInfo(GSConfigDimensions.dimensionIDMercury, WorldProviderMercury.class);
        planetVenus = new Planet("venus").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetVenus.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetVenus.setPhaseShift(2.0f);
        planetVenus.setTierRequired(4);
        planetVenus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.75f, 0.75f));
        planetVenus.setRelativeOrbitTime(0.6152793f);
        planetVenus.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/venus.png"));
        planetVenus.setDimensionInfo(GSConfigDimensions.dimensionIDVenus, WorldProviderVenus.class);
        planetVenus.atmosphereComponent(IAtmosphericGas.CO2).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.ARGON);
        venusSpaceStation = new Satellite("spaceStation.venus").setParentBody(planetVenus);
        venusSpaceStation.setRelativeSize(0.2667f);
        venusSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(10.0f, 10.0f));
        venusSpaceStation.setRelativeOrbitTime(20.0f);
        venusSpaceStation.setDimensionInfo(GSConfigDimensions.dimensionIDVenusOrbit, GSConfigDimensions.dimensionIDVenusOrbitStatic, WorldProviderVenusSS.class);
        venusSpaceStation.setTierRequired(4);
        venusSpaceStation.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/spaceStation.png"));
        if (GSConfigCore.enableLeadGeneration) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OverworldGenerator((Block)GSBlocks.LeadOre, 0, 6, 0, 45, 4), (int)4);
        }
        phobosMars = new Moon("Phobos").setParentPlanet(MarsModule.planetMars);
        phobosMars.setRelativeSize(0.0017f);
        phobosMars.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(8.0f, 8.0f));
        phobosMars.setRelativeOrbitTime(100.0f);
        phobosMars.setTierRequired(2);
        phobosMars.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/phobos.png"));
        phobosMars.setDimensionInfo(GSConfigDimensions.dimensionIDPhobos, WorldProviderPhobos.class);
        deimosMars = new Moon("Deimos").setParentPlanet(MarsModule.planetMars);
        deimosMars.setRelativeSize(0.0017f);
        deimosMars.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(16.0f, 16.0f));
        deimosMars.setRelativeOrbitTime(300.0f);
        deimosMars.setTierRequired(2);
        deimosMars.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/deimos.png"));
        deimosMars.setDimensionInfo(GSConfigDimensions.dimensionIDDeimos, WorldProviderDeimos.class);
        marsSpaceStation = new Satellite("spaceStation.mars").setParentBody(MarsModule.planetMars);
        marsSpaceStation.setRelativeSize(0.2667f);
        marsSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(10.0f, 10.0f));
        marsSpaceStation.setRelativeOrbitTime(20.0f);
        marsSpaceStation.setDimensionInfo(GSConfigDimensions.dimensionIDMarsOrbit, GSConfigDimensions.dimensionIDMarsOrbitStatic, WorldProviderMarsSS.class);
        marsSpaceStation.setTierRequired(2);
        marsSpaceStation.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/spaceStation.png"));
        planetCeres = new Planet("Ceres").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetCeres.setPhaseShift(2.0f);
        planetCeres.setTierRequired(3);
        planetCeres.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.5f, 1.5f));
        planetCeres.setRelativeOrbitTime(15.0f);
        planetCeres.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/ceres.png"));
        planetCeres.setDimensionInfo(GSConfigDimensions.dimensionIDCeres, WorldProviderCeres.class);
        AsteroidsModule.planetAsteroids.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.75f, 1.75f));
        planetJupiter = new Planet("jupiter").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetJupiter.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetJupiter.setPhaseShift((float)Math.PI);
        planetJupiter.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/jupiter.png"));
        planetJupiter.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.0f, 2.0f));
        planetJupiter.setRelativeOrbitTime(11.861994f);
        ioJupiter = new Moon("ioJupiter").setParentPlanet(planetJupiter);
        ioJupiter.setRelativeSize(0.0017f);
        ioJupiter.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(10.0f, 10.0f));
        ioJupiter.setRelativeOrbitTime(50.0f);
        ioJupiter.setTierRequired(4);
        ioJupiter.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/io.png"));
        ioJupiter.setDimensionInfo(GSConfigDimensions.dimensionIDIo, WorldProviderIo.class);
        europaJupiter = new Moon("Europa").setParentPlanet(planetJupiter);
        europaJupiter.setRelativeSize(35.1f);
        europaJupiter.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(15.0f, 15.0f));
        europaJupiter.setRelativeOrbitTime(200.0f);
        europaJupiter.setTierRequired(3);
        europaJupiter.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/europa.png"));
        europaJupiter.setDimensionInfo(GSConfigDimensions.dimensionIDEuropa, WorldProviderEuropa.class);
        ganymedeJupiter = new Moon("Ganymed").setParentPlanet(planetJupiter);
        ganymedeJupiter.setRelativeSize(3.0517f);
        ganymedeJupiter.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(20.0f, 20.0f));
        ganymedeJupiter.setRelativeOrbitTime(350.0f);
        ganymedeJupiter.setTierRequired(3);
        ganymedeJupiter.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/ganymede.png"));
        ganymedeJupiter.setDimensionInfo(GSConfigDimensions.dimensionIDGanymede, WorldProviderGanymede.class);
        callistoJupiter = new Moon("Callisto").setParentPlanet(planetJupiter);
        callistoJupiter.setRelativeSize(14.5017f);
        callistoJupiter.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(30.0f, 30.0f));
        callistoJupiter.setRelativeOrbitTime(500.0f);
        callistoJupiter.setTierRequired(3);
        callistoJupiter.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/callisto.png"));
        callistoJupiter.setDimensionInfo(GSConfigDimensions.dimensionIDCallisto, WorldProviderCallisto.class);
        planetSaturn = new Planet("saturn").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetSaturn.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetSaturn.setPhaseShift(5.45f);
        planetSaturn.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.25f, 2.25f));
        planetSaturn.setRelativeOrbitTime(29.463308f);
        planetSaturn.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/saturn.png"));
        mimasSaturn = new Moon("Mimas").setParentPlanet(planetSaturn);
        mimasSaturn.setRelativeSize(5.0017f);
        mimasSaturn.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(10.0f, 10.0f));
        mimasSaturn.setRelativeOrbitTime(20.0f);
        mimasSaturn.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/mimas.png"));
        enceladusSaturn = new Moon("Enceladus").setParentPlanet(planetSaturn);
        enceladusSaturn.setRelativeSize(8.0017f);
        enceladusSaturn.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(15.0f, 15.0f));
        enceladusSaturn.setRelativeOrbitTime(50.0f);
        enceladusSaturn.setTierRequired(5);
        enceladusSaturn.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/enceladus.png"));
        enceladusSaturn.setDimensionInfo(GSConfigDimensions.dimensionIDEnceladus, WorldProviderEnceladus.class);
        tethysSaturn = new Moon("Tethys").setParentPlanet(planetSaturn);
        tethysSaturn.setRelativeSize(15.0f);
        tethysSaturn.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(20.0f, 20.0f));
        tethysSaturn.setRelativeOrbitTime(120.0f);
        tethysSaturn.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/tethys.png"));
        dioneSaturn = new Moon("Dione").setParentPlanet(planetSaturn);
        dioneSaturn.setRelativeSize(28.0f);
        dioneSaturn.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(25.0f, 25.0f));
        dioneSaturn.setRelativeOrbitTime(180.0f);
        dioneSaturn.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/dione.png"));
        rheyaSaturn = new Moon("Rheya").setParentPlanet(planetSaturn);
        rheyaSaturn.setRelativeSize(50.0f);
        rheyaSaturn.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(30.0f, 30.0f));
        rheyaSaturn.setRelativeOrbitTime(220.0f);
        rheyaSaturn.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/rheya.png"));
        titanSaturn = new Moon("Titan").setParentPlanet(planetSaturn);
        titanSaturn.setRelativeSize(80.12123f);
        titanSaturn.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(35.0f, 35.0f));
        titanSaturn.setRelativeOrbitTime(280.0f);
        titanSaturn.setTierRequired(5);
        titanSaturn.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/titan.png"));
        titanSaturn.setDimensionInfo(GSConfigDimensions.dimensionIDTitan, WorldProviderTitan.class);
        titanSaturn.atmosphereComponent(IAtmosphericGas.NITROGEN);
        iapetusSaturn = new Moon("Iapetus").setParentPlanet(planetSaturn);
        iapetusSaturn.setRelativeSize(-180.0017f);
        iapetusSaturn.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(40.0f, 40.0f));
        iapetusSaturn.setRelativeOrbitTime(350.0f);
        iapetusSaturn.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/iapetus.png"));
        planetUranus = new Planet("uranus").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetUranus.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetUranus.setPhaseShift(1.38f);
        planetUranus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.5f, 2.5f));
        planetUranus.setRelativeOrbitTime(84.06353f);
        planetUranus.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/uranus.png"));
        mirandaUranus = new Moon("Miranda").setParentPlanet(planetUranus);
        mirandaUranus.setRelativeSize(10.0f);
        mirandaUranus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(10.0f, 10.0f));
        mirandaUranus.setRelativeOrbitTime(20.0f);
        mirandaUranus.setTierRequired(5);
        mirandaUranus.setDimensionInfo(GSConfigDimensions.dimensionIDMiranda, WorldProviderMiranda.class);
        mirandaUranus.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/miranda.png"));
        arielUranus = new Moon("Ariel").setParentPlanet(planetUranus);
        arielUranus.setRelativeSize(30.0f);
        arielUranus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(15.0f, 15.0f));
        arielUranus.setRelativeOrbitTime(50.0f);
        arielUranus.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/ariel.png"));
        umbrielUranus = new Moon("Umbriel").setParentPlanet(planetUranus);
        umbrielUranus.setRelativeSize(70.0f);
        umbrielUranus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(20.0f, 20.0f));
        umbrielUranus.setRelativeOrbitTime(120.0f);
        umbrielUranus.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/umbriel.png"));
        titaniaUranus = new Moon("Titania").setParentPlanet(planetUranus);
        titaniaUranus.setRelativeSize(120.0f);
        titaniaUranus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(25.0f, 25.0f));
        titaniaUranus.setRelativeOrbitTime(180.0f);
        titaniaUranus.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/titania.png"));
        oberonUranus = new Moon("Oberon").setParentPlanet(planetUranus);
        oberonUranus.setRelativeSize(150.12123f);
        oberonUranus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(30.0f, 30.0f));
        oberonUranus.setRelativeOrbitTime(200.0f);
        oberonUranus.setTierRequired(5);
        oberonUranus.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/oberon.png"));
        oberonUranus.setDimensionInfo(GSConfigDimensions.dimensionIDOberon, WorldProviderOberon.class);
        planetNeptune = new Planet("neptune").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetNeptune.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetNeptune.setPhaseShift(1.0f);
        planetNeptune.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.75f, 2.75f));
        planetNeptune.setRelativeOrbitTime(164.84119f);
        planetNeptune.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/neptune.png"));
        proteusNeptune = new Moon("Proteus").setParentPlanet(planetNeptune);
        proteusNeptune.setRelativeSize(0.0017f);
        proteusNeptune.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(10.0f, 10.0f));
        proteusNeptune.setRelativeOrbitTime(50.0f);
        proteusNeptune.setTierRequired(6);
        proteusNeptune.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/proteus.png"));
        proteusNeptune.setDimensionInfo(GSConfigDimensions.dimensionIDProteus, WorldProviderProteus.class);
        tritonNeptune = new Moon("Triton").setParentPlanet(planetNeptune);
        tritonNeptune.setRelativeSize(150.12123f);
        tritonNeptune.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(25.0f, 25.0f));
        tritonNeptune.setRelativeOrbitTime(200.0f);
        tritonNeptune.setTierRequired(6);
        tritonNeptune.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/triton.png"));
        tritonNeptune.setDimensionInfo(GSConfigDimensions.dimensionIDTriton, WorldProviderTriton.class);
        planetPluto = new Planet("pluto").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetPluto.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetPluto.setPhaseShift(0.1f);
        planetPluto.setTierRequired(7);
        planetPluto.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(3.0f, 3.0f));
        planetPluto.setRelativeOrbitTime(250.9f);
        planetPluto.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/pluto.png"));
        planetPluto.setDimensionInfo(GSConfigDimensions.dimensionIDPluto, WorldProviderPluto.class);
        charonPluto = new Moon("Charon").setParentPlanet(planetPluto);
        charonPluto.setRelativeSize(0.0017f);
        charonPluto.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(10.0f, 10.0f));
        charonPluto.setRelativeOrbitTime(50.0f);
        charonPluto.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/charon.png"));
        planetKuiperBelt = new Planet("kuiperbelt").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetKuiperBelt.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetKuiperBelt.setPhaseShift(1.5f);
        planetKuiperBelt.setTierRequired(7);
        planetKuiperBelt.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(3.25f, 3.25f));
        planetKuiperBelt.setRelativeOrbitTime(300.9f);
        planetKuiperBelt.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/kuiperbelt.png"));
        planetKuiperBelt.setDimensionInfo(GSConfigDimensions.dimensionIDKuiperBelt, WorldProviderKuiper.class);
        planetHaumea = new Planet("haumea").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetHaumea.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetHaumea.setPhaseShift(21.5f);
        planetHaumea.setTierRequired(7);
        planetHaumea.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(3.5f, 3.5f));
        planetHaumea.setRelativeOrbitTime(280.9f);
        planetHaumea.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/haumea.png"));
        planetHaumea.setDimensionInfo(GSConfigDimensions.dimensionIDHaumea, WorldProviderHaumea.class);
        planetMakemake = new Planet("makemake").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetMakemake.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetMakemake.setPhaseShift(11.5f);
        planetMakemake.setTierRequired(7);
        planetMakemake.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(3.75f, 3.75f));
        planetMakemake.setRelativeOrbitTime(300.9f);
        planetMakemake.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/makemake.png"));
        planetMakemake.setDimensionInfo(GSConfigDimensions.dimensionIDMakemake, WorldProviderMakemake.class);
        planetEris = new Planet("eris").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetEris.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetEris.setPhaseShift(41.5f);
        planetEris.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(4.0f, 4.0f));
        planetEris.setRelativeOrbitTime(360.9f);
        planetEris.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/eris.png"));
        SolarSystemPlanets.registrycelestial();
        SolarSystemPlanets.registryteleport();
    }

    private static void registrycelestial() {
        if (GSConfigDimensions.enableMercury) {
            GalaxyRegistry.registerPlanet((Planet)planetMercury);
        }
        if (GSConfigDimensions.enableVenus) {
            GalaxyRegistry.registerPlanet((Planet)planetVenus);
        }
        if (GSConfigDimensions.enableCeres) {
            GalaxyRegistry.registerPlanet((Planet)planetCeres);
        }
        GalaxyRegistry.registerPlanet((Planet)planetJupiter);
        GalaxyRegistry.registerPlanet((Planet)planetSaturn);
        GalaxyRegistry.registerPlanet((Planet)planetUranus);
        GalaxyRegistry.registerPlanet((Planet)planetNeptune);
        if (GSConfigDimensions.enablePluto) {
            GalaxyRegistry.registerPlanet((Planet)planetPluto);
        }
        GalaxyRegistry.registerPlanet((Planet)planetKuiperBelt);
        if (GSConfigDimensions.enableHaumea) {
            GalaxyRegistry.registerPlanet((Planet)planetHaumea);
        }
        if (GSConfigDimensions.enableMakemake) {
            GalaxyRegistry.registerPlanet((Planet)planetMakemake);
        }
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerPlanet((Planet)planetEris);
        }
        if (GSConfigDimensions.enablePhobos) {
            GalaxyRegistry.registerMoon((Moon)phobosMars);
        }
        if (GSConfigDimensions.enableDeimos) {
            GalaxyRegistry.registerMoon((Moon)deimosMars);
        }
        if (GSConfigDimensions.enableIo) {
            GalaxyRegistry.registerMoon((Moon)ioJupiter);
        }
        if (GSConfigDimensions.enableEuropa) {
            GalaxyRegistry.registerMoon((Moon)europaJupiter);
        }
        if (GSConfigDimensions.enableGanymede) {
            GalaxyRegistry.registerMoon((Moon)ganymedeJupiter);
        }
        if (GSConfigDimensions.enableCallisto) {
            GalaxyRegistry.registerMoon((Moon)callistoJupiter);
        }
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerMoon((Moon)mimasSaturn);
        }
        if (GSConfigDimensions.enableEnceladus) {
            GalaxyRegistry.registerMoon((Moon)enceladusSaturn);
        }
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerMoon((Moon)tethysSaturn);
        }
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerMoon((Moon)dioneSaturn);
        }
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerMoon((Moon)rheyaSaturn);
        }
        if (GSConfigDimensions.enableTitan) {
            GalaxyRegistry.registerMoon((Moon)titanSaturn);
        }
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerMoon((Moon)iapetusSaturn);
        }
        if (GSConfigDimensions.enableMiranda) {
            GalaxyRegistry.registerMoon((Moon)mirandaUranus);
        }
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerMoon((Moon)arielUranus);
        }
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerMoon((Moon)umbrielUranus);
        }
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerMoon((Moon)titaniaUranus);
        }
        if (GSConfigDimensions.enableOberon) {
            GalaxyRegistry.registerMoon((Moon)oberonUranus);
        }
        if (GSConfigDimensions.enableProteus) {
            GalaxyRegistry.registerMoon((Moon)proteusNeptune);
        }
        if (GSConfigDimensions.enableTriton) {
            GalaxyRegistry.registerMoon((Moon)tritonNeptune);
        }
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerMoon((Moon)charonPluto);
        }
        if (GSConfigDimensions.enableMarsSS) {
            GalaxyRegistry.registerSatellite((Satellite)marsSpaceStation);
        }
        if (GSConfigDimensions.enableVenusSS) {
            GalaxyRegistry.registerSatellite((Satellite)venusSpaceStation);
        }
    }

    private static void registryteleport() {
        GalacticraftRegistry.registerTeleportType(WorldProviderMercury.class, (ITeleportType)new WorldProviderMercury());
        GalacticraftRegistry.registerTeleportType(WorldProviderVenus.class, (ITeleportType)new WorldProviderVenus());
        GalacticraftRegistry.registerTeleportType(WorldProviderCeres.class, (ITeleportType)new TeleportTypeCeres());
        GalacticraftRegistry.registerTeleportType(WorldProviderPluto.class, (ITeleportType)new WorldProviderPluto());
        GalacticraftRegistry.registerTeleportType(WorldProviderKuiper.class, (ITeleportType)new WorldProviderKuiper());
        GalacticraftRegistry.registerTeleportType(WorldProviderHaumea.class, (ITeleportType)new TeleportTypeHaumea());
        GalacticraftRegistry.registerTeleportType(WorldProviderMakemake.class, (ITeleportType)new TeleportTypeMakemake());
        GalacticraftRegistry.registerTeleportType(WorldProviderPhobos.class, (ITeleportType)new WorldProviderPhobos());
        GalacticraftRegistry.registerTeleportType(WorldProviderDeimos.class, (ITeleportType)new WorldProviderDeimos());
        GalacticraftRegistry.registerTeleportType(WorldProviderIo.class, (ITeleportType)new WorldProviderIo());
        GalacticraftRegistry.registerTeleportType(WorldProviderEuropa.class, (ITeleportType)new WorldProviderEuropa());
        GalacticraftRegistry.registerTeleportType(WorldProviderGanymede.class, (ITeleportType)new WorldProviderGanymede());
        GalacticraftRegistry.registerTeleportType(WorldProviderCallisto.class, (ITeleportType)new WorldProviderCallisto());
        GalacticraftRegistry.registerTeleportType(WorldProviderEnceladus.class, (ITeleportType)new WorldProviderEnceladus());
        GalacticraftRegistry.registerTeleportType(WorldProviderTitan.class, (ITeleportType)new WorldProviderTitan());
        GalacticraftRegistry.registerTeleportType(WorldProviderMiranda.class, (ITeleportType)new WorldProviderMiranda());
        GalacticraftRegistry.registerTeleportType(WorldProviderOberon.class, (ITeleportType)new WorldProviderOberon());
        GalacticraftRegistry.registerTeleportType(WorldProviderProteus.class, (ITeleportType)new WorldProviderProteus());
        GalacticraftRegistry.registerTeleportType(WorldProviderTriton.class, (ITeleportType)new WorldProviderTriton());
        GalacticraftRegistry.registerTeleportType(WorldProviderMarsSS.class, (ITeleportType)new WorldProviderMarsSS());
        GalacticraftRegistry.registerTeleportType(WorldProviderVenusSS.class, (ITeleportType)new WorldProviderVenusSS());
        if (GSConfigDimensions.enableMarsSS) {
            GalacticraftRegistry.registerProvider((int)GSConfigDimensions.dimensionIDMarsOrbit, WorldProviderMarsSS.class, (boolean)false, (int)-40);
            GalacticraftRegistry.registerProvider((int)GSConfigDimensions.dimensionIDMarsOrbitStatic, WorldProviderMarsSS.class, (boolean)true, (int)-41);
        }
        if (GSConfigDimensions.enableVenusSS) {
            GalacticraftRegistry.registerProvider((int)GSConfigDimensions.dimensionIDVenusOrbit, WorldProviderVenusSS.class, (boolean)false, (int)-42);
            GalacticraftRegistry.registerProvider((int)GSConfigDimensions.dimensionIDVenusOrbitStatic, WorldProviderVenusSS.class, (boolean)true, (int)-43);
        }
    }
}

