/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.VegaSystem;

import galaxyspace.VegaSystem.VegaBlocks;
import galaxyspace.VegaSystem.planets.vegaB.dimension.WorldProviderVegaB;
import galaxyspace.core.config.GSConfigDimensions;
import galaxyspace.core.render.sky.SkyProviderBase;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;

public class VegaPlanets {
    public static SolarSystem vegaSystem;
    public static Star Vega;
    public static Planet planetVega1;
    public static Planet planetVega2;
    public static Planet planetVegaasteroids;
    public static Planet planetVegaasteroids2;

    public static void preInit() {
        VegaBlocks.initialize();
    }

    public static void init() {
        vegaSystem = new SolarSystem("VegaSystem", "milkyWay").setMapPosition(new Vector3(-1.5, -3.5, 0.0));
        GalaxyRegistry.registerSolarSystem((SolarSystem)vegaSystem);
        Vega = (Star)new Star("Vega").setParentSolarSystem(vegaSystem).setTierRequired(-1);
        Vega.setBodyIcon(SkyProviderBase.vegaTexture);
        vegaSystem.setMainStar(Vega);
        planetVega1 = new Planet("Vega1").setParentSolarSystem(vegaSystem);
        planetVega1.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetVega1.setPhaseShift((float)Math.PI);
        planetVega1.setTierRequired(8);
        planetVega1.setBodyIcon(SkyProviderBase.vegaBTexture);
        planetVega1.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f));
        planetVega1.setRelativeOrbitTime(1.8619934f);
        if (GSConfigDimensions.enableVegaB) {
            planetVega1.setDimensionInfo(GSConfigDimensions.dimensionIDVegaB, WorldProviderVegaB.class);
            GalaxyRegistry.registerPlanet((Planet)planetVega1);
            GalacticraftRegistry.registerTeleportType(WorldProviderVegaB.class, (ITeleportType)new WorldProviderVegaB());
        }
        planetVegaasteroids = new Planet("VegaAsteroids").setParentSolarSystem(vegaSystem);
        planetVegaasteroids.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetVegaasteroids.setPhaseShift(0.7853982f);
        planetVegaasteroids.setBodyIcon(SkyProviderBase.vegaAsteroidsTexture);
        planetVegaasteroids.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.6f, 1.0f));
        planetVegaasteroids.setRelativeOrbitTime(11.861994f);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerPlanet((Planet)planetVegaasteroids);
        }
        planetVega2 = new Planet("Vega2").setParentSolarSystem(vegaSystem);
        planetVega2.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetVega2.setPhaseShift(1.5707964f);
        planetVega2.setBodyIcon(SkyProviderBase.vegaCTexture);
        planetVega2.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.75f, 1.75f));
        planetVega2.setRelativeOrbitTime(5.8619933f);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerPlanet((Planet)planetVega2);
        }
        planetVegaasteroids2 = new Planet("VegaAsteroids2").setParentSolarSystem(vegaSystem);
        planetVegaasteroids2.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetVegaasteroids2.setPhaseShift(0.3926991f);
        planetVegaasteroids2.setBodyIcon(SkyProviderBase.vegaAsteroidsTexture);
        planetVegaasteroids2.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.5f, 2.5f));
        planetVegaasteroids2.setRelativeOrbitTime(11.861994f);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerPlanet((Planet)planetVegaasteroids2);
        }
    }
}

