/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.dimension;

import galaxyspace.GalaxySpace;
import galaxyspace.SolarSystem.satellites.OrbitGSSpinSaveData;
import galaxyspace.core.dimension.GSWorldProviderSpace;
import galaxyspace.core.dimension.WorldChunkManagerSpaceGS;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockSpinThruster;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.WorldChunkManager;

public abstract class WorldProviderDefaultSpaceStation
extends GSWorldProviderSpace
implements IOrbitDimension,
ISolarLevel,
IExitHeight,
ITeleportType {
    private static final float GFORCE = 0.024525002f;
    private OrbitGSSpinSaveData savefile;
    private boolean doSpinning = true;
    private float angularVelocityRadians;
    private float skyAngularVelocity;
    private float angularVelocityTarget;
    private float angularVelocityAccel;
    private double spinCentreX;
    private double spinCentreZ;
    private float momentOfInertia;
    private float massCentreX;
    private float massCentreZ;
    private int ssBoundsMaxX;
    private int ssBoundsMinX;
    private int ssBoundsMaxY;
    private int ssBoundsMinY;
    private int ssBoundsMaxZ;
    private int ssBoundsMinZ;
    private List<BlockVec3> thrustersPlus = new LinkedList<BlockVec3>();
    private List<BlockVec3> thrustersMinus = new LinkedList<BlockVec3>();
    private BlockVec3 oneSSBlock;
    private Set<BlockVec3> checked = new HashSet<BlockVec3>();
    private boolean thrustersFiring;
    private boolean dataNotLoaded = true;
    private List<Entity> loadedEntities = new LinkedList<Entity>();
    private double pPrevMotionX;
    private double pPrevMotionY;
    private double pPrevMotionZ;
    private int pjumpticks;
    private boolean pWasOnGround;

    public void updateWeather() {
        super.updateWeather();
        if (!this.field_76579_a.field_72995_K) {
            if (this.dataNotLoaded) {
                this.savefile = OrbitGSSpinSaveData.initWorldData(this.field_76579_a);
                this.readFromNBT(this.savefile.datacompound);
                if (ConfigManagerCore.enableDebug) {
                    GalaxySpace.info("Loading data from save: " + this.savefile.datacompound.func_74760_g("omegaSky"));
                }
                this.dataNotLoaded = false;
            }
            if (this.doSpinning) {
                float newAngle;
                boolean updateNeeded = true;
                if (this.angularVelocityTarget < this.angularVelocityRadians) {
                    newAngle = this.angularVelocityRadians - this.angularVelocityAccel;
                    if (newAngle < this.angularVelocityTarget) {
                        newAngle = this.angularVelocityTarget;
                    }
                    this.setSpinRate(newAngle);
                    this.thrustersFiring = true;
                } else if (this.angularVelocityTarget > this.angularVelocityRadians) {
                    newAngle = this.angularVelocityRadians + this.angularVelocityAccel;
                    if (newAngle > this.angularVelocityTarget) {
                        newAngle = this.angularVelocityTarget;
                    }
                    this.setSpinRate(newAngle);
                    this.thrustersFiring = true;
                } else if (this.thrustersFiring) {
                    this.thrustersFiring = false;
                } else {
                    updateNeeded = false;
                }
                if (updateNeeded) {
                    this.writeToNBT(this.savefile.datacompound);
                    this.savefile.func_76185_a();
                    ArrayList<Constable> objList = new ArrayList<Constable>();
                    objList.add(Float.valueOf(this.angularVelocityRadians));
                    objList.add(Boolean.valueOf(this.thrustersFiring));
                    GalacticraftCore.packetPipeline.sendToDimension((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_SPIN, objList), this.field_76574_g);
                }
                this.loadedEntities.clear();
                this.loadedEntities.addAll(this.field_76579_a.field_72996_f);
                for (Entity e : this.loadedEntities) {
                    if (!(e instanceof EntityItem) && (!(e instanceof EntityLivingBase) || e instanceof EntityPlayer) && !(e instanceof EntityTNTPrimed) && !(e instanceof EntityFallingBlock) || e.field_70122_E) continue;
                    boolean freefall = true;
                    if (e.field_70121_D.field_72336_d >= (double)this.ssBoundsMinX && e.field_70121_D.field_72340_a <= (double)this.ssBoundsMaxX && e.field_70121_D.field_72337_e >= (double)this.ssBoundsMinY && e.field_70121_D.field_72338_b <= (double)this.ssBoundsMaxY && e.field_70121_D.field_72334_f >= (double)this.ssBoundsMinZ && e.field_70121_D.field_72339_c <= (double)this.ssBoundsMaxZ) {
                        int xmx = MathHelper.func_76128_c((double)(e.field_70121_D.field_72336_d + 0.2));
                        int ym = MathHelper.func_76128_c((double)(e.field_70121_D.field_72338_b - 0.1));
                        int yy = MathHelper.func_76128_c((double)(e.field_70121_D.field_72337_e + 0.1));
                        int zm = MathHelper.func_76128_c((double)(e.field_70121_D.field_72339_c - 0.2));
                        int zz = MathHelper.func_76128_c((double)(e.field_70121_D.field_72334_f + 0.2));
                        block1: for (int x = MathHelper.func_76128_c((double)(e.field_70121_D.field_72340_a - 0.2)); x <= xmx; ++x) {
                            for (int y = ym; y <= yy; ++y) {
                                for (int z = zm; z <= zz; ++z) {
                                    if (!this.field_76579_a.func_72899_e(x, y, z) || Blocks.field_150350_a == this.field_76579_a.func_147439_a(x, y, z)) continue;
                                    freefall = false;
                                    break block1;
                                }
                            }
                        }
                    }
                    if (!freefall) continue;
                    if (this.angularVelocityRadians != 0.0f) {
                        double xx = e.field_70165_t - this.spinCentreX;
                        double zz2 = e.field_70161_v - this.spinCentreZ;
                        double arc = Math.sqrt(xx * xx + zz2 * zz2);
                        float angle = xx == 0.0 ? (zz2 > 0.0 ? 1.5707964f : -1.5707964f) : (float)Math.atan(zz2 / xx);
                        if (xx < 0.0) {
                            angle += (float)Math.PI;
                        }
                        double offsetX = -(arc *= (double)this.angularVelocityRadians) * (double)MathHelper.func_76126_a((float)(angle += this.angularVelocityRadians / 3.0f));
                        double offsetZ = arc * (double)MathHelper.func_76134_b((float)angle);
                        Entity entity = e;
                        entity.field_70165_t += offsetX;
                        Entity entity2 = e;
                        entity2.field_70161_v += offsetZ;
                        Entity entity3 = e;
                        entity3.field_70142_S += offsetX;
                        Entity entity4 = e;
                        entity4.field_70136_U += offsetZ;
                        if (!this.field_76579_a.func_72899_e(MathHelper.func_76128_c((double)e.field_70165_t), 64, MathHelper.func_76128_c((double)e.field_70161_v))) {
                            e.func_70106_y();
                        }
                        e.field_70121_D.func_72317_d(offsetX, 0.0, offsetZ);
                        Entity entity5 = e;
                        entity5.field_70177_z += this.skyAngularVelocity;
                        while (e.field_70177_z > 360.0f) {
                            Entity entity6 = e;
                            entity6.field_70177_z -= 360.0f;
                        }
                    }
                    if (e instanceof EntityLivingBase) {
                        Entity entity7 = e;
                        entity7.field_70159_w /= 0.91;
                        Entity entity8 = e;
                        entity8.field_70179_y /= 0.91;
                        if (e instanceof EntityFlying) {
                            Entity entity9 = e;
                            entity9.field_70181_x /= 0.91;
                            continue;
                        }
                        Entity entity10 = e;
                        entity10.field_70181_x /= 0.98;
                        continue;
                    }
                    if (e instanceof EntityFallingBlock) {
                        Entity entity11 = e;
                        entity11.field_70181_x /= 0.98;
                        continue;
                    }
                    Entity entity12 = e;
                    entity12.field_70159_w /= 0.98;
                    Entity entity13 = e;
                    entity13.field_70181_x /= 0.98;
                    Entity entity14 = e;
                    entity14.field_70179_y /= 0.98;
                }
            }
        }
    }

    public boolean checkSS(BlockVec3 baseBlock, boolean placingThruster) {
        if (this.oneSSBlock == null || this.oneSSBlock.getBlockID(this.field_76579_a) instanceof BlockAir) {
            this.oneSSBlock = baseBlock != null ? baseBlock.clone() : new BlockVec3(0, 64, 0);
        }
        LinkedList<BlockVec3> currentLayer = new LinkedList<BlockVec3>();
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        LinkedList<BlockVec3> foundThrusters = new LinkedList<BlockVec3>();
        this.checked.clear();
        currentLayer.add(this.oneSSBlock.clone());
        this.checked.add(this.oneSSBlock.clone());
        Block bStart = this.oneSSBlock.getBlockID(this.field_76579_a);
        if (bStart instanceof BlockSpinThruster) {
            foundThrusters.add(this.oneSSBlock);
        }
        float thismass = 0.1f;
        float thismassCentreX = 0.1f * (float)this.oneSSBlock.x;
        float thismassCentreY = 0.1f * (float)this.oneSSBlock.y;
        float thismassCentreZ = 0.1f * (float)this.oneSSBlock.z;
        float thismoment = 0.0f;
        int thisssBoundsMaxX = this.oneSSBlock.x;
        int thisssBoundsMinX = this.oneSSBlock.x;
        int thisssBoundsMaxY = this.oneSSBlock.y;
        int thisssBoundsMinY = this.oneSSBlock.y;
        int thisssBoundsMaxZ = this.oneSSBlock.z;
        int thisssBoundsMinZ = this.oneSSBlock.z;
        while (currentLayer.size() > 0) {
            for (BlockVec3 vec : currentLayer) {
                int bits = vec.sideDoneBits;
                if (vec.x < thisssBoundsMinX) {
                    thisssBoundsMinX = vec.x;
                }
                if (vec.y < thisssBoundsMinY) {
                    thisssBoundsMinY = vec.y;
                }
                if (vec.z < thisssBoundsMinZ) {
                    thisssBoundsMinZ = vec.z;
                }
                if (vec.x > thisssBoundsMaxX) {
                    thisssBoundsMaxX = vec.x;
                }
                if (vec.y > thisssBoundsMaxY) {
                    thisssBoundsMaxY = vec.y;
                }
                if (vec.z > thisssBoundsMaxZ) {
                    thisssBoundsMaxZ = vec.z;
                }
                for (int side = 0; side < 6; ++side) {
                    BlockVec3 sideVec;
                    if ((bits & 1 << side) == 1 || this.checked.contains(sideVec = vec.newVecSide(side))) continue;
                    this.checked.add(sideVec);
                    Block b = sideVec.getBlockID(this.field_76579_a);
                    if (b == null || b.isAir((IBlockAccess)this.field_76579_a, sideVec.x, sideVec.y, sideVec.z)) continue;
                    nextLayer.add(sideVec);
                    if (bStart.isAir((IBlockAccess)this.field_76579_a, this.oneSSBlock.x, this.oneSSBlock.y, this.oneSSBlock.z)) {
                        this.oneSSBlock = sideVec.clone();
                        bStart = b;
                    }
                    float m = 1.0f;
                    if (!(b instanceof BlockLiquid)) {
                        m = b.func_149712_f(this.field_76579_a, sideVec.x, sideVec.y, sideVec.z);
                        if (m < 0.1f) {
                            m = 0.1f;
                        } else if (m > 30.0f) {
                            m = 30.0f;
                        }
                        if (b.func_149688_o() == Material.field_151575_d) {
                            m /= 4.0f;
                        }
                    }
                    thismassCentreX += m * (float)sideVec.x;
                    thismassCentreY += m * (float)sideVec.y;
                    thismassCentreZ += m * (float)sideVec.z;
                    thismass += m;
                    thismoment += m * (float)(sideVec.x * sideVec.x + sideVec.z * sideVec.z);
                    if (!(b instanceof BlockSpinThruster) || this.field_76579_a.func_94577_B(sideVec.x, sideVec.y, sideVec.z) != 0) continue;
                    foundThrusters.add(sideVec);
                }
            }
            currentLayer = nextLayer;
            nextLayer = new LinkedList();
        }
        if (!placingThruster || this.checked.contains(baseBlock)) {
            this.thrustersPlus.clear();
            this.thrustersMinus.clear();
            for (BlockVec3 thruster : foundThrusters) {
                int facing = thruster.getBlockMetadata((IBlockAccess)this.field_76579_a) & 8;
                if (facing == 0) {
                    this.thrustersPlus.add(thruster.clone());
                    continue;
                }
                this.thrustersMinus.add(thruster.clone());
            }
            float mass = thismass;
            this.massCentreX = thismassCentreX / thismass + 0.5f;
            float massCentreY = thismassCentreY / thismass + 0.5f;
            this.massCentreZ = thismassCentreZ / thismass + 0.5f;
            this.setSpinCentre(this.massCentreX, this.massCentreZ);
            this.ssBoundsMaxX = thisssBoundsMaxX + 1;
            this.ssBoundsMinX = thisssBoundsMinX;
            this.ssBoundsMaxY = thisssBoundsMaxY + 1;
            this.ssBoundsMinY = thisssBoundsMinY;
            this.ssBoundsMaxZ = thisssBoundsMaxZ + 1;
            this.ssBoundsMinZ = thisssBoundsMinZ;
            thismoment -= this.massCentreX * this.massCentreX * mass;
            this.momentOfInertia = thismoment -= this.massCentreZ * this.massCentreZ * mass;
            GalaxySpace.debug("MoI = " + this.momentOfInertia + " CoMx = " + this.massCentreX + " CoMz = " + this.massCentreZ);
            ArrayList<Number> objList = new ArrayList<Number>();
            objList.add(this.spinCentreX);
            objList.add(this.spinCentreZ);
            GalacticraftCore.packetPipeline.sendToDimension((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_DATA, objList), this.field_76574_g);
            objList = new ArrayList();
            objList.add(this.ssBoundsMinX);
            objList.add(this.ssBoundsMaxX);
            objList.add(this.ssBoundsMinY);
            objList.add(this.ssBoundsMaxY);
            objList.add(this.ssBoundsMinZ);
            objList.add(this.ssBoundsMaxZ);
            GalacticraftCore.packetPipeline.sendToDimension((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_BOX, objList), this.field_76574_g);
            this.updateSpinSpeed();
            return true;
        }
        if (foundThrusters.size() > 0) {
            if (ConfigManagerCore.enableDebug) {
                GalaxySpace.info("Thruster placed on wrong part of space station: base at " + this.oneSSBlock.x + "," + this.oneSSBlock.y + "," + this.oneSSBlock.z + " - baseBlock was " + baseBlock.x + "," + baseBlock.y + "," + baseBlock.z + " - found " + foundThrusters.size());
            }
            return false;
        }
        if (!this.oneSSBlock.equals((Object)baseBlock)) {
            this.oneSSBlock = baseBlock.clone();
            if (this.oneSSBlock.getBlockID(this.field_76579_a).func_149688_o() != Material.field_151579_a) {
                return this.checkSS(baseBlock, true);
            }
        }
        return false;
    }

    public void updateSpinSpeed() {
        if (this.momentOfInertia > 0.0f) {
            float zz;
            float xx;
            float netTorque = 0.0f;
            int countThrusters = 0;
            int countThrustersReverse = 0;
            for (BlockVec3 thruster : this.thrustersPlus) {
                xx = (float)thruster.x - this.massCentreX;
                zz = (float)thruster.z - this.massCentreZ;
                netTorque += MathHelper.func_76129_c((float)(xx * xx + zz * zz));
                ++countThrusters;
            }
            for (BlockVec3 thruster : this.thrustersMinus) {
                xx = (float)thruster.x - this.massCentreX;
                zz = (float)thruster.z - this.massCentreZ;
                netTorque -= MathHelper.func_76129_c((float)(xx * xx + zz * zz));
                ++countThrustersReverse;
            }
            if (countThrusters == countThrustersReverse) {
                this.angularVelocityAccel = 4.0E-6f;
                this.angularVelocityTarget = 0.0f;
            } else {
                if ((countThrusters += countThrustersReverse) > 4) {
                    countThrusters = 4;
                }
                float maxRx = Math.max((float)this.ssBoundsMaxX - this.massCentreX, this.massCentreX - (float)this.ssBoundsMinX);
                float maxRz = Math.max((float)this.ssBoundsMaxZ - this.massCentreZ, this.massCentreZ - (float)this.ssBoundsMinZ);
                float maxR = Math.max(maxRx, maxRz);
                this.angularVelocityTarget = MathHelper.func_76129_c((float)(0.024525002f / maxR)) / 2.0f;
                float spinCap = 0.00125f * (float)countThrusters;
                this.angularVelocityAccel = netTorque / this.momentOfInertia / 20.0f;
                if (this.angularVelocityAccel < 0.0f) {
                    this.angularVelocityAccel = -this.angularVelocityAccel;
                    this.angularVelocityTarget = -this.angularVelocityTarget;
                    if (this.angularVelocityTarget < -spinCap) {
                        this.angularVelocityTarget = -spinCap;
                    }
                } else if (this.angularVelocityTarget > spinCap) {
                    this.angularVelocityTarget = spinCap;
                }
                if (ConfigManagerCore.enableDebug) {
                    GalaxySpace.info("MaxR = " + maxR + " Angular vel = " + this.angularVelocityTarget + " Angular accel = " + this.angularVelocityAccel);
                }
            }
        }
        if (!this.field_76579_a.field_72995_K) {
            if (this.savefile == null) {
                this.savefile = OrbitGSSpinSaveData.initWorldData(this.field_76579_a);
                this.dataNotLoaded = false;
            } else {
                this.writeToNBT(this.savefile.datacompound);
                this.savefile.func_76185_a();
            }
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.doSpinning = true;
        this.angularVelocityRadians = nbt.func_74760_g("omegaRad");
        this.skyAngularVelocity = nbt.func_74760_g("omegaSky");
        this.angularVelocityTarget = nbt.func_74760_g("omegaTarget");
        this.angularVelocityAccel = nbt.func_74760_g("omegaAcc");
        NBTTagCompound oneBlock = (NBTTagCompound)nbt.func_74781_a("oneBlock");
        this.oneSSBlock = oneBlock != null ? BlockVec3.readFromNBT((NBTTagCompound)oneBlock) : null;
        this.checkSS(this.oneSSBlock, false);
        ArrayList<Constable> objList = new ArrayList<Constable>();
        objList.add(Float.valueOf(this.angularVelocityRadians));
        objList.add(Boolean.valueOf(this.thrustersFiring));
        GalacticraftCore.packetPipeline.sendToDimension((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_SPIN, objList), this.field_76574_g);
        objList = new ArrayList();
        objList.add(Double.valueOf(this.spinCentreX));
        objList.add(Double.valueOf(this.spinCentreZ));
        GalacticraftCore.packetPipeline.sendToDimension((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_DATA, objList), this.field_76574_g);
        objList = new ArrayList();
        objList.add(Integer.valueOf(this.ssBoundsMinX));
        objList.add(Integer.valueOf(this.ssBoundsMaxX));
        objList.add(Integer.valueOf(this.ssBoundsMinY));
        objList.add(Integer.valueOf(this.ssBoundsMaxY));
        objList.add(Integer.valueOf(this.ssBoundsMinZ));
        objList.add(Integer.valueOf(this.ssBoundsMaxZ));
        GalacticraftCore.packetPipeline.sendToDimension((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_BOX, objList), this.field_76574_g);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("doSpinning", this.doSpinning);
        nbt.func_74776_a("omegaRad", this.angularVelocityRadians);
        nbt.func_74776_a("omegaSky", this.skyAngularVelocity);
        nbt.func_74776_a("omegaTarget", this.angularVelocityTarget);
        nbt.func_74776_a("omegaAcc", this.angularVelocityAccel);
        if (this.oneSSBlock != null) {
            NBTTagCompound oneBlock = new NBTTagCompound();
            this.oneSSBlock.writeToNBT(oneBlock);
            nbt.func_74782_a("oneBlock", (NBTBase)oneBlock);
        }
    }

    public void sendPacketsToClient(EntityPlayerMP player) {
        ArrayList<Constable> objList = new ArrayList<Constable>();
        objList.add(Float.valueOf(this.angularVelocityRadians));
        objList.add(Boolean.valueOf(this.thrustersFiring));
        GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_SPIN, objList), player);
        objList = new ArrayList();
        objList.add(Double.valueOf(this.spinCentreX));
        objList.add(Double.valueOf(this.spinCentreZ));
        GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_DATA, objList), player);
        objList = new ArrayList();
        objList.add(Integer.valueOf(this.ssBoundsMinX));
        objList.add(Integer.valueOf(this.ssBoundsMaxX));
        objList.add(Integer.valueOf(this.ssBoundsMinY));
        objList.add(Integer.valueOf(this.ssBoundsMaxY));
        objList.add(Integer.valueOf(this.ssBoundsMinZ));
        objList.add(Integer.valueOf(this.ssBoundsMaxZ));
        GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_BOX, objList), player);
    }

    public void addThruster(BlockVec3 thruster, boolean positive) {
        if (positive) {
            this.thrustersPlus.add(thruster);
            this.thrustersMinus.remove(thruster);
        } else {
            this.thrustersPlus.remove(thruster);
            this.thrustersMinus.add(thruster);
        }
    }

    public void removeThruster(BlockVec3 thruster, boolean positive) {
        if (positive) {
            this.thrustersPlus.remove(thruster);
        } else {
            this.thrustersMinus.remove(thruster);
        }
    }

    public void setSpinCentre(double x, double z) {
        this.spinCentreX = x;
        this.spinCentreZ = z;
        if (this.field_76579_a.field_72995_K && ConfigManagerCore.enableDebug) {
            GalaxySpace.info("Clientside update to spin centre: " + x + "," + z);
        }
    }

    public void setSpinBox(int mx, int xx, int my, int yy, int mz, int zz) {
        this.ssBoundsMinX = mx;
        this.ssBoundsMaxX = xx;
        this.ssBoundsMinY = my;
        this.ssBoundsMaxY = yy;
        this.ssBoundsMinZ = mz;
        this.ssBoundsMaxZ = zz;
    }

    public void setSpinRate(float angle, boolean firing) {
        this.angularVelocityRadians = angle;
        this.skyAngularVelocity = angle * 180.0f / (float)Math.PI;
        this.thrustersFiring = firing;
    }

    public void setSpinRate(float angle) {
        this.angularVelocityRadians = angle;
        this.skyAngularVelocity = angle * 180.0f / (float)Math.PI;
    }

    public float getSpinRate() {
        return this.skyAngularVelocity;
    }

    public boolean func_76561_g() {
        return false;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 44;
    }

    public boolean func_76566_a(int x, int z) {
        return true;
    }

    public String func_80007_l() {
        return "Space Station " + this.field_76574_g;
    }

    public boolean hasBreathableAtmosphere() {
        return false;
    }

    public String getSaveFolder() {
        return "DIM_SPACESTATION" + this.field_76574_g;
    }

    public float getGravity() {
        return 0.075f;
    }

    public double getMeteorFrequency() {
        return 0.0;
    }

    public double getFuelUsageMultiplier() {
        return 0.5;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= this.getCelestialBody().getTierRequirement();
    }

    public float getFallDamageModifier() {
        return 0.4f;
    }

    public float getSoundVolReductionAmount() {
        return 50.0f;
    }

    public float getWindLevel() {
        return 0.1f;
    }

    public boolean useParachute() {
        return false;
    }

    public Vector3 getPlayerSpawnLocation(WorldServer world, EntityPlayerMP player) {
        return new Vector3(0.5, 65.1, 0.5);
    }

    public Vector3 getEntitySpawnLocation(WorldServer world, Entity entity) {
        return new Vector3(0.5, 65.1, 0.5);
    }

    public Vector3 getParaChestSpawnLocation(WorldServer world, EntityPlayerMP player, Random rand) {
        return new Vector3(-8.5, 90.0, -1.5);
    }

    public void onSpaceDimensionChanged(World newWorld, EntityPlayerMP player, boolean ridingAutoRocket) {
    }

    public void setupAdventureSpawn(EntityPlayerMP player) {
    }

    public double getYCoordinateToTeleport() {
        return 1200.0;
    }

    public int getYCoordToTeleportToPlanet() {
        return 30;
    }

    @Override
    public int AtmosphericPressure() {
        return 0;
    }

    @Override
    public boolean SolarRadiation() {
        return false;
    }

    public Vector3 getFogColor() {
        return new Vector3();
    }

    public Vector3 getSkyColor() {
        return new Vector3();
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 24000L;
    }

    public Class<? extends WorldChunkManager> getWorldChunkManagerClass() {
        return WorldChunkManagerSpaceGS.class;
    }
}

