/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace;

import bartworks.API.WerkstoffAdderRegistry;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import galaxyspace.ACentauriSystem.ACentauriPlanets;
import galaxyspace.BarnardsSystem.BarnardsPlanets;
import galaxyspace.BarnardsSystem.planets.barnardaC.tile.TileEntityBlockCrystalBTE;
import galaxyspace.SolarSystem.SolarSystemPlanets;
import galaxyspace.SolarSystem.moons.enceladus.tile.TileEntityBlockCrystallTE;
import galaxyspace.SolarSystem.moons.enceladus.tile.TileEntityDungeonSpawnerEnceladus;
import galaxyspace.SolarSystem.moons.io.tile.TileEntityDungeonSpawnerIO;
import galaxyspace.SolarSystem.moons.proteus.tile.TileEntityDungeonSpawnerProteus;
import galaxyspace.SolarSystem.planets.ceres.tile.TileEntityDungeonSpawnerCeres;
import galaxyspace.SolarSystem.planets.pluto.tile.TileEntityDungeonSpawnerPluto;
import galaxyspace.TCetiSystem.TCetiPlanets;
import galaxyspace.VegaSystem.VegaPlanets;
import galaxyspace.core.achievement.AchEvent;
import galaxyspace.core.achievement.AchievementList;
import galaxyspace.core.config.GSConfigBiomes;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.config.GSConfigDimensions;
import galaxyspace.core.config.GSConfigSchematics;
import galaxyspace.core.entity.boss.EntityBlazeBoss;
import galaxyspace.core.entity.boss.EntityCrystalBoss;
import galaxyspace.core.entity.boss.EntityGhastBoss;
import galaxyspace.core.entity.boss.EntitySlimeBoss;
import galaxyspace.core.entity.boss.EntityWolfBoss;
import galaxyspace.core.entity.mob.EntityCrawler;
import galaxyspace.core.entity.mob.EntityEvolvedBlaze;
import galaxyspace.core.entity.mob.EntityEvolvedColdBlaze;
import galaxyspace.core.entity.mob.EntityEvolvedEnderman;
import galaxyspace.core.entity.mob.EntityEvolvedFireCreeper;
import galaxyspace.core.entity.mob.EntityEvolvedFireSkeleton;
import galaxyspace.core.entity.mob.EntityEvolvedFireSpider;
import galaxyspace.core.entity.mob.EntityTentacles;
import galaxyspace.core.entity.rocket.EntityTier4Rocket;
import galaxyspace.core.entity.rocket.EntityTier5Rocket;
import galaxyspace.core.entity.rocket.EntityTier6Rocket;
import galaxyspace.core.entity.rocket.EntityTier7Rocket;
import galaxyspace.core.entity.rocket.EntityTier8Rocket;
import galaxyspace.core.handler.GSEventHandler;
import galaxyspace.core.handler.GSFuelHandler;
import galaxyspace.core.handler.GSGuiHandler;
import galaxyspace.core.handler.GSLightningStormHandler;
import galaxyspace.core.handler.GSOreGenOtherMods;
import galaxyspace.core.handler.GSPlanetFogHandler;
import galaxyspace.core.handler.GSSpaceSuitHandler;
import galaxyspace.core.particle.EntityIceBolt;
import galaxyspace.core.particle.EntityPlasmaBall;
import galaxyspace.core.particle.EntityPlasmaLaser;
import galaxyspace.core.particle.EntitySmallIceBolt;
import galaxyspace.core.proxy.CommonProxy;
import galaxyspace.core.recipe.CraftingRecipes;
import galaxyspace.core.recipe.SpaceStationRecipes;
import galaxyspace.core.recipe.schematic.Tier1RocketRecipe;
import galaxyspace.core.recipe.schematic.Tier2RocketRecipe;
import galaxyspace.core.recipe.schematic.Tier3RocketRecipe;
import galaxyspace.core.recipe.schematic.Tier4RocketRecipe;
import galaxyspace.core.recipe.schematic.Tier5RocketRecipe;
import galaxyspace.core.recipe.schematic.Tier6RocketRecipe;
import galaxyspace.core.recipe.schematic.Tier7RocketRecipe;
import galaxyspace.core.recipe.schematic.Tier8RocketRecipe;
import galaxyspace.core.register.GSBlocks;
import galaxyspace.core.register.GSFluids;
import galaxyspace.core.register.GSItems;
import galaxyspace.core.register.GSMaterials;
import galaxyspace.core.register.GSPotions;
import galaxyspace.core.schematic.SchematicAdd;
import galaxyspace.core.schematic.SchematicTier1Rocket;
import galaxyspace.core.schematic.SchematicTier2Rocket;
import galaxyspace.core.schematic.SchematicTier3Rocket;
import galaxyspace.core.schematic.SchematicTier4Rocket;
import galaxyspace.core.schematic.SchematicTier5Rocket;
import galaxyspace.core.schematic.SchematicTier6Rocket;
import galaxyspace.core.schematic.SchematicTier7Rocket;
import galaxyspace.core.schematic.SchematicTier8Rocket;
import galaxyspace.core.tile.TileEntityDuraluminumWire;
import galaxyspace.core.tile.chest.TileEntityTreasureChestT4;
import galaxyspace.core.tile.chest.TileEntityTreasureChestT5;
import galaxyspace.core.tile.chest.TileEntityTreasureChestT6;
import galaxyspace.core.tile.chest.TileEntityTreasureChestT7;
import galaxyspace.core.tile.chest.TileEntityTreasureChestT8;
import galaxyspace.core.tile.machine.TileEntityAssemblyMachine;
import galaxyspace.core.tile.machine.TileEntityConverterSurface;
import galaxyspace.core.tile.machine.TileEntityFuelGenerator;
import galaxyspace.core.tile.machine.TileEntityGeothermalGenerator;
import galaxyspace.core.tile.machine.TileEntityOxStorageModule;
import galaxyspace.core.tile.machine.TileEntitySolarPanel;
import galaxyspace.core.tile.machine.TileEntitySolarWind;
import galaxyspace.core.tile.machine.TileEntityStorageModule;
import gregtech.api.util.GTModHandler;
import java.io.File;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.core.util.CreativeTabGC;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Logger;

@Mod(modid="GalaxySpace", version="1.1.97-GTNH", dependencies="required-after:GalacticraftCore@[3.0.36,);required-after:GalacticraftMars;required-after:gregtech;required-after:gtnhlib@[0.0.8.1,);required-after:bartworks;after:miscutils;required-after:tectech;required-after:structurelib;after:IronChest;", name="GalaxySpace", acceptedMinecraftVersions="[1.7.10]")
public class GalaxySpace {
    public static final String MODID = "GalaxySpace";
    public static final String VERSION = "1.1.97-GTNH";
    public static final String NAME = "GalaxySpace";
    public static final String ASSET_PREFIX = "galaxyspace";
    public static CreativeTabs tabBlocks;
    public static CreativeTabs tabItems;
    public static CreativeTabs tabArmor;
    public static Logger logger;
    @Mod.Instance(value="GalaxySpace")
    public static GalaxySpace instance;
    @SidedProxy(clientSide="galaxyspace.core.proxy.ClientProxy", serverSide="galaxyspace.core.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        new GSConfigDimensions(new File(event.getModConfigurationDirectory(), "GalaxySpace/dimensions.conf"));
        new GSConfigBiomes(new File(event.getModConfigurationDirectory(), "GalaxySpace/biomes.conf"));
        new GSConfigSchematics(new File(event.getModConfigurationDirectory(), "GalaxySpace/schematics.conf"));
        new GSConfigCore(new File(event.getModConfigurationDirectory(), "GalaxySpace/core.conf"));
        GSBlocks.initialize();
        GSItems.initialize();
        GSPotions.initialize();
        GSFluids.initialize();
        WerkstoffAdderRegistry.addWerkstoffAdder((Runnable)new GSMaterials());
        if (GSConfigCore.enableACentauri) {
            ACentauriPlanets.preInit();
        }
        if (GSConfigCore.enableBarnarda) {
            BarnardsPlanets.preInit();
        }
        if (GSConfigCore.enableVega) {
            VegaPlanets.preInit();
        }
        if (GSConfigCore.enableTCeti) {
            TCetiPlanets.preInit();
        }
        proxy.preload();
        GameRegistry.registerFuelHandler((IFuelHandler)new GSFuelHandler());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicAdd());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier1Rocket());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier2Rocket());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier3Rocket());
        proxy.register_event(new GSEventHandler());
        proxy.register_event(new GSPlanetFogHandler());
        proxy.register_event(new GSLightningStormHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registerEntities();
        MinecraftForge.EVENT_BUS.register((Object)new GSOreGenOtherMods());
        AchievementList.load();
        SolarSystemPlanets.init();
        if (GSConfigCore.enableACentauri) {
            ACentauriPlanets.init();
        }
        if (GSConfigCore.enableBarnarda) {
            BarnardsPlanets.init();
        }
        if (GSConfigCore.enableVega) {
            VegaPlanets.init();
        }
        if (GSConfigCore.enableTCeti) {
            TCetiPlanets.init();
        }
        proxy.load();
        tabBlocks = new CreativeTabGC(CreativeTabs.getNextID(), "AddonsBlocks", Item.func_150898_a((Block)GSBlocks.CeresGlowStone), 0);
        tabItems = new CreativeTabGC(CreativeTabs.getNextID(), "AddonsItems", GSItems.Tier7Rocket, 0);
        tabArmor = new CreativeTabGC(CreativeTabs.getNextID(), "AddonsArmor", GSItems.JetPack, 0);
        GalacticraftRegistry.addDungeonLoot((int)4, (ItemStack)new ItemStack(GSItems.Tier4Schematic, 1, 0));
        GalacticraftRegistry.addDungeonLoot((int)5, (ItemStack)new ItemStack(GSItems.Tier5Schematic, 1, 0));
        GalacticraftRegistry.addDungeonLoot((int)6, (ItemStack)new ItemStack(GSItems.Tier6Schematic, 1, 0));
        GalacticraftRegistry.addDungeonLoot((int)7, (ItemStack)new ItemStack(GSItems.Tier7Schematic, 1, 0));
        GalacticraftRegistry.addDungeonLoot((int)8, (ItemStack)new ItemStack(GSItems.Tier8Schematic, 1, 0));
        if (Loader.isModLoaded((String)"kubatech")) {
            GalacticraftRegistry.addDungeonLoot((int)8, (ItemStack)GTModHandler.getModItem((String)"kubatech", (String)"kubaitems", (long)1L, (int)38));
        }
        GSSpaceSuitHandler.registerValidSpaceSuits();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        CraftingRecipes.loadRecipes();
        SpaceStationRecipes.loadRecipes();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GSGuiHandler());
        proxy.postload();
        proxy.register_event(new AchEvent());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        SolarSystemPlanets.setUnreachables();
    }

    private void registerEntities() {
        this.registerCreatures();
        this.registerNonMobEntities();
        this.registerTileEntities();
        this.registerRecipesWorkBench();
    }

    public void registerCreatures() {
        GCCoreUtil.registerGalacticraftCreature(EntityBlazeBoss.class, (String)"EvolvedBossBlaze", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityGhastBoss.class, (String)"EvolvedBossGhast", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityCrystalBoss.class, (String)"EvolvedCrystalBoss", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntitySlimeBoss.class, (String)"EvolvedBossSlime", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityWolfBoss.class, (String)"EvolvedBossWolf", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedFireCreeper.class, (String)"EvolvedFireCreeper", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedFireSkeleton.class, (String)"EvolvedFireSkeleton", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedFireSpider.class, (String)"EvolvedFireSpider", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedEnderman.class, (String)"EvolvedEnderman", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityTentacles.class, (String)"Tentacles", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedColdBlaze.class, (String)"EvolvedColdBlaze", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityCrawler.class, (String)"Crawler", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedBlaze.class, (String)"EvolvedBlaze", (int)-771829, (int)-870131);
    }

    private void registerNonMobEntities() {
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier4Rocket.class, (String)"SpaceshipT4", (int)150, (int)1, (boolean)false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier5Rocket.class, (String)"SpaceshipT5", (int)150, (int)1, (boolean)false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier6Rocket.class, (String)"SpaceshipT6", (int)150, (int)1, (boolean)false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier7Rocket.class, (String)"SpaceshipT7", (int)150, (int)1, (boolean)false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier8Rocket.class, (String)"SpaceshipT8", (int)150, (int)1, (boolean)false);
        EntityRegistry.registerModEntity(EntityPlasmaBall.class, (String)"PlasmaBall", (int)0, (Object)this, (int)40, (int)100, (boolean)true);
        EntityRegistry.registerModEntity(EntityPlasmaLaser.class, (String)"PlasmaLaser", (int)1, (Object)this, (int)40, (int)100, (boolean)true);
        EntityRegistry.registerModEntity(EntityIceBolt.class, (String)"IceBolt", (int)3, (Object)this, (int)40, (int)100, (boolean)true);
        EntityRegistry.registerModEntity(EntitySmallIceBolt.class, (String)"SmallIceBolt", (int)4, (Object)this, (int)40, (int)100, (boolean)true);
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityBlockCrystallTE.class, (String)"Crystal");
        GameRegistry.registerTileEntity(TileEntityAssemblyMachine.class, (String)"Assembly Machine");
        GameRegistry.registerTileEntity(TileEntityGeothermalGenerator.class, (String)"GS Geothermal Generator");
        GameRegistry.registerTileEntity(TileEntityFuelGenerator.class, (String)"GS Fuel Generator");
        GameRegistry.registerTileEntity(TileEntityConverterSurface.class, (String)"GS Converter Surface");
        GameRegistry.registerTileEntity(TileEntitySolarWind.class, (String)"GS Solar Wind Panel");
        GameRegistry.registerTileEntity(TileEntityTreasureChestT4.class, (String)"Tier 4 Treasure Chest");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawnerCeres.class, (String)"Ceres Dungeon Spawner");
        GameRegistry.registerTileEntity(TileEntityTreasureChestT5.class, (String)"Tier 5 Treasure Chest");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawnerIO.class, (String)"Io Dungeon Spawner");
        GameRegistry.registerTileEntity(TileEntityTreasureChestT6.class, (String)"Tier 6 Treasure Chest");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawnerEnceladus.class, (String)"Enceladus Dungeon Spawner");
        GameRegistry.registerTileEntity(TileEntityTreasureChestT7.class, (String)"Tier 7 Treasure Chest");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawnerProteus.class, (String)"Proteus Dungeon Spawner");
        GameRegistry.registerTileEntity(TileEntityTreasureChestT8.class, (String)"Tier 8 Treasure Chest");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawnerPluto.class, (String)"Pluto Dungeon Spawner");
        if (GSConfigCore.enableBarnarda) {
            GameRegistry.registerTileEntity(TileEntityBlockCrystalBTE.class, (String)"CrystalB");
        }
        GameRegistry.registerTileEntity(TileEntityDuraluminumWire.class, (String)"Duraluminum Wire");
        GameRegistry.registerTileEntity(TileEntityStorageModule.class, (String)"GS Storage Module");
        GameRegistry.registerTileEntity(TileEntityOxStorageModule.class, (String)"GS Oxygen Storage Module");
        GameRegistry.registerTileEntity(TileEntitySolarPanel.class, (String)"GS Solar Panel");
    }

    private void registerRecipesWorkBench() {
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier4Rocket());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier5Rocket());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier6Rocket());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier7Rocket());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier8Rocket());
        Tier1RocketRecipe.registerRecipeWorkBench();
        Tier2RocketRecipe.registerRecipeWorkBench();
        Tier3RocketRecipe.registerRecipeWorkBench();
        Tier4RocketRecipe.registerRecipeWorkBench();
        Tier5RocketRecipe.registerRecipeWorkBench();
        Tier6RocketRecipe.registerRecipeWorkBench();
        Tier7RocketRecipe.registerRecipeWorkBench();
        Tier8RocketRecipe.registerRecipeWorkBench();
    }

    public static void trace(String message) {
        logger.trace(message);
    }

    public static void debug(String message) {
        logger.debug(message);
    }

    public static void info(String message) {
        logger.info(message);
    }

    public static void warn(String message) {
        logger.warn(message);
    }

    public static void error(String message) {
        logger.error(message);
    }

    public static void fatal(String message) {
        logger.fatal(message);
    }

    public void markTextureUsed(IIcon o) {
        proxy.markTextureUsed(o);
    }
}

