/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import galaxyspace.core.nei.NEIGalaxySpaceConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class AssemblyMachineRecipeHandler
extends TemplateRecipeHandler {
    private static final ResourceLocation assemblymachineTexture = new ResourceLocation("galaxyspace", "textures/gui/assembly_machine.png");
    public static int ticksPassed;
    private int alternate = 0;

    public String getRecipeId() {
        return "galaxyspace.assemblymachine";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getRecipes() {
        HashMap recipes = new HashMap();
        for (Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack> stack : NEIGalaxySpaceConfig.getAssemblyMachineRecipes()) {
            ArrayList<PositionedStack> inputStacks = new ArrayList<PositionedStack>();
            for (Map.Entry<Integer, PositionedStack> input : stack.getKey().entrySet()) {
                inputStacks.add(input.getValue());
            }
            recipes.put(inputStacks, stack.getValue());
        }
        return recipes.entrySet();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)assemblymachineTexture);
        GuiDraw.drawTexturedModalRect((int)20, (int)25, (int)18, (int)17, (int)137, (int)54);
        if (ticksPassed % 70 > 26) {
            GuiDraw.drawTexturedModalRect((int)93, (int)39, (int)176, (int)0, (int)17, (int)13);
        }
        GuiDraw.drawTexturedModalRect((int)79, (int)46, (int)176, (int)13, (int)Math.min(ticksPassed % 70, 53), (int)17);
    }

    public void onUpdate() {
        ticksPassed += 1 + this.alternate;
        this.alternate = 1 - this.alternate;
        super.onUpdate();
    }

    public void loadTransferRects() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
                this.arecipes.add(new AssemblyMachineRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getValue().item, (ItemStack)result)) continue;
            this.arecipes.add(new AssemblyMachineRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block0: for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
            for (PositionedStack pstack : irecipe.getKey()) {
                if (!pstack.contains(ingredient)) continue;
                this.arecipes.add(new AssemblyMachineRecipe(irecipe));
                continue block0;
            }
        }
    }

    public ArrayList<PositionedStack> getIngredientStacks(int recipe) {
        return (ArrayList)((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getIngredients();
    }

    public PositionedStack getResultStack(int recipe) {
        if (ticksPassed % 70 >= 53) {
            return ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getResult();
        }
        return null;
    }

    public String getRecipeName() {
        return "Assembly Machine";
    }

    public String getGuiTexture() {
        return "galaxyspacetextures/gui/assembly_machine.png";
    }

    public void drawForeground(int recipe) {
    }

    public class AssemblyMachineRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> input;
        public PositionedStack output;

        public AssemblyMachineRecipe(Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe) {
            super((TemplateRecipeHandler)AssemblyMachineRecipeHandler.this);
        }

        public ArrayList<PositionedStack> getIngredients() {
            return (ArrayList)this.getCycledIngredients(AssemblyMachineRecipeHandler.this.cycleticks / 20, this.input);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public AssemblyMachineRecipe(ArrayList<PositionedStack> pstack1, PositionedStack pstack2) {
            super((TemplateRecipeHandler)AssemblyMachineRecipeHandler.this);
            this.input = pstack1;
            this.output = pstack2;
        }

        public AssemblyMachineRecipe(AssemblyMachineRecipeHandler assemblyMachineRecipeHandler, Map.Entry<ArrayList<PositionedStack>, PositionedStack> recipe) {
            this(new ArrayList<PositionedStack>((Collection)recipe.getKey()), recipe.getValue().copy());
        }
    }
}

