/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.item.electric;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.GalaxySpace;
import galaxyspace.core.particle.EntityPlasmaBall;
import galaxyspace.core.particle.EntityPlasmaLaser;
import galaxyspace.core.register.GSItems;
import java.util.List;
import micdoodle8.mods.galacticraft.api.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.items.ItemBatteryInfinite;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ItemElectricGun
extends ItemElectricBase {
    public float transferMax;
    private float maxPower;
    private int count = 0;

    public ItemElectricGun(String name, float maxPower) {
        this.func_77656_e(100);
        this.setNoRepair();
        this.setMaxTransfer();
        this.func_77655_b(name);
        this.maxPower = maxPower;
        this.func_111206_d("galaxyspace:tools/" + name);
    }

    protected void setMaxTransfer() {
        this.transferMax = 200.0f;
    }

    public float getMaxElectricityStored(ItemStack itemStack) {
        return this.maxPower;
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase living, EntityLivingBase holder) {
        if (this.getElectricityStored(itemStack) != 0.0f) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - 10.5f);
            return true;
        }
        return false;
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        if (this.getElectricityStored(itemStack) != 0.0f) {
            return EnumAction.bow;
        }
        return EnumAction.bow;
    }

    public int func_77626_a(ItemStack itemStack) {
        if (this.getElectricityStored(itemStack) != 0.0f) {
            return 72000;
        }
        return 0;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entity, World world, int par1, int par2, int par3, int par4, float par5, float par6, float par7) {
        return false;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (!world.field_72995_K && this.getElectricityStored(itemStack) != 0.0f && itemStack.func_77973_b() == GSItems.PlasmaGun) {
            float fire1 = 1.5f;
            float fire2 = 100.5f;
            if (Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151470_d()) {
                ++this.count;
            }
            if (this.count > 5 && Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151470_d() && this.getElectricityStored(itemStack) > 100.5f) {
                this.count = 0;
                world.func_72838_d((Entity)new EntityPlasmaBall(world, (EntityLivingBase)player));
                player.func_71008_a(itemStack, this.func_77626_a(itemStack));
                this.setElectricity(itemStack, this.getElectricityStored(itemStack) - 100.5f);
                return itemStack;
            }
            if (!Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151470_d() && this.getElectricityStored(itemStack) > 1.5f) {
                world.func_72838_d((Entity)new EntityPlasmaLaser(world, (EntityLivingBase)player));
                this.setElectricity(itemStack, this.getElectricityStored(itemStack) - 1.5f);
            }
        }
        return itemStack;
    }

    public Multimap getAttributeModifiers(ItemStack itemStack) {
        if (this.getElectricityStored(itemStack) != 0.0f) {
            return super.getAttributeModifiers(itemStack);
        }
        return HashMultimap.create();
    }

    public CreativeTabs func_77640_w() {
        return GalaxySpace.tabArmor;
    }

    public boolean func_82789_a(ItemStack itemStack, ItemStack itemStack2) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(ElectricItemHelper.getWithCharge((ItemStack)new ItemStack((Item)this), (float)this.getMaxElectricityStored(new ItemStack((Item)this))));
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="Mekanism")
    public double getEnergy(ItemStack itemStack) {
        return this.getElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="Mekanism")
    public void setEnergy(ItemStack itemStack, double amount) {
        this.setElectricity(itemStack, (float)amount * EnergyConfigHandler.MEKANISM_RATIO);
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="Mekanism")
    public double getMaxEnergy(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="Mekanism")
    public double getMaxTransfer(ItemStack itemStack) {
        return this.transferMax * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="Mekanism")
    public boolean canReceive(ItemStack itemStack) {
        return itemStack != null && !(itemStack.func_77973_b() instanceof ItemBatteryInfinite);
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public Item getChargedItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public Item getEmptyItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public int getTier(ItemStack itemStack) {
        return 1;
    }

    @Annotations.VersionSpecific(version="[1.7.10]")
    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public double getMaxCharge(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) / EnergyConfigHandler.IC2_RATIO;
    }

    @Annotations.AltForVersion(version="[1.7.2]")
    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public int getMaxChargeB(ItemStack itemStack) {
        return (int)(this.getMaxElectricityStored(itemStack) / EnergyConfigHandler.IC2_RATIO);
    }

    @Annotations.VersionSpecific(version="[1.7.10]")
    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public double getTransferLimit(ItemStack itemStack) {
        return this.transferMax * EnergyConfigHandler.TO_IC2_RATIO;
    }

    @Annotations.VersionSpecific(version="[1.7.2]")
    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public int getTransferLimitB(ItemStack itemStack) {
        return (int)(this.transferMax * EnergyConfigHandler.TO_IC2_RATIO);
    }

    public float recharge(ItemStack itemStack, float energy, boolean doRecharge) {
        float rejectedElectricity = Math.max(this.getElectricityStored(itemStack) + energy - this.getMaxElectricityStored(itemStack), 0.0f);
        float energyToReceive = energy - rejectedElectricity;
        if (energyToReceive > this.transferMax) {
            rejectedElectricity += energyToReceive - this.transferMax;
            energyToReceive = this.transferMax;
        }
        if (doRecharge) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) + energyToReceive);
        }
        return energyToReceive;
    }

    public float discharge(ItemStack itemStack, float energy, boolean doDischarge) {
        float energyToTransfer = Math.min(Math.min(this.getElectricityStored(itemStack), energy), this.transferMax);
        if (doDischarge) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - energyToTransfer);
        }
        return energyToTransfer;
    }

    public float getElectricityStored(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float energyStored = 0.0f;
        if (itemStack.func_77978_p().func_74764_b("electricity")) {
            NBTBase obj = itemStack.func_77978_p().func_74781_a("electricity");
            if (obj instanceof NBTTagDouble) {
                energyStored = ((NBTTagDouble)obj).func_150288_h();
            } else if (obj instanceof NBTTagFloat) {
                energyStored = ((NBTTagFloat)obj).func_150288_h();
            }
        }
        itemStack.func_77964_b((int)(100.0f - energyStored / this.getMaxElectricityStored(itemStack) * 100.0f));
        return energyStored;
    }

    public void setElectricity(ItemStack itemStack, float joules) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float electricityStored = Math.max(Math.min(joules, this.getMaxElectricityStored(itemStack)), 0.0f);
        itemStack.func_77978_p().func_74776_a("electricity", electricityStored);
        itemStack.func_77964_b((int)(100.0f - electricityStored / this.getMaxElectricityStored(itemStack) * 100.0f));
    }

    public float getTransfer(ItemStack itemStack) {
        return Math.min(this.transferMax, this.getMaxElectricityStored(itemStack) - this.getElectricityStored(itemStack));
    }

    public int getTierGC(ItemStack itemStack) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean advanced) {
        EnumChatFormatting color = null;
        float joules = this.getElectricityStored(itemStack);
        color = joules <= this.getMaxElectricityStored(itemStack) / 3.0f ? EnumChatFormatting.DARK_RED : (joules > this.getMaxElectricityStored(itemStack) * 2.0f / 3.0f ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.GOLD);
        list.add(color + EnergyDisplayHelper.getEnergyDisplayS((float)joules) + "/" + EnergyDisplayHelper.getEnergyDisplayS((float)this.getMaxElectricityStored(itemStack)));
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        this.setElectricity(itemStack, 0.0f);
    }
}

