/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.config;

import galaxyspace.GalaxySpace;
import java.io.File;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class GSConfigCore {
    public static boolean loaded;
    static Configuration config;
    public static boolean recipesRockets;
    public static boolean enableCheckVersion;
    public static boolean enableACentauri;
    public static boolean enableBarnarda;
    public static boolean enableVega;
    public static boolean enableTCeti;
    public static boolean enableLeadGeneration;
    public static boolean enableOresGeneration;
    public static boolean enableNewMenu;
    public static boolean enableFogVenus;
    public static int coefficientFuelGenerator;
    public static int coefficientGeothermalGenerator;
    public static int coefficientSolarWindPanel;
    public static int coefficientSolarPanel;
    public static int idSolarRadiation;
    public static int crystalBossInvisibilityIntervall;
    public static int crystalBossInvisibilityDuration;
    public static double crystalBossInvisibilityProbability;
    public static float baseBossDamage;
    public static boolean enableMethaneParticle;
    public static String[] oregenIDs;

    public GSConfigCore(File file) {
        if (!loaded) {
            config = new Configuration(file);
            GSConfigCore.syncConfig(true);
        }
    }

    public static void syncConfig(boolean load) {
        ArrayList<String> propOrder = new ArrayList<String>();
        try {
            if (!GSConfigCore.config.isChild && load) {
                config.load();
            }
            Property prop = config.get("general", "Advanced Recipes Rocket", true);
            prop.comment = "Enable/Disable advanced recipes rocket (Tier 1-8).";
            prop.setLanguageKey("gc.configgui.recipesRockets").setRequiresMcRestart(true);
            recipesRockets = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableCheckVersion", true);
            prop.comment = "Enable/Disable Check Version.";
            prop.setLanguageKey("gc.configgui.enableCheckVersion").setRequiresMcRestart(true);
            enableCheckVersion = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "enableACentauri", true);
            prop.comment = "Enable/Disable aCentauri System.";
            prop.setLanguageKey("gc.configgui.enableACentauri").setRequiresMcRestart(true);
            enableACentauri = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "enableBarnarda", true);
            prop.comment = "Enable/Disable Barnarda System.";
            prop.setLanguageKey("gc.configgui.enableBarnarda").setRequiresMcRestart(true);
            enableBarnarda = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "enableVega", true);
            prop.comment = "Enable/Disable Vega System.";
            prop.setLanguageKey("gc.configgui.enableVega").setRequiresMcRestart(true);
            enableVega = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "enableTCeti", true);
            prop.comment = "Enable/Disable tCeti System.";
            prop.setLanguageKey("gc.configgui.enableTCeti").setRequiresMcRestart(true);
            enableTCeti = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("worldgen", "enableLeadGeneration", true);
            prop.comment = "Enable/Disable Generation Lead on Overworld.";
            prop.setLanguageKey("gc.configgui.enableLeadGeneration").setRequiresMcRestart(true);
            enableLeadGeneration = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("worldgen", "enableOresGeneration", true);
            prop.comment = "Enable/Disable Generation Ores on Planets/Moon (Global Config).";
            prop.setLanguageKey("gc.configgui.enableOresGeneration").setRequiresMcRestart(true);
            enableOresGeneration = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableNewMenu", true);
            prop.comment = "Enable/Disable new Main Menu.";
            prop.setLanguageKey("gc.configgui.enableNewMenu").setRequiresMcRestart(true);
            enableNewMenu = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "enableMethaneParticle", true);
            prop.comment = "Enable/Disable Methane Particles.";
            prop.setLanguageKey("gc.configgui.enableMethaneParticle").setRequiresMcRestart(true);
            enableMethaneParticle = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "coefficientFuelGenerator", coefficientFuelGenerator);
            prop.comment = "Fuel Generator power factor";
            prop.setLanguageKey("gc.configgui.coefficientFuelGenerator").setRequiresMcRestart(true);
            coefficientFuelGenerator = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("general", "coefficientGeothermalGenerator", coefficientGeothermalGenerator);
            prop.comment = "Geothermal Generator power factor";
            prop.setLanguageKey("gc.configgui.coefficientGeothermalGenerator").setRequiresMcRestart(true);
            coefficientGeothermalGenerator = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("general", "coefficientSolarWindPanel", coefficientSolarWindPanel);
            prop.comment = "Solar Wind Panel power factor";
            prop.setLanguageKey("gc.configgui.coefficientSolarWindPanel").setRequiresMcRestart(true);
            coefficientSolarWindPanel = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("general", "coefficientSolarPanel", coefficientSolarPanel);
            prop.comment = "Gybrid Solar Panel power factor";
            prop.setLanguageKey("gc.configgui.coefficientSolarPanel").setRequiresMcRestart(true);
            coefficientSolarPanel = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("worldgen", "Other mods ores for GC to generate on GS planets", new String[0]);
            prop.comment = "Enter IDs of other mods' ores here for Galacticraft to generate them on GalaxySpace planets. Format is BlockName or BlockName:metadata. Use optional parameters at end of each line: /RARE /UNCOMMON or /COMMON for rarity in a chunk; /DEEP /SHALLOW or /BOTH for height; /SINGLE /STANDARD or /LARGE for clump size; /XTRARANDOM for ores sometimes there sometimes not at all.  /ONLYMOON or /ONLYMARS if wanted on one planet only.  If nothing specified, defaults are /COMMON, /BOTH and /STANDARD.  Repeat lines to generate a huge quantity of ores.";
            prop.comment = "/ONLYPHOBOS, /ONLYDEIMOS, /ONLYEUROPA, /ONLYIO, /ONLYENCELADUS, /ONLYVENUS, /ONLYMERCURY, /ONLYCERES if wanted on one planet only.";
            prop.setLanguageKey("gc.configgui.otherModOreGenIDs");
            oregenIDs = prop.getStringList();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "enableFogVenus", true);
            prop.comment = "Enable/Disable Fog on Venus.";
            prop.setLanguageKey("gc.configgui.enableFogVenus").setRequiresMcRestart(true);
            enableFogVenus = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "idSolarRadiation", idSolarRadiation);
            prop.comment = "ID Potion 'Solar Radiation'";
            prop.setLanguageKey("gc.configgui.idSolarRadiation").setRequiresMcRestart(true);
            idSolarRadiation = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("general", "crystalBossInvisibilityInterval", 100);
            prop.comment = "Every x ticks, the Crystal Boss tries to make itself invisible";
            prop.setMinValue(1);
            crystalBossInvisibilityIntervall = prop.getInt(100);
            propOrder.add(prop.getName());
            prop = config.get("general", "crystalBossInvisibilityDuration", 60);
            prop.comment = "How long the Crystal Boss can make itself invisible";
            prop.setMinValue(1).setMaxValue(1000000);
            crystalBossInvisibilityDuration = prop.getInt(60);
            propOrder.add(prop.getName());
            prop = config.get("general", "crystalBossInvisibilityInterval", 0.5);
            prop.comment = "How high the probability is, that the Crystal Boss will make itself invisible";
            prop.setMinValue(0.0).setMaxValue(1.0);
            crystalBossInvisibilityProbability = prop.getDouble(0.5);
            propOrder.add(prop.getName());
            prop = config.get("general", "baseBossDamage", 3.0);
            prop.comment = "How much damage the player can deal at most to Evolved Crystal Boss, Evolved Blaze Boss and Evolved Ghast Boss (These bosses are supposed to be beatenb by their own fireballs!)";
            prop.setMinValue(0.0).setMaxValue(3.4028234663852886E38);
            baseBossDamage = (float)prop.getDouble(3.0);
            propOrder.add(prop.getName());
            config.setCategoryPropertyOrder("general", propOrder);
            if (config.hasChanged()) {
                config.save();
            }
        }
        catch (Exception e) {
            GalaxySpace.error("A problem occured while loading the core config!");
            e.printStackTrace();
        }
    }

    static {
        coefficientFuelGenerator = 1;
        coefficientGeothermalGenerator = 1;
        coefficientSolarWindPanel = 1;
        coefficientSolarPanel = 1;
        crystalBossInvisibilityIntervall = 1;
        idSolarRadiation = 29;
        oregenIDs = new String[0];
    }
}

