/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.tile.machine.multi.elevator.projects.pump;

import com.github.technus.tectech.thing.metaTileEntity.multi.base.INameFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.LedStatus;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.Parameters;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import galaxyspace.BarnardsSystem.BRFluids;
import galaxyspace.core.tile.machine.multi.elevator.projects.TileEntity_ProjectBase;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public abstract class TileEntity_ProjectPump
extends TileEntity_ProjectBase {
    public static final Map<Pair<Integer, Integer>, FluidStack> RECIPES = new HashMap<Pair<Integer, Integer>, FluidStack>();
    public static final int ENERGY_CONSUMPTION = (int)GT_Values.VP[9];
    Parameters.Group.ParameterIn[] parallelSettings;
    Parameters.Group.ParameterIn[] gasTypeSettings;
    Parameters.Group.ParameterIn[] planetTypeSettings;
    private static final INameFunction<TileEntity_ProjectPump> PLANET_TYPE_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.gs.pump.cfgi.0") + " " + (p.hatchId() / 2 + 1);
    private static final IStatusFunction<TileEntity_ProjectPump> PLANET_TYPE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)1.0, (double)0.0, (double)100.0, (double)100.0, (double[])new double[0]);
    private static final INameFunction<TileEntity_ProjectPump> GAS_TYPE_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.gs.pump.cfgi.1") + " " + (p.hatchId() / 2 + 1);
    private static final IStatusFunction<TileEntity_ProjectPump> GAS_TYPE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)1.0, (double)0.0, (double)100.0, (double)100.0, (double[])new double[0]);
    private static final INameFunction<TileEntity_ProjectPump> PARALLEL_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.gs.pump.cfgi.2") + " " + (p.hatchId() / 2 + 1);
    private static final IStatusFunction<TileEntity_ProjectPump> PARALLEL_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)1.0, (double)100.0, (double)base.getParallels(), (double[])new double[0]);

    public TileEntity_ProjectPump(int aID, String aName, String aNameRegional, int tTier, int tModuleTier, int tMinMotorTier) {
        super(aID, aName, aNameRegional, tTier, tModuleTier, tMinMotorTier);
    }

    public TileEntity_ProjectPump(String aName, int tTier, int tModuleTier, int tMinMotorTier) {
        super(aName, tTier, tModuleTier, tMinMotorTier);
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        ArrayList<FluidStack> outputs = new ArrayList<FluidStack>();
        int usedEUt = 0;
        for (int i = 0; i < this.getParallelRecipes(); ++i) {
            FluidStack fluid = RECIPES.get(Pair.of((Object)((int)this.planetTypeSettings[i].get()), (Object)((int)this.gasTypeSettings[i].get())));
            if (fluid == null) continue;
            fluid = fluid.copy();
            fluid.amount *= Math.min((int)this.parallelSettings[i].get(), this.getParallels());
            usedEUt += ENERGY_CONSUMPTION * Math.min((int)this.parallelSettings[i].get(), this.getParallels());
            outputs.add(fluid);
        }
        this.lEUt = -usedEUt;
        this.mOutputFluids = outputs.toArray(new FluidStack[0]);
        this.eAmpereFlow = 1L;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = 20;
        return outputs.size() > 0;
    }

    protected abstract int getParallels();

    protected abstract int getParallelRecipes();

    @Override
    protected void parametersInstantiation_EM() {
        super.parametersInstantiation_EM();
        int parallels = this.getParallelRecipes();
        this.planetTypeSettings = new Parameters.Group.ParameterIn[parallels];
        this.gasTypeSettings = new Parameters.Group.ParameterIn[parallels];
        this.parallelSettings = new Parameters.Group.ParameterIn[parallels];
        for (int i = 0; i < this.getParallelRecipes(); ++i) {
            this.planetTypeSettings[i] = this.parametrization.getGroup(i * 2, false).makeInParameter(0, 1.0, PLANET_TYPE_SETTING_NAME, PLANET_TYPE_STATUS);
            this.gasTypeSettings[i] = this.parametrization.getGroup(i * 2, false).makeInParameter(1, 1.0, GAS_TYPE_SETTING_NAME, GAS_TYPE_STATUS);
            this.parallelSettings[i] = this.parametrization.getGroup(i * 2 + 1, false).makeInParameter(0, (double)this.getParallels(), PARALLEL_SETTING_NAME, PARALLEL_STATUS);
        }
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.gs.elevator.gui.config")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine));
        int i = 0;
        while (i < this.getParallelRecipes()) {
            int fluidIndex = i++;
            ((Column)((Column)screenElements.widget(TextWidget.dynamicString(() -> {
                String fluidName = this.getPumpedFluid(fluidIndex);
                if (fluidName != null) {
                    return " - " + fluidName;
                }
                return "";
            }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getPumpedFluid(fluidIndex) != null))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> (int)this.planetTypeSettings[fluidIndex].get(), val -> this.parametrization.trySetParameters(this.planetTypeSettings[fluidIndex].id % 10, this.planetTypeSettings[fluidIndex].id / 10, this.planetTypeSettings[fluidIndex].get())))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> (int)this.planetTypeSettings[fluidIndex].get(), val -> this.parametrization.trySetParameters(this.gasTypeSettings[fluidIndex].id % 10, this.gasTypeSettings[fluidIndex].id / 10, this.gasTypeSettings[fluidIndex].get())));
        }
    }

    private String getPumpedFluid(int index) {
        if (index < 0 || index >= this.getParallelRecipes()) {
            return null;
        }
        FluidStack fluid = RECIPES.get(Pair.of((Object)((int)this.planetTypeSettings[index].get()), (Object)((int)this.gasTypeSettings[index].get())));
        if (fluid == null) {
            return null;
        }
        return fluid.getLocalizedName();
    }

    public static void initCommon() {
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)2, (Object)1), Materials.Chlorobenzene.getFluid(896000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)4, (Object)1), Materials.SulfuricAcid.getFluid(784000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)4, (Object)2), Materials.Iron.getMolten(896000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)4, (Object)3), Materials.Oil.getFluid(1400000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)4, (Object)4), Materials.OilHeavy.getFluid(1792000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)5, (Object)1), Materials.CarbonMonoxide.getGas(4480000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)5, (Object)2), Materials.Helium_3.getGas(2800000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)5, (Object)3), Materials.SaltWater.getFluid(2800000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)5, (Object)4), Materials.Helium.getGas(20000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)5, (Object)5), Materials.LiquidOxygen.getGas(1500L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)5, (Object)6), FluidRegistry.getFluidStack((String)"neon", (int)4500));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)5, (Object)7), Materials.Argon.getGas(2250L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)5, (Object)8), FluidRegistry.getFluidStack((String)"krypton", (int)1000));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)5, (Object)9), Materials.Methane.getGas(1792000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)6, (Object)1), Materials.Deuterium.getGas(1568000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)6, (Object)2), Materials.Tritium.getGas(240000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)6, (Object)3), Materials.Ammonia.getGas(2000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)6, (Object)4), FluidRegistry.getFluidStack((String)"xenon", (int)1750));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)6, (Object)5), Materials.Ethylene.getGas(1792000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)7, (Object)1), Materials.HydrofluoricAcid.getFluid(672000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)7, (Object)2), Materials.Fluorine.getGas(1792000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)7, (Object)3), Materials.Nitrogen.getGas(1792000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)7, (Object)4), Materials.Oxygen.getGas(1792000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)8, (Object)1), Materials.Hydrogen.getGas(1568000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)8, (Object)2), Materials.LiquidAir.getFluid(875000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)8, (Object)3), Materials.Copper.getMolten(672000L));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)8, (Object)4), new FluidStack(BRFluids.UnknowWater, 672000));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)8, (Object)5), FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)0x1117000));
        RECIPES.put((Pair<Integer, Integer>)Pair.of((Object)8, (Object)6), Materials.Radon.getGas(64000L));
    }

    public static void initClient() {
        TileEntity_ProjectPump.initCommon();
    }
}

