/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.tile.machine.multi.elevator.projects.miner;

import com.github.bartimaeusnek.bartworks.util.RecipeFinderForParallel;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.INameFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.LedStatus;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.Parameters;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import galaxyspace.core.recipe.GS_Recipe;
import galaxyspace.core.recipe.GS_RecipeAdder;
import galaxyspace.core.tile.machine.multi.elevator.projects.MultiblockControl;
import galaxyspace.core.tile.machine.multi.elevator.projects.TileEntity_ProjectBase;
import galaxyspace.core.tile.machine.multi.elevator.projects.spaceprojects.AsteroidOutpost;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Recipe;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import gregtech.common.misc.spaceprojects.enums.SolarSystem;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceBody;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceProject;
import gregtech.common.power.BasicMachineEUPower;
import gregtech.common.power.Power;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public abstract class TileEntity_ProjectMiner
extends TileEntity_ProjectBase {
    protected static int BONUS_STACK_BASE_CHANCE = 5000;
    protected static int BONUS_STACK_MAX_CHANCE = 7500;
    protected static final double MIN_RECIPE_TIME_MODIFIER = 0.5;
    protected static int PLASMA_HELIUM_USAGE = 1000;
    protected static int PLASMA_BISMUTH_USAGE = 500;
    protected static int PLASMA_RADON_USAGE = 300;
    protected static final ISpaceProject ASTEROID_OUTPOST = SpaceProjectManager.getProject((String)"AsteroidOutput");
    Parameters.Group.ParameterIn distanceSetting;
    Parameters.Group.ParameterIn parallelSetting;
    Parameters.Group.ParameterIn overdriveSetting;
    Parameters.Group.ParameterIn modeSetting;
    Parameters.Group.ParameterIn rangeSetting;
    Parameters.Group.ParameterIn stepSetting;
    Parameters.Group.ParameterOut distanceDisplay;
    private static final INameFunction<TileEntity_ProjectMiner> DISTANCE_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.gs.miner.cfgi.0");
    private static final IStatusFunction<TileEntity_ProjectMiner> DISTANCE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)1.0, (double)0.0, (double)200.0, (double)300.0, (double[])new double[0]);
    private static final INameFunction<TileEntity_ProjectMiner> PARALLEL_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.gs.miner.cfgi.1");
    private static final IStatusFunction<TileEntity_ProjectMiner> PARALLEL_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)1.0, (double)100.0, (double)base.getParallels(), (double[])new double[0]);
    private static final INameFunction<TileEntity_ProjectMiner> OVERDRIVE_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.gs.miner.cfgi.2");
    private static final IStatusFunction<TileEntity_ProjectMiner> OVERDRIVE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)1.0, (double)1.5, (double)2.0, (double[])new double[0]);
    private static final INameFunction<TileEntity_ProjectMiner> MODE_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.gs.miner.cfgi.4");
    private static final IStatusFunction<TileEntity_ProjectMiner> MODE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)0.0, (double)1.1, (double)1.1, (double[])new double[0]);
    private static final INameFunction<TileEntity_ProjectMiner> RANGE_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.gs.miner.cfgi.5");
    private static final IStatusFunction<TileEntity_ProjectMiner> RANGE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)0.0, (double)50.0, (double)150.0, (double[])new double[0]);
    private static final INameFunction<TileEntity_ProjectMiner> STEP_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.gs.miner.cfgi.6");
    private static final IStatusFunction<TileEntity_ProjectMiner> STEP_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)0.0, (double)10.0, (double)20.0, (double[])new double[0]);
    protected final Power power;
    protected AsteroidOutpost asteroidOutpost;

    public TileEntity_ProjectMiner(int aID, String aName, String aNameRegional, int tTier, int tModuleTier, int tMinMotorTier) {
        super(aID, aName, aNameRegional, tTier, tModuleTier, tMinMotorTier);
        this.power = new MinerPower((byte)tTier, tModuleTier);
    }

    public TileEntity_ProjectMiner(String aName, int tTier, int tModuleTier, int tMinMotorTier) {
        super(aName, tTier, tModuleTier, tMinMotorTier);
        this.power = new MinerPower((byte)tTier, tModuleTier);
    }

    public Power getPower() {
        return this.power;
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        this.lEUt = 0L;
        this.eAmpereFlow = 0L;
        this.eRequiredData = 0L;
        this.mEfficiencyIncrease = 0;
        this.mPollution = 0;
        this.mOutputItems = null;
        this.mOutputFluids = null;
        float plasmaModifier = 1.0f;
        if (this.asteroidOutpost != null) {
            plasmaModifier -= this.asteroidOutpost.getPlasmaDiscount();
        }
        if (this.getStoredFluids().size() <= 0) {
            return false;
        }
        for (FluidStack fluidStack : this.getStoredFluids()) {
            MultiblockControl control;
            int availablePlasmaTier = this.getTierFromPlasma(fluidStack);
            if (availablePlasmaTier <= 0 || (control = this.process(this.getStoredInputs().toArray(new ItemStack[0]), this.getStoredFluids().toArray(new FluidStack[0]), availablePlasmaTier, this.getParallels(fluidStack, this.getPlasmaUsageFromTier(availablePlasmaTier)))) == null) continue;
            fluidStack.amount = (int)Math.max(0.0, Math.ceil((float)fluidStack.amount - (float)(control.getParallels() * this.getPlasmaUsageFromTier(availablePlasmaTier)) * plasmaModifier));
            if (control.shouldExplode()) {
                this.explodeMultiblock();
                return false;
            }
            this.mOutputItems = control.getItemOutput();
            this.mOutputFluids = control.getFluidOutput();
            this.lEUt = -control.getEUT();
            this.eAmpereFlow += (long)control.getAmperage();
            this.mPollution += control.getPollutionToAdd();
            this.eRequiredData += (long)control.getRequiredComputation();
            this.mMaxProgresstime = control.getMaxProgressTime();
            this.mEfficiencyIncrease = control.getEffIncrease();
            this.cycleDistance();
            return true;
        }
        this.cycleDistance();
        return false;
    }

    public MultiblockControl process(ItemStack[] inputs, FluidStack[] fluidInputs, int availablePlasmaTier, int maxParallels) {
        int recipeIndex;
        if (inputs == null && fluidInputs == null) {
            return null;
        }
        if (availablePlasmaTier <= 0) {
            return null;
        }
        long tVoltage = this.getMaxInputVoltage();
        GS_Recipe.GT_Recipe_MapGS tRecipeMap = GS_RecipeAdder.instance.sSpaceMiningRecipes;
        List<GS_Recipe.GS_SpaceMiningRecipe> recipes = GS_RecipeAdder.instance.sSpaceMiningRecipes.findRecipes((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), null, false, false, tVoltage, fluidInputs, null, (int)this.distanceDisplay.get(), this.tModuleTier, inputs);
        if (recipes == null || recipes.size() <= 0) {
            return null;
        }
        int totalWeight = recipes.stream().mapToInt(GS_Recipe.GS_SpaceMiningRecipe::getRecipeWeight).sum();
        double r = Math.random() * (double)totalWeight;
        for (recipeIndex = 0; recipeIndex < recipes.size() - 1 && !((r -= (double)recipes.get(recipeIndex).getRecipeWeight()) <= 0.0); ++recipeIndex) {
        }
        GS_Recipe.GS_SpaceMiningRecipe tRecipe = recipes.get(recipeIndex);
        if (tRecipe == null || (long)tRecipe.mEUt > tVoltage) {
            return null;
        }
        if ((maxParallels = (int)Math.min((long)maxParallels, this.getAvailableData_EM() / (long)tRecipe.computation)) <= 0) {
            return null;
        }
        int parallels = RecipeFinderForParallel.handleParallelRecipe((GT_Recipe)tRecipe, (FluidStack[])fluidInputs, (ItemStack[])inputs, (int)maxParallels);
        if (parallels <= 0) {
            return null;
        }
        float compModifier = 1.0f;
        if (this.asteroidOutpost != null) {
            compModifier -= this.asteroidOutpost.getComputationDiscount();
        }
        ItemStack[] outputs = new ItemStack[tRecipe.maxSize * parallels];
        int totalChance = Arrays.stream(tRecipe.mChances).sum();
        try {
            block3: for (int i = 0; i < tRecipe.maxSize * parallels; ++i) {
                int bonusStackChance = 0;
                if (i >= tRecipe.minSize * parallels) {
                    bonusStackChance = this.getBonusStackChance(availablePlasmaTier);
                }
                if (i >= tRecipe.minSize * parallels && bonusStackChance <= XSTR.XSTR_INSTANCE.nextInt(10000)) continue;
                int random = XSTR.XSTR_INSTANCE.nextInt(totalChance);
                int currentChance = 0;
                for (int j = 0; j < tRecipe.mChances.length; ++j) {
                    if (random > (currentChance += tRecipe.mChances[j])) continue;
                    outputs[i] = tRecipe.mOutputs[j].func_77946_l();
                    continue block3;
                }
            }
        }
        catch (Exception ignored) {
            return null;
        }
        return new MultiblockControl(outputs, null, tRecipe.mEUt * parallels, 1, (int)Math.ceil((float)(tRecipe.computation * parallels) * compModifier), 10000, this.getRecipeTime(tRecipe.mDuration, availablePlasmaTier), parallels, 0);
    }

    protected int getTierFromPlasma(FluidStack fluidStack) {
        if (fluidStack == null) {
            return 0;
        }
        if (fluidStack.isFluidEqual(Materials.Radon.getPlasma(1L)) && fluidStack.amount >= PLASMA_RADON_USAGE) {
            return 3;
        }
        if (fluidStack.isFluidEqual(Materials.Bismuth.getPlasma(1L)) && fluidStack.amount >= PLASMA_BISMUTH_USAGE) {
            return 2;
        }
        if (fluidStack.isFluidEqual(Materials.Helium.getPlasma(1L)) && fluidStack.amount >= PLASMA_HELIUM_USAGE) {
            return 1;
        }
        return 0;
    }

    protected int getPlasmaUsageFromTier(int plasmaTier) {
        switch (plasmaTier) {
            case 1: {
                return PLASMA_HELIUM_USAGE;
            }
            case 2: {
                return PLASMA_BISMUTH_USAGE;
            }
            case 3: {
                return PLASMA_RADON_USAGE;
            }
        }
        return 0;
    }

    protected int getBonusStackChance(int plasmaTier) {
        if (plasmaTier <= 0 || plasmaTier > 3) {
            return 0;
        }
        return Math.min((int)((double)(BONUS_STACK_BASE_CHANCE + 1000 * (plasmaTier - 1)) * (2.0 - this.overdriveSetting.get())), BONUS_STACK_MAX_CHANCE);
    }

    protected abstract int getParallels();

    protected int getParallels(FluidStack plasma, int plasmaUsage) {
        if (plasma == null) {
            return 0;
        }
        return Math.min((int)this.parallelSetting.get(), plasma.amount / plasmaUsage);
    }

    protected int getRecipeTime(int unboostedTime, int plasmaTier) {
        return plasmaTier > 0 ? (int)((double)unboostedTime * Math.max((1.0 - 0.1 * (double)(plasmaTier - 1)) / this.overdriveSetting.get(), 0.5)) : unboostedTime;
    }

    protected void cycleDistance() {
        if ((int)this.modeSetting.get() != 0) {
            if (this.distanceDisplay.get() + this.stepSetting.get() < this.distanceSetting.get() + this.rangeSetting.get()) {
                this.distanceDisplay.set(this.distanceDisplay.get() + this.stepSetting.get());
            } else {
                this.distanceDisplay.set(this.distanceSetting.get() - this.rangeSetting.get());
            }
        } else {
            this.distanceDisplay.set(this.distanceSetting.get());
        }
    }

    @Override
    protected void parametersInstantiation_EM() {
        super.parametersInstantiation_EM();
        Parameters.Group hatch_0 = this.parametrization.getGroup(0, false);
        Parameters.Group hatch_1 = this.parametrization.getGroup(1, false);
        Parameters.Group hatch_2 = this.parametrization.getGroup(2, false);
        Parameters.Group hatch_3 = this.parametrization.getGroup(3, false);
        this.distanceSetting = hatch_0.makeInParameter(0, 1.0, DISTANCE_SETTING_NAME, DISTANCE_STATUS);
        this.parallelSetting = hatch_0.makeInParameter(1, (double)this.getParallels(), PARALLEL_SETTING_NAME, PARALLEL_STATUS);
        this.overdriveSetting = hatch_1.makeInParameter(0, 1.0, OVERDRIVE_SETTING_NAME, OVERDRIVE_STATUS);
        this.modeSetting = hatch_2.makeInParameter(0, 0.0, MODE_SETTING_NAME, MODE_STATUS);
        this.rangeSetting = hatch_2.makeInParameter(1, 0.0, RANGE_SETTING_NAME, RANGE_STATUS);
        this.stepSetting = hatch_3.makeInParameter(0, 0.0, STEP_SETTING_NAME, STEP_STATUS);
        this.distanceDisplay = hatch_0.makeOutParameter(1, 1.0, DISTANCE_SETTING_NAME, DISTANCE_STATUS);
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)screenElements.widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.project.gs.miner.cfgi.4") + ": " + ((int)this.modeSetting.get() == 0 ? StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.project.gs.miner.cfgi.4.1") : StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.project.gs.miner.cfgi.4.2"))).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> (int)this.modeSetting.get(), val -> this.parametrization.trySetParameters(this.modeSetting.id % 10, this.modeSetting.id / 10, this.modeSetting.get())));
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        ISpaceProject proj;
        if (!super.checkMachine_EM(aBaseMetaTileEntity, aStack)) {
            return false;
        }
        if (SpaceProjectManager.teamHasProject((UUID)this.getBaseMetaTileEntity().getOwnerUuid(), (ISpaceProject)ASTEROID_OUTPOST) && (proj = SpaceProjectManager.getTeamProject((UUID)this.getBaseMetaTileEntity().getOwnerUuid(), (ISpaceBody)SolarSystem.KuiperBelt, (String)"AsteroidOutpost")).isFinished()) {
            this.asteroidOutpost = (AsteroidOutpost)proj;
        }
        return true;
    }

    private static class MinerPower
    extends BasicMachineEUPower {
        public MinerPower(byte tier, int moduleTier) {
            super(tier, 1, moduleTier);
        }

        public void computePowerUsageAndDuration(int euPerTick, int duration) {
            this.originalVoltage = this.computeVoltageForEuRate(euPerTick);
            this.recipeEuPerTick = euPerTick;
            this.recipeDuration = duration;
        }

        public String getTierString() {
            return GT_Values.TIER_COLORS[this.tier] + "MK " + this.specialValue + EnumChatFormatting.RESET;
        }
    }
}

