/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.tile.machine.multi.elevator.projects.assembler;

import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.INameFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.LedStatus;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.Parameters;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import galaxyspace.core.recipe.GS_Recipe;
import galaxyspace.core.recipe.GS_RecipeAdder;
import galaxyspace.core.tile.machine.multi.elevator.ElevatorUtil;
import galaxyspace.core.tile.machine.multi.elevator.projects.TileEntity_ProjectBase;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import gregtech.common.power.BasicMachineEUPower;
import gregtech.common.power.Power;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;

public abstract class TileEntity_ProjectAssembler
extends TileEntity_ProjectBase {
    private static final INameFunction<TileEntity_ProjectAssembler> PARALLEL_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.gs.assembler.cfgi.0");
    private static final IStatusFunction<TileEntity_ProjectAssembler> PARALLEL_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)1.0, (double)100.0, (double)base.getMaxParallels(), (double[])new double[0]);
    GT_Recipe lastRecipe = null;
    protected final Power power;
    Parameters.Group.ParameterIn parallelSetting;

    public TileEntity_ProjectAssembler(int aID, String aName, String aNameRegional, int tTier, int tModuleTier, int tMinMotorTier, int bufferSizeMultiplier) {
        super(aID, aName, aNameRegional, tTier, tModuleTier, tMinMotorTier, bufferSizeMultiplier);
        this.power = new AssemblerPower((byte)tTier, tModuleTier);
    }

    public TileEntity_ProjectAssembler(String aName, int tTier, int tModuleTier, int tMinMotorTier, int bufferSizeMultiplier) {
        super(aName, tTier, tModuleTier, tMinMotorTier, bufferSizeMultiplier);
        this.power = new AssemblerPower((byte)tTier, tModuleTier);
    }

    protected abstract int getMaxParallels();

    public Power getPower() {
        return this.power;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)155), new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? GT_MetaTileEntity_MultiblockBase_EM.ScreenON : GT_MetaTileEntity_MultiblockBase_EM.ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)155)};
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        FluidStack[] fluids = this.getStoredFluids().toArray(new FluidStack[0]);
        ItemStack[] items = this.getStoredInputs().toArray(new ItemStack[0]);
        GT_Recipe recipe = GS_RecipeAdder.instance.sSpaceAssemblerRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.lastRecipe, false, false, GT_Values.V[this.tTier], fluids, items);
        if (recipe == null) {
            return false;
        }
        if (this.lastRecipe != recipe && recipe instanceof GS_Recipe) {
            GS_Recipe gsRecipe = (GS_Recipe)recipe;
            if (!ElevatorUtil.isProjectAvailable(this.getBaseMetaTileEntity().getOwnerUuid(), gsRecipe.getNeededSpaceProject(), gsRecipe.getNeededSpaceProjectLocation())) {
                return false;
            }
        }
        GT_ParallelHelper helper = new GT_ParallelHelper().setRecipe(recipe).setItemInputs(items).setFluidInputs(fluids).setAvailableEUt(GT_Values.V[this.tTier] * (long)Math.min(this.getMaxParallels(), (int)this.parallelSetting.get())).setMaxParallel(Math.min(this.getMaxParallels(), (int)this.parallelSetting.get())).enableConsumption().enableOutputCalculation();
        if (!this.eSafeVoid) {
            helper.enableVoidProtection((GT_MetaTileEntity_MultiBlockBase)this);
        }
        helper.build();
        if (helper.getCurrentParallel() == 0) {
            return false;
        }
        GT_OverclockCalculator calculator = new GT_OverclockCalculator().setRecipeEUt((long)recipe.mEUt).setEUt(GT_Values.V[this.tTier] * (long)helper.getCurrentParallel()).setDuration(recipe.mDuration).setParallel((int)Math.floor(helper.getCurrentParallel())).calculate();
        this.lEUt = -calculator.getConsumption();
        this.mMaxProgresstime = (int)Math.ceil((float)calculator.getDuration() * helper.getDurationMultiplier());
        this.mEfficiency = 10000;
        this.mEfficiencyIncrease = 10000;
        this.mOutputItems = helper.getItemOutputs();
        return true;
    }

    @Override
    protected void parametersInstantiation_EM() {
        super.parametersInstantiation_EM();
        Parameters.Group hatch_0 = this.parametrization.getGroup(0, false);
        this.parallelSetting = hatch_0.makeInParameter(0, (double)this.getMaxParallels(), PARALLEL_SETTING_NAME, PARALLEL_STATUS);
    }

    private static class AssemblerPower
    extends BasicMachineEUPower {
        public AssemblerPower(byte tier, int moduleTier) {
            super(tier, 1, moduleTier);
        }

        public String getTierString() {
            return GT_Values.TIER_COLORS[this.tier] + "MK " + this.specialValue + EnumChatFormatting.RESET;
        }
    }
}

