/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.tile.machine.multi.elevator;

import com.github.technus.tectech.thing.gui.TecTechUITextures;
import com.github.technus.tectech.thing.metaTileEntity.multi.GT_MetaTileEntity_EM_infuser;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.gui.GS_UITextures;
import galaxyspace.core.register.GSBlocks;
import galaxyspace.core.register.GSItems;
import galaxyspace.core.tile.machine.multi.GT_MetaTileEntity_EnhancedMultiBlockBase_EM;
import galaxyspace.core.tile.machine.multi.TileEntitySpaceElevatorCable;
import galaxyspace.core.tile.machine.multi.elevator.ElevatorUtil;
import galaxyspace.core.tile.machine.multi.elevator.projects.TileEntity_ProjectBase;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_ChunkManager;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_HatchElementBuilder;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import java.util.ArrayList;
import java.util.UUID;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySpaceElevator
extends GT_MetaTileEntity_EnhancedMultiBlockBase_EM
implements ISurvivalConstructable {
    public ArrayList<TileEntity_ProjectBase> mProjectModuleHatches = new ArrayList();
    protected TileEntitySpaceElevatorCable elevatorCable;
    protected int motorTier = 0;
    private static final int MODULES_MOTOR_T1 = 6;
    private static final int MODULES_MOTOR_T2 = 12;
    private static final int MODULES_MOTOR_T3 = 15;
    private static final int MODULES_MOTOR_T4 = 18;
    private boolean isLoadedChunk;
    private static final int MODULE_BASE_TIER = 7;
    private static final int MODULE_CHARGE_INTERVAL = 20;
    private static final int INTERNAL_BUFFER_MULTIPLIER = 8;
    public static final int CASING_INDEX_BASE = 155;
    public static final int CASING_INDEX_SUPPORT_STRUCTURE = 156;
    public static final int CASING_INDEX_INTERNAL_STRUCTURE = 157;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final String STRUCTURE_PIECE_EXTENDED = "extended";
    private static final int MAX_TELEPORTATION_TIER = 8;
    private static final int CONTRIBUTORS_WINDOW_ID = 10;
    private static final int STRUCTURE_PIECE_MAIN_VERT_OFFSET = 39;
    private static final int STRUCTURE_PIECE_MAIN_HOR_OFFSET = 17;
    private static final int STRUCTURE_PIECE_MAIN_DEPTH_OFFSET = 14;
    private static final int STRUCTURE_PIECE_EXTENDED_VERT_OFFSET = 1;
    private static final int STRUCTURE_PIECE_EXTENDED_HOR_OFFSET = 23;
    private static final int STRUCTURE_PIECE_EXTENDED_DEPTH_OFFSET = 20;
    private static final String LORE_TOOLTIP;
    private static final IStructureDefinition<TileEntitySpaceElevator> STRUCTURE_DEFINITION;

    public TileEntitySpaceElevator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.useLongPower = true;
    }

    protected TileEntitySpaceElevator(String aName) {
        super(aName);
        this.useLongPower = true;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TileEntitySpaceElevator(this.mName);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.motorTier = aNBT.func_74762_e("motorTier");
        super.loadNBTData(aNBT);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("motorTier", this.motorTier);
        super.saveNBTData(aNBT);
    }

    public long maxEUStore() {
        return 8L * super.maxEUStore();
    }

    public int getNumberOfModules() {
        return this.mProjectModuleHatches != null ? this.mProjectModuleHatches.size() : 0;
    }

    public int getChunkX() {
        return this.getBaseMetaTileEntity().getXCoord() >> 4;
    }

    public int getChunkZ() {
        return this.getBaseMetaTileEntity().getZCoord() >> 4;
    }

    @Override
    public IStructureDefinition<? extends GT_MetaTileEntity_MultiblockBase_EM> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public IAlignmentLimits getAlignmentLimits() {
        return IAlignmentLimits.Builder.allowAll().deny(ForgeDirection.DOWN).deny(ForgeDirection.UP).deny(Rotation.UPSIDE_DOWN).deny(Rotation.CLOCKWISE).deny(Rotation.COUNTER_CLOCKWISE).build();
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(STRUCTURE_PIECE_MAIN, 17, 39, 14, stackSize, hintsOnly);
        if (stackSize.field_77994_a >= 3) {
            this.structureBuild_EM(STRUCTURE_PIECE_EXTENDED, 23, 1, 20, stackSize, hintsOnly);
        }
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        int consumedBudget = this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 17, 39, 14, elementBudget, source, actor, false, true);
        if (stackSize.field_77994_a >= 3) {
            consumedBudget += this.survivialBuildPiece(STRUCTURE_PIECE_EXTENDED, stackSize, 23, 1, 20, elementBudget, source, actor, false, true);
        }
        return consumedBudget;
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        boolean isMachineValid = true;
        this.mProjectModuleHatches.clear();
        this.elevatorCable = null;
        this.motorTier = 0;
        if (!this.structureCheck_EM(STRUCTURE_PIECE_MAIN, 17, 39, 14)) {
            if (this.elevatorCable != null) {
                this.elevatorCable.setShouldRender(false);
            }
            return false;
        }
        if (this.motorTier >= 2) {
            this.structureCheck_EM(STRUCTURE_PIECE_EXTENDED, 23, 1, 20);
        }
        switch (this.motorTier) {
            case 0: {
                isMachineValid = false;
            }
            case 1: {
                if (this.mProjectModuleHatches.size() <= 6) break;
                isMachineValid = false;
                break;
            }
            case 2: {
                if (this.mProjectModuleHatches.size() <= 12) break;
                isMachineValid = false;
                break;
            }
            case 3: {
                if (this.mProjectModuleHatches.size() <= 15) break;
                isMachineValid = false;
                break;
            }
            case 4: {
                if (this.mProjectModuleHatches.size() <= 18) break;
                isMachineValid = false;
            }
        }
        this.fixAllIssues();
        if (this.elevatorCable != null) {
            this.elevatorCable.setShouldRender(isMachineValid);
            return isMachineValid;
        }
        return isMachineValid;
    }

    public boolean addProjectModuleToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof TileEntity_ProjectBase) {
            return this.mProjectModuleHatches.add((TileEntity_ProjectBase)aMetaTileEntity);
        }
        return false;
    }

    public boolean addCable(Block block, int aBaseCasingIndex, World world, int x, int y, int z) {
        if (block != GSBlocks.SpaceElevatorCable || world == null) {
            return false;
        }
        if (!world.func_72937_j(x, y + 1, z)) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntitySpaceElevatorCable) {
            this.elevatorCable = (TileEntitySpaceElevatorCable)te;
            return true;
        }
        return false;
    }

    public void setMotorTier(int tier) {
        this.motorTier = tier;
    }

    public int getMotorTier() {
        return this.motorTier;
    }

    public void onRemoval() {
        if (this.elevatorCable != null) {
            this.elevatorCable.setShouldRender(false);
        }
        super.onRemoval();
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            if (aTick == 1L) {
                SpaceProjectManager.checkOrCreateTeam((UUID)aBaseMetaTileEntity.getOwnerUuid());
            }
            if (!aBaseMetaTileEntity.isAllowedToWork()) {
                GT_ChunkManager.releaseTicket((TileEntity)((TileEntity)aBaseMetaTileEntity));
                this.isLoadedChunk = false;
            } else if (!this.isLoadedChunk) {
                GT_ChunkManager.releaseTicket((TileEntity)((TileEntity)aBaseMetaTileEntity));
                int offX = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getFrontFacing()).offsetX;
                int offZ = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getFrontFacing()).offsetZ;
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() + offX + i, this.getChunkZ() + offZ + j));
                    }
                }
                this.isLoadedChunk = true;
            } else if (this.elevatorCable != null && GSConfigCore.isCableRenderingEnabled && this.elevatorCable.getAnimation() == TileEntitySpaceElevatorCable.ClimberAnimation.NO_ANIMATION && aTick % 2000L == 0L) {
                this.elevatorCable.startAnimation(TileEntitySpaceElevatorCable.ClimberAnimation.DELIVER_ANIMATION);
            }
            if (aTick % 20L == 0L) {
                this.fixAllIssues();
                if (this.getBaseMetaTileEntity().isAllowedToWork() && this.mProjectModuleHatches.size() > 0) {
                    long tEnergy = this.getEUVar() / (long)this.mProjectModuleHatches.size() * 20L;
                    for (TileEntity_ProjectBase projectModule : this.mProjectModuleHatches) {
                        long tAvailableEnergy;
                        if (projectModule.getNeededMotorTier() > this.motorTier || (tAvailableEnergy = this.getEUVar()) <= 0L) continue;
                        this.setEUVar(Math.max(0L, tAvailableEnergy - projectModule.increaseStoredEU(Math.min(tEnergy, tAvailableEnergy))));
                    }
                }
            }
            if (this.mEfficiency < 0) {
                this.mEfficiency = 0;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected ResourceLocation getActivitySound() {
        return GT_MetaTileEntity_EM_infuser.activitySound;
    }

    protected void fixAllIssues() {
        this.mWrench = true;
        this.mScrewdriver = true;
        this.mSoftHammer = true;
        this.mHardHammer = true;
        this.mSolderingTool = true;
        this.mCrowbar = true;
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        if (this.getBaseMetaTileEntity().isAllowedToWork()) {
            this.mEfficiencyIncrease = 10000;
            this.mMaxProgresstime = 20;
            return true;
        }
        this.mEfficiencyIncrease = 0;
        this.mMaxProgresstime = 0;
        return false;
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.gs.elevator.name")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.gs.elevator.desc0")).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + LORE_TOOLTIP).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.gs.elevator.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.gs.elevator.desc3")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.gs.elevator.desc4")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.gs.elevator.desc5")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.gs.elevator.desc6")).addInfo(GCCoreUtil.translate((String)"gs.elevator.structure.TooComplex")).addInfo(TileEntitySpaceElevator.buildAddedBy(EnumChatFormatting.LIGHT_PURPLE + "minecraft7771")).addInfo(GCCoreUtil.translate((String)"gs.structure.moreContributors")).addSeparator().beginStructureBlock(35, 43, 35, false).addOtherStructurePart(GCCoreUtil.translate((String)"gs.elevator.structure.ProjectModule"), GCCoreUtil.translate((String)"gs.elevator.structure.AnyBaseCasingWith2Dot"), new int[]{2}).addCasingInfo(GCCoreUtil.translate((String)"tile.DysonSwarmFloor.name"), 800).addCasingInfo(GCCoreUtil.translate((String)"gt.blockcasings.gs.0.name"), 617).addCasingInfo(GCCoreUtil.translate((String)"gt.blockcasings.gs.1.name"), 620).addCasingInfo(GCCoreUtil.translate((String)"gt.blockcasings.gs.2.name"), 360).addCasingInfo(GCCoreUtil.translate((String)"gt.blockcasings.gs.cable.name"), 1).addCasingInfo(GCCoreUtil.translate((String)"gs.elevator.structure.FrameNeutronium"), 56).addInputBus(GCCoreUtil.translate((String)"gs.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputBus(GCCoreUtil.translate((String)"gs.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(GCCoreUtil.translate((String)"gs.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"gs.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addEnergyHatch(GCCoreUtil.translate((String)"gs.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOtherStructurePart(GCCoreUtil.translate((String)"gs.elevator.structure.Parametrizer"), GCCoreUtil.translate((String)"gs.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOtherStructurePart(GCCoreUtil.translate((String)"gs.elevator.structure.OpticalConnector"), GCCoreUtil.translate((String)"gs.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(EnumChatFormatting.DARK_PURPLE + "GalaxySpace");
        return tt;
    }

    public static void initCommon() {
        GSItems.SpaceElevatorController = new TileEntitySpaceElevator(14003, "SpaceElevator", GCCoreUtil.translate((String)"gt.blockmachines.multimachine.gs.elevator.name")).getStackForm(1L);
    }

    public static void initClient() {
        Textures.BlockIcons.setCasingTextureForId((int)155, (ITexture)TextureFactory.of((Block)GSBlocks.SpaceElevatorBlocks, (int)0));
        Textures.BlockIcons.setCasingTextureForId((int)156, (ITexture)TextureFactory.of((Block)GSBlocks.SpaceElevatorBlocks, (int)1));
        Textures.BlockIcons.setCasingTextureForId((int)157, (ITexture)TextureFactory.of((Block)GSBlocks.SpaceElevatorBlocks, (int)2));
        TileEntitySpaceElevator.initCommon();
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)155), new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? GT_MetaTileEntity_MultiblockBase_EM.ScreenON : GT_MetaTileEntity_MultiblockBase_EM.ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)155)};
    }

    public String[] getInfoData() {
        return new String[]{EnumChatFormatting.LIGHT_PURPLE + "Operational Data:" + EnumChatFormatting.RESET, "Maintenance Status: " + (this.getRepairStatus() == this.getIdealStatus() ? EnumChatFormatting.GREEN + "Working perfectly" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "Has problems" + EnumChatFormatting.RESET), "---------------------------------------------"};
    }

    public boolean doesBindPlayerInventory() {
        return false;
    }

    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GS_UITextures.PICTURE_ELEVATOR_LOGO_DARK).setSize(18, 18).setPos(150, 154));
    }

    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        screenElements.setSynced(false).setSpace(0).setPos(10, 7);
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans((String)"138", (String)"Incomplete Structure.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mMachine))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mMachine, val -> {
            this.mMachine = val;
        }));
        screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.gs.elevator.gui.ready")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine));
        screenElements.widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.gs.elevator.gui.numOfModules") + ": " + this.getNumberOfModules()).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0));
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            EntityPlayer player;
            if (!widget.getContext().isClient() && this.getBaseMetaTileEntity().isAllowedToWork() && this.motorTier > 0 && (player = widget.getContext().getPlayer()) instanceof EntityPlayerMP) {
                EntityPlayerMP playerBase = (EntityPlayerMP)player;
                GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)playerBase);
                stats.coordsTeleportedFromX = playerBase.field_70165_t;
                stats.coordsTeleportedFromZ = playerBase.field_70161_v;
                try {
                    WorldUtil.toCelestialSelection((EntityPlayerMP)playerBase, (GCPlayerStats)stats, (int)8, (GuiCelestialSelection.MapMode)GuiCelestialSelection.MapMode.TELEPORTATION);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).setPlayClickSound(false).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(TecTechUITextures.BUTTON_STANDARD_16x16);
            ret.add(GS_UITextures.OVERLAY_BUTTON_PLANET_TELEPORT);
            return ret.toArray(new IDrawable[0]);
        }).setPos(174, this.doesBindPlayerInventory() ? 132 : 156).setSize(16, 16).addTooltip(GCCoreUtil.translate((String)"mui.elevator.button.travel")).setTooltipShowUpDelay(5));
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.getContext().isClient()) {
                widget.getContext().openSyncedWindow(10);
            }
        }).addTooltip(StatCollector.func_74838_a((String)"gs.structure.contributors")).setBackground(new IDrawable[]{ModularUITextures.ICON_INFO}).setPos(151, 136).setSize(16, 16));
        buildContext.addSyncedWindow(10, player -> {
            DynamicPositionedColumn texts = new DynamicPositionedColumn();
            texts.setSynced(false).setSpace(2).setPos(10, 7);
            texts.widget((Widget)new TextWidget(StatCollector.func_74838_a((String)"gs.structure.contributors")).setDefaultColor(Color.PURPLE.normal));
            texts.widget((Widget)new TextWidget(StatCollector.func_74838_a((String)"gs.structure.programming")).setDefaultColor(Color.PINK.normal));
            texts.widget((Widget)new TextWidget("minecraft7771").setDefaultColor(Color.GRAY.bright(1)));
            texts.widget((Widget)new TextWidget("BlueWeabo").setDefaultColor(Color.GRAY.bright(1)));
            texts.widget((Widget)new TextWidget(StatCollector.func_74838_a((String)"gs.structure.design")).setDefaultColor(Color.PINK.normal));
            texts.widget((Widget)new TextWidget("Sampsa").setDefaultColor(Color.GRAY.bright(1)));
            texts.widget((Widget)new TextWidget("Jimbno").setDefaultColor(Color.GRAY.bright(1)));
            texts.widget((Widget)new TextWidget("Adam").setDefaultColor(Color.GRAY.bright(1)));
            texts.widget((Widget)new TextWidget("Baunti").setDefaultColor(Color.GRAY.bright(1)));
            texts.widget((Widget)new TextWidget(StatCollector.func_74838_a((String)"gs.structure.specialThanks")).setDefaultColor(Color.PINK.normal));
            texts.widget((Widget)new TextWidget("glowredman").setDefaultColor(Color.GRAY.bright(1)));
            texts.widget((Widget)new TextWidget("miozune").setDefaultColor(Color.GRAY.bright(1)));
            return ((ModularWindow.Builder)((ModularWindow.Builder)ModularWindow.builder((int)120, (int)130).setBackground(new IDrawable[]{TecTechUITextures.BACKGROUND_SCREEN_BLUE}).widget(ButtonWidget.closeWindowButton((boolean)true).setPos(100, 7))).widget((Widget)texts)).build();
        });
    }

    protected ButtonWidget createSafeVoidButton() {
        return null;
    }

    public boolean willExplodeInRain() {
        return false;
    }

    static {
        STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, (String[][])new String[][]{{"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "               FF FF               ", "               AAAAA               "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "               D   D               ", "            FFFFF FFFFF            ", "            AAAAAAAAAAA            "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "            DDDDE EDDDD            ", "          FFFFFFF FFFFFFF          ", "          AAAAAAAAAAAAAAA          "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "          DD   DE ED   DD          ", "         FFFFFFD   DFFFFFF         ", "        AAAAAAAAAAAAAAAAAAA        "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "               DE ED               ", "               D   D               ", "         FFF           FFF         ", "       AAAAAAAAAAAAAAAAAAAAA       "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "               DE ED               ", "               DE ED               ", "                                   ", "                                   ", "      AAAAAAAAAAAAAAAAAAAAAAA      "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "                                   ", "                                   ", "                                   ", "     AAAAAAAAAAAAAAAAAAAAAAAAA     "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "              HDE EDH              ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "    AAAAAAAAAAAAAAAAAAAAAAAAAAA    "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "            HH DE ED HH            ", "                                   ", "                                   ", "                                   ", "                                   ", "               X X X               ", "               X X X               ", "               X X X               ", "               X X X               ", "   AAAAAAAAAAAAX X XAAAAAAAAAAAA   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "                                   ", "         E               E         ", "         EHH           HHE         ", "         E               E         ", "         E               E         ", "         E               E         ", "         E               E         ", "         E     X X X     E         ", "         E     I I I     E         ", "         E     X X X     E         ", "   FF    E     X X X     E    FF   ", "   AAAAAAAAAAAAX X XAAAAAAAAAAAA   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "          E             E          ", "          E             E          ", "          E             E          ", "          E             E          ", "          E             E          ", "         HE             EH         ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "   D                           D   ", "  FFF          F F F          FFF  ", "  AAAAAAAAAAAAA     AAAAAAAAAAAAA  "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "                                   ", "                                   ", "           E           E           ", "           E           E           ", "           E           E           ", "           E           E           ", "           E           E           ", "                                   ", "                                   ", "         H               H         ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "   D                           D   ", "  FFF          F F F          FFF  ", "  AAAAAAAAAAAAA     AAAAAAAAAAAAA  "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "             HH     HH             ", "            E         E            ", "            E         E            ", "            E         E            ", "            E         E            ", "            E         E            ", "            E         E            ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "        H                 H        ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "  D                             D  ", " FFF          FFFFFFF          FFF ", " AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                FFF                ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "             E       E             ", "             E       E             ", "             E       E             ", "             E       E             ", "             E       E             ", "             E       E             ", "             E       E             ", "            HE       EH            ", "             E       E             ", "             E       E             ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "        H                 H        ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "  D                             D  ", " FFF         FFFFFFFFF         FFF ", " AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA "}, {"                FFF                ", "                 E                 ", "                 E                 ", "                 E                 ", "                 E                 ", "                 E                 ", "               F   F               ", "              E     E              ", "              E     E              ", "              E     E              ", "              E     E              ", "              E     E              ", "              E     E              ", "              E     E              ", "              E     E              ", "              E     E              ", "                                   ", "                                   ", "                FFF                ", "                                   ", "                                   ", "            H         H            ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                FFF                ", "                                   ", "                                   ", "                                   ", "                                   ", "       H                   H       ", "                                   ", "                                   ", "                                   ", "                                   ", "                XXX                ", "                X~X                ", "  D             XXX             D  ", " FFF        FFFFFFFFFFF        FFF ", " AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA "}, {"               F D F               ", "                 D                 ", "                 D                 ", "                 D                 ", "                 D                 ", "                 D                 ", "              F  D  F              ", "                 D                 ", "            D    D    D            ", "            D    D    D            ", "            D    D    D            ", "            D    D    D            ", "            D    D    D            ", "            D    D    D            ", "            D    D    D            ", "           DD    D    DD           ", "           D     D     D           ", "           D     D     D           ", "           D   F D F   D           ", "           D     C     D           ", "           D     C     D           ", "           D     C     D           ", "           D     C     D           ", "          DD     C     DD          ", "          D      C      D          ", "          D      C      D          ", "          D      C      D          ", "         DD      C      DD         ", "         D     FDCDF     D         ", "         D      DCD      D         ", "        DD      DCD      DD        ", "        D       DCD       D        ", "        D       DCD       D        ", "       DD      DDCDD      DD       ", "       D       D C D       D       ", "       D       D C D       D       ", "      DD       D C D       DD      ", "      D        D C D        D      ", "     DD XX     XDCDX     XX DD     ", "    DD  XI     XDCDX     IX  DD    ", " DDDD   XX     XDCDX     XX   DDDD ", "FFFD    XXFFFFFDDDDDFFFFFXX    DFFF", "AAAAAAAAXX  AAAXXXXXAAA  XXAAAAAAAA"}, {"              F     F              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "             F       F             ", "            E         E            ", "            E         E            ", "            E         E            ", "            E         E            ", "            E         E            ", "            E         E            ", "            E         E            ", "           EE         EE           ", "           EE         EE           ", "           E           E           ", "           E           E           ", "           E  F     F  E           ", "           E           E           ", "           E           E           ", "           E           E           ", "          EE           EE          ", "          EE           EE          ", "          E             E          ", "          E             E          ", "         EE             EE         ", "         EE             EE         ", "         E    FD   DF    E         ", "        EE     D   D     EE        ", "        EE     D   D     EE        ", "        E      D   D      E        ", "       EE      D   D      EE       ", "       EE      D   D      EE       ", "       E                   E       ", "      EE                   EE      ", "      EE                   EE      ", "     EE                     EE     ", "    EEE       XD   DX       EEE    ", "   EEE        XD   DX        EEE   ", "  EE          XD   DX          EE  ", "FFF         FFFDDDDDFFF         FFF", "AAAAAAAA    AAAXXXXXAAA    AAAAAAAA"}, {"              FD   DF              ", "              ED   DE              ", "              ED   DE              ", "              ED   DE              ", "              ED   DE              ", "              ED   DE              ", "             F D   D F             ", "               D   D               ", "               D   D               ", "               D   D               ", "               D   D               ", "               D   D               ", "               D   D               ", "               D   D               ", "               D   D               ", "               D   D               ", "               D   D               ", "               D B D               ", "              FD - DF              ", "               C - C               ", "               C - C               ", "               C - C               ", "               C - C               ", "               C - C               ", "               C - C               ", "               C - C               ", "               C - C               ", "               C - C               ", "              FC - CF              ", "               C - C               ", "               C - C               ", "               C - C               ", "               C - C               ", "               C - C               ", "               C - C               ", "               C - C               ", "               C - C               ", "               C - C               ", "        XX    XC - CX    XX        ", "        XI    XC - CX    IX        ", "        XX    XC - CX    XX        ", "        XXFFFFFDDDDDFFFFFXX        ", "AAAAAAAAXX  AAAXXXXXAAA  XXAAAAAAAA"}, {"              F     F              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "             F       F             ", "            E         E            ", "            E         E            ", "            E         E            ", "            E         E            ", "            E         E            ", "            E         E            ", "            E         E            ", "           EE         EE           ", "           EE         EE           ", "           E           E           ", "           E           E           ", "           E  F     F  E           ", "           E           E           ", "           E           E           ", "           E           E           ", "          EE           EE          ", "          EE           EE          ", "          E             E          ", "          E             E          ", "         EE             EE         ", "         EE             EE         ", "         E    FD   DF    E         ", "        EE     D   D     EE        ", "        EE     D   D     EE        ", "        E      D   D      E        ", "       EE      D   D      EE       ", "       EE      D   D      EE       ", "       E                   E       ", "      EE                   EE      ", "      EE                   EE      ", "     EE                     EE     ", "    EEE       XD   DX       EEE    ", "   EEE        XD   DX        EEE   ", "  EE          XD   DX          EE  ", "FFF         FFFDDDDDFFF         FFF", "AAAAAAAA    AAAXXXXXAAA    AAAAAAAA"}, {"               F D F               ", "                 D                 ", "                 D                 ", "                 D                 ", "                 D                 ", "                 D                 ", "              F  D  F              ", "                 D                 ", "            D    D    D            ", "            D    D    D            ", "            D    D    D            ", "            D    D    D            ", "            D    D    D            ", "            D    D    D            ", "            D    D    D            ", "           DD    D    DD           ", "           D     D     D           ", "           D     D     D           ", "           D   F D F   D           ", "           D     C     D           ", "           D     C     D           ", "           D     C     D           ", "           D     C     D           ", "          DD     C     DD          ", "          D      C      D          ", "          D      C      D          ", "          D      C      D          ", "         DD      C      DD         ", "         D     FDCDF     D         ", "         D      DCD      D         ", "        DD      DCD      DD        ", "        D       DCD       D        ", "        D       DCD       D        ", "       DD      DDCDD      DD       ", "       D       D C D       D       ", "       D       D C D       D       ", "      DD       D C D       DD      ", "      D        D C D        D      ", "     DD XX     XDCDX     XX DD     ", "    DD  XI     XDCDX     IX  DD    ", " DDDD   XX     XDCDX     XX   DDDD ", "FFFD    XXFFFFFDDDDDFFFFFXX    DFFF", "AAAAAAAAXX  AAAXXXXXAAA  XXAAAAAAAA"}, {"                FFF                ", "                 E                 ", "                 E                 ", "                 E                 ", "                 E                 ", "                 E                 ", "               F   F               ", "              E     E              ", "              E     E              ", "              E     E              ", "              E     E              ", "              E     E              ", "              E     E              ", "              E     E              ", "              E     E              ", "              E     E              ", "                                   ", "                                   ", "                FFF                ", "                                   ", "                                   ", "            H         H            ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                FFF                ", "                                   ", "                                   ", "                                   ", "                                   ", "       H                   H       ", "                                   ", "                                   ", "                                   ", "                                   ", "                XXX                ", "                XXX                ", "  D             XXX             D  ", " FFF        FFFFFFFFFFF        FFF ", " AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                FFF                ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "             E       E             ", "             E       E             ", "             E       E             ", "             E       E             ", "             E       E             ", "             E       E             ", "             E       E             ", "            HE       EH            ", "             E       E             ", "             E       E             ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "        H                 H        ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "  D                             D  ", " FFF         FFFFFFFFF         FFF ", " AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "             HH     HH             ", "            E         E            ", "            E         E            ", "            E         E            ", "            E         E            ", "            E         E            ", "            E         E            ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "        H                 H        ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "  D                             D  ", " FFF          FFFFFFF          FFF ", " AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "                                   ", "                                   ", "           E           E           ", "           E           E           ", "           E           E           ", "           E           E           ", "           E           E           ", "                                   ", "                                   ", "         H               H         ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "   D                           D   ", "  FFF          F F F          FFF  ", "  AAAAAAAAAAAAA     AAAAAAAAAAAAA  "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "          E             E          ", "          E             E          ", "          E             E          ", "          E             E          ", "          E             E          ", "         HE             EH         ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "   D                           D   ", "  FFF          F F F          FFF  ", "  AAAAAAAAAAAAA     AAAAAAAAAAAAA  "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "                                   ", "         E               E         ", "         EHH           HHE         ", "         E               E         ", "         E               E         ", "         E               E         ", "         E               E         ", "         E     X X X     E         ", "         E     I I I     E         ", "         E     X X X     E         ", "   FF    E     X X X     E    FF   ", "   AAAAAAAAAAAAX X XAAAAAAAAAAAA   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "            HH DE ED HH            ", "                                   ", "                                   ", "                                   ", "                                   ", "               X X X               ", "               X X X               ", "               X X X               ", "               X X X               ", "   AAAAAAAAAAAAX X XAAAAAAAAAAAA   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "              HDE EDH              ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "    AAAAAAAAAAAAAAAAAAAAAAAAAAA    "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "               DE ED               ", "               DE ED               ", "               DE ED               ", "                                   ", "                                   ", "                                   ", "     AAAAAAAAAAAAAAAAAAAAAAAAA     "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "               DE ED               ", "               DE ED               ", "                                   ", "                                   ", "      AAAAAAAAAAAAAAAAAAAAAAA      "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "               DE ED               ", "               D   D               ", "         FFF           FFF         ", "       AAAAAAAAAAAAAAAAAAAAA       "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                E E                ", "          DD   DE ED   DD          ", "         FFFFFFD   DFFFFFF         ", "        AAAAAAAAAAAAAAAAAAA        "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "            DDDDE EDDDD            ", "          FFFFFFF FFFFFFF          ", "          AAAAAAAAAAAAAAA          "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "               D   D               ", "            FFFFF FFFFF            ", "            AAAAAAAAAAA            "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "               FF FF               ", "               AAAAA               "}}).addShape(STRUCTURE_PIECE_EXTENDED, (String[][])new String[][]{{"                                               ", "                                               ", "                                               ", "                    FFFFFFF                    ", "                    AAAAAAA                    "}, {"                     X X X                     ", "                     X X X                     ", "                     X X X                     ", "                   FFX X XFF                   ", "                 AAAAX X XAAAA                 "}, {"                     X X X                     ", "                     I I I                     ", "                     X X X                     ", "                   FFX X XFF                   ", "              AAAAAAAX X XAAAAAAA              "}, {"                                               ", "                                               ", "                                               ", "                   FFF F FFF                   ", "            AAAAAAAAAA   AAAAAAAAAA            "}, {"                                               ", "                                               ", "                                               ", "                  FFFF F FFFF                  ", "          AAAA   AAAAA   AAAAA   AAAA          "}, {"                                               ", "                                               ", "                                               ", "                  FFFF F FFFF                  ", "        AAAA     AAAAA   AAAAA     AAAA        "}, {"                                               ", "                                               ", "                                               ", "                  FFFFFFFFFFF                  ", "       AAA      AAAAAAAAAAAAAAA      AAA       "}, {"                                               ", "                                               ", "                                               ", "                                               ", "      AAA       AA           AA       AAA      "}, {"                                               ", "                                               ", "                                               ", "                                               ", "     AAA                               AAA     "}, {"                                               ", "                                               ", "                                               ", "                                               ", "     AA                                 AA     "}, {"                                               ", "                                               ", "                                               ", "                                               ", "    AA                                   AA    "}, {"                                               ", "                                               ", "                                               ", "                                               ", "    AA                                   AA    "}, {"                                               ", "                                               ", "                                               ", "                                               ", "   AA                                     AA   "}, {"                                               ", "                                               ", "                                               ", "                                               ", "   AA                                     AA   "}, {"                                               ", "                                               ", "                                               ", "                                               ", "  AA                                       AA  "}, {"                                               ", "                                               ", "                                               ", "                                               ", "  AA                                       AA  "}, {"                                               ", "                                               ", "                                               ", "                                               ", "  AA  AA                               AA  AA  "}, {"                                               ", "                                               ", "                                               ", "                                               ", " AAAAAAA                               AAAAAAA "}, {"                                               ", "                                               ", "                                               ", "    FFF                                 FFF    ", " AAAAAA                                 AAAAAA "}, {"                                               ", "                                               ", "                                               ", " FFFFFF                                 FFFFFF ", " AAAAAA                                 AAAAAA "}, {"                                               ", "                                               ", "                                               ", "FFFFFFF                                 FFFFFFF", "AAAAAAA                                 AAAAAAA"}, {" XX                                         XX ", " XI                                         IX ", " XX                                         XX ", "FXXFFFF                                 FFFFXXF", "AXXAAAA                                 AAAAXXA"}, {"                                               ", "                                               ", "                                               ", "F     F                                 F     F", "A     A                                 A     A"}, {" XX                                         XX ", " XI                                         IX ", " XX                                         XX ", "FXXFFFF                                 FFFFXXF", "AXX   A                                 A   XXA"}, {"                                               ", "                                               ", "                                               ", "F     F                                 F     F", "A     A                                 A     A"}, {" XX                                         XX ", " XI                                         IX ", " XX                                         XX ", "FXXFFFF                                 FFFFXXF", "AXXAAAA                                 AAAAXXA"}, {"                                               ", "                                               ", "                                               ", "FFFFFFF                                 FFFFFFF", "AAAAAAA                                 AAAAAAA"}, {"                                               ", "                                               ", "                                               ", " FFFFFF                                 FFFFFF ", " AAAAAA                                 AAAAAA "}, {"                                               ", "                                               ", "                                               ", "    FFF                                 FFF    ", " AAAAAA                                 AAAAAA "}, {"                                               ", "                                               ", "                                               ", "                                               ", " AAAAAAA                               AAAAAAA "}, {"                                               ", "                                               ", "                                               ", "                                               ", "  AA  AA                               AA  AA  "}, {"                                               ", "                                               ", "                                               ", "                                               ", "  AA                                       AA  "}, {"                                               ", "                                               ", "                                               ", "                                               ", "  AA                                       AA  "}, {"                                               ", "                                               ", "                                               ", "                                               ", "   AA                                     AA   "}, {"                                               ", "                                               ", "                                               ", "                                               ", "   AA                                     AA   "}, {"                                               ", "                                               ", "                                               ", "                                               ", "    AA                                   AA    "}, {"                                               ", "                                               ", "                                               ", "                                               ", "    AA                                   AA    "}, {"                                               ", "                                               ", "                                               ", "                                               ", "     AA                                 AA     "}, {"                                               ", "                                               ", "                                               ", "                                               ", "     AAA                               AAA     "}, {"                                               ", "                                               ", "                                               ", "                                               ", "      AAA       AA           AA       AAA      "}, {"                                               ", "                                               ", "                                               ", "                  FFFFFFFFFFF                  ", "       AAA      AAAAAAAAAAAAAAA      AAA       "}, {"                                               ", "                                               ", "                                               ", "                  FFFF F FFFF                  ", "        AAAA     AAAAA   AAAAA     AAAA        "}, {"                                               ", "                                               ", "                                               ", "                  FFFF F FFFF                  ", "          AAAA   AAAAA   AAAAA   AAAA          "}, {"                                               ", "                                               ", "                                               ", "                   FFF F FFF                   ", "            AAAAAAAAAA   AAAAAAAAAA            "}, {"                     X X X                     ", "                     I I I                     ", "                     X X X                     ", "                   FFX X XFF                   ", "              AAAAAAAX X XAAAAAAA              "}, {"                     X X X                     ", "                     X X X                     ", "                     X X X                     ", "                   FFX X XFF                   ", "                 AAAAX X XAAAA                 "}, {"                                               ", "                                               ", "                                               ", "                    FFFFFFF                    ", "                    AAAAAAA                    "}}).addElement('E', StructureUtility.ofBlock((Block)GSBlocks.SpaceElevatorBlocks, (int)1)).addElement('B', ElevatorUtil.ofBlockAdder(TileEntitySpaceElevator::addCable, GSBlocks.SpaceElevatorCable, 0)).addElement('X', TileEntitySpaceElevator.classicHatches((int)155, (int)1, (Block)GSBlocks.SpaceElevatorBlocks, (int)0)).addElement('H', GT_StructureUtility.ofFrame((Materials)Materials.Neutronium)).addElement('F', StructureUtility.ofBlock((Block)GSBlocks.SpaceElevatorBlocks, (int)2)).addElement('C', StructureUtility.ofBlocksTiered(ElevatorUtil.motorTierConverter(), ElevatorUtil.getMotorTiers(), (Object)0, TileEntitySpaceElevator::setMotorTier, TileEntitySpaceElevator::getMotorTier)).addElement('A', StructureUtility.ofBlock((Block)GSBlocks.DysonSwarmBlocks, (int)9)).addElement('D', StructureUtility.ofBlock((Block)GSBlocks.SpaceElevatorBlocks, (int)0)).addElement('I', (IStructureElement)GT_HatchElementBuilder.builder().atLeast(new IHatchElement[]{ElevatorUtil.ProjectModuleElement.ProjectModule}).casingIndex(155).dot(2).buildAndChain(GSBlocks.SpaceElevatorBlocks, 0)).build();
        String[] possibleLore = new String[]{GCCoreUtil.translate((String)"gt.blockmachines.multimachine.gs.elevator.lore1"), GCCoreUtil.translate((String)"gt.blockmachines.multimachine.gs.elevator.lore2"), GCCoreUtil.translate((String)"gt.blockmachines.multimachine.gs.elevator.lore3")};
        LORE_TOOLTIP = possibleLore[XSTR.XSTR_INSTANCE.nextInt(possibleLore.length)];
    }
}

