/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.tile.machine.multi;

import com.github.bartimaeusnek.bartworks.client.textures.PrefixTextureLinker;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGeneratedBlocks_CasingAdvanced_TE;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import galaxyspace.SolarSystem.SolarSystemPlanets;
import galaxyspace.core.register.GSBlocks;
import galaxyspace.core.register.GSItems;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IChunkLoader;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_ChunkManager;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityPlanetaryGasSiphon
extends GT_MetaTileEntity_EnhancedMultiBlockBase<TileEntityPlanetaryGasSiphon>
implements IChunkLoader {
    private static IIconContainer OVERLAY_FRONT_GLOW;
    private static IIconContainer OVERLAY_FRONT_ACTIVE_GLOW;
    private static ITexture OVERLAY_FRONT;
    private static Item miningPipe;
    private static final int CASING_INDEX = 154;
    private static final String LORE_TOOLTIP;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final Map<String, Map<Integer, FluidStack>> RECIPES;
    private static final double LOG4;
    private static final IStructureDefinition<TileEntityPlanetaryGasSiphon> STRUCTURE_DEFINITION;
    private int depth;
    private FluidStack fluid = new FluidStack(FluidRegistry.WATER, 0){

        public String getLocalizedName() {
            return "None";
        }
    };
    private boolean mChunkLoadingEnabled = true;
    private ChunkCoordIntPair mCurrentChunk = null;
    private boolean mWorkChunkNeedsReload = true;

    protected TileEntityPlanetaryGasSiphon(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    protected TileEntityPlanetaryGasSiphon(String aName) {
        super(aName);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 6, 0);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TileEntityPlanetaryGasSiphon(this.mName);
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Pump").addInfo(EnumChatFormatting.ITALIC + LORE_TOOLTIP).addInfo("Build on an Space Station orbiting a Gas Planet").addInfo("Requires a Programmed Circuit set to the depth you want to pump from (1 - 4)").addInfo("Requires 64x depth Mining Pipes").addInfo("EU/t: d*4^(t+2), t is the Space Station's tier and d the depth").addInfo("Can load the chunk it is in (toggle using a Soldering Iron)").addSeparator().beginStructureBlock(3, 7, 3, false).addController("Front bottom").addOtherStructurePart("Advanced Machine Frame", "3x1x3 base (hollow)").addOtherStructurePart("Rebolted Rhodium-Plated Palladium Casing", "1x4x1 pillar in the middle").addOtherStructurePart("Tungstensteel Frame Box", "Each pillar's side and 1x3x1 on top").addEnergyHatch("Any Advanced Machine Frame", new int[]{1}).addMaintenanceHatch("Any Advanced Machine Frame", new int[]{1}).addInputBus("Any Advanced Machine Frame", new int[]{1}).addOutputHatch("Any Advanced Machine Frame", new int[]{1}).toolTipFinisher(EnumChatFormatting.DARK_PURPLE + "GalaxySpace");
        return tt;
    }

    public IStructureDefinition<TileEntityPlanetaryGasSiphon> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public ChunkCoordIntPair getActiveChunk() {
        return this.mCurrentChunk;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)154), TextureFactory.of((ITexture[])new ITexture[]{OVERLAY_FRONT}), TextureFactory.builder().addIcon(new IIconContainer[]{OVERLAY_FRONT_ACTIVE_GLOW}).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)154), TextureFactory.of((ITexture[])new ITexture[]{OVERLAY_FRONT}), TextureFactory.builder().addIcon(new IIconContainer[]{OVERLAY_FRONT_GLOW}).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)154)};
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public boolean checkRecipe(ItemStack aStack) {
        if (this.mInputBusses.isEmpty() || !TileEntityPlanetaryGasSiphon.isValidMetaTileEntity((MetaTileEntity)((MetaTileEntity)this.mInputBusses.get(0))) || !(this.getBaseMetaTileEntity().getWorld().field_73011_w instanceof IOrbitDimension)) {
            this.depth = 0;
            this.mEUt = 0;
            this.mEfficiency = 0;
            return false;
        }
        IOrbitDimension provider = (IOrbitDimension)this.getBaseMetaTileEntity().getWorld().field_73011_w;
        Map<Integer, FluidStack> planetRecipes = RECIPES.get(provider.getPlanetToOrbit());
        if (planetRecipes == null) {
            this.depth = 0;
            this.mEUt = 0;
            this.mEfficiency = 0;
            return false;
        }
        GT_MetaTileEntity_Hatch_InputBus bus = (GT_MetaTileEntity_Hatch_InputBus)this.mInputBusses.get(0);
        int numPipes = 0;
        for (int i = 0; i < bus.getBaseMetaTileEntity().func_70302_i_(); ++i) {
            ItemStack stack = bus.getBaseMetaTileEntity().func_70301_a(i);
            if (stack == null) continue;
            if (stack.func_77973_b() == ItemList.Circuit_Integrated.getItem()) {
                this.depth = stack.func_77960_j();
                continue;
            }
            if (stack.func_77973_b() != miningPipe) continue;
            numPipes += stack.field_77994_a;
        }
        if (this.depth == 0 || numPipes < this.depth * 64) {
            this.mEUt = 0;
            this.mEfficiency = 0;
            return false;
        }
        FluidStack recipeFluid = planetRecipes.get(this.depth);
        if (recipeFluid == null) {
            this.depth = 0;
            this.mEUt = 0;
            this.mEfficiency = 0;
            return false;
        }
        int recipeEUt = this.depth * (4 << 2 * provider.getCelestialBody().getTierRequirement() + 2);
        int ocLevel = MathHelper.func_76128_c((double)(Math.log10((double)this.getMaxInputVoltage() / (double)recipeEUt) / LOG4));
        if (ocLevel < 0) {
            this.mEUt = 0;
            this.mEfficiency = 0;
            return false;
        }
        this.fluid = recipeFluid.copy();
        if (ocLevel == 0) {
            this.mEUt = -recipeEUt;
        } else {
            this.fluid.amount *= 2 << --ocLevel;
            this.mEUt = -recipeEUt * (4 << 2 * ocLevel);
        }
        this.mOutputFluids = new FluidStack[]{this.fluid};
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = 20;
        return true;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 6, 0) && this.mMaintenanceHatches.size() == 1 && this.mInputBusses.size() == 1 && this.mOutputHatches.size() == 1 && this.mEnergyHatches.size() == 1;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("chunkLoadingEnabled", this.mChunkLoadingEnabled);
        aNBT.func_74757_a("isChunkloading", this.mCurrentChunk != null);
        if (this.mCurrentChunk != null) {
            aNBT.func_74768_a("loadedChunkXPos", this.mCurrentChunk.field_77276_a);
            aNBT.func_74768_a("loadedChunkZPos", this.mCurrentChunk.field_77275_b);
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("chunkLoadingEnabled")) {
            this.mChunkLoadingEnabled = aNBT.func_74767_n("chunkLoadingEnabled");
        }
        if (aNBT.func_74767_n("isChunkloading")) {
            this.mCurrentChunk = new ChunkCoordIntPair(aNBT.func_74762_e("loadedChunkXPos"), aNBT.func_74762_e("loadedChunkZPos"));
        }
    }

    public boolean onSolderingToolRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aSide == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.mChunkLoadingEnabled = !this.mChunkLoadingEnabled;
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(this.mChunkLoadingEnabled ? GT_Utility.trans((String)"502", (String)"Mining chunk loading enabled") : GT_Utility.trans((String)"503", (String)"Mining chunk loading disabled")));
            return true;
        }
        return super.onSolderingToolRightClick(aSide, aWrenchingSide, aPlayer, aX, aY, aZ);
    }

    public void onRemoval() {
        if (this.mChunkLoadingEnabled) {
            GT_ChunkManager.releaseTicket((TileEntity)((TileEntity)this.getBaseMetaTileEntity()));
        }
        super.onRemoval();
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && this.mCurrentChunk != null && !this.mWorkChunkNeedsReload && !aBaseMetaTileEntity.isAllowedToWork()) {
            GT_ChunkManager.releaseTicket((TileEntity)((TileEntity)aBaseMetaTileEntity));
            this.mWorkChunkNeedsReload = true;
        }
    }

    public String[] getInfoData() {
        return new String[]{EnumChatFormatting.LIGHT_PURPLE + "Operational Data:" + EnumChatFormatting.RESET, "Depth: " + EnumChatFormatting.YELLOW + this.depth + EnumChatFormatting.RESET, "Fluid: " + EnumChatFormatting.YELLOW + this.fluid.amount + EnumChatFormatting.RESET + "L/s " + EnumChatFormatting.BLUE + this.fluid.getLocalizedName() + EnumChatFormatting.RESET, "EU/t required: " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)(-this.mEUt)) + EnumChatFormatting.RESET + " EU/t", "Maintenance Status: " + (this.getRepairStatus() == this.getIdealStatus() ? EnumChatFormatting.GREEN + "Working perfectly" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "Has problems" + EnumChatFormatting.RESET), "---------------------------------------------"};
    }

    private static <T> IStructureElement<T> ofReboltedCasing(final Werkstoff werkstoff) {
        return new IStructureElement<T>(){
            private IIcon[] icons;

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                if (this.icons == null) {
                    this.icons = new IIcon[6];
                    Arrays.fill(this.icons, ((IIconContainer)((HashMap)PrefixTextureLinker.texMapBlocks.get(WerkstoffLoader.blockCasingAdvanced)).get(werkstoff.getTexSet())).getIcon());
                }
                StructureLibAPI.hintParticleTinted((World)world, (int)x, (int)y, (int)z, (IIcon[])this.icons, (short[])werkstoff.getRGBA());
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                ItemStack stack = werkstoff.get(WerkstoffLoader.blockCasingAdvanced);
                if (stack.func_77973_b() instanceof ItemBlock) {
                    ItemBlock item = (ItemBlock)stack.func_77973_b();
                    return item.placeBlockAt(stack, null, world, x, y, z, 6, 0.0f, 0.0f, 0.0f, (int)werkstoff.getmID());
                }
                return false;
            }

            public boolean check(T t, World world, int x, int y, int z) {
                TileEntity tile = world.func_147438_o(x, y, z);
                if (tile instanceof BW_MetaGeneratedBlocks_CasingAdvanced_TE) {
                    BW_MetaGeneratedBlocks_CasingAdvanced_TE tileCasingAdvanced = (BW_MetaGeneratedBlocks_CasingAdvanced_TE)tile;
                    if (tileCasingAdvanced.func_145837_r()) {
                        return false;
                    }
                    return tileCasingAdvanced.mMetaData == werkstoff.getmID();
                }
                return false;
            }
        };
    }

    public static void initCommon() {
        GSItems.PlanetarySiphonController = new TileEntityPlanetaryGasSiphon(14002, "PlanetaryGasSiphon", "Planetary Gas Siphon").getStackForm(1L);
        miningPipe = GT_ModHandler.getIC2Item((String)"miningPipe", (long)0L).func_77973_b();
        HashMap<Integer, FluidStack> jupiterRecipes = new HashMap<Integer, FluidStack>();
        jupiterRecipes.put(1, Materials.Hydrogen.getGas(15000L));
        jupiterRecipes.put(2, Materials.Helium.getGas(500L));
        jupiterRecipes.put(3, Materials.Nitrogen.getGas(300L));
        jupiterRecipes.put(4, Materials.Oxygen.getGas(200L));
        RECIPES.put(SolarSystemPlanets.planetJupiter.getUnlocalizedName(), jupiterRecipes);
        HashMap<Integer, FluidStack> saturnRecipes = new HashMap<Integer, FluidStack>();
        saturnRecipes.put(1, Materials.Hydrogen.getGas(18000L));
        saturnRecipes.put(2, Materials.Helium.getGas(800L));
        saturnRecipes.put(3, Materials.Oxygen.getGas(500L));
        saturnRecipes.put(4, Materials.LiquidOxygen.getGas(150L));
        RECIPES.put(SolarSystemPlanets.planetSaturn.getUnlocalizedName(), saturnRecipes);
        HashMap<Integer, FluidStack> uranusRecipes = new HashMap<Integer, FluidStack>();
        uranusRecipes.put(1, Materials.Deuterium.getGas(5000L));
        uranusRecipes.put(2, FluidRegistry.getFluidStack((String)"neon", (int)450));
        uranusRecipes.put(3, Materials.Argon.getGas(250L));
        uranusRecipes.put(4, FluidRegistry.getFluidStack((String)"krypton", (int)100));
        RECIPES.put(SolarSystemPlanets.planetUranus.getUnlocalizedName(), uranusRecipes);
        HashMap<Integer, FluidStack> neptuneRecipes = new HashMap<Integer, FluidStack>();
        neptuneRecipes.put(1, Materials.Tritium.getGas(3000L));
        neptuneRecipes.put(2, Materials.Helium_3.getGas(500L));
        neptuneRecipes.put(3, Materials.Ammonia.getGas(400L));
        neptuneRecipes.put(4, FluidRegistry.getFluidStack((String)"xenon", (int)350));
        RECIPES.put(SolarSystemPlanets.planetNeptune.getUnlocalizedName(), neptuneRecipes);
    }

    public static void initClient() {
        TileEntityPlanetaryGasSiphon.initCommon();
        Textures.BlockIcons.setCasingTextureForId((int)154, (ITexture)TextureFactory.of((Block)GSBlocks.MachineFrames));
        OVERLAY_FRONT = TextureFactory.of((IIconContainer)new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_FRONT_PLANETARYSIPHON"));
        OVERLAY_FRONT_GLOW = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_FRONT_PLANETARYSIPHON_GLOW");
        OVERLAY_FRONT_ACTIVE_GLOW = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_FRONT_PLANETARYSIPHON_ACTIVE_GLOW");
    }

    static {
        RECIPES = new HashMap<String, Map<Integer, FluidStack>>();
        LOG4 = Math.log10(4.0);
        STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"   ", " f ", "   "}, {"   ", " f ", "   "}, {"   ", " f ", "   "}, {" f ", "fcf", " f "}, {" f ", "fcf", " f "}, {" f ", "fcf", " f "}, {"b~b", "bcb", "bbb"}})).addElement('f', GT_StructureUtility.ofFrame((Materials)Materials.TungstenSteel)).addElement('c', TileEntityPlanetaryGasSiphon.ofReboltedCasing(WerkstoffLoader.LuVTierMaterial)).addElement('b', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, (int)154, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, (int)154, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, (int)154, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, (int)154, (int)1), StructureUtility.ofBlock((Block)GSBlocks.MachineFrames, (int)0)})).build();
        String[] possibleLore = new String[]{"Taking Space-Mining to another Level!", "It's time to SUCC!", "Trading EU -> Fluids"};
        LORE_TOOLTIP = possibleLore[XSTR.XSTR_INSTANCE.nextInt(possibleLore.length)];
    }
}

