/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.recipe;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import galaxyspace.core.gui.GS_UITextures;
import galaxyspace.core.recipe.GS_Recipe;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_RecipeAdder;
import gregtech.common.gui.modularui.UIHelper;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import gregtech.nei.NEIRecipeInfo;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GS_RecipeAdder
extends GT_RecipeAdder {
    public static GS_RecipeAdder instance = new GS_RecipeAdder();
    public static final ItemStack[] nullItem = new ItemStack[0];
    public static final FluidStack[] nullFluid = new FluidStack[0];
    public GS_Recipe.GT_Recipe_MapGS sSpaceResearchRecipes = (GS_Recipe.GT_Recipe_MapGS)new GS_Recipe.GT_Recipe_MapGS(new HashSet(32), "gt.recipe.spaceResearch", GCCoreUtil.translate((String)"gs.nei.spaceresearch.name"), null, "gregtech:textures/gui/FakeAssemblyline", 7, 1, 1, 0, 1, GCCoreUtil.translate((String)"gs.nei.spacemining.computationPrefix") + " ", 1, " " + GCCoreUtil.translate((String)"gs.nei.spacemining.computationSuffix"), true, true){

        public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
            return Collections.singletonList(new Pos2d(142, 35));
        }

        public List<Pos2d> getItemInputPositions(int itemInputCount) {
            ArrayList<Pos2d> inputPositions = new ArrayList<Pos2d>();
            inputPositions.add(new Pos2d(80, 35));
            inputPositions.add(new Pos2d(62, 8));
            inputPositions.add(new Pos2d(80, 8));
            inputPositions.add(new Pos2d(98, 8));
            inputPositions.add(new Pos2d(62, 60));
            inputPositions.add(new Pos2d(80, 60));
            inputPositions.add(new Pos2d(98, 60));
            return inputPositions;
        }

        public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
            return UIHelper.getGridPositions((int)fluidInputCount, (int)34, (int)17, (int)1);
        }
    }.setUsualFluidInputCount(3).setLogo((IDrawable)GS_UITextures.PICTURE_ELEVATOR_LOGO).setLogoSize(18, 18).setNEITransferRect(new Rectangle(110, 35, 18, 18)).setProgressBarPos(110, 35).setNEISpecialInfoFormatter((recipeInfo, applyPrefixAndSuffix) -> {
        ArrayList<Object> specialInfo = new ArrayList<Object>();
        specialInfo.add(applyPrefixAndSuffix.apply(recipeInfo.recipe.mSpecialValue));
        if (recipeInfo.recipe instanceof GS_Recipe) {
            GS_Recipe recipe = (GS_Recipe)recipeInfo.recipe;
            String neededProject = recipe.getNeededSpaceProject();
            String neededProjectLocation = recipe.getNeededSpaceProjectLocation();
            if (neededProject != null && !neededProject.equals("")) {
                specialInfo.add(String.format(GCCoreUtil.translate((String)"gs.nei.spaceassembler.project"), SpaceProjectManager.getProject((String)neededProject).getLocalizedName()));
                specialInfo.add(String.format(GCCoreUtil.translate((String)"gs.nei.spaceassembler.projectAt"), neededProjectLocation == null || neededProjectLocation.equals("") ? GCCoreUtil.translate((String)"gs.nei.spaceassembler.projectAnyLocation") : GCCoreUtil.translate((String)SpaceProjectManager.getLocation((String)neededProjectLocation).getUnlocalizedName())));
            }
        }
        return specialInfo;
    });
    public GS_Recipe.GT_Recipe_MapGS sSpaceAssemblerRecipes = (GS_Recipe.GT_Recipe_MapGS)new GS_Recipe.GT_Recipe_MapGS(new HashSet(32), "gt.recipe.spaceAssembler", GCCoreUtil.translate((String)"gs.nei.spaceassembler.name"), null, "gregtech:textures/gui/FakeAssemblyline", 16, 1, 1, 0, 1, GCCoreUtil.translate((String)"gs.nei.spacemining.specialValue.0"), 1, GCCoreUtil.translate((String)"gs.nei.spacemining.specialValue.1"), true, true){

        public List<Pos2d> getItemInputPositions(int itemInputCount) {
            return UIHelper.getGridPositions((int)itemInputCount, (int)16, (int)8, (int)4);
        }

        public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
            return Collections.singletonList(new Pos2d(142, 8));
        }

        public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
            return UIHelper.getGridPositions((int)fluidInputCount, (int)106, (int)8, (int)1);
        }

        public void addProgressBarUI(ModularWindow.Builder builder, Supplier<Float> progressSupplier, Pos2d windowOffset) {
            int bar1Width = 17;
            int bar2Width = 18;
            builder.widget(new ProgressBar().setTexture(GT_UITextures.PROGRESSBAR_ASSEMBLY_LINE_1, 17).setDirection(ProgressBar.Direction.RIGHT).setProgress(() -> Float.valueOf(((Float)progressSupplier.get()).floatValue() * ((float)(bar1Width + bar2Width) / (float)bar1Width))).setSynced(false, false).setPos(new Pos2d(88, 8).add(windowOffset)).setSize(bar1Width, 72));
            builder.widget(new ProgressBar().setTexture(GT_UITextures.PROGRESSBAR_ASSEMBLY_LINE_2, 18).setDirection(ProgressBar.Direction.RIGHT).setProgress(() -> Float.valueOf((((Float)progressSupplier.get()).floatValue() - (float)bar1Width / (float)(bar1Width + bar2Width)) * ((float)(bar1Width + bar2Width) / (float)bar2Width))).setSynced(false, false).setPos(new Pos2d(124, 8).add(windowOffset)).setSize(bar2Width, 72));
        }
    }.setUsualFluidInputCount(4).setLogo((IDrawable)GS_UITextures.PICTURE_ELEVATOR_LOGO).setLogoSize(18, 18).setNEITransferRect(new Rectangle(124, 8, 16, 16)).useComparatorForNEI(true).setNEISpecialInfoFormatter((recipeInfo, applyPrefixAndSuffix) -> {
        ArrayList<Object> specialInfo = new ArrayList<Object>();
        specialInfo.add(applyPrefixAndSuffix.apply(recipeInfo.recipe.mSpecialValue));
        if (recipeInfo.recipe instanceof GS_Recipe) {
            GS_Recipe recipe = (GS_Recipe)recipeInfo.recipe;
            String neededProject = recipe.getNeededSpaceProject();
            String neededProjectLocation = recipe.getNeededSpaceProjectLocation();
            if (neededProject != null && !neededProject.equals("")) {
                specialInfo.add(String.format(GCCoreUtil.translate((String)"gs.nei.spaceassembler.project"), SpaceProjectManager.getProject((String)neededProject).getLocalizedName()));
                specialInfo.add(String.format(GCCoreUtil.translate((String)"gs.nei.spaceassembler.projectAt"), neededProjectLocation == null || neededProjectLocation.equals("") ? GCCoreUtil.translate((String)"gs.nei.spaceassembler.projectAnyLocation") : GCCoreUtil.translate((String)SpaceProjectManager.getLocation((String)neededProjectLocation).getUnlocalizedName())));
            }
        }
        return specialInfo;
    });
    public GS_Recipe.GT_Recipe_MapGS sSpaceMiningRecipes = (GS_Recipe.GT_Recipe_MapGS)new GS_Recipe.GT_Recipe_MapGS(new HashSet(32), "gt.recipe.spaceMining", GCCoreUtil.translate((String)"gs.nei.spacemining.name"), null, "gregtech:textures/gui/FakeSpaceMiningModule", 5, 16, 1, 0, 1, GCCoreUtil.translate((String)"gs.nei.spacemining.specialValue.0"), 1, GCCoreUtil.translate((String)"gs.nei.spacemining.specialValue.1"), true, true){

        public List<Pos2d> getItemInputPositions(int itemInputCount) {
            ArrayList<Pos2d> results = new ArrayList<Pos2d>();
            results.add(new Pos2d(143, 15));
            results.addAll(UIHelper.getGridPositions((int)(itemInputCount - 1), (int)10, (int)6, (int)2));
            return results;
        }

        public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
            return UIHelper.getGridPositions((int)itemOutputCount, (int)69, (int)6, (int)4);
        }

        public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
            return UIHelper.getGridPositions((int)fluidInputCount, (int)10, (int)51, (int)fluidInputCount);
        }

        public void addProgressBarUI(ModularWindow.Builder builder, Supplier<Float> progressSupplier, Pos2d windowOffset) {
            builder.widget(new DrawableWidget().setDrawable((IDrawable)GS_UITextures.PROGRESSBAR_SPACE_MINING_MODULE_ARROW).setPos(new Pos2d(46, 6).add(windowOffset)).setSize(23, 63));
        }

        protected void drawNEISpecialInfo(NEIRecipeInfo recipeInfo) {
            --recipeInfo.yPos;
            super.drawNEISpecialInfo(recipeInfo);
        }
    }.setUsualFluidInputCount(2).useComparatorForNEI(true).setLogo((IDrawable)GS_UITextures.PICTURE_ELEVATOR_LOGO).setLogoPos(151, 58).setLogoSize(18, 18).setNEIBackgroundSize(172, 78).setNEITransferRect(new Rectangle(46, 6, 23, 63)).setNEISpecialInfoFormatter((recipeInfo, applyPrefixAndSuffix) -> {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(applyPrefixAndSuffix.apply(recipeInfo.recipe.mSpecialValue));
        if (recipeInfo.recipe instanceof GS_Recipe.GS_SpaceMiningRecipe) {
            GS_Recipe.GS_SpaceMiningRecipe miningRecipe = (GS_Recipe.GS_SpaceMiningRecipe)recipeInfo.recipe;
            result.add(GCCoreUtil.translate((String)"gs.nei.spacemining.distance") + " " + miningRecipe.minDistance + "-" + miningRecipe.maxDistance);
            result.add(GCCoreUtil.translate((String)"gs.nei.spacemining.size") + " " + miningRecipe.minSize + "-" + miningRecipe.maxSize);
            result.add(GCCoreUtil.translate((String)"gs.nei.spacemining.computationPrefix") + " " + GT_Utility.formatNumbers((long)miningRecipe.computation) + " " + GCCoreUtil.translate((String)"gs.nei.spacemining.computationSuffix"));
            result.add(GCCoreUtil.translate((String)"gs.nei.spacemining.weight") + " " + miningRecipe.recipeWeight);
        }
        return result;
    });

    public static void init() {
    }

    public static void postInit() {
    }

    public static boolean addSpaceResearchRecipe(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, ItemStack output, int computationRequiredPerSec, int duration, int EUt, String neededSpaceProject, String neededSpaceProjectLocation) {
        if (aItemInputs == null) {
            aItemInputs = nullItem;
        }
        if (aFluidInputs == null) {
            aFluidInputs = nullFluid;
        }
        return GS_RecipeAdder.instance.sSpaceResearchRecipes.add(new GS_Recipe(false, aItemInputs, new ItemStack[]{output}, null, null, aFluidInputs, null, duration, EUt, computationRequiredPerSec, neededSpaceProject, neededSpaceProjectLocation)) != null;
    }

    public static boolean addSpaceAssemblerRecipe(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, ItemStack output, int requiredModuleTier, int duration, int EUt, String neededSpaceProject, String neededSpaceProjectLocation) {
        if (aItemInputs == null) {
            aItemInputs = nullItem;
        }
        if (aFluidInputs == null) {
            aFluidInputs = nullFluid;
        }
        return GS_RecipeAdder.instance.sSpaceAssemblerRecipes.add(new GS_Recipe(false, aItemInputs, new ItemStack[]{output}, null, null, aFluidInputs, null, duration, EUt, requiredModuleTier, neededSpaceProject, neededSpaceProjectLocation)) != null;
    }

    public static boolean addSpaceMiningRecipe(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int[] aChances, Materials[] ores, OrePrefixes orePrefixes, int minSize, int maxSize, int minDistance, int maxDistance, int computationRequiredPerSec, int minModuleTier, int duration, int EUt, int recipeWeight) {
        if (aItemInputs == null && aFluidInputs == null || ores == null) {
            return false;
        }
        if (minDistance > maxDistance || minSize > maxSize) {
            return false;
        }
        if (recipeWeight <= 0) {
            GT_Log.err.println("Weight of mining recipe for main material " + ores[0].toString() + " is 0");
        }
        if (aChances != null) {
            if (aChances.length < ores.length) {
                return false;
            }
            if (aChances.length > ores.length) {
                GT_Log.err.println("Chances and outputs of mining recipe for main material " + ores[0].toString() + " have different length!");
            }
            if (Arrays.stream(aChances).sum() != 10000) {
                GT_Log.err.println("Sum of chances in mining recipe for main material " + ores[0].toString() + " is not 100%! This will lead to no issue but might be unintentional");
            }
        } else {
            aChances = new int[ores.length];
            Arrays.fill(aChances, 10000);
        }
        if (aItemInputs == null) {
            aItemInputs = nullItem;
        }
        if (aFluidInputs == null) {
            aFluidInputs = nullFluid;
        }
        if (orePrefixes == null) {
            return false;
        }
        ItemStack[] outputs = new ItemStack[ores.length];
        for (int i = 0; i < ores.length; ++i) {
            outputs[i] = GT_OreDictUnificator.get((OrePrefixes)orePrefixes, (Object)ores[i], (long)64L);
        }
        GS_RecipeAdder.instance.sSpaceMiningRecipes.add(new GS_Recipe.GS_SpaceMiningRecipe(false, aItemInputs, outputs, aFluidInputs, aChances, duration, EUt, computationRequiredPerSec, minModuleTier, minDistance, maxDistance, minSize, maxSize, recipeWeight));
        return true;
    }

    public static boolean addSpaceMiningRecipe(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int[] aChances, ItemStack[] aItemOutputs, int minSize, int maxSize, int minDistance, int maxDistance, int computationRequiredPerSec, int minModuleTier, int duration, int EUt, int recipeWeight) {
        if (aItemInputs == null && aFluidInputs == null || aItemOutputs == null) {
            return false;
        }
        if (minDistance > maxDistance || minSize > maxSize) {
            return false;
        }
        if (recipeWeight <= 0) {
            GT_Log.err.println("Weight of mining recipe for main material " + aItemOutputs[0].func_77977_a() + " is 0");
        }
        if (aChances != null) {
            if (aChances.length < aItemOutputs.length) {
                return false;
            }
            if (aChances.length > aItemOutputs.length) {
                GT_Log.err.println("Chances and outputs of mining recipe for main material " + aItemOutputs[0].func_77977_a() + " have different length!");
            }
            if (Arrays.stream(aChances).sum() != 10000) {
                GT_Log.err.println("Sum of chances in mining recipe for main material " + aItemOutputs[0].func_77977_a() + " is not 100%! This will lead to no issue but might be unintentional");
            }
        } else {
            aChances = new int[aItemOutputs.length];
            Arrays.fill(aChances, 10000);
        }
        if (aItemInputs == null) {
            aItemInputs = nullItem;
        }
        if (aFluidInputs == null) {
            aFluidInputs = nullFluid;
        }
        GS_RecipeAdder.instance.sSpaceMiningRecipes.add(new GS_Recipe.GS_SpaceMiningRecipe(false, aItemInputs, aItemOutputs, aFluidInputs, aChances, duration, EUt, computationRequiredPerSec, minModuleTier, minDistance, maxDistance, minSize, maxSize, recipeWeight));
        return true;
    }
}

