/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.recipe;

import gregtech.api.GregTech_API;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GS_Recipe
extends GT_Recipe {
    protected final String neededSpaceProject;
    protected final String neededSpaceProjectLocation;

    public GS_Recipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
        this(aOptimize, aInputs, aOutputs, aSpecialItems, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue, null, null);
    }

    public GS_Recipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue, String neededSpaceProject, String neededSpaceProjectLocation) {
        super(aOptimize, aInputs, aOutputs, aSpecialItems, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue);
        this.neededSpaceProject = neededSpaceProject;
        this.neededSpaceProjectLocation = neededSpaceProjectLocation;
    }

    public String getNeededSpaceProject() {
        return this.neededSpaceProject;
    }

    public String getNeededSpaceProjectLocation() {
        return this.neededSpaceProjectLocation;
    }

    public static class GS_SpaceMiningRecipe
    extends GS_Recipe {
        public int minDistance;
        public int maxDistance;
        public int minSize;
        public int maxSize;
        public int computation;
        public int recipeWeight;

        public GS_SpaceMiningRecipe(boolean aOptimize, ItemStack[] aItemInputs, ItemStack[] aItemOutputs, FluidStack[] aFluidInputs, int[] aChances, int aDuration, int aEUt, int computation, int minModuleTier, int minDistance, int maxDistance, int minSize, int maxSize, int recipeWeight) {
            super(aOptimize, aItemInputs, aItemOutputs, null, aChances, aFluidInputs, null, aDuration, aEUt, minModuleTier);
            this.minDistance = minDistance;
            this.maxDistance = maxDistance;
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.computation = computation;
            this.recipeWeight = recipeWeight;
        }

        public int getRecipeWeight() {
            return this.recipeWeight;
        }
    }

    public static class GT_Recipe_MapGS
    extends GT_Recipe.GT_Recipe_Map {
        public GT_Recipe_MapGS(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        public List<GS_SpaceMiningRecipe> findRecipes(IHasWorldObjectAndCoords aTileEntity, GS_SpaceMiningRecipe aRecipe, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, int distance, int moduleTier, ItemStack ... aInputs) {
            int var12;
            if (this.mRecipeList.isEmpty()) {
                return null;
            }
            if (GregTech_API.sPostloadFinished) {
                int var13;
                int tAmount;
                if (this.mMinimalInputFluids > 0) {
                    if (aFluids == null) {
                        return null;
                    }
                    tAmount = 0;
                    FluidStack[] var11 = aFluids;
                    var12 = aFluids.length;
                    for (var13 = 0; var13 < var12; ++var13) {
                        FluidStack aFluid = var11[var13];
                        if (aFluid == null) continue;
                        ++tAmount;
                    }
                    if (tAmount < this.mMinimalInputFluids) {
                        return null;
                    }
                }
                if (this.mMinimalInputItems > 0) {
                    if (aInputs == null) {
                        return null;
                    }
                    tAmount = 0;
                    ItemStack[] var17 = aInputs;
                    var12 = aInputs.length;
                    for (var13 = 0; var13 < var12; ++var13) {
                        ItemStack aInput = var17[var13];
                        if (aInput == null) continue;
                        ++tAmount;
                    }
                    if (tAmount < this.mMinimalInputItems) {
                        return null;
                    }
                }
            }
            ArrayList<GS_SpaceMiningRecipe> recipes = new ArrayList<GS_SpaceMiningRecipe>();
            if (aNotUnificated) {
                aInputs = GT_OreDictUnificator.getStackArray((boolean)true, (Object[])aInputs);
            }
            if (aRecipe != null && !aRecipe.mFakeRecipe && aRecipe.mCanBeBuffered && aRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs)) {
                if (aRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)aRecipe.mEUt && aRecipe.minDistance <= distance && aRecipe.maxDistance >= distance && aRecipe.mSpecialValue <= moduleTier) {
                    recipes.add(aRecipe);
                }
            } else {
                Collection tRecipes;
                if (this.mUsualInputCount > 0 && aInputs != null) {
                    ItemStack[] var18 = aInputs;
                    int var19 = aInputs.length;
                    for (var12 = 0; var12 < var19; ++var12) {
                        ItemStack tStack = var18[var12];
                        if (tStack == null) continue;
                        tRecipes = (Collection)this.mRecipeItemMap.get(new GT_ItemStack(tStack));
                        if (tRecipes != null) {
                            for (GS_SpaceMiningRecipe tRecipe : tRecipes) {
                                if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs) || !tRecipe.mEnabled || aVoltage * (long)this.mAmperage < (long)tRecipe.mEUt || tRecipe.minDistance > distance || tRecipe.maxDistance < distance || tRecipe.mSpecialValue > moduleTier) continue;
                                recipes.add(tRecipe);
                            }
                        }
                        if ((tRecipes = (Collection)this.mRecipeItemMap.get(new GT_ItemStack(tStack, true))) == null) continue;
                        for (GS_SpaceMiningRecipe tRecipe : tRecipes) {
                            if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs) || !tRecipe.mEnabled || aVoltage * (long)this.mAmperage < (long)tRecipe.mEUt || tRecipe.minDistance > distance || tRecipe.maxDistance < distance || tRecipe.mSpecialValue > moduleTier) continue;
                            recipes.add(tRecipe);
                        }
                    }
                }
                if (this.mMinimalInputItems == 0 && aFluids != null) {
                    FluidStack[] var20 = aFluids;
                    int var19 = aFluids.length;
                    for (var12 = 0; var12 < var19; ++var12) {
                        FluidStack aFluid = var20[var12];
                        if (aFluid == null || (tRecipes = (Collection)this.mRecipeFluidMap.get(aFluid.getFluid())) == null) continue;
                        for (GS_SpaceMiningRecipe tRecipe : tRecipes) {
                            if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs) || !tRecipe.mEnabled || aVoltage * (long)this.mAmperage < (long)tRecipe.mEUt || tRecipe.minDistance > distance || tRecipe.maxDistance < distance || tRecipe.mSpecialValue > moduleTier) continue;
                            recipes.add(tRecipe);
                        }
                    }
                }
            }
            return recipes;
        }
    }
}

