/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.TCetiSystem;

import galaxyspace.SolarSystem.core.configs.GSConfigCore;
import galaxyspace.SolarSystem.core.configs.GSConfigDimensions;
import galaxyspace.TCetiSystem.core.registers.blocks.TCBlocks;
import galaxyspace.TCetiSystem.planets.tcetiE.dimension.WorldProviderTCetiE;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import net.minecraft.util.ResourceLocation;

public class TCetiPlanets {
    public static SolarSystem tcetiSystem;
    public static Star TCetiA;
    public static Planet tcetiB;
    public static Planet tcetiC;
    public static Planet tcetiD;
    public static Planet tcetiE;
    public static Planet tcetiF;
    public static Planet tcetiG;
    public static Planet tcetiH;
    public static Planet tcetiI;
    public static Planet tcetiAsteroids;

    public static void preInit() {
        TCBlocks.initialize();
    }

    public static void init() {
        tcetiSystem = new SolarSystem("TCetiSystem", "milkyWay").setMapPosition(new Vector3(-2.0, 1.0, 0.0));
        TCetiA = (Star)new Star("TCetiA").setParentSolarSystem(tcetiSystem).setTierRequired(-1);
        TCetiA.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/tceti/TCetiA.png"));
        tcetiSystem.setMainStar(TCetiA);
        tcetiB = new Planet("TCetiB").setParentSolarSystem(tcetiSystem);
        tcetiB.setRingColorRGB(0.1f, 0.9f, 0.6f);
        tcetiB.setPhaseShift(0.7853982f);
        tcetiB.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/tceti/TCetiB.png"));
        tcetiB.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f));
        tcetiB.setRelativeOrbitTime(0.3f);
        tcetiC = new Planet("TCetiC").setParentSolarSystem(tcetiSystem);
        tcetiC.setRingColorRGB(0.1f, 0.9f, 0.6f);
        tcetiC.setPhaseShift(1.5707964f);
        tcetiC.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/tceti/TCetiC.png"));
        tcetiC.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.75f, 0.75f));
        tcetiC.setRelativeOrbitTime(0.8f);
        tcetiD = new Planet("TCetiD").setParentSolarSystem(tcetiSystem);
        tcetiD.setRingColorRGB(0.1f, 0.9f, 0.6f);
        tcetiD.setPhaseShift((float)Math.PI * 2);
        tcetiD.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/tceti/TCetiD.png"));
        tcetiD.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.0f, 1.0f));
        tcetiD.setRelativeOrbitTime(1.4f);
        tcetiE = new Planet("TCetiE").setParentSolarSystem(tcetiSystem);
        tcetiE.setRingColorRGB(0.1f, 1.1f, 0.6f);
        tcetiE.setPhaseShift((float)Math.PI);
        tcetiE.setTierRequired(8);
        tcetiE.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/tceti/TCetiE.png"));
        tcetiE.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.25f, 1.25f));
        tcetiE.setRelativeOrbitTime(1.8619934f);
        tcetiE.setDimensionInfo(GSConfigDimensions.dimensionIDTCetiE, WorldProviderTCetiE.class);
        tcetiE.atmosphereComponent(IAtmosphericGas.CO2).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.ARGON).atmosphereComponent(IAtmosphericGas.OXYGEN);
        tcetiF = new Planet("TCetiF").setParentSolarSystem(tcetiSystem);
        tcetiF.setRingColorRGB(0.1f, 0.9f, 0.6f);
        tcetiF.setPhaseShift(1.0471976f);
        tcetiF.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/tceti/TCetiF.png"));
        tcetiF.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.5f, 1.5f));
        tcetiF.setRelativeOrbitTime(2.3f);
        tcetiG = new Planet("TCetiG").setParentSolarSystem(tcetiSystem);
        tcetiG.setRingColorRGB(0.1f, 0.9f, 0.6f);
        tcetiG.setPhaseShift(0.7853982f);
        tcetiG.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/tceti/TCetiG.png"));
        tcetiG.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.75f, 1.75f));
        tcetiG.setRelativeOrbitTime(2.8f);
        tcetiAsteroids = new Planet("TCetiAsteroids").setParentSolarSystem(tcetiSystem);
        tcetiAsteroids.setRingColorRGB(1.1f, 0.1f, 0.1f);
        tcetiAsteroids.setPhaseShift((float)Math.PI);
        tcetiAsteroids.setBodyIcon(new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/tceti/TCetiAsteroids.png"));
        tcetiAsteroids.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.0f, 2.0f));
        tcetiAsteroids.setRelativeOrbitTime(11.861994f);
        TCetiPlanets.registrycelestial();
        TCetiPlanets.registryteleport();
    }

    private static void registrycelestial() {
        if (GSConfigCore.enableTCeti) {
            GalaxyRegistry.registerSolarSystem((SolarSystem)tcetiSystem);
        }
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerPlanet((Planet)tcetiB);
        }
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerPlanet((Planet)tcetiC);
        }
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerPlanet((Planet)tcetiD);
        }
        if (GSConfigDimensions.enableTCetiE) {
            GalaxyRegistry.registerPlanet((Planet)tcetiE);
        }
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerPlanet((Planet)tcetiF);
        }
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerPlanet((Planet)tcetiG);
        }
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerPlanet((Planet)tcetiAsteroids);
        }
    }

    private static void registryteleport() {
        GalacticraftRegistry.registerTeleportType(WorldProviderTCetiE.class, (ITeleportType)new WorldProviderTCetiE());
    }
}

