/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.planets.overworld.tile;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityStorageModule
extends TileBaseUniversalElectricalSource
implements IPacketReceiver,
ISidedInventory,
IConnector {
    private static final float TIER3_CAPACITY = 5000000.0f;
    private static final float TIER4_CAPACITY = 1.0E7f;
    private ItemStack[] containingItems = new ItemStack[2];
    public final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    public int scaledEnergyLevel;
    public int lastScaledEnergyLevel;
    private float lastEnergy = 0.0f;
    private boolean initialised = true;

    public TileEntityStorageModule() {
        this(1);
    }

    public TileEntityStorageModule(int tier) {
        if (tier == 1) {
            this.storage.setCapacity(5000000.0f);
            this.storage.setMaxExtract(2200.0f);
            return;
        }
        this.setTier2();
    }

    private void setTier2() {
        this.storage.setCapacity(1.0E7f);
        this.storage.setMaxExtract(3400.0f);
        this.setTierGC(2);
    }

    public void func_145845_h() {
        if (!this.initialised) {
            int metadata = this.func_145832_p();
            if (metadata >= 8) {
                this.setTier2();
            }
            this.initialised = true;
        }
        float energy = this.storage.getEnergyStoredGC();
        if (this.getTierGC() == 1 && !this.field_145850_b.field_72995_K && this.lastEnergy - energy > this.storage.getMaxExtract() - 1.0f) {
            this.storage.extractEnergyGC(25.0f, false);
        }
        this.lastEnergy = energy;
        super.func_145845_h();
        this.scaledEnergyLevel = (int)Math.floor((this.getEnergyStoredGC() + 49.0f) * 16.0f / this.getMaxEnergyStoredGC());
        if (this.scaledEnergyLevel != this.lastScaledEnergyLevel) {
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.recharge(this.containingItems[0]);
            this.discharge(this.containingItems[1]);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.produce();
        }
        this.lastScaledEnergyLevel = this.scaledEnergyLevel;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        if (this.storage.getEnergyStoredGC() > 5000000.0f) {
            this.setTier2();
            this.initialised = true;
        } else {
            this.initialised = false;
        }
        NBTTagList var2 = par1NBTTagCompound.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        if (this.tierGC == 1 && this.storage.getEnergyStoredGC() > 5000000.0f) {
            this.storage.setEnergyStored(5000000.0f);
        }
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)var2);
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)(this.tierGC == 1 ? "tile.StorageModuleT3_4.name" : "tile.storagemodule_t4.name"));
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
    }

    public int[] func_94128_d(int slotID) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        if (itemstack.func_77973_b() instanceof ItemElectricBase) {
            if (slotID == 0) {
                return ((ItemElectricBase)itemstack.func_77973_b()).getTransfer(itemstack) > 0.0f;
            }
            if (slotID == 1) {
                return ((ItemElectricBase)itemstack.func_77973_b()).getElectricityStored(itemstack) > 0.0f;
            }
        }
        return false;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (itemstack.func_77973_b() instanceof ItemElectricBase) {
            if (slotID == 0) {
                return ((ItemElectricBase)itemstack.func_77973_b()).getTransfer(itemstack) <= 0.0f;
            }
            if (slotID == 1) {
                return ((ItemElectricBase)itemstack.func_77973_b()).getElectricityStored(itemstack) <= 0.0f || this.getEnergyStoredGC() >= this.getMaxEnergyStoredGC();
            }
        }
        return false;
    }

    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        return EnumSet.of(ForgeDirection.getOrientation((int)((this.func_145832_p() & 3) + 2)).getOpposite(), ForgeDirection.UNKNOWN);
    }

    public EnumSet<ForgeDirection> getElectricalOutputDirections() {
        return EnumSet.of(ForgeDirection.getOrientation((int)((this.func_145832_p() & 3) + 2)), ForgeDirection.UNKNOWN);
    }

    public ForgeDirection getElectricalOutputDirectionMain() {
        return ForgeDirection.getOrientation((int)((this.func_145832_p() & 3) + 2));
    }

    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        if (direction == null || direction.equals((Object)ForgeDirection.UNKNOWN) || type != NetworkType.POWER) {
            return false;
        }
        int metadata = this.func_145832_p() & 3;
        return direction == ForgeDirection.getOrientation((int)(metadata + 2)) || direction == ForgeDirection.getOrientation((int)(metadata + 2 ^ 1));
    }
}

