/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.planets.overworld.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.SolarSystem.core.registers.fluids.GSFluids;
import galaxyspace.SolarSystem.planets.overworld.inventory.ContainerFuelGenerator;
import galaxyspace.SolarSystem.planets.overworld.tile.TileEntityFuelGenerator;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiFuelGenerator
extends GuiContainerGC {
    private static final ResourceLocation fuelGeneratorTexture = new ResourceLocation("galaxyspace", "textures/gui/geothermal_generator.png");
    private GuiElementInfoRegion fuelTankRegion;
    private TileEntityFuelGenerator tileEntity;

    public GuiFuelGenerator(InventoryPlayer par1InventoryPlayer, TileEntityFuelGenerator tileEntity) {
        super((Container)new ContainerFuelGenerator(par1InventoryPlayer, tileEntity));
        this.fuelTankRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 7, (this.field_146295_m - this.field_147000_g) / 2 + 28, 16, 38, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
        this.tileEntity = tileEntity;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ArrayList<String> fuelTankDesc = new ArrayList<String>();
        int fuelLevel = this.tileEntity.fuelTank != null && this.tileEntity.fuelTank.getFluid() != null ? this.tileEntity.fuelTank.getFluid().amount : 0;
        int fuelCapacity = this.tileEntity.fuelTank != null ? this.tileEntity.fuelTank.getCapacity() : 0;
        fuelTankDesc.add(EnumColor.YELLOW + GCCoreUtil.translate((String)"gui.message.fuel.name") + ": " + fuelLevel + " / " + fuelCapacity);
        this.fuelTankRegion.tooltipStrings = fuelTankDesc;
        this.fuelTankRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 7;
        this.fuelTankRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 28;
        this.fuelTankRegion.parentWidth = this.field_146294_l;
        this.fuelTankRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.fuelTankRegion);
    }

    protected void func_146979_b(int par1, int par2) {
        int yOffset = -18;
        this.field_146289_q.func_78276_b(EnumColor.WHITE + this.tileEntity.func_145825_b(), 45, 4, 0x404040);
        String displayText = EnumColor.WHITE + GCCoreUtil.translate((String)"gui.status.generating.name");
        this.field_146289_q.func_78276_b(displayText, 122 - this.field_146289_q.func_78256_a(displayText) / 2, 33, 0x404040);
        displayText = this.tileEntity.heatGJperTick <= 0.0f ? EnumColor.WHITE + GCCoreUtil.translate((String)"gui.status.notGenerating.name") : (this.tileEntity.heatGJperTick < 1.0f ? EnumColor.WHITE + GCCoreUtil.translate((String)"gui.status.hullHeat.name") + ": " + (int)(this.tileEntity.heatGJperTick / 1.0f * 100.0f) + "%" : EnergyDisplayHelper.getEnergyDisplayS((float)(this.tileEntity.heatGJperTick - 1.0f)) + "/t");
        if (this.tileEntity.fuelTank.getFluid() == null && this.tileEntity.heatGJperTick <= 0.0f) {
            displayText = EnumColor.RED + GCCoreUtil.translate((String)"gui.status.nofuelgenerator.name");
        }
        this.field_146289_q.func_78276_b(EnumColor.WHITE + GCCoreUtil.translate((String)"gui.message.status.name") + ": " + displayText, 72, 68 + yOffset, 0x404040);
        this.field_146289_q.func_78276_b(EnumColor.WHITE + GCCoreUtil.translate((String)"container.inventory"), 14, this.field_147000_g - 93 + 2, 0x404040);
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        int fuelCapacity;
        this.field_146297_k.field_71446_o.func_110577_a(fuelGeneratorTexture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int containerWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int containerHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(containerWidth, containerHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        FluidStack nuclear = this.tileEntity.fuelTank.getFluid();
        int fuelgraphLevel = this.tileEntity.getScaledFuelLevel(38);
        if (nuclear != null && nuclear.getFluid() == GSFluids.BioFuel) {
            this.func_73729_b((this.field_146294_l - this.field_146999_f) / 2 + 7, (this.field_146295_m - this.field_147000_g) / 2 + 12 + 54 - fuelgraphLevel, 208, 38 - fuelgraphLevel, 16, fuelgraphLevel);
        } else {
            this.func_73729_b((this.field_146294_l - this.field_146999_f) / 2 + 7, (this.field_146295_m - this.field_147000_g) / 2 + 12 + 54 - fuelgraphLevel, 192, 38 - fuelgraphLevel, 16, fuelgraphLevel);
        }
        ArrayList<String> fuelTankDesc = new ArrayList<String>();
        int fuelLevel = this.tileEntity.fuelTank != null && this.tileEntity.fuelTank.getFluid() != null ? this.tileEntity.fuelTank.getFluid().amount : 0;
        int n = fuelCapacity = this.tileEntity.fuelTank != null ? this.tileEntity.fuelTank.getCapacity() : 0;
        if (nuclear != null && nuclear.getFluid() == GSFluids.BioFuel) {
            fuelTankDesc.add(EnumColor.YELLOW + GCCoreUtil.translate((String)"gui.message.biofuel.name") + ": " + fuelLevel + " / " + fuelCapacity);
        } else {
            fuelTankDesc.add(EnumColor.YELLOW + GCCoreUtil.translate((String)"gui.message.fuel.name") + ": " + fuelLevel + " / " + fuelCapacity);
        }
        this.fuelTankRegion.tooltipStrings = fuelTankDesc;
    }
}

