/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.planets.kuiperbelt.dimension;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.SolarSystem.SolarSystemPlanets;
import galaxyspace.SolarSystem.core.world.gen.GSWorldProviderSpace;
import galaxyspace.SolarSystem.planets.kuiperbelt.dimension.ChunkProviderKuiper;
import galaxyspace.SolarSystem.planets.kuiperbelt.dimension.KuiperSaveData;
import galaxyspace.SolarSystem.planets.kuiperbelt.dimension.WorldChunkManagerKuiper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.TreeMap;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityEntryPod;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;

public class WorldProviderKuiper
extends GSWorldProviderSpace
implements ISolarLevel,
ITeleportType {
    private HashSet<AsteroidData> asteroids = new HashSet();
    private boolean dataNotLoaded = true;
    private KuiperSaveData datafile;
    private double solarMultiplier = -1.0;
    public boolean doSpinning = true;
    private int pjumpticks = 0;
    private float angularVelocityRadians = 0.0f;
    private float skyAngularVelocity = (float)((double)(this.angularVelocityRadians * 180.0f) / Math.PI);
    private float angularVelocityTarget = 0.0f;
    private float angularVelocityAccel = 0.0f;
    private double spinCentreX;
    private double spinCentreZ;
    private double pPrevMotionX = 0.0;
    private double pPrevMotionY = 0.0;
    private double pPrevMotionZ = 0.0;
    private boolean pWasOnGround = false;
    private int ssBoundsMaxX;
    private int ssBoundsMinX;
    private int ssBoundsMaxY;
    private int ssBoundsMinY;
    private int ssBoundsMaxZ;
    private int ssBoundsMinZ;

    public CelestialBody getCelestialBody() {
        return SolarSystemPlanets.planetKuiperBelt;
    }

    public Vector3 getFogColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 0L;
    }

    public boolean isDaytime() {
        return true;
    }

    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return ChunkProviderKuiper.class;
    }

    public Class<? extends WorldChunkManager> getWorldChunkManagerClass() {
        return WorldChunkManagerKuiper.class;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    public float func_76563_a(long par1, float par3) {
        return 0.25f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        return 1.0f;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 96;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public boolean func_76569_d() {
        return this.field_76579_a == null ? false : this.field_76579_a.field_72995_K;
    }

    public boolean func_76567_e() {
        if (EventHandlerGC.bedActivated) {
            EventHandlerGC.bedActivated = false;
            return true;
        }
        return false;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        return this.shouldForceRespawn() ? this.field_76574_g : 0;
    }

    public float getGravity() {
        return 0.075f;
    }

    public double getMeteorFrequency() {
        return 10.0;
    }

    public double getFuelUsageMultiplier() {
        return 0.9;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= SolarSystemPlanets.planetKuiperBelt.getTierRequirement();
    }

    public float getFallDamageModifier() {
        return 0.1f;
    }

    public float getSoundVolReductionAmount() {
        return 10.0f;
    }

    public boolean hasBreathableAtmosphere() {
        return false;
    }

    public float getThermalLevelModifier() {
        return -4.0f;
    }

    public void addAsteroid(int x, int y, int z, int size, int core) {
        AsteroidData coords = new AsteroidData(x, y, z, size, core);
        if (!this.asteroids.contains(coords)) {
            if (this.dataNotLoaded) {
                this.loadAsteroidSavedData();
            }
            if (!this.asteroids.contains(coords)) {
                this.addToNBT(this.datafile.datacompound, coords);
                this.asteroids.add(coords);
            }
        }
    }

    public void removeAsteroid(int x, int y, int z) {
        AsteroidData coords = new AsteroidData(x, y, z);
        if (this.asteroids.contains(coords)) {
            this.asteroids.remove(coords);
            if (this.dataNotLoaded) {
                this.loadAsteroidSavedData();
            }
            this.writeToNBT(this.datafile.datacompound);
        }
    }

    private void loadAsteroidSavedData() {
        this.datafile = (KuiperSaveData)this.field_76579_a.func_72943_a(KuiperSaveData.class, "GSKuiperData");
        if (this.datafile == null) {
            this.datafile = new KuiperSaveData("");
            this.field_76579_a.func_72823_a("GSKuiperData", (WorldSavedData)this.datafile);
            this.writeToNBT(this.datafile.datacompound);
        } else {
            this.readFromNBT(this.datafile.datacompound);
        }
        this.dataNotLoaded = false;
    }

    private void readFromNBT(NBTTagCompound nbt) {
        NBTTagList coordList = nbt.func_150295_c("coords", 10);
        if (coordList.func_74745_c() > 0) {
            for (int j = 0; j < coordList.func_74745_c(); ++j) {
                NBTTagCompound tag1 = coordList.func_150305_b(j);
                if (tag1 == null) continue;
                this.asteroids.add(AsteroidData.readFromNBT(tag1));
            }
        }
    }

    private void writeToNBT(NBTTagCompound nbt) {
        NBTTagList coordList = new NBTTagList();
        for (AsteroidData coords : this.asteroids) {
            NBTTagCompound tag = new NBTTagCompound();
            coords.writeToNBT(tag);
            coordList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("coords", (NBTBase)coordList);
        this.datafile.func_76185_a();
    }

    private void addToNBT(NBTTagCompound nbt, AsteroidData coords) {
        NBTTagList coordList = nbt.func_150295_c("coords", 10);
        NBTTagCompound tag = new NBTTagCompound();
        coords.writeToNBT(tag);
        coordList.func_74742_a((NBTBase)tag);
        nbt.func_74782_a("coords", (NBTBase)coordList);
        this.datafile.func_76185_a();
    }

    public BlockVec3 getClosestAsteroidXZ(int x, int y, int z) {
        if (this.dataNotLoaded) {
            this.loadAsteroidSavedData();
        }
        if (this.asteroids.size() == 0) {
            return null;
        }
        BlockVec3 result = null;
        AsteroidData resultRoid = null;
        int lowestDistance = Integer.MAX_VALUE;
        for (AsteroidData test : this.asteroids) {
            int dz;
            int dx;
            int a;
            if ((test.sizeAndLandedFlag & 0x80) > 0 || (a = (dx = x - test.centre.x) * dx + (dz = z - test.centre.z) * dz) >= lowestDistance) continue;
            lowestDistance = a;
            result = test.centre;
            resultRoid = test;
        }
        if (result == null) {
            return null;
        }
        resultRoid.sizeAndLandedFlag |= 0x80;
        this.writeToNBT(this.datafile.datacompound);
        return result.clone();
    }

    public ArrayList<BlockVec3> getClosestAsteroidsXZ(int x, int y, int z, int facing, int count) {
        if (this.dataNotLoaded) {
            this.loadAsteroidSavedData();
        }
        if (this.asteroids.size() == 0) {
            return null;
        }
        TreeMap<Integer, BlockVec3> targets = new TreeMap<Integer, BlockVec3>();
        block12: for (AsteroidData roid : this.asteroids) {
            int dz;
            int dx;
            int a;
            BlockVec3 test = roid.centre;
            switch (facing) {
                case 2: {
                    if (z - 16 >= test.z) break;
                    continue block12;
                }
                case 3: {
                    if (z + 16 <= test.z) break;
                    continue block12;
                }
                case 4: {
                    if (x - 16 >= test.x) break;
                    continue block12;
                }
                case 5: {
                    if (x + 16 <= test.x) break;
                    continue block12;
                }
            }
            if ((a = (dx = x - test.x) * dx + (dz = z - test.z) * dz) >= 262144) continue;
            targets.put(a, test);
        }
        int max = Math.max(count, targets.size());
        if (max <= 0) {
            return null;
        }
        ArrayList<BlockVec3> returnValues = new ArrayList<BlockVec3>();
        int i = 0;
        int offset = 6;
        for (BlockVec3 target : targets.values()) {
            BlockVec3 coords = target.clone();
            GCLog.debug((String)("Found nearby asteroid at " + target.toString()));
            switch (facing) {
                case 2: {
                    coords.z += offset;
                    break;
                }
                case 3: {
                    coords.z -= offset;
                    break;
                }
                case 4: {
                    coords.x += offset;
                    break;
                }
                case 5: {
                    coords.x -= offset;
                }
            }
            returnValues.add(coords);
            if (++i < count) continue;
            break;
        }
        return returnValues;
    }

    public float getWindLevel() {
        return 0.05f;
    }

    public int getActualHeight() {
        return 256;
    }

    public void func_76572_b() {
        super.func_76572_b();
        this.field_76576_e = true;
    }

    public double getSolarEnergyMultiplier() {
        if (this.solarMultiplier < 0.0) {
            double s = this.getSolarSize();
            this.solarMultiplier = s * s * s * ConfigManagerCore.spaceStationEnergyScalar;
        }
        return this.solarMultiplier;
    }

    public boolean useParachute() {
        return false;
    }

    public Vector3 getPlayerSpawnLocation(WorldServer world, EntityPlayerMP player) {
        if (player != null) {
            GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)player);
            int x = MathHelper.func_76128_c((double)stats.coordsTeleportedFromX);
            int z = MathHelper.func_76128_c((double)stats.coordsTeleportedFromZ);
            int attemptCount = 0;
            this.preGenChunks((World)world, x >> 4, z >> 4);
            do {
                BlockVec3 bv3 = null;
                if (world.field_73011_w instanceof WorldProviderKuiper) {
                    bv3 = ((WorldProviderKuiper)world.field_73011_w).getClosestAsteroidXZ(x, 0, z);
                }
                if (bv3 == null) continue;
                if (bv3.distanceSquared(new BlockVec3(x, 128, z)) > 25600) break;
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info((String)("Testing asteroid at x" + bv3.x + " y" + bv3.y + " z" + bv3.z));
                }
                this.loadChunksAround(bv3.x, bv3.z, 2, world.field_73059_b);
                this.loadChunksAround(bv3.x, bv3.z, -3, world.field_73059_b);
                if (this.goodAsteroidEntry((World)world, bv3.x, bv3.y, bv3.z)) {
                    return new Vector3((double)bv3.x, 310.0, (double)bv3.z);
                }
                if (this.goodAsteroidEntry((World)world, bv3.x + 2, bv3.y, bv3.z + 2)) {
                    return new Vector3((double)(bv3.x + 2), 310.0, (double)(bv3.z + 2));
                }
                if (this.goodAsteroidEntry((World)world, bv3.x + 2, bv3.y, bv3.z - 2)) {
                    return new Vector3((double)(bv3.x + 2), 310.0, (double)(bv3.z - 2));
                }
                if (this.goodAsteroidEntry((World)world, bv3.x - 2, bv3.y, bv3.z - 2)) {
                    return new Vector3((double)(bv3.x - 2), 310.0, (double)(bv3.z - 2));
                }
                if (this.goodAsteroidEntry((World)world, bv3.x - 2, bv3.y, bv3.z + 2)) {
                    return new Vector3((double)(bv3.x - 2), 310.0, (double)(bv3.z + 2));
                }
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info((String)("Removing drilled out asteroid at x" + bv3.x + " z" + bv3.z));
                }
                ((WorldProviderKuiper)world.field_73011_w).removeAsteroid(bv3.x, bv3.y, bv3.z);
            } while (++attemptCount < 5);
            FMLLog.info((String)"Failed to find good large asteroid landing spot! Falling back to making a small one.", (Object[])new Object[0]);
            this.makeSmallLandingSpot((World)world, x, z);
            return new Vector3((double)x, 310.0, (double)z);
        }
        FMLLog.severe((String)"Null player when teleporting to Asteroids!", (Object[])new Object[0]);
        return new Vector3(0.0, 310.0, 0.0);
    }

    private boolean goodAsteroidEntry(World world, int x, int yorig, int z) {
        for (int k = 208; k > 48; --k) {
            if (world.func_147437_c(x, k, z) || Math.abs(k - yorig) > 20) continue;
            for (int y = k + 2; y < 256; ++y) {
                if (world.func_147439_a(x, y, z) == AsteroidBlocks.blockBasic) {
                    world.func_147468_f(x, y, z);
                }
                if (world.func_147439_a(x - 1, y, z) == AsteroidBlocks.blockBasic) {
                    world.func_147468_f(x - 1, y, z);
                }
                if (world.func_147439_a(x, y, z - 1) == AsteroidBlocks.blockBasic) {
                    world.func_147468_f(x, y, z - 1);
                }
                if (world.func_147439_a(x - 1, y, z - 1) != AsteroidBlocks.blockBasic) continue;
                world.func_147468_f(x - 1, y, z - 1);
            }
            if (ConfigManagerCore.enableDebug) {
                GCLog.info((String)("Found asteroid at x" + x + " z" + z));
            }
            return true;
        }
        return false;
    }

    private void makeSmallLandingSpot(World world, int x, int z) {
        this.loadChunksAround(x, z, -1, (ChunkProviderServer)world.func_72863_F());
        for (int k = 255; k > 48; --k) {
            if (!world.func_147437_c(x, k, z)) {
                this.makePlatform(world, x, k - 1, z);
                return;
            }
            if (!world.func_147437_c(x - 1, k, z)) {
                this.makePlatform(world, x - 1, k - 1, z);
                return;
            }
            if (!world.func_147437_c(x - 1, k, z - 1)) {
                this.makePlatform(world, x - 1, k - 1, z - 1);
                return;
            }
            if (world.func_147437_c(x, k, z - 1)) continue;
            this.makePlatform(world, x, k - 1, z - 1);
            return;
        }
        this.makePlatform(world, x, 48 + world.field_73012_v.nextInt(128), z);
    }

    private void loadChunksAround(int x, int z, int i, ChunkProviderServer cp) {
        cp.func_73158_c(x >> 4, z >> 4);
        if (x + i >> 4 != x >> 4) {
            cp.func_73158_c(x + i >> 4, z >> 4);
            if (z + i >> 4 != z >> 4) {
                cp.func_73158_c(x >> 4, z + i >> 4);
                cp.func_73158_c(x + i >> 4, z + i >> 4);
            }
        } else if (z + i >> 4 != z >> 4) {
            cp.func_73158_c(x >> 4, z + i >> 4);
        }
    }

    private void makePlatform(World world, int x, int y, int z) {
        int zz;
        int xx;
        for (xx = -3; xx < 3; ++xx) {
            for (zz = -3; zz < 3; ++zz) {
                if (xx == -3 && (zz == -3 || zz == 2) || xx == 2 && (zz == -3 || zz == 2)) continue;
                this.doBlock(world, x + xx, y, z + zz);
            }
        }
        for (xx = -2; xx < 2; ++xx) {
            for (zz = -2; zz < 2; ++zz) {
                this.doBlock(world, x + xx, y - 1, z + zz);
            }
        }
        this.doBlock(world, x - 1, y - 2, z - 1);
        this.doBlock(world, x - 1, y - 2, z);
        this.doBlock(world, x, y - 2, z);
        this.doBlock(world, x, y - 2, z - 1);
    }

    private void doBlock(World world, int x, int y, int z) {
        int meta = (int)(world.field_73012_v.nextFloat() * 1.5f);
        if (world.func_147437_c(x, y, z)) {
            world.func_147465_d(x, y, z, AsteroidBlocks.blockBasic, meta, 2);
        }
    }

    public Vector3 getEntitySpawnLocation(WorldServer world, Entity entity) {
        return new Vector3(entity.field_70165_t, ConfigManagerCore.disableLander ? 250.0 : 900.0, entity.field_70161_v);
    }

    public Vector3 getParaChestSpawnLocation(WorldServer world, EntityPlayerMP player, Random rand) {
        return null;
    }

    private void preGenChunks(World w, int cx, int cz) {
        this.preGenChunk(w, cx, cz);
        for (int r = 1; r < 3; ++r) {
            int xmin = cx - r;
            int xmax = cx + r;
            int zmin = cz - r;
            int zmax = cz + r;
            for (int i = -r; i < r; ++i) {
                this.preGenChunk(w, xmin, cz + i);
                this.preGenChunk(w, xmax, cz - i);
                this.preGenChunk(w, cx - i, zmin);
                this.preGenChunk(w, cx + i, zmax);
            }
        }
    }

    private void preGenChunk(World w, int chunkX, int chunkZ) {
        w.func_72964_e(chunkX, chunkZ);
    }

    public void onSpaceDimensionChanged(World newWorld, EntityPlayerMP player, boolean ridingAutoRocket) {
        if (!ridingAutoRocket && player != null) {
            GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)player);
            if (stats.teleportCooldown <= 0) {
                if (player.field_71075_bZ.field_75100_b) {
                    player.field_71075_bZ.field_75100_b = false;
                }
                if (!newWorld.field_72995_K) {
                    EntityEntryPod entryPod = new EntityEntryPod(player);
                    newWorld.func_72838_d((Entity)entryPod);
                }
                stats.teleportCooldown = 10;
            }
        }
    }

    public void setupAdventureSpawn(EntityPlayerMP player) {
        GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)player);
        SchematicRegistry.unlockNewPage((EntityPlayerMP)player, (ItemStack)new ItemStack(GCItems.schematic, 1, 1));
        SchematicRegistry.unlockNewPage((EntityPlayerMP)player, (ItemStack)new ItemStack(MarsItems.schematic, 1, 0));
        SchematicRegistry.unlockNewPage((EntityPlayerMP)player, (ItemStack)new ItemStack(MarsItems.schematic, 1, 2));
        stats.rocketStacks = new ItemStack[20];
        stats.fuelLevel = 1000;
        int i = 0;
        stats.rocketStacks[i++] = new ItemStack(GCItems.oxMask);
        stats.rocketStacks[i++] = new ItemStack(GCItems.oxygenGear);
        stats.rocketStacks[i++] = new ItemStack(GCItems.oxTankMedium);
        stats.rocketStacks[i++] = new ItemStack(GCItems.oxTankHeavy);
        stats.rocketStacks[i++] = new ItemStack(GCItems.oxTankHeavy);
        stats.rocketStacks[i++] = new ItemStack(AsteroidsItems.canisterLOX);
        stats.rocketStacks[i++] = new ItemStack(AsteroidsItems.canisterLOX);
        stats.rocketStacks[i++] = new ItemStack(AsteroidsItems.canisterLOX);
        stats.rocketStacks[i++] = new ItemStack(AsteroidsItems.basicItem, 32, 7);
        stats.rocketStacks[i++] = new ItemStack(Blocks.field_150410_aZ, 16);
        stats.rocketStacks[i++] = new ItemStack(Blocks.field_150344_f, 32, 2);
        stats.rocketStacks[i++] = new ItemStack(MarsItems.marsItemBasic, 16, 2);
        stats.rocketStacks[i++] = new ItemStack(GCItems.basicItem, 8, 13);
        stats.rocketStacks[i++] = new ItemStack(GCItems.basicItem, 2, 1);
        stats.rocketStacks[i++] = new ItemStack(GCItems.basicItem, 16, 15);
        stats.rocketStacks[i++] = new ItemStack(Items.field_151110_aK, 12);
        stats.rocketStacks[i++] = new ItemStack(Items.field_151063_bx, 2, ((Integer)EntityList.field_75623_d.get(EntityCow.class)).intValue());
        stats.rocketStacks[i++] = new ItemStack((Item)Items.field_151068_bn, 4, 8262);
        stats.rocketStacks[i++] = new ItemStack(MarsBlocks.machine, 1, 4);
        stats.rocketStacks[i++] = new ItemStack(MarsItems.spaceship, 1, IRocketType.EnumRocketType.INVENTORY36.ordinal());
    }

    @Override
    public int AtmosphericPressure() {
        return 0;
    }

    @Override
    public boolean SolarRadiation() {
        return false;
    }

    private static class AsteroidData {
        protected BlockVec3 centre;
        protected int sizeAndLandedFlag = 15;
        protected int coreAndSpawnedFlag = -2;

        public AsteroidData(int x, int y, int z) {
            this.centre = new BlockVec3(x, y, z);
        }

        public AsteroidData(int x, int y, int z, int size, int core) {
            this.centre = new BlockVec3(x, y, z);
            this.sizeAndLandedFlag = size;
            this.coreAndSpawnedFlag = core;
        }

        public AsteroidData(BlockVec3 bv) {
            this.centre = bv;
        }

        public int hashCode() {
            if (this.centre != null) {
                return this.centre.hashCode();
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o instanceof AsteroidData) {
                BlockVec3 vector = ((AsteroidData)o).centre;
                return this.centre.x == vector.x && this.centre.y == vector.y && this.centre.z == vector.z;
            }
            if (o instanceof BlockVec3) {
                BlockVec3 vector = (BlockVec3)o;
                return this.centre.x == vector.x && this.centre.y == vector.y && this.centre.z == vector.z;
            }
            return false;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("x", this.centre.x);
            tag.func_74768_a("y", this.centre.y);
            tag.func_74768_a("z", this.centre.z);
            tag.func_74768_a("coreAndFlag", this.coreAndSpawnedFlag);
            tag.func_74768_a("sizeAndFlag", this.sizeAndLandedFlag);
            return tag;
        }

        public static AsteroidData readFromNBT(NBTTagCompound tag) {
            BlockVec3 tempVector = new BlockVec3();
            tempVector.x = tag.func_74762_e("x");
            tempVector.y = tag.func_74762_e("y");
            tempVector.z = tag.func_74762_e("z");
            AsteroidData roid = new AsteroidData(tempVector);
            if (tag.func_74764_b("coreAndFlag")) {
                roid.coreAndSpawnedFlag = tag.func_74762_e("coreAndFlag");
            }
            if (tag.func_74764_b("sizeAndFlag")) {
                roid.sizeAndLandedFlag = tag.func_74762_e("sizeAndFlag");
            }
            return roid;
        }
    }
}

