/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.planets.ceres.dimension;

import com.google.common.collect.Lists;
import galaxyspace.SolarSystem.core.registers.blocks.GSBlocks;
import galaxyspace.SolarSystem.core.world.gen.ChunkProviderSpaceCraters;
import galaxyspace.SolarSystem.core.world.gen.GSBiomeGenBase;
import galaxyspace.SolarSystem.core.world.gen.dungeon.GSMapGenDungeon;
import galaxyspace.SolarSystem.planets.ceres.world.gen.BiomeDecoratorCeresOre;
import galaxyspace.SolarSystem.planets.ceres.world.gen.MapGenCavesCeres;
import galaxyspace.SolarSystem.planets.ceres.world.gen.dungeon.RoomBossCeres;
import galaxyspace.SolarSystem.planets.ceres.world.gen.dungeon.RoomChestsCeres;
import galaxyspace.SolarSystem.planets.ceres.world.gen.dungeon.RoomEmptyCeres;
import galaxyspace.SolarSystem.planets.ceres.world.gen.dungeon.RoomSpawnerCeres;
import galaxyspace.SolarSystem.planets.ceres.world.gen.dungeon.RoomTreasureCeres;
import galaxyspace.SolarSystem.planets.pluto.entities.EntityEvolvedEnderman;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.util.ForgeDirection;

public class ChunkProviderCeres
extends ChunkProviderSpaceCraters {
    private final GSMapGenDungeon dungeonGenerator = new GSMapGenDungeon(GSBlocks.CeresBlocks, 2, 8, 16, 3, 4);
    private List<MapGenBaseMeta> worldGenerators;
    private BiomeGenBase[] biomesForGeneration;
    private final MapGenCavesCeres caveGenerator;

    @Override
    protected List<MapGenBaseMeta> getWorldGenerators() {
        ArrayList generators = Lists.newArrayList();
        generators.add(this.caveGenerator);
        return generators;
    }

    public ChunkProviderCeres(World par1World, long seed, boolean mapFeaturesEnabled) {
        super(par1World, seed, mapFeaturesEnabled);
        this.dungeonGenerator.otherRooms.add(new RoomEmptyCeres(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerCeres(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerCeres(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerCeres(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerCeres(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerCeres(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerCeres(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerCeres(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerCeres(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomChestsCeres(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomChestsCeres(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.bossRooms.add(new RoomBossCeres(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.treasureRooms.add(new RoomTreasureCeres(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.biomesForGeneration = this.getBiomesForGeneration();
        this.caveGenerator = new MapGenCavesCeres();
    }

    @Override
    protected BiomeDecoratorSpace getBiomeGenerator() {
        return new BiomeDecoratorCeresOre();
    }

    @Override
    protected BiomeGenBase[] getBiomesForGeneration() {
        return new BiomeGenBase[]{GSBiomeGenBase.SpaceGS};
    }

    @Override
    public int getCraterProbability() {
        return 300;
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getCreatures() {
        return new BiomeGenBase.SpawnListEntry[0];
    }

    @Override
    public double getHeightModifier() {
        return 20.0;
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getMonsters() {
        BiomeGenBase.SpawnListEntry skele = new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry creeper = new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry spider = new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry enderman = new BiomeGenBase.SpawnListEntry(EntityEvolvedEnderman.class, 100, 4, 4);
        return new BiomeGenBase.SpawnListEntry[]{skele, creeper, spider, enderman};
    }

    @Override
    public double getMountainHeightModifier() {
        return 0.0;
    }

    @Override
    protected int getSeaLevel() {
        return 80;
    }

    @Override
    public double getSmallFeatureHeightModifier() {
        return 1.0;
    }

    @Override
    public double getValleyHeightModifier() {
        return 0.0;
    }

    @Override
    public void onChunkProvide(int cX, int cZ, Block[] blocks, byte[] metadata) {
        this.dungeonGenerator.generateUsingArrays(this.field_73230_p, this.field_73230_p.func_72905_C(), cX * 16, 30, cZ * 16, cX, cZ, blocks, metadata);
    }

    @Override
    public void onPopulate(IChunkProvider arg0, int arg1, int arg2) {
        this.dungeonGenerator.handleTileEntities(this.field_73220_k);
    }

    @Override
    public boolean func_73149_a(int x, int y) {
        return false;
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getWaterCreatures() {
        return new BiomeGenBase.SpawnListEntry[0];
    }

    @Override
    protected BlockMetaPair getGrassBlock() {
        return new BlockMetaPair((Block)GSBlocks.CeresBlocks, 0);
    }

    @Override
    protected BlockMetaPair getDirtBlock() {
        return new BlockMetaPair((Block)GSBlocks.CeresBlocks, 1);
    }

    @Override
    protected BlockMetaPair getStoneBlock() {
        return new BlockMetaPair((Block)GSBlocks.CeresBlocks, 1);
    }

    @Override
    protected boolean enableBiomeGenBaseBlock() {
        return false;
    }
}

