/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.moons.titan.dimension;

import com.google.common.collect.Lists;
import galaxyspace.SolarSystem.core.registers.blocks.GSBlocks;
import galaxyspace.SolarSystem.core.registers.fluids.GSFluids;
import galaxyspace.SolarSystem.core.world.gen.ChunkProviderSpaceLakes;
import galaxyspace.SolarSystem.moons.titan.world.gen.BiomeDecoratorTitanOre;
import galaxyspace.SolarSystem.moons.titan.world.gen.BiomeGenBaseTitan;
import galaxyspace.SolarSystem.moons.titan.world.gen.MapGenCavesTitan;
import galaxyspace.SolarSystem.planets.pluto.entities.EntityEvolvedEnderman;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class ChunkProviderTitan
extends ChunkProviderSpaceLakes {
    private List<MapGenBaseMeta> worldGenerators;
    private BiomeGenBase[] biomesForGeneration = this.getBiomesForGeneration();
    private final MapGenCavesTitan caveGenerator = new MapGenCavesTitan();

    @Override
    protected List<MapGenBaseMeta> getWorldGenerators() {
        ArrayList generators = Lists.newArrayList();
        generators.add(this.caveGenerator);
        return generators;
    }

    public ChunkProviderTitan(World par1World, long seed, boolean mapFeaturesEnabled) {
        super(par1World, seed, mapFeaturesEnabled);
    }

    @Override
    protected BiomeDecoratorSpace getBiomeGenerator() {
        return new BiomeDecoratorTitanOre();
    }

    @Override
    protected BiomeGenBase[] getBiomesForGeneration() {
        return new BiomeGenBase[]{BiomeGenBaseTitan.Titan};
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getCreatures() {
        return new BiomeGenBase.SpawnListEntry[0];
    }

    @Override
    public double getHeightModifier() {
        return 15.0;
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getMonsters() {
        BiomeGenBase.SpawnListEntry skele = new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry creeper = new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry spider = new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry enderman = new BiomeGenBase.SpawnListEntry(EntityEvolvedEnderman.class, 100, 4, 4);
        return new BiomeGenBase.SpawnListEntry[]{skele, creeper, spider, enderman};
    }

    @Override
    public void onChunkProvider(int cX, int cZ, Block[] blocks, byte[] metadata) {
        Arrays.fill(blocks, Blocks.field_150350_a);
        this.generateTerrain(cX, cZ, blocks, metadata);
        this.biomesForGeneration = this.field_73230_p.func_72959_q().func_76933_b(this.biomesForGeneration, cX * 16, cZ * 16, 16, 16);
        this.func_147422_a(cX, cZ, blocks, metadata, this.biomesForGeneration);
        if (this.worldGenerators == null) {
            this.worldGenerators = this.getWorldGenerators();
        }
        for (MapGenBaseMeta generator : this.worldGenerators) {
            generator.generate((IChunkProvider)this, this.field_73230_p, cX, cZ, blocks, metadata);
        }
    }

    @Override
    public void onPopulate(IChunkProvider arg0, int arg1, int arg2) {
    }

    @Override
    public boolean func_73149_a(int x, int y) {
        return false;
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getWaterCreatures() {
        return new BiomeGenBase.SpawnListEntry[0];
    }

    @Override
    public boolean canGenerateWaterBlock() {
        return true;
    }

    @Override
    protected BlockMetaPair getWaterBlock() {
        return new BlockMetaPair(GSFluids.BlockLiquidMethane, 0);
    }

    @Override
    public int getWaterLevel() {
        return 63;
    }

    @Override
    protected BlockMetaPair getGrassBlock() {
        return new BlockMetaPair(Blocks.field_150357_h, 0);
    }

    @Override
    protected BlockMetaPair getDirtBlock() {
        return new BlockMetaPair(Blocks.field_150357_h, 0);
    }

    @Override
    protected BlockMetaPair getStoneBlock() {
        return new BlockMetaPair((Block)GSBlocks.TitanBlocks, 0);
    }

    @Override
    protected boolean enableBiomeGenBaseBlock() {
        return true;
    }

    @Override
    public boolean canGenerateIceBlock() {
        return true;
    }
}

