/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.moons.io.dimension;

import galaxyspace.SolarSystem.moons.io.world.gen.BiomeGenBaseIo;
import galaxyspace.SolarSystem.moons.io.world.gen.layer.GenLayerIo;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldChunkManagerSpace;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class WorldChunkManagerIo
extends WorldChunkManagerSpace {
    private GenLayer unzoomedBiomes;
    private GenLayer zoomedBiomes;
    private BiomeCache myBiomeCache = new BiomeCache((WorldChunkManager)this);
    private List<BiomeGenBase> myBiomesToSpawnIn = new ArrayList<BiomeGenBase>();

    protected WorldChunkManagerIo() {
        this.myBiomesToSpawnIn.add(BiomeGenBaseIo.Io);
        this.myBiomesToSpawnIn.add(BiomeGenBaseIo.IoAsh);
    }

    public WorldChunkManagerIo(long seed) {
        this();
        GenLayer[] agenlayer = GenLayerIo.makeTheWorld(seed);
        this.unzoomedBiomes = agenlayer[0];
        this.zoomedBiomes = agenlayer[1];
    }

    public WorldChunkManagerIo(World world) {
        this(world.func_72905_C());
    }

    public BiomeGenBase getBiome() {
        return BiomeGenBaseIo.Io;
    }

    public List func_76932_a() {
        return this.myBiomesToSpawnIn;
    }

    public BiomeGenBase func_76935_a(int par1, int par2) {
        BiomeGenBase biome = this.myBiomeCache.func_76837_b(par1, par2);
        if (biome == null) {
            return this.getBiome();
        }
        return biome;
    }

    public float[] func_76936_a(float[] par1, int x, int z, int width, int depth) {
        IntCache.func_76446_a();
        int[] aint = this.zoomedBiomes.func_75904_a(x, z, width, depth);
        if (par1 == null || par1.length < width * depth) {
            par1 = new float[width * depth];
        }
        for (int i1 = 0; i1 < width * depth; ++i1) {
            float f = (float)BiomeGenBase.func_150568_d((int)aint[i1]).func_76744_g() / 65536.0f;
            if (f > 1.0f) {
                f = 1.0f;
            }
            par1[i1] = f;
        }
        return par1;
    }

    public float func_76939_a(float par1, int par2) {
        return par1;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int x, int z, int length, int width) {
        int[] arrayOfInts = this.unzoomedBiomes.func_75904_a(x, z, length, width);
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < length * width) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[length * width];
        }
        for (int i = 0; i < length * width; ++i) {
            par1ArrayOfBiomeGenBase[i] = arrayOfInts[i] >= 0 ? BiomeGenBase.func_150568_d((int)arrayOfInts[i]) : this.getBiome();
        }
        return par1ArrayOfBiomeGenBase;
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        return this.func_76931_a(par1ArrayOfBiomeGenBase, par2, par3, par4, par5, true);
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int x, int y, int width, int length, boolean cacheFlag) {
        int[] ai = this.zoomedBiomes.func_75904_a(x, y, width, length);
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < width * length) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (y & 0xF) == 0) {
            BiomeGenBase[] abiomegenbase = this.myBiomeCache.func_76839_e(x, y);
            System.arraycopy(abiomegenbase, 0, par1ArrayOfBiomeGenBase, 0, width * length);
            return par1ArrayOfBiomeGenBase;
        }
        for (int i = 0; i < width * length; ++i) {
            par1ArrayOfBiomeGenBase[i] = ai[i] >= 0 ? BiomeGenBase.func_150568_d((int)ai[i]) : this.getBiome();
        }
        return par1ArrayOfBiomeGenBase;
    }

    public boolean func_76940_a(int par1, int par2, int par3, List par4List) {
        int i = par1 - par3 >> 2;
        int j = par2 - par3 >> 2;
        int k = par1 + par3 >> 2;
        int l = par2 + par3 >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] ai = this.unzoomedBiomes.func_75904_a(i, j, i1, j1);
        for (int k1 = 0; k1 < i1 * j1; ++k1) {
            BiomeGenBase biomegenbase = BiomeGenBase.func_150568_d((int)ai[k1]);
            if (par4List.contains(biomegenbase)) continue;
            return false;
        }
        return true;
    }

    public ChunkPosition func_150795_a(int par1, int par2, int par3, List par4List, Random par5Random) {
        int i = par1 - par3 >> 2;
        int j = par2 - par3 >> 2;
        int k = par1 + par3 >> 2;
        int l = par2 + par3 >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] ai = this.unzoomedBiomes.func_75904_a(i, j, i1, j1);
        ChunkPosition chunkposition = null;
        int k1 = 0;
        for (int l1 = 0; l1 < ai.length; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            BiomeGenBase biomegenbase = BiomeGenBase.func_150568_d((int)ai[l1]);
            if (!par4List.contains(biomegenbase) || chunkposition != null && par5Random.nextInt(k1 + 1) != 0) continue;
            chunkposition = new ChunkPosition(i2, 0, j2);
            ++k1;
        }
        return chunkposition;
    }

    public void func_76938_b() {
        this.myBiomeCache.func_76838_a();
    }
}

