/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.moons.europa.dimension;

import com.google.common.collect.Lists;
import galaxyspace.SolarSystem.core.registers.blocks.GSBlocks;
import galaxyspace.SolarSystem.core.world.gen.ChunkProviderSpaceCraters;
import galaxyspace.SolarSystem.core.world.gen.GSBiomeGenBase;
import galaxyspace.SolarSystem.moons.europa.entities.EntityEvolvedColdBlaze;
import galaxyspace.SolarSystem.moons.europa.world.gen.BiomeDecoratorEuropaOre;
import galaxyspace.SolarSystem.planets.pluto.entities.EntityEvolvedEnderman;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class ChunkProviderEuropa
extends ChunkProviderSpaceCraters {
    private final NoiseModule noiseGen4;
    private static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Y = 128;
    private static final int CHUNK_SIZE_Z = 16;
    private List<MapGenBaseMeta> worldGenerators;
    private BiomeGenBase[] biomesForGeneration = this.getBiomesForGeneration();

    protected List getWorldGenerators() {
        ArrayList generators = Lists.newArrayList();
        return generators;
    }

    public ChunkProviderEuropa(World par1World, long seed, boolean mapFeaturesEnabled) {
        super(par1World, seed, mapFeaturesEnabled);
        this.noiseGen4 = new Gradient(this.field_73220_k.nextLong(), 1, 0.25f);
    }

    @Override
    protected BiomeDecoratorSpace getBiomeGenerator() {
        return new BiomeDecoratorEuropaOre();
    }

    @Override
    protected BiomeGenBase[] getBiomesForGeneration() {
        return new BiomeGenBase[]{GSBiomeGenBase.SpaceGS};
    }

    @Override
    public int getCraterProbability() {
        return 300;
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getCreatures() {
        return new BiomeGenBase.SpawnListEntry[0];
    }

    @Override
    public double getHeightModifier() {
        return 8.0;
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getMonsters() {
        BiomeGenBase.SpawnListEntry skele = new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry creeper = new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry spider = new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry enderman = new BiomeGenBase.SpawnListEntry(EntityEvolvedEnderman.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry blaze = new BiomeGenBase.SpawnListEntry(EntityEvolvedColdBlaze.class, 100, 4, 4);
        return new BiomeGenBase.SpawnListEntry[]{skele, creeper, spider, enderman, blaze};
    }

    @Override
    public double getMountainHeightModifier() {
        return 30.0;
    }

    @Override
    protected int getSeaLevel() {
        return 70;
    }

    @Override
    public double getSmallFeatureHeightModifier() {
        return 5.0;
    }

    @Override
    public double getValleyHeightModifier() {
        return 0.0;
    }

    @Override
    public void onChunkProvide(int cX, int cZ, Block[] blocks, byte[] metadata) {
        this.generateTerrain(cX, cZ, blocks, metadata);
        this.biomesForGeneration = this.field_73230_p.func_72959_q().func_76933_b(this.biomesForGeneration, cX * 16, cZ * 16, 16, 16);
        this.func_147422_a(cX, cZ, blocks, metadata, this.biomesForGeneration);
    }

    @Override
    public void onPopulate(IChunkProvider arg0, int arg1, int arg2) {
    }

    @Override
    public void func_147422_a(int par1, int par2, Block[] arrayOfIDs, byte[] arrayOfMeta, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        int var5 = 40;
        float var6 = 0.03125f;
        this.noiseGen4.setFrequency(0.0625f);
        for (int var8 = 0; var8 < 16; ++var8) {
            for (int var9 = 0; var9 < 16; ++var9) {
                GSBiomeGenBase biomegenbase = (GSBiomeGenBase)par4ArrayOfBiomeGenBase[var8 + var9 * 16];
                int var12 = (int)((double)this.noiseGen4.getNoise((float)(par1 * 16 + var8), (float)(par2 * 16 + var9)) / 3.0 + 3.0 + this.field_73220_k.nextDouble() * 0.25);
                int var13 = -1;
                Block var14 = this.enableBiomeGenBaseBlock() ? biomegenbase.field_76752_A : this.getGrassBlock().getBlock();
                byte var14m = this.enableBiomeGenBaseBlock() ? biomegenbase.topMeta : this.getGrassBlock().getMetadata();
                Block var15 = this.enableBiomeGenBaseBlock() ? biomegenbase.field_76753_B : this.getDirtBlock().getBlock();
                byte var15m = this.enableBiomeGenBaseBlock() ? biomegenbase.fillerMeta : this.getDirtBlock().getMetadata();
                for (int var16 = 128 - 1; var16 >= 0; --var16) {
                    int index = this.getIndex(var8, var16, var9);
                    if (var16 <= 0 + this.field_73220_k.nextInt(5)) {
                        arrayOfIDs[index] = Blocks.field_150357_h;
                        continue;
                    }
                    if (var16 == 5 || var16 == 6 + this.field_73220_k.nextInt(3)) {
                        arrayOfIDs[index] = Blocks.field_150403_cj;
                        continue;
                    }
                    if (var16 <= this.getSeaLevel() - 6 && var16 >= this.getSeaLevel() - 16 || var16 <= this.getSeaLevel() - 6 && var16 >= this.getSeaLevel() - 16 + this.field_73220_k.nextInt(3)) {
                        arrayOfIDs[index] = GSBlocks.EuropaBlocks;
                        arrayOfMeta[index] = 1;
                        continue;
                    }
                    Block var18 = arrayOfIDs[index];
                    if (Blocks.field_150350_a == var18) {
                        var13 = -1;
                        continue;
                    }
                    if (var18 != this.getStoneBlock().getBlock()) continue;
                    if (var13 == -1) {
                        if (var12 <= 0) {
                            var14 = Blocks.field_150350_a;
                            var14m = 0;
                            if (biomegenbase.stoneBlock != null) {
                                var15 = biomegenbase.stoneBlock;
                                var15m = biomegenbase.stoneMeta;
                            } else {
                                var15 = this.getStoneBlock().getBlock();
                                var15m = this.getStoneBlock().getMetadata();
                            }
                        } else if (var16 >= 56 && var16 <= 41) {
                            if (this.enableBiomeGenBaseBlock()) {
                                var14 = biomegenbase.field_76752_A;
                                var14m = biomegenbase.topMeta;
                                var14 = biomegenbase.field_76753_B;
                                var14m = biomegenbase.fillerMeta;
                            } else {
                                var14 = this.getGrassBlock().getBlock();
                                var14m = this.getGrassBlock().getMetadata();
                                var14 = this.getDirtBlock().getBlock();
                                var14m = this.getDirtBlock().getMetadata();
                            }
                        }
                        var13 = var12;
                        if (var16 >= 39) {
                            arrayOfIDs[index] = var14;
                            arrayOfMeta[index] = var14m;
                            continue;
                        }
                        arrayOfIDs[index] = var15;
                        arrayOfMeta[index] = var15m;
                        continue;
                    }
                    if (var13 <= 0) continue;
                    --var13;
                    arrayOfIDs[index] = var15;
                    arrayOfMeta[index] = var15m;
                }
            }
        }
    }

    private int getIndex(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getWaterCreatures() {
        return new BiomeGenBase.SpawnListEntry[0];
    }

    @Override
    protected BlockMetaPair getGrassBlock() {
        return new BlockMetaPair((Block)GSBlocks.EuropaBlocks, 0);
    }

    @Override
    protected BlockMetaPair getDirtBlock() {
        return new BlockMetaPair((Block)GSBlocks.EuropaBlocks, 1);
    }

    @Override
    protected BlockMetaPair getStoneBlock() {
        return new BlockMetaPair(Blocks.field_150355_j, 0);
    }

    @Override
    protected boolean enableBiomeGenBaseBlock() {
        return false;
    }
}

