/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.core.proxy;

import com.google.common.collect.Maps;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import galaxyspace.BarnardsSystem.planets.barnardaC.entities.EntityCrawler;
import galaxyspace.BarnardsSystem.planets.barnardaC.entities.EntityTentacles;
import galaxyspace.BarnardsSystem.planets.barnardaC.render.entities.RenderCrawler;
import galaxyspace.BarnardsSystem.planets.barnardaC.render.entities.RenderTentacles;
import galaxyspace.BarnardsSystem.planets.barnardaC.tile.TileEntityBlockCrystalB;
import galaxyspace.BarnardsSystem.planets.barnardaC.tile.TileEntityBlockCrystalBTE;
import galaxyspace.BarnardsSystem.planets.barnardaC.tile.TileEntityBlockLamp;
import galaxyspace.BarnardsSystem.planets.barnardaC.tile.TileEntityBlockLampTE;
import galaxyspace.SolarSystem.core.animations.MCACommonLibrary.animation.AnimTickHandler;
import galaxyspace.SolarSystem.core.configs.GSConfigCore;
import galaxyspace.SolarSystem.core.handler.GSClientTickHandler;
import galaxyspace.SolarSystem.core.handler.GSColorRingClient;
import galaxyspace.SolarSystem.core.handler.GSEffectHandler;
import galaxyspace.SolarSystem.core.handler.GSSkyProviderHandler;
import galaxyspace.SolarSystem.core.particles.EntityIceBolt;
import galaxyspace.SolarSystem.core.particles.EntityPlasmaBall;
import galaxyspace.SolarSystem.core.particles.EntityPlasmaLaser;
import galaxyspace.SolarSystem.core.proxy.CommonProxy;
import galaxyspace.SolarSystem.core.registers.blocks.GSBlocks;
import galaxyspace.SolarSystem.core.registers.fluids.FluidTexturesGS;
import galaxyspace.SolarSystem.core.registers.items.GSItems;
import galaxyspace.SolarSystem.core.render.entities.RenderPlasmaBall;
import galaxyspace.SolarSystem.core.render.entities.RenderPlasmaLaser;
import galaxyspace.SolarSystem.core.render.items.ItemRenderBow;
import galaxyspace.SolarSystem.moons.enceladus.entities.EntityCrystalBoss;
import galaxyspace.SolarSystem.moons.enceladus.entities.EntityTier6Rocket;
import galaxyspace.SolarSystem.moons.enceladus.render.blocks.BlockRendererEnceladusTreasureChest;
import galaxyspace.SolarSystem.moons.enceladus.render.entities.RenderCrystalBoss;
import galaxyspace.SolarSystem.moons.enceladus.render.entities.RenderTier6Rocket;
import galaxyspace.SolarSystem.moons.enceladus.render.items.ItemRendererTier6Rocket;
import galaxyspace.SolarSystem.moons.enceladus.render.tile.TileEntityEnceladusTreasureChestRenderer;
import galaxyspace.SolarSystem.moons.enceladus.tile.TileEntityBlockCrystall;
import galaxyspace.SolarSystem.moons.enceladus.tile.TileEntityBlockCrystallTE;
import galaxyspace.SolarSystem.moons.enceladus.tile.TileEntityEnceladusTreasureChest;
import galaxyspace.SolarSystem.moons.europa.entities.EntityEvolvedColdBlaze;
import galaxyspace.SolarSystem.moons.europa.entities.EntityEvolvedGuardian;
import galaxyspace.SolarSystem.moons.europa.models.ModelEvolvedGuardian;
import galaxyspace.SolarSystem.moons.europa.render.entities.RenderEvolvedColdBlaze;
import galaxyspace.SolarSystem.moons.europa.render.entities.RenderEvolvedGuardian;
import galaxyspace.SolarSystem.moons.io.entities.EntityBossGhast;
import galaxyspace.SolarSystem.moons.io.entities.EntityTier5Rocket;
import galaxyspace.SolarSystem.moons.io.render.block.BlockRendererIOTreasureChest;
import galaxyspace.SolarSystem.moons.io.render.entities.RenderBossGhast;
import galaxyspace.SolarSystem.moons.io.render.entities.RenderTier5Rocket;
import galaxyspace.SolarSystem.moons.io.render.items.ItemRendererTier5Rocket;
import galaxyspace.SolarSystem.moons.io.render.tile.TileEntityIOTreasureChestRenderer;
import galaxyspace.SolarSystem.moons.io.tile.TileEntityIOTreasureChest;
import galaxyspace.SolarSystem.moons.proteus.entities.EntityEvolvedBossSlime;
import galaxyspace.SolarSystem.moons.proteus.entities.EntityTier7Rocket;
import galaxyspace.SolarSystem.moons.proteus.render.blocks.BlockRendererProteusTreasureChest;
import galaxyspace.SolarSystem.moons.proteus.render.entities.RenderBossSlime;
import galaxyspace.SolarSystem.moons.proteus.render.entities.RenderTier7Rocket;
import galaxyspace.SolarSystem.moons.proteus.render.items.ItemRendererTier7Rocket;
import galaxyspace.SolarSystem.moons.proteus.render.tile.TileEntityProteusTreasureChestRenderer;
import galaxyspace.SolarSystem.moons.proteus.tile.TileEntityProteusTreasureChest;
import galaxyspace.SolarSystem.planets.ceres.entities.EntityBossBlaze;
import galaxyspace.SolarSystem.planets.ceres.entities.EntityTier4Rocket;
import galaxyspace.SolarSystem.planets.ceres.render.block.BlockRendererCeresTreasureChest;
import galaxyspace.SolarSystem.planets.ceres.render.entities.RenderBossBlaze;
import galaxyspace.SolarSystem.planets.ceres.render.entities.RenderIceBolt;
import galaxyspace.SolarSystem.planets.ceres.render.entities.RenderTier4Rocket;
import galaxyspace.SolarSystem.planets.ceres.render.item.ItemRendererTier4Rocket;
import galaxyspace.SolarSystem.planets.ceres.render.tile.TileEntityCeresTreasureChestRenderer;
import galaxyspace.SolarSystem.planets.ceres.tile.TileEntityCeresTreasureChest;
import galaxyspace.SolarSystem.planets.mercury.entities.EntityEvolvedBlaze;
import galaxyspace.SolarSystem.planets.mercury.render.entities.RenderEvolvedBlaze;
import galaxyspace.SolarSystem.planets.overworld.render.block.FutureLampRender;
import galaxyspace.SolarSystem.planets.overworld.render.item.ItemRendererJetPack;
import galaxyspace.SolarSystem.planets.overworld.render.item.ItemRendererThermalPaddingT2;
import galaxyspace.SolarSystem.planets.overworld.render.tile.TileEntityDuraluminumWireRenderer;
import galaxyspace.SolarSystem.planets.overworld.render.tile.TileEntitySolarPanelRenderer;
import galaxyspace.SolarSystem.planets.overworld.render.tile.TileEntitySolarWindPanelRenderer;
import galaxyspace.SolarSystem.planets.overworld.tile.TileEntityDuraluminumWire;
import galaxyspace.SolarSystem.planets.overworld.tile.TileEntitySolarPanel;
import galaxyspace.SolarSystem.planets.overworld.tile.TileEntitySolarWind;
import galaxyspace.SolarSystem.planets.pluto.entities.EntityEvolvedBossWolf;
import galaxyspace.SolarSystem.planets.pluto.entities.EntityEvolvedEnderman;
import galaxyspace.SolarSystem.planets.pluto.entities.EntityTier8Rocket;
import galaxyspace.SolarSystem.planets.pluto.render.block.BlockRendererPlutoTreasureChest;
import galaxyspace.SolarSystem.planets.pluto.render.entities.RenderEvolvedBossWolf;
import galaxyspace.SolarSystem.planets.pluto.render.entities.RenderEvolvedEnderman;
import galaxyspace.SolarSystem.planets.pluto.render.entities.RenderTier8Rocket;
import galaxyspace.SolarSystem.planets.pluto.render.item.ItemRendererTier8Rocket;
import galaxyspace.SolarSystem.planets.pluto.render.tile.TileEntityPlutoTreasureChestRenderer;
import galaxyspace.SolarSystem.planets.pluto.tile.TileEntityPlutoTreasureChest;
import galaxyspace.SolarSystem.planets.venus.entities.EntityEvolvedFireCreeper;
import galaxyspace.SolarSystem.planets.venus.entities.EntityEvolvedFireSkeleton;
import galaxyspace.SolarSystem.planets.venus.entities.EntityEvolvedFireSpider;
import galaxyspace.SolarSystem.planets.venus.render.entities.RenderEvolvedFireCreeper;
import galaxyspace.SolarSystem.planets.venus.render.entities.RenderEvolvedFireSkeleton;
import galaxyspace.SolarSystem.planets.venus.render.entities.RenderEvolvedFireSpider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.client.render.block.BlockRendererMachine;
import micdoodle8.mods.galacticraft.core.client.render.item.ItemRendererKey;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    public static Map<String, String> GScapeMap = new HashMap<String, String>();
    public static Map<String, ResourceLocation> GScapesMap = Maps.newHashMap();
    public static Minecraft mc = FMLClientHandler.instance().getClient();
    private static int ceresMachineRenderID;
    private static int geothermalGeneratorRenderID;
    private static int fuelGeneratorRenderID;
    private static int solarWindPanelRenderID;
    private static int convertersurfaceRenderID;
    private static int storagemoduleRenderID;
    private static int oxstoragemoduleRenderID;
    private static int solarPanelRenderID;
    public static int futureLampRenderID;
    private static int ceresTreasureChestRenderID;
    private static int ioTreasureChestRenderID;
    private static int enceladusTreasureChestRenderID;
    private static int proteusTreasureChestRenderID;
    private static int plutoTreasureChestRenderID;
    private static int renderIndexJetpackArmor;
    private static int renderIndexLeadArmor;

    @Override
    public void preload() {
        GSSkyProviderHandler sky = new GSSkyProviderHandler();
        this.register_event(sky);
        GSColorRingClient colorring = new GSColorRingClient();
        this.register_event(colorring);
        GSClientTickHandler clienttick = new GSClientTickHandler();
        this.register_event(clienttick);
        renderIndexJetpackArmor = RenderingRegistry.addNewArmourRendererPrefix((String)"Jetpack");
        renderIndexLeadArmor = RenderingRegistry.addNewArmourRendererPrefix((String)"Lead");
        ClientProxy.setupCapes();
        FluidTexturesGS.init();
        AnimTickHandler.init();
    }

    @Override
    public void load() {
        ClientProxy.registerEntityRenderers();
        ClientProxy.registerItemRenderers();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCeresTreasureChest.class, (TileEntitySpecialRenderer)new TileEntityCeresTreasureChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityIOTreasureChest.class, (TileEntitySpecialRenderer)new TileEntityIOTreasureChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEnceladusTreasureChest.class, (TileEntitySpecialRenderer)new TileEntityEnceladusTreasureChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityProteusTreasureChest.class, (TileEntitySpecialRenderer)new TileEntityProteusTreasureChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPlutoTreasureChest.class, (TileEntitySpecialRenderer)new TileEntityPlutoTreasureChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySolarWind.class, (TileEntitySpecialRenderer)new TileEntitySolarWindPanelRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDuraluminumWire.class, (TileEntitySpecialRenderer)new TileEntityDuraluminumWireRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySolarPanel.class, (TileEntitySpecialRenderer)new TileEntitySolarPanelRenderer());
    }

    @Override
    public void postload() {
    }

    @Override
    public void spawnParticle(String particleID, Vector3 position, Vector3 motion, Object[] otherInfo) {
        GSEffectHandler.spawnParticle(particleID, position, motion, otherInfo);
    }

    public static void registerEntityRenderers() {
        ceresMachineRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(ceresMachineRenderID));
        storagemoduleRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(storagemoduleRenderID));
        geothermalGeneratorRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(geothermalGeneratorRenderID));
        fuelGeneratorRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(fuelGeneratorRenderID));
        solarWindPanelRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(solarWindPanelRenderID));
        convertersurfaceRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(convertersurfaceRenderID));
        oxstoragemoduleRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(oxstoragemoduleRenderID));
        solarPanelRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(solarPanelRenderID));
        futureLampRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new FutureLampRender());
        ceresTreasureChestRenderID = RenderingRegistry.getNextAvailableRenderId();
        ioTreasureChestRenderID = RenderingRegistry.getNextAvailableRenderId();
        enceladusTreasureChestRenderID = RenderingRegistry.getNextAvailableRenderId();
        proteusTreasureChestRenderID = RenderingRegistry.getNextAvailableRenderId();
        plutoTreasureChestRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererCeresTreasureChest(ceresTreasureChestRenderID));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererIOTreasureChest(ioTreasureChestRenderID));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererEnceladusTreasureChest(enceladusTreasureChestRenderID));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererProteusTreasureChest(proteusTreasureChestRenderID));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererPlutoTreasureChest(plutoTreasureChestRenderID));
        RenderingRegistry.registerEntityRenderingHandler(EntityBossBlaze.class, (Render)new RenderBossBlaze());
        RenderingRegistry.registerEntityRenderingHandler(EntityBossGhast.class, (Render)new RenderBossGhast());
        RenderingRegistry.registerEntityRenderingHandler(EntityCrystalBoss.class, (Render)new RenderCrystalBoss());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedBossSlime.class, (Render)new RenderBossSlime((ModelBase)new ModelSlime(16), (ModelBase)new ModelSlime(0)));
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedBossWolf.class, (Render)new RenderEvolvedBossWolf());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedFireCreeper.class, (Render)new RenderEvolvedFireCreeper());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedFireSkeleton.class, (Render)new RenderEvolvedFireSkeleton());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedFireSpider.class, (Render)new RenderEvolvedFireSpider());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedEnderman.class, (Render)new RenderEvolvedEnderman());
        if (GSConfigCore.enableBarnarda) {
            RenderingRegistry.registerEntityRenderingHandler(EntityTentacles.class, (Render)new RenderTentacles());
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedColdBlaze.class, (Render)new RenderEvolvedColdBlaze());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedGuardian.class, (Render)new RenderEvolvedGuardian(new ModelEvolvedGuardian(), 1.0f));
        if (GSConfigCore.enableBarnarda) {
            RenderingRegistry.registerEntityRenderingHandler(EntityCrawler.class, (Render)new RenderCrawler());
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedBlaze.class, (Render)new RenderEvolvedBlaze());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBlockCrystallTE.class, (TileEntitySpecialRenderer)new TileEntityBlockCrystall());
        if (GSConfigCore.enableBarnarda) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBlockCrystalBTE.class, (TileEntitySpecialRenderer)new TileEntityBlockCrystalB());
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityPlasmaBall.class, (Render)new RenderPlasmaBall(2.0f));
        RenderingRegistry.registerEntityRenderingHandler(EntityPlasmaLaser.class, (Render)new RenderPlasmaLaser(2.0f));
        RenderingRegistry.registerEntityRenderingHandler(EntityIceBolt.class, (Render)new RenderIceBolt(2.0f));
        if (GSConfigCore.enableBarnarda) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBlockLampTE.class, (TileEntitySpecialRenderer)new TileEntityBlockLamp());
        }
    }

    public static void registerItemRenderers() {
        IModelCustom rocketModeltier4 = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("galaxyspace", "models/tier4rocket.obj"));
        IModelCustom rocketModeltier5 = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("galaxyspace", "models/tier5rocket.obj"));
        IModelCustom rocketModeltier6 = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("galaxyspace", "models/tier6rocket.obj"));
        IModelCustom rocketModeltier7 = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("galaxyspace", "models/tier7rocket.obj"));
        IModelCustom rocketModeltier8 = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("galaxyspace", "models/tier8rocket.obj"));
        RenderingRegistry.registerEntityRenderingHandler(EntityTier4Rocket.class, (Render)new RenderTier4Rocket(rocketModeltier4, "galaxyspace", "tier4rocket"));
        RenderingRegistry.registerEntityRenderingHandler(EntityTier5Rocket.class, (Render)new RenderTier5Rocket(rocketModeltier5, "galaxyspace", "tier5rocket"));
        RenderingRegistry.registerEntityRenderingHandler(EntityTier6Rocket.class, (Render)new RenderTier6Rocket(rocketModeltier6, "galaxyspace", "tier6rocket"));
        RenderingRegistry.registerEntityRenderingHandler(EntityTier7Rocket.class, (Render)new RenderTier7Rocket(rocketModeltier7, "galaxyspace", "tier7rocket"));
        RenderingRegistry.registerEntityRenderingHandler(EntityTier8Rocket.class, (Render)new RenderTier8Rocket(rocketModeltier8, "galaxyspace", "tier8rocket"));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier4Rocket, (IItemRenderer)new ItemRendererTier4Rocket(rocketModeltier4));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier4Key, (IItemRenderer)new ItemRendererKey(new ResourceLocation("galaxyspace", "textures/model/ceresTreasureChest.png")));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier5Rocket, (IItemRenderer)new ItemRendererTier5Rocket(rocketModeltier5));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier5Key, (IItemRenderer)new ItemRendererKey(new ResourceLocation("galaxyspace", "textures/model/ioTreasureChest.png")));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier6Rocket, (IItemRenderer)new ItemRendererTier6Rocket(rocketModeltier6));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier6Key, (IItemRenderer)new ItemRendererKey(new ResourceLocation("galaxyspace", "textures/model/enceladusTreasureChest.png")));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier7Rocket, (IItemRenderer)new ItemRendererTier7Rocket(rocketModeltier7));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier7Key, (IItemRenderer)new ItemRendererKey(new ResourceLocation("galaxyspace", "textures/model/proteusTreasureChest.png")));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier8Key, (IItemRenderer)new ItemRendererKey(new ResourceLocation("galaxyspace", "textures/model/plutoTreasureChest.png")));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier8Rocket, (IItemRenderer)new ItemRendererTier8Rocket(rocketModeltier8));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.ThermalPaddingTier2, (IItemRenderer)new ItemRendererThermalPaddingT2());
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.JetPack, (IItemRenderer)new ItemRendererJetPack());
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.QuantBow, (IItemRenderer)new ItemRenderBow());
    }

    @Override
    public int getBlockRender(Block block) {
        if (block == GSBlocks.AssemblyMachine) {
            return ceresMachineRenderID;
        }
        if (block == GSBlocks.GeothermalGenerator) {
            return geothermalGeneratorRenderID;
        }
        if (block == GSBlocks.StorageModuleT3) {
            return storagemoduleRenderID;
        }
        if (block == GSBlocks.FuelGenerator) {
            return fuelGeneratorRenderID;
        }
        if (block == GSBlocks.SolarWindPanel) {
            return solarWindPanelRenderID;
        }
        if (block == GSBlocks.ConverterSurface) {
            return convertersurfaceRenderID;
        }
        if (block == GSBlocks.CeresTChestT4) {
            return ceresTreasureChestRenderID;
        }
        if (block == GSBlocks.IoTChestT5) {
            return ioTreasureChestRenderID;
        }
        if (block == GSBlocks.EnceladusTChestT6) {
            return enceladusTreasureChestRenderID;
        }
        if (block == GSBlocks.ProteusTChestT7) {
            return proteusTreasureChestRenderID;
        }
        if (block == GSBlocks.PlutoTChestT8) {
            return plutoTreasureChestRenderID;
        }
        if (block == GSBlocks.OxStorageModuleT2) {
            return oxstoragemoduleRenderID;
        }
        if (block == GSBlocks.SolarPanel) {
            return solarPanelRenderID;
        }
        if (block == GSBlocks.FutureLamp) {
            return futureLampRenderID;
        }
        return -1;
    }

    @Override
    public int getJetpackArmorRenderIndex() {
        return renderIndexJetpackArmor;
    }

    @Override
    public int getLeadArmorRenderIndex() {
        return renderIndexLeadArmor;
    }

    @Override
    public void register_event(Object obj) {
        FMLCommonHandler.instance().bus().register(obj);
        MinecraftForge.EVENT_BUS.register(obj);
    }

    public static void setupCapes() {
        try {
            ClientProxy.updateCapeList();
        }
        catch (Exception e) {
            FMLLog.severe((String)"Error while setting up Galaxy Space donate capes/skins", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    private static void updateCapeList() {
        int timeout = 10000;
        URL capeListUrl = null;
        try {
            capeListUrl = new URL("http://demigods.at.ua/capes.txt");
        }
        catch (MalformedURLException e) {
            FMLLog.severe((String)"Error getting capes list URL", (Object[])new Object[0]);
            e.printStackTrace();
            return;
        }
        URLConnection connection = null;
        try {
            connection = capeListUrl.openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        InputStream stream = null;
        try {
            stream = connection.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        InputStreamReader streamReader = new InputStreamReader(stream);
        BufferedReader reader = new BufferedReader(streamReader);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(":")) continue;
                int splitLocation = line.indexOf(":");
                String username = line.substring(0, splitLocation);
                String capeUrl = "http://demigods.at.ua/capes/" + line.substring(splitLocation + 1) + ".png";
                GScapeMap.put(username, capeUrl);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            streamReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getWorldHeight(World world) {
        return world.func_72800_K();
    }

    @Override
    public void resetPlayerInAirTime(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            ObfuscationReflectionHelper.setPrivateValue(NetHandlerPlayServer.class, (Object)((EntityPlayerMP)player).field_71135_a, (Object)0, (String[])new String[]{"field_147365_f", "floatingTickCount"});
        }
    }
}

