/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.core.coremod.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.IHighlightHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import galaxyspace.SolarSystem.core.configs.GSConfigCore;
import galaxyspace.SolarSystem.core.coremod.nei.RocketT1RecipeHandler;
import galaxyspace.SolarSystem.core.coremod.nei.RocketT2RecipeHandler;
import galaxyspace.SolarSystem.core.coremod.nei.RocketT3RecipeHandler;
import galaxyspace.SolarSystem.core.recipe.AssemblyRecipes;
import galaxyspace.SolarSystem.core.registers.items.GSItems;
import galaxyspace.SolarSystem.moons.enceladus.nei.RocketT6RecipeHandler;
import galaxyspace.SolarSystem.moons.io.nei.RocketT5RecipeHandler;
import galaxyspace.SolarSystem.moons.proteus.nei.RocketT7RecipeHandler;
import galaxyspace.SolarSystem.planets.ceres.nei.RocketT4RecipeHandler;
import galaxyspace.SolarSystem.planets.overworld.nei.AssemblyMachineRecipeHandler;
import galaxyspace.SolarSystem.planets.pluto.nei.RocketT8RecipeHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.mars.nei.NEIGalacticraftMarsConfig;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class NEIGalaxySpaceConfig
implements IConfigureNEI {
    private static HashMap<ArrayList<PositionedStack>, PositionedStack> rocketBenchRecipes = new HashMap();
    private static HashMap<HashMap<Integer, PositionedStack>, PositionedStack> assemblyMachineRecipes = new HashMap();
    private static HashMap<HashMap<Integer, PositionedStack>, PositionedStack> rocketBenchT1Recipes = new HashMap();

    public void loadConfig() {
        this.registerRecipes();
        API.registerRecipeHandler((ICraftingHandler)new RocketT1RecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RocketT1RecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RocketT2RecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RocketT2RecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RocketT3RecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RocketT3RecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RocketT4RecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RocketT4RecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RocketT5RecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RocketT5RecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RocketT6RecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RocketT6RecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RocketT7RecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RocketT7RecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RocketT8RecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RocketT8RecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new AssemblyMachineRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new AssemblyMachineRecipeHandler());
        API.registerHighlightIdentifier((Block)AsteroidBlocks.blockBasic, (IHighlightHandler)NEIGalacticraftMarsConfig.planetsHighlightHandler);
    }

    public String getName() {
        return "GalaxySpace NEI Plugin";
    }

    public String getVersion() {
        return "3.0.12";
    }

    public void registerRocketBenchRecipe(ArrayList<PositionedStack> input, PositionedStack output) {
        rocketBenchRecipes.put(input, output);
    }

    public static Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getRocketBenchRecipes() {
        return rocketBenchRecipes.entrySet();
    }

    public void registerRocketBenchT1Recipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        rocketBenchT1Recipes.put(input, output);
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getRocketBenchT1Recipes() {
        return rocketBenchT1Recipes.entrySet();
    }

    public void registerAssemblyMachineRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        assemblyMachineRecipes.put(input, output);
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getAssemblyMachineRecipes() {
        return assemblyMachineRecipes.entrySet();
    }

    public void registerRecipes() {
        this.addAssemblyMachineRecipes();
        this.addRocketT1Recipes();
        this.addRocketT2Recipes();
        this.addRocketT3Recipes();
        this.addRocketT4Recipes();
        this.addRocketT5Recipes();
        this.addRocketT6Recipes();
        this.addRocketT7Recipes();
        this.addRocketT8Recipes();
    }

    private void addRocketT1Recipes() {
        HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
        input1.put(0, new PositionedStack((Object)new ItemStack(GCItems.partNoseCone), 45, 15));
        input1.put(1, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 36, 33));
        input1.put(2, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 36, 51));
        input1.put(3, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 36, 69));
        input1.put(4, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 36, 87));
        input1.put(5, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 54, 33));
        input1.put(6, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 54, 51));
        input1.put(7, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 54, 69));
        input1.put(8, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 54, 87));
        input1.put(9, new PositionedStack((Object)new ItemStack(GCItems.rocketEngine), 45, 105));
        input1.put(10, new PositionedStack((Object)new ItemStack(GCItems.partFins), 18, 87));
        input1.put(11, new PositionedStack((Object)new ItemStack(GCItems.partFins), 18, 105));
        input1.put(12, new PositionedStack((Object)new ItemStack(GCItems.partFins), 72, 87));
        input1.put(13, new PositionedStack((Object)new ItemStack(GCItems.partFins), 72, 105));
        input1.put(17, new PositionedStack((Object)new ItemStack(GSItems.ModuleLander), 89, 33));
        input1.put(18, new PositionedStack((Object)new ItemStack(GSItems.ModuleSmallFuelCanister), 107, 33));
        input1.put(19, new PositionedStack((Object)new ItemStack(GSItems.ModuleSmallFuelCanister), 125, 33));
        this.registerRocketBenchT1Recipe(input1, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 0), 139, 92));
        HashMap<Integer, PositionedStack> input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(14, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 8));
        this.registerRocketBenchT1Recipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 1), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(15, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 8));
        this.registerRocketBenchT1Recipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 1), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(16, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 8));
        this.registerRocketBenchT1Recipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 1), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(14, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 8));
        input2.put(15, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 8));
        this.registerRocketBenchT1Recipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 2), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(15, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 8));
        input2.put(16, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 8));
        this.registerRocketBenchT1Recipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 2), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(14, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 8));
        input2.put(16, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 8));
        this.registerRocketBenchT1Recipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 2), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(14, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 8));
        input2.put(15, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 8));
        input2.put(16, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 8));
        this.registerRocketBenchT1Recipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 3), 139, 92));
    }

    private void addRocketT2Recipes() {
        int changeY = 15;
        ArrayList<PositionedStack> input1 = new ArrayList<PositionedStack>();
        input1.add(new PositionedStack((Object)new ItemStack(GCItems.partNoseCone), 45, 7));
        input1.add(new PositionedStack((Object)new ItemStack(MarsItems.marsItemBasic, 1, 3), 36, 25));
        input1.add(new PositionedStack((Object)new ItemStack(MarsItems.marsItemBasic, 1, 3), 36, 43));
        input1.add(new PositionedStack((Object)new ItemStack(MarsItems.marsItemBasic, 1, 3), 36, 61));
        input1.add(new PositionedStack((Object)new ItemStack(MarsItems.marsItemBasic, 1, 3), 36, 79));
        input1.add(new PositionedStack((Object)new ItemStack(MarsItems.marsItemBasic, 1, 3), 36, 97));
        input1.add(new PositionedStack((Object)new ItemStack(MarsItems.marsItemBasic, 1, 3), 54, 25));
        input1.add(new PositionedStack((Object)new ItemStack(MarsItems.marsItemBasic, 1, 3), 54, 43));
        input1.add(new PositionedStack((Object)new ItemStack(MarsItems.marsItemBasic, 1, 3), 54, 61));
        input1.add(new PositionedStack((Object)new ItemStack(MarsItems.marsItemBasic, 1, 3), 54, 79));
        input1.add(new PositionedStack((Object)new ItemStack(MarsItems.marsItemBasic, 1, 3), 54, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GCItems.rocketEngine), 45, 115));
        input1.add(new PositionedStack((Object)new ItemStack(GCItems.rocketEngine, 1, 1), 18, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GCItems.rocketEngine, 1, 1), 72, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GCItems.partFins), 18, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GCItems.partFins), 18, 115));
        input1.add(new PositionedStack((Object)new ItemStack(GCItems.partFins), 72, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GCItems.partFins), 72, 115));
        if (GSConfigCore.recipesRockets) {
            input1.add(new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1), 139, 61));
        }
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.ModuleLanderT2), 89, 27));
        this.registerRocketBenchRecipe(input1, new PositionedStack((Object)new ItemStack(MarsItems.spaceship, 1, 0), 139, 102));
        ArrayList<PositionedStack> input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(MarsItems.spaceship, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(MarsItems.spaceship, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(MarsItems.spaceship, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(MarsItems.spaceship, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(MarsItems.spaceship, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(MarsItems.spaceship, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(MarsItems.spaceship, 1, 3), 139, 102));
    }

    public void addRocketT3Recipes() {
        int changeY = 15;
        ArrayList<PositionedStack> input1 = new ArrayList<PositionedStack>();
        input1.add(new PositionedStack((Object)new ItemStack((Item)AsteroidsItems.heavyNoseCone), 45, 7));
        input1.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem, 1, 0), 36, 25));
        input1.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem, 1, 0), 36, 43));
        input1.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem, 1, 0), 36, 61));
        input1.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem, 1, 0), 36, 79));
        input1.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem, 1, 0), 36, 97));
        input1.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem, 1, 0), 54, 25));
        input1.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem, 1, 0), 54, 43));
        input1.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem, 1, 0), 54, 61));
        input1.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem, 1, 0), 54, 79));
        input1.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem, 1, 0), 54, 97));
        input1.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem, 1, 1), 45, 115));
        input1.add(new PositionedStack((Object)new ItemStack(GCItems.rocketEngine, 1, 1), 18, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GCItems.rocketEngine, 1, 1), 72, 79));
        input1.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem, 1, 2), 18, 97));
        input1.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem, 1, 2), 18, 115));
        input1.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem, 1, 2), 72, 97));
        input1.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem, 1, 2), 72, 115));
        if (GSConfigCore.recipesRockets) {
            input1.add(new PositionedStack((Object)new ItemStack(MarsItems.spaceship, 1, 0), 139, 61));
        }
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.ModuleLanderT3), 89, 27));
        this.registerRocketBenchRecipe(input1, new PositionedStack((Object)new ItemStack(AsteroidsItems.tier3Rocket, 1, 0), 139, 102));
        ArrayList<PositionedStack> input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(AsteroidsItems.tier3Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(AsteroidsItems.tier3Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(AsteroidsItems.tier3Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(AsteroidsItems.tier3Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(AsteroidsItems.tier3Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(AsteroidsItems.tier3Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(AsteroidsItems.tier3Rocket, 1, 3), 139, 102));
    }

    public void addRocketT4Recipes() {
        int changeY = 15;
        ArrayList<PositionedStack> input1 = new ArrayList<PositionedStack>();
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 0), 45, 7));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate4, 1, 0), 36, 25));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate4, 1, 0), 36, 43));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate4, 1, 0), 36, 61));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate4, 1, 0), 36, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate4, 1, 0), 36, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate4, 1, 0), 54, 25));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate4, 1, 0), 54, 43));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate4, 1, 0), 54, 61));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate4, 1, 0), 54, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate4, 1, 0), 54, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 1), 45, 115));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 2), 18, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 2), 72, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 18, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 18, 115));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 72, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 72, 115));
        if (GSConfigCore.recipesRockets) {
            input1.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.tier3Rocket, 1, 0), 139, 61));
        }
        this.registerRocketBenchRecipe(input1, new PositionedStack((Object)new ItemStack(GSItems.Tier4Rocket, 1, 0), 139, 102));
        ArrayList<PositionedStack> input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier4Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier4Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier4Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier4Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier4Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier4Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier4Rocket, 1, 3), 139, 102));
    }

    public void addRocketT5Recipes() {
        int changeY = 15;
        ArrayList<PositionedStack> input1 = new ArrayList<PositionedStack>();
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 0), 45, 7));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate5, 1, 0), 36, 25));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate5, 1, 0), 36, 43));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate5, 1, 0), 36, 61));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate5, 1, 0), 36, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate5, 1, 0), 36, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate5, 1, 0), 54, 25));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate5, 1, 0), 54, 43));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate5, 1, 0), 54, 61));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate5, 1, 0), 54, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate5, 1, 0), 54, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 1), 45, 115));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 2), 18, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 2), 72, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 18, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 18, 115));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 72, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 72, 115));
        if (GSConfigCore.recipesRockets) {
            input1.add(new PositionedStack((Object)new ItemStack(GSItems.Tier4Rocket, 1, 0), 139, 61));
        }
        this.registerRocketBenchRecipe(input1, new PositionedStack((Object)new ItemStack(GSItems.Tier5Rocket, 1, 0), 139, 102));
        ArrayList<PositionedStack> input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier5Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier5Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier5Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier5Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier5Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier5Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier5Rocket, 1, 3), 139, 102));
    }

    public void addRocketT6Recipes() {
        int changeY = 15;
        ArrayList<PositionedStack> input1 = new ArrayList<PositionedStack>();
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 0), 45, 7));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate6, 1, 0), 36, 25));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate6, 1, 0), 36, 43));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate6, 1, 0), 36, 61));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate6, 1, 0), 36, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate6, 1, 0), 36, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate6, 1, 0), 54, 25));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate6, 1, 0), 54, 43));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate6, 1, 0), 54, 61));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate6, 1, 0), 54, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate6, 1, 0), 54, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 1), 45, 115));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 2), 18, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 2), 72, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 18, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 18, 115));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 72, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 72, 115));
        if (GSConfigCore.recipesRockets) {
            input1.add(new PositionedStack((Object)new ItemStack(GSItems.Tier5Rocket, 1, 0), 139, 61));
        }
        this.registerRocketBenchRecipe(input1, new PositionedStack((Object)new ItemStack(GSItems.Tier6Rocket, 1, 0), 139, 102));
        ArrayList<PositionedStack> input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier6Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier6Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier6Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier6Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier6Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier6Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier6Rocket, 1, 3), 139, 102));
    }

    public void addRocketT7Recipes() {
        int changeY = 15;
        ArrayList<PositionedStack> input1 = new ArrayList<PositionedStack>();
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 0), 45, 7));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate7, 1, 0), 36, 25));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate7, 1, 0), 36, 43));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate7, 1, 0), 36, 61));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate7, 1, 0), 36, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate7, 1, 0), 36, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate7, 1, 0), 54, 25));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate7, 1, 0), 54, 43));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate7, 1, 0), 54, 61));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate7, 1, 0), 54, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate7, 1, 0), 54, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 1), 45, 115));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 2), 18, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 2), 72, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 18, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 18, 115));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 72, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 72, 115));
        if (GSConfigCore.recipesRockets) {
            input1.add(new PositionedStack((Object)new ItemStack(GSItems.Tier6Rocket, 1, 0), 139, 61));
        }
        this.registerRocketBenchRecipe(input1, new PositionedStack((Object)new ItemStack(GSItems.Tier7Rocket, 1, 0), 139, 102));
        ArrayList<PositionedStack> input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier7Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier7Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier7Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier7Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier7Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier7Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier7Rocket, 1, 3), 139, 102));
    }

    public void addRocketT8Recipes() {
        int changeY = 15;
        ArrayList<PositionedStack> input1 = new ArrayList<PositionedStack>();
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 0), 45, 7));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate8, 1, 0), 36, 25));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate8, 1, 0), 36, 43));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate8, 1, 0), 36, 61));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate8, 1, 0), 36, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate8, 1, 0), 36, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate8, 1, 0), 54, 25));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate8, 1, 0), 54, 43));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate8, 1, 0), 54, 61));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate8, 1, 0), 54, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.HeavyDutyPlate8, 1, 0), 54, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 1), 45, 115));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 2), 18, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 2), 72, 79));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 18, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 18, 115));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 72, 97));
        input1.add(new PositionedStack((Object)new ItemStack(GSItems.RocketParts, 1, 3), 72, 115));
        if (GSConfigCore.recipesRockets) {
            input1.add(new PositionedStack((Object)new ItemStack(GSItems.Tier7Rocket, 1, 0), 139, 61));
        }
        this.registerRocketBenchRecipe(input1, new PositionedStack((Object)new ItemStack(GSItems.Tier8Rocket, 1, 0), 139, 102));
        ArrayList<PositionedStack> input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier8Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier8Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier8Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier8Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier8Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier8Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GSItems.Tier8Rocket, 1, 3), 139, 102));
    }

    private void addAssemblyMachineRecipes() {
        for (int i = 0; i < AssemblyRecipes.getRecipeList().size(); ++i) {
            int j;
            ShapedRecipes recipe;
            HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
            IRecipe rec = AssemblyRecipes.getRecipeList().get(i);
            if (rec instanceof ShapedRecipes) {
                recipe = (ShapedRecipes)rec;
                for (j = 0; j < recipe.field_77574_d.length; ++j) {
                    ItemStack stack = recipe.field_77574_d[j];
                    input1.put(j, new PositionedStack((Object)stack, 21 + j % 3 * 18, 26 + j / 3 * 18));
                }
            } else if (rec instanceof ShapelessOreRecipe) {
                recipe = (ShapelessOreRecipe)rec;
                for (j = 0; j < recipe.getInput().size(); ++j) {
                    Object obj = recipe.getInput().get(j);
                    input1.put(j, new PositionedStack(obj, 21 + j % 3 * 18, 26 + j / 3 * 18));
                }
            }
            this.registerAssemblyMachineRecipe(input1, new PositionedStack((Object)rec.func_77571_b(), 140, 44));
        }
    }
}

