/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import galaxyspace.ACentauriSystem.ACentauriPlanets;
import galaxyspace.BarnardsSystem.BarnardsPlanets;
import galaxyspace.BarnardsSystem.planets.barnardaC.entities.EntityCrawler;
import galaxyspace.BarnardsSystem.planets.barnardaC.entities.EntityTentacles;
import galaxyspace.BarnardsSystem.planets.barnardaC.recipe.CraftingRecipesBarnardaC;
import galaxyspace.BarnardsSystem.planets.barnardaC.tile.TileEntityBlockCrystalBTE;
import galaxyspace.BarnardsSystem.planets.barnardaE.recipe.CraftingRecipesBarnardaE;
import galaxyspace.CreativeTabsGS;
import galaxyspace.SolarSystem.SolarSystemPlanets;
import galaxyspace.SolarSystem.core.achievements.AchEvent;
import galaxyspace.SolarSystem.core.achievements.AchievementList;
import galaxyspace.SolarSystem.core.configs.GSConfigBiomes;
import galaxyspace.SolarSystem.core.configs.GSConfigCore;
import galaxyspace.SolarSystem.core.configs.GSConfigDimensions;
import galaxyspace.SolarSystem.core.configs.GSConfigSchematics;
import galaxyspace.SolarSystem.core.coremod.recipe.Tier1RocketRecipe;
import galaxyspace.SolarSystem.core.coremod.recipe.Tier2RocketRecipe;
import galaxyspace.SolarSystem.core.coremod.recipe.Tier3RocketRecipe;
import galaxyspace.SolarSystem.core.coremod.schematic.SchematicAdd;
import galaxyspace.SolarSystem.core.coremod.schematic.SchematicTier1Rocket;
import galaxyspace.SolarSystem.core.coremod.schematic.SchematicTier2Rocket;
import galaxyspace.SolarSystem.core.coremod.schematic.SchematicTier3Rocket;
import galaxyspace.SolarSystem.core.handler.GSEventHandler;
import galaxyspace.SolarSystem.core.handler.GSFuelHandler;
import galaxyspace.SolarSystem.core.handler.GSGuiHandler;
import galaxyspace.SolarSystem.core.handler.GSLightningStormHandler;
import galaxyspace.SolarSystem.core.handler.GSOreGenOtherMods;
import galaxyspace.SolarSystem.core.handler.GSPlanetFogHandler;
import galaxyspace.SolarSystem.core.particles.EntityIceBolt;
import galaxyspace.SolarSystem.core.particles.EntityPlasmaBall;
import galaxyspace.SolarSystem.core.particles.EntityPlasmaLaser;
import galaxyspace.SolarSystem.core.particles.EntitySmallIceBolt;
import galaxyspace.SolarSystem.core.proxy.CommonProxy;
import galaxyspace.SolarSystem.core.registers.blocks.GSBlocks;
import galaxyspace.SolarSystem.core.registers.fluids.GSFluids;
import galaxyspace.SolarSystem.core.registers.items.GSItems;
import galaxyspace.SolarSystem.core.registers.potions.GSPotions;
import galaxyspace.SolarSystem.moons.deimos.recipe.CraftingRecipesDeimos;
import galaxyspace.SolarSystem.moons.enceladus.entities.EntityCrystalBoss;
import galaxyspace.SolarSystem.moons.enceladus.entities.EntityTier6Rocket;
import galaxyspace.SolarSystem.moons.enceladus.recipe.CraftingRecipesEnceladus;
import galaxyspace.SolarSystem.moons.enceladus.recipe.Tier6RocketRecipe;
import galaxyspace.SolarSystem.moons.enceladus.schematic.SchematicTier6Rocket;
import galaxyspace.SolarSystem.moons.enceladus.tile.TileEntityBlockCrystallTE;
import galaxyspace.SolarSystem.moons.enceladus.tile.TileEntityDungeonSpawnerEnceladus;
import galaxyspace.SolarSystem.moons.enceladus.tile.TileEntityEnceladusTreasureChest;
import galaxyspace.SolarSystem.moons.europa.entities.EntityEvolvedColdBlaze;
import galaxyspace.SolarSystem.moons.ganymede.recipe.CraftingRecipesGanymede;
import galaxyspace.SolarSystem.moons.io.entities.EntityBossGhast;
import galaxyspace.SolarSystem.moons.io.entities.EntityTier5Rocket;
import galaxyspace.SolarSystem.moons.io.recipe.CraftingRecipesIo;
import galaxyspace.SolarSystem.moons.io.recipe.Tier5RocketRecipe;
import galaxyspace.SolarSystem.moons.io.schematic.SchematicTier5Rocket;
import galaxyspace.SolarSystem.moons.io.tile.TileEntityDungeonSpawnerIO;
import galaxyspace.SolarSystem.moons.io.tile.TileEntityIOTreasureChest;
import galaxyspace.SolarSystem.moons.oberon.recipe.CraftingRecipesOberon;
import galaxyspace.SolarSystem.moons.phobos.recipe.CraftingRecipesPhobos;
import galaxyspace.SolarSystem.moons.proteus.entities.EntityEvolvedBossSlime;
import galaxyspace.SolarSystem.moons.proteus.entities.EntityTier7Rocket;
import galaxyspace.SolarSystem.moons.proteus.recipe.CraftingRecipesProteus;
import galaxyspace.SolarSystem.moons.proteus.recipe.Tier7RocketRecipe;
import galaxyspace.SolarSystem.moons.proteus.schematic.SchematicTier7Rocket;
import galaxyspace.SolarSystem.moons.proteus.tile.TileEntityDungeonSpawnerProteus;
import galaxyspace.SolarSystem.moons.proteus.tile.TileEntityProteusTreasureChest;
import galaxyspace.SolarSystem.moons.titan.recipe.CraftingRecipesTitan;
import galaxyspace.SolarSystem.moons.triton.recipe.CraftingRecipesTriton;
import galaxyspace.SolarSystem.planets.ceres.entities.EntityBossBlaze;
import galaxyspace.SolarSystem.planets.ceres.entities.EntityTier4Rocket;
import galaxyspace.SolarSystem.planets.ceres.recipe.CraftingRecipesCeres;
import galaxyspace.SolarSystem.planets.ceres.recipe.Tier4RocketRecipe;
import galaxyspace.SolarSystem.planets.ceres.schematic.SchematicTier4Rocket;
import galaxyspace.SolarSystem.planets.ceres.tile.TileEntityCeresTreasureChest;
import galaxyspace.SolarSystem.planets.ceres.tile.TileEntityDungeonSpawnerCeres;
import galaxyspace.SolarSystem.planets.mercury.entities.EntityEvolvedBlaze;
import galaxyspace.SolarSystem.planets.mercury.recipe.CraftingRecipesMercury;
import galaxyspace.SolarSystem.planets.overworld.recipe.CraftingRecipesOverworld;
import galaxyspace.SolarSystem.planets.overworld.tile.TileEntityAssemblyMachine;
import galaxyspace.SolarSystem.planets.overworld.tile.TileEntityConverterSurface;
import galaxyspace.SolarSystem.planets.overworld.tile.TileEntityDuraluminumWire;
import galaxyspace.SolarSystem.planets.overworld.tile.TileEntityFuelGenerator;
import galaxyspace.SolarSystem.planets.overworld.tile.TileEntityGeothermalGenerator;
import galaxyspace.SolarSystem.planets.overworld.tile.TileEntityOxStorageModule;
import galaxyspace.SolarSystem.planets.overworld.tile.TileEntitySolarPanel;
import galaxyspace.SolarSystem.planets.overworld.tile.TileEntitySolarWind;
import galaxyspace.SolarSystem.planets.overworld.tile.TileEntityStorageModule;
import galaxyspace.SolarSystem.planets.pluto.entities.EntityEvolvedBossWolf;
import galaxyspace.SolarSystem.planets.pluto.entities.EntityEvolvedEnderman;
import galaxyspace.SolarSystem.planets.pluto.entities.EntityTier8Rocket;
import galaxyspace.SolarSystem.planets.pluto.recipe.CraftingRecipesPluto;
import galaxyspace.SolarSystem.planets.pluto.recipe.Tier8RocketRecipe;
import galaxyspace.SolarSystem.planets.pluto.schematic.SchematicTier8Rocket;
import galaxyspace.SolarSystem.planets.pluto.tile.TileEntityDungeonSpawnerPluto;
import galaxyspace.SolarSystem.planets.pluto.tile.TileEntityPlutoTreasureChest;
import galaxyspace.SolarSystem.planets.venus.entities.EntityEvolvedFireCreeper;
import galaxyspace.SolarSystem.planets.venus.entities.EntityEvolvedFireSkeleton;
import galaxyspace.SolarSystem.planets.venus.entities.EntityEvolvedFireSpider;
import galaxyspace.SolarSystem.planets.venus.recipe.CraftingRecipesVenus;
import galaxyspace.SolarSystem.satellites.mars.recipe.CraftingRecipeMarsSS;
import galaxyspace.SolarSystem.satellites.venus.recipe.CraftingRecipeVenusSS;
import galaxyspace.TCetiSystem.TCetiPlanets;
import galaxyspace.ThreadVersionCheckGS;
import galaxyspace.VegaSystem.VegaPlanets;
import java.io.File;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.core.util.CreativeTabGC;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;

@Mod(modid="GalaxySpace", version="1.1.3", dependencies="required-after:GalacticraftCore; required-after:GalacticraftMars;", name="GalaxySpace")
public class GalaxySpace {
    public static final int major_version = 1;
    public static final int minor_version = 1;
    public static final int build_version = 3;
    public static final String MODID = "GalaxySpace";
    public static final String VERSION = "1.1.3";
    public static final String NAME = "GalaxySpace";
    public static final String ASSET_PREFIX = "galaxyspace";
    @Mod.Instance(value="GalaxySpace")
    public static GalaxySpace instance;
    @SidedProxy(clientSide="galaxyspace.SolarSystem.core.proxy.ClientProxy", serverSide="galaxyspace.SolarSystem.core.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        new GSConfigDimensions(new File(event.getModConfigurationDirectory(), "GalaxySpace/dimensions.conf"));
        new GSConfigBiomes(new File(event.getModConfigurationDirectory(), "GalaxySpace/biomes.conf"));
        new GSConfigSchematics(new File(event.getModConfigurationDirectory(), "GalaxySpace/schematics.conf"));
        new GSConfigCore(new File(event.getModConfigurationDirectory(), "GalaxySpace/core.conf"));
        GSBlocks.initialize();
        GSItems.initialize();
        GSPotions.initialize();
        GSFluids.initialize();
        if (GSConfigCore.enableACentauri) {
            ACentauriPlanets.preInit();
        }
        if (GSConfigCore.enableBarnarda) {
            BarnardsPlanets.preInit();
        }
        if (GSConfigCore.enableVega) {
            VegaPlanets.preInit();
        }
        if (GSConfigCore.enableTCeti) {
            TCetiPlanets.preInit();
        }
        proxy.preload();
        GameRegistry.registerFuelHandler((IFuelHandler)new GSFuelHandler());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicAdd());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier1Rocket());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier2Rocket());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier3Rocket());
        proxy.register_event(new GSEventHandler());
        proxy.register_event(new GSPlanetFogHandler());
        proxy.register_event(new GSLightningStormHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.load();
        this.registerEntities();
        MinecraftForge.EVENT_BUS.register((Object)new GSOreGenOtherMods());
        proxy.register_event(new AchEvent());
        AchievementList.load();
        SolarSystemPlanets.init();
        if (GSConfigCore.enableACentauri) {
            ACentauriPlanets.init();
        }
        if (GSConfigCore.enableBarnarda) {
            BarnardsPlanets.init();
        }
        if (GSConfigCore.enableVega) {
            VegaPlanets.init();
        }
        if (GSConfigCore.enableTCeti) {
            TCetiPlanets.init();
        }
        CreativeTabsGS.GSBlocksTab = new CreativeTabGC(CreativeTabs.getNextID(), "AddonsBlocks", Item.func_150898_a((Block)GSBlocks.CeresGlowStone), 0);
        CreativeTabsGS.GSItemsTab = new CreativeTabGC(CreativeTabs.getNextID(), "AddonsItems", GSItems.Tier7Rocket, 0);
        CreativeTabsGS.GSArmorTab = new CreativeTabGC(CreativeTabs.getNextID(), "AddonsArmor", GSItems.JetPack, 0);
        GalacticraftRegistry.addDungeonLoot((int)4, (ItemStack)new ItemStack(GSItems.Tier4Schematic, 1, 0));
        GalacticraftRegistry.addDungeonLoot((int)5, (ItemStack)new ItemStack(GSItems.Tier5Schematic, 1, 0));
        GalacticraftRegistry.addDungeonLoot((int)6, (ItemStack)new ItemStack(GSItems.Tier6Schematic, 1, 0));
        GalacticraftRegistry.addDungeonLoot((int)7, (ItemStack)new ItemStack(GSItems.Tier7Schematic, 1, 0));
        GalacticraftRegistry.addDungeonLoot((int)8, (ItemStack)new ItemStack(GSItems.Tier8Schematic, 1, 0));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        CraftingRecipesMercury.loadRecipes();
        CraftingRecipesVenus.loadRecipes();
        CraftingRecipesOverworld.loadRecipes();
        CraftingRecipesPhobos.loadRecipes();
        CraftingRecipesDeimos.loadRecipes();
        CraftingRecipesCeres.loadRecipes();
        CraftingRecipesGanymede.loadRecipes();
        CraftingRecipesIo.loadRecipes();
        CraftingRecipesEnceladus.loadRecipes();
        CraftingRecipesTitan.loadRecipes();
        CraftingRecipesOberon.loadRecipes();
        CraftingRecipesProteus.loadRecipes();
        CraftingRecipesTriton.loadRecipes();
        CraftingRecipesPluto.loadRecipes();
        CraftingRecipeMarsSS.loadRecipes();
        CraftingRecipeVenusSS.loadRecipes();
        if (GSConfigDimensions.enableBarnardaC) {
            CraftingRecipesBarnardaC.loadRecipes();
        }
        if (GSConfigDimensions.enableBarnardaE) {
            CraftingRecipesBarnardaE.loadRecipes();
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GSGuiHandler());
        proxy.postload();
    }

    @Mod.EventHandler
    public void serverInit(FMLServerStartedEvent event) {
        ThreadVersionCheckGS.startCheck();
    }

    private void registerEntities() {
        this.registerCreatures();
        this.registerNonMobEntities();
        this.registerTileEntities();
        this.registerRecipesWorkBench();
    }

    public void registerCreatures() {
        GCCoreUtil.registerGalacticraftCreature(EntityBossBlaze.class, (String)"EvolvedBossBlaze", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityBossGhast.class, (String)"EvolvedBossGhast", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityCrystalBoss.class, (String)"EvolvedCrystalBoss", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedBossSlime.class, (String)"EvolvedBossSlime", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedBossWolf.class, (String)"EvolvedBossWolf", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedFireCreeper.class, (String)"EvolvedFireCreeper", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedFireSkeleton.class, (String)"EvolvedFireSkeleton", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedFireSpider.class, (String)"EvolvedFireSpider", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedEnderman.class, (String)"EvolvedEnderman", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityTentacles.class, (String)"Tentacles", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedColdBlaze.class, (String)"EvolvedColdBlaze", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityCrawler.class, (String)"Crawler", (int)-771829, (int)-870131);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedBlaze.class, (String)"EvolvedBlaze", (int)-771829, (int)-870131);
    }

    private void registerNonMobEntities() {
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier4Rocket.class, (String)"SpaceshipT4", (int)150, (int)1, (boolean)false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier5Rocket.class, (String)"SpaceshipT5", (int)150, (int)1, (boolean)false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier6Rocket.class, (String)"SpaceshipT6", (int)150, (int)1, (boolean)false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier7Rocket.class, (String)"SpaceshipT7", (int)150, (int)1, (boolean)false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier8Rocket.class, (String)"SpaceshipT8", (int)150, (int)1, (boolean)false);
        EntityRegistry.registerModEntity(EntityPlasmaBall.class, (String)"PlasmaBall", (int)0, (Object)this, (int)40, (int)100, (boolean)true);
        EntityRegistry.registerModEntity(EntityPlasmaLaser.class, (String)"PlasmaLaser", (int)1, (Object)this, (int)40, (int)100, (boolean)true);
        EntityRegistry.registerModEntity(EntityIceBolt.class, (String)"IceBolt", (int)3, (Object)this, (int)40, (int)100, (boolean)true);
        EntityRegistry.registerModEntity(EntitySmallIceBolt.class, (String)"SmallIceBolt", (int)4, (Object)this, (int)40, (int)100, (boolean)true);
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityBlockCrystallTE.class, (String)"Crystal");
        GameRegistry.registerTileEntity(TileEntityAssemblyMachine.class, (String)"Assembly Machine");
        GameRegistry.registerTileEntity(TileEntityGeothermalGenerator.class, (String)"GS Geothermal Generator");
        GameRegistry.registerTileEntity(TileEntityFuelGenerator.class, (String)"GS Fuel Generator");
        GameRegistry.registerTileEntity(TileEntityConverterSurface.class, (String)"GS Converter Surface");
        GameRegistry.registerTileEntity(TileEntitySolarWind.class, (String)"GS Solar Wind Panel");
        GameRegistry.registerTileEntity(TileEntityCeresTreasureChest.class, (String)"Tier 4 Treasure Chest");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawnerCeres.class, (String)"Ceres Dungeon Spawner");
        GameRegistry.registerTileEntity(TileEntityIOTreasureChest.class, (String)"Tier 5 Treasure Chest");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawnerIO.class, (String)"Io Dungeon Spawner");
        GameRegistry.registerTileEntity(TileEntityEnceladusTreasureChest.class, (String)"Tier 6 Treasure Chest");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawnerEnceladus.class, (String)"Enceladus Dungeon Spawner");
        GameRegistry.registerTileEntity(TileEntityProteusTreasureChest.class, (String)"Tier 7 Treasure Chest");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawnerProteus.class, (String)"Proteus Dungeon Spawner");
        GameRegistry.registerTileEntity(TileEntityPlutoTreasureChest.class, (String)"Tier 8 Treasure Chest");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawnerPluto.class, (String)"Pluto Dungeon Spawner");
        if (GSConfigCore.enableBarnarda) {
            GameRegistry.registerTileEntity(TileEntityBlockCrystalBTE.class, (String)"CrystalB");
        }
        GameRegistry.registerTileEntity(TileEntityDuraluminumWire.class, (String)"Duraluminum Wire");
        GameRegistry.registerTileEntity(TileEntityStorageModule.class, (String)"GS Storage Module");
        GameRegistry.registerTileEntity(TileEntityOxStorageModule.class, (String)"GS Oxygen Storage Module");
        GameRegistry.registerTileEntity(TileEntitySolarPanel.class, (String)"GS Solar Panel");
    }

    private void registerRecipesWorkBench() {
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier4Rocket());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier5Rocket());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier6Rocket());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier7Rocket());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier8Rocket());
        Tier1RocketRecipe.registerRecipeWorkBench();
        Tier2RocketRecipe.registerRecipeWorkBench();
        Tier3RocketRecipe.registerRecipeWorkBench();
        Tier4RocketRecipe.registerRecipeWorkBench();
        Tier5RocketRecipe.registerRecipeWorkBench();
        Tier6RocketRecipe.registerRecipeWorkBench();
        Tier7RocketRecipe.registerRecipeWorkBench();
        Tier8RocketRecipe.registerRecipeWorkBench();
    }

    public static void info(String message) {
        FMLRelaunchLog.log((String)"Galaxy Space", (Level)Level.INFO, (String)message, (Object[])new Object[0]);
    }

    public static void severe(String message) {
        FMLRelaunchLog.log((String)"Galaxy Space", (Level)Level.ERROR, (String)message, (Object[])new Object[0]);
    }
}

