/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.render.tile;

import galaxyspace.core.block.BlockTreasureChestGS;
import galaxyspace.core.tile.chest.TileEntityTreasureChestGS;
import micdoodle8.mods.galacticraft.core.client.model.block.ModelTreasureChest;
import micdoodle8.mods.galacticraft.core.client.model.block.ModelTreasureChestLarge;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TileEntityTreasureChestRendererGS
extends TileEntitySpecialRenderer {
    private final ResourceLocation treasureChestTexture;
    private final ResourceLocation treasureLargeChestTexture;
    private final ModelTreasureChest chestModel = new ModelTreasureChest();
    private final ModelTreasureChestLarge largeChestModel = new ModelTreasureChestLarge();

    public TileEntityTreasureChestRendererGS(String treasureChestTexture, String treasureLargeChestTexture) {
        this.treasureChestTexture = new ResourceLocation("galaxyspace", "textures/model/" + treasureChestTexture + ".png");
        this.treasureLargeChestTexture = new ResourceLocation("galaxyspace", "textures/model/" + treasureLargeChestTexture + ".png");
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTicks) {
        float adjacentLidAngle;
        float f;
        boolean isLargeChest;
        int meta;
        TileEntityTreasureChestGS tileChest = (TileEntityTreasureChestGS)tile;
        if (!tileChest.func_145830_o()) {
            meta = 0;
        } else {
            meta = tileChest.func_145832_p();
            Block block = tileChest.func_145838_q();
            if (block instanceof BlockTreasureChestGS) {
                BlockTreasureChestGS blockChest = (BlockTreasureChestGS)block;
                if (meta == 0) {
                    blockChest.unifyAdjacentChests(tileChest.func_145831_w(), tileChest.field_145851_c, tileChest.field_145848_d, tileChest.field_145849_e);
                    meta = tileChest.func_145832_p();
                }
            }
            tileChest.checkForAdjacentChests();
        }
        if (tileChest.adjacentChestZNeg != null || tileChest.adjacentChestXNeg != null) {
            return;
        }
        if (tileChest.adjacentChestXPos != null || tileChest.adjacentChestZPos != null) {
            isLargeChest = true;
            this.func_147499_a(this.treasureLargeChestTexture);
        } else {
            isLargeChest = false;
            this.func_147499_a(this.treasureChestTexture);
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)x, (double)(y + 1.0), (double)(z + 1.0));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        if (meta == 2 && tileChest.adjacentChestXPos != null) {
            GL11.glTranslatef((float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (meta == 5 && tileChest.adjacentChestZPos != null) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
        }
        switch (meta) {
            case 2: {
                f = 180.0f;
                break;
            }
            case 4: {
                f = 90.0f;
                break;
            }
            case 5: {
                f = -90.0f;
                break;
            }
            default: {
                f = 0.0f;
            }
        }
        float rotation = f;
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float lidAngle = tileChest.prevLidAngle + (tileChest.lidAngle - tileChest.prevLidAngle) * partialTicks;
        if (tileChest.adjacentChestZNeg != null && (adjacentLidAngle = tileChest.adjacentChestZNeg.prevLidAngle + (tileChest.adjacentChestZNeg.lidAngle - tileChest.adjacentChestZNeg.prevLidAngle) * partialTicks) > lidAngle) {
            lidAngle = adjacentLidAngle;
        }
        if (tileChest.adjacentChestXNeg != null && (adjacentLidAngle = tileChest.adjacentChestXNeg.prevLidAngle + (tileChest.adjacentChestXNeg.lidAngle - tileChest.adjacentChestXNeg.prevLidAngle) * partialTicks) > lidAngle) {
            lidAngle = adjacentLidAngle;
        }
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        if (isLargeChest) {
            this.largeChestModel.field_78234_a.field_78795_f = -(lidAngle * (float)Math.PI / 4.0f);
            this.largeChestModel.renderAll(!tileChest.locked);
        } else {
            this.chestModel.field_78234_a.field_78795_f = -(lidAngle * (float)Math.PI / 4.0f);
            this.chestModel.renderAll(!tileChest.locked);
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

