/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.item.electric;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.GalaxySpace;
import galaxyspace.core.item.electric.ElectricItem;
import java.util.List;
import micdoodle8.mods.galacticraft.api.item.ElectricItemHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ItemElectricPickaxe
extends ItemPickaxe
implements ElectricItem {
    public float transferMax;
    private float maxPower;
    public static final IIcon[] ICONS = new IIcon[2];

    public ItemElectricPickaxe(String name, Item.ToolMaterial material, float maxPower) {
        super(material);
        this.func_77656_e(100);
        this.setNoRepair();
        this.setMaxTransfer();
        this.func_77655_b(name);
        this.maxPower = maxPower;
        this.func_77637_a(GalaxySpace.tabArmor);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        for (int i = 0; i < ICONS.length; ++i) {
            ItemElectricPickaxe.ICONS[i] = register.func_94245_a("galaxyspace:tools/" + this.func_77658_a() + "_" + i);
        }
    }

    public IIcon func_77617_a(int damage) {
        return damage == 100 ? ICONS[1] : ICONS[0];
    }

    protected void setMaxTransfer() {
        this.transferMax = 200.0f;
    }

    @Override
    public float getMaxTransfer() {
        return this.transferMax;
    }

    public float getMaxElectricityStored(ItemStack itemStack) {
        return this.maxPower;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (this.getElectricityStored(stack) == 0.0f) {
            return 0.1f;
        }
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            return this.field_77864_a;
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase targetEntity, EntityLivingBase attackingEntity) {
        if (this.getElectricityStored(stack) != 0.0f) {
            this.setElectricity(stack, this.getElectricityStored(stack) - 10.5f);
            return true;
        }
        return false;
    }

    public boolean func_150894_a(ItemStack stack, World worldIn, Block blockIn, int x, int y, int z, EntityLivingBase player) {
        if ((double)blockIn.func_149712_f(worldIn, x, y, z) != 0.0 && this.getElectricityStored(stack) != 0.0f) {
            this.setElectricity(stack, this.getElectricityStored(stack) - 10.0f);
        }
        return false;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (this.getElectricityStored(stack) != 0.0f) {
            return EnumAction.block;
        }
        return EnumAction.none;
    }

    public int func_77626_a(ItemStack stack) {
        if (this.getElectricityStored(stack) != 0.0f) {
            return 72000;
        }
        return 0;
    }

    public boolean func_82789_a(ItemStack stack1, ItemStack stack2) {
        return false;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> itemList) {
        itemList.add(ElectricItemHelper.getWithCharge((ItemStack)new ItemStack((Item)this), (float)this.getMaxElectricityStored(new ItemStack((Item)this))));
    }

    public void func_77624_a(ItemStack itemIn, EntityPlayer player, List<String> toolTip, boolean advancedItemTooltips) {
        this.addEnergyInformation(itemIn, player, toolTip, advancedItemTooltips);
    }

    public void func_77622_d(ItemStack item, World world, EntityPlayer player) {
        this.setElectricity(item, 0.0f);
    }
}

