/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.item.armor;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.Optional;
import galaxyspace.GalaxySpace;
import galaxyspace.core.item.IItemPressurized;
import galaxyspace.core.item.electric.ItemElectricArmor;
import galaxyspace.core.proxy.CommonProxy;
import galaxyspace.core.register.GSItems;
import gregtech.api.hazards.Hazard;
import gregtech.api.hazards.IHazardProtector;
import java.util.List;
import micdoodle8.mods.galacticraft.api.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="gregtech.api.hazards.IHazardProtector", modid="gregtech")})
public class ItemSpacesuitJetPlate
extends ItemElectricArmor
implements IItemPressurized,
IHazardProtector {
    public boolean active;

    public ItemSpacesuitJetPlate(ItemArmor.ArmorMaterial material, int renderIndex, int armorType, String assetSuffix) {
        super(material, renderIndex, armorType);
        this.func_77655_b(assetSuffix);
        this.func_111206_d("galaxyspace:armors/" + assetSuffix);
        this.func_77637_a(GalaxySpace.tabArmor);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (this.func_82812_d() == GSItems.SPACESUIT && stack.func_77973_b() == GSItems.SpacesuitJetPlate) {
            return "galaxyspace:textures/model/armor/spacesuit_plate.png";
        }
        return null;
    }

    @Override
    public void addEnergyInformation(ItemStack itemIn, EntityPlayer player, List<String> toolTip, boolean advancedItemTooltips) {
        String color = "";
        float joules = this.getElectricityStored(itemIn);
        color = joules <= this.getMaxElectricityStored(itemIn) / 3.0f ? "\u00a74" : (joules > this.getMaxElectricityStored(itemIn) * 2.0f / 3.0f ? "\u00a72" : "\u00a76");
        toolTip.add(color + EnergyDisplayHelper.getEnergyDisplayS((float)joules) + "/" + EnergyDisplayHelper.getEnergyDisplayS((float)this.getMaxElectricityStored(itemIn)));
        toolTip.addAll(FMLClientHandler.instance().getClient().field_71466_p.func_78271_c(GCCoreUtil.translate((String)"gui.spacesuit.desc"), 150));
        toolTip.addAll(FMLClientHandler.instance().getClient().field_71466_p.func_78271_c(EnumColor.DARK_GREEN + GCCoreUtil.translate((String)"gui.ssjetplate.desc"), 150));
    }

    public void use(ItemStack itemStack, double amount) {
        this.drainfromJetpack(itemStack, (int)amount);
        this.discharge(itemStack, 5.0f, true);
    }

    public boolean useJetpack(EntityPlayer player) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack jetpack = player.field_71071_by.field_70460_b[2];
        if ((double)this.getElectricityStored(jetpack) <= 0.0) {
            return false;
        }
        boolean electric = jetpack.func_77973_b() != GSItems.SpacesuitJetPlate;
        float power = 1.0f;
        float dropPercentage = 0.2f;
        if (electric) {
            power = 0.7f;
            dropPercentage = 0.05f;
        }
        if ((double)this.getElectricityStored(jetpack) / this.getMaxCharge(jetpack) <= (double)dropPercentage) {
            power *= (float)((double)this.getElectricityStored(jetpack) / (this.getMaxCharge(jetpack) * (double)dropPercentage));
        }
        if (mc.field_71474_y.field_74351_w.func_151470_d() && mc.field_71462_r == null) {
            float maxFlightHeight;
            float worldHeight = 0.15f;
            if (electric) {
                worldHeight += 0.15f;
            }
            if ((maxFlightHeight = power * worldHeight * 2.0f) > 0.0f) {
                player.func_70060_a(0.0f, 0.4f * maxFlightHeight, 0.02f);
            }
        }
        int worldHeight2 = CommonProxy.getWorldHeight(player.field_70170_p);
        double y = player.field_70163_u;
        int maxFlightHeight2 = electric ? (int)((float)worldHeight2 / 1.28f) : worldHeight2;
        if (y > (double)(maxFlightHeight2 - 25)) {
            if (y > (double)maxFlightHeight2) {
                y = maxFlightHeight2;
            }
            power *= (float)(((double)maxFlightHeight2 - y) / 25.0);
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (electric) {
            float consume = 0.0f;
            if (mc.field_71474_y.field_74314_A.func_151470_d() && mc.field_71462_r == null) {
                consume = electric ? 0.1f : 0.2f;
            }
            if (mc.field_71474_y.field_74311_E.func_151470_d() && mc.field_71462_r == null) {
                consume = electric ? -0.1f : -0.2f;
            }
            if (player.field_70181_x > (double)consume) {
                player.field_70181_x = consume;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        int consume2 = 2;
        if (electric) {
            consume2 += 6;
        }
        this.use(jetpack, consume2);
        player.field_70143_R = 1.0E-10f;
        player.field_70140_Q = 0.6f;
        GalaxySpace.proxy.resetPlayerInAirTime(player);
        return true;
    }

    public boolean drainfromJetpack(ItemStack pack, int amount) {
        return !ItemElectricArmor.isElectricItemEmpty(pack);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        Minecraft mc = Minecraft.func_71410_x();
        if (player.field_71071_by.field_70460_b[2] == itemStack) {
            boolean jetpackUsed = false;
            if (mc.field_71474_y.field_74314_A.func_151470_d() && mc.field_71462_r == null) {
                jetpackUsed = this.useJetpack(player);
            }
            if (jetpackUsed) {
                player.field_71069_bz.func_75142_b();
            }
        }
    }

    @Override
    public float getMaxElectricityStored(ItemStack theItem) {
        return 100000.0f;
    }

    @Override
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> itemList) {
        itemList.add(ElectricItemHelper.getWithCharge((ItemStack)new ItemStack((Item)this), (float)this.getMaxElectricityStored(new ItemStack((Item)this))));
    }

    @Optional.Method(modid="gregtech")
    public boolean protectsAgainst(ItemStack itemStack, Hazard hazard) {
        return true;
    }
}

