/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.world.dungeon;

import galaxyspace.core.world.dungeon.GSDungeonBoundingBox;
import galaxyspace.core.world.dungeon.GSMapGenDungeon;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class GSDungeonRoom {
    protected final GSMapGenDungeon dungeonInstance;
    protected final World worldObj;
    protected final int posX;
    protected final int posY;
    protected final int posZ;
    protected ForgeDirection entranceDir;

    public GSDungeonRoom(GSMapGenDungeon dungeon, int posX, int posY, int posZ, ForgeDirection entranceDir) {
        this.dungeonInstance = dungeon;
        this.worldObj = dungeon != null ? dungeon.worldObj : null;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.entranceDir = entranceDir;
    }

    public abstract void generate(Block[] var1, byte[] var2, int var3, int var4);

    public abstract GSDungeonBoundingBox getBoundingBox();

    protected abstract GSDungeonRoom makeRoom(GSMapGenDungeon var1, int var2, int var3, int var4, ForgeDirection var5);

    protected abstract void handleTileEntities(Random var1);

    public static GSDungeonRoom makeRoom(GSMapGenDungeon dungeon, Random rand, int x, int y, int z, ForgeDirection dir) {
        return dungeon.otherRooms.get(rand.nextInt(dungeon.otherRooms.size())).makeRoom(dungeon, x, y, z, dir);
    }

    public static GSDungeonRoom makeBossRoom(GSMapGenDungeon dungeon, Random rand, int x, int y, int z, ForgeDirection dir) {
        return dungeon.bossRooms.get(rand.nextInt(dungeon.bossRooms.size())).makeRoom(dungeon, x, y, z, dir);
    }

    public static GSDungeonRoom makeTreasureRoom(GSMapGenDungeon dungeon, Random rand, int x, int y, int z, ForgeDirection dir) {
        return dungeon.treasureRooms.get(rand.nextInt(dungeon.treasureRooms.size())).makeRoom(dungeon, x, y, z, dir);
    }

    protected boolean placeBlock(Block[] blocks, byte[] metas, int x, int y, int z, int cx, int cz, Block id, int meta) {
        if (GSMapGenDungeon.useArrays) {
            if ((x -= (cx *= 16)) < 0 || x >= 16 || (z -= (cz *= 16)) < 0 || z >= 16) {
                return false;
            }
            int index = this.getIndex(x, y, z);
            blocks[index] = id;
            metas[index] = (byte)meta;
        } else {
            this.worldObj.func_147465_d(x, y, z, id, meta, 0);
        }
        return true;
    }

    private int getIndex(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }
}

