/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.proxy;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import galaxyspace.BarnardsSystem.planets.barnardaC.tile.TileEntityBlockCrystalB;
import galaxyspace.BarnardsSystem.planets.barnardaC.tile.TileEntityBlockCrystalBTE;
import galaxyspace.GalaxySpace;
import galaxyspace.SolarSystem.moons.enceladus.tile.TileEntityBlockCrystall;
import galaxyspace.SolarSystem.moons.enceladus.tile.TileEntityBlockCrystallTE;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.entity.boss.EntityBlazeBoss;
import galaxyspace.core.entity.boss.EntityCrystalBoss;
import galaxyspace.core.entity.boss.EntityGhastBoss;
import galaxyspace.core.entity.boss.EntitySlimeBoss;
import galaxyspace.core.entity.boss.EntityWolfBoss;
import galaxyspace.core.entity.mob.EntityCrawler;
import galaxyspace.core.entity.mob.EntityEvolvedBlaze;
import galaxyspace.core.entity.mob.EntityEvolvedColdBlaze;
import galaxyspace.core.entity.mob.EntityEvolvedEnderman;
import galaxyspace.core.entity.mob.EntityEvolvedFireCreeper;
import galaxyspace.core.entity.mob.EntityEvolvedFireSkeleton;
import galaxyspace.core.entity.mob.EntityEvolvedFireSpider;
import galaxyspace.core.entity.mob.EntityEvolvedGuardian;
import galaxyspace.core.entity.mob.EntityTentacles;
import galaxyspace.core.entity.rocket.EntityTier4Rocket;
import galaxyspace.core.entity.rocket.EntityTier5Rocket;
import galaxyspace.core.entity.rocket.EntityTier6Rocket;
import galaxyspace.core.entity.rocket.EntityTier7Rocket;
import galaxyspace.core.entity.rocket.EntityTier8Rocket;
import galaxyspace.core.handler.GSClientEventHandler;
import galaxyspace.core.handler.GSColorRingClient;
import galaxyspace.core.handler.GSEffectHandler;
import galaxyspace.core.handler.GSPlanetFogHandler;
import galaxyspace.core.handler.GSSkyProviderHandler;
import galaxyspace.core.handler.GSSpaceSuitHandler;
import galaxyspace.core.model.entity.ModelEvolvedGuardian;
import galaxyspace.core.proxy.CommonProxy;
import galaxyspace.core.register.FluidTexturesGS;
import galaxyspace.core.register.GSBlocks;
import galaxyspace.core.register.GSItems;
import galaxyspace.core.render.block.BlockRendererTreasureChestGS;
import galaxyspace.core.render.entity.RenderRocket;
import galaxyspace.core.render.entity.boss.RenderBossBlaze;
import galaxyspace.core.render.entity.boss.RenderBossCrystal;
import galaxyspace.core.render.entity.boss.RenderBossGhast;
import galaxyspace.core.render.entity.boss.RenderBossSlime;
import galaxyspace.core.render.entity.boss.RenderBossWolf;
import galaxyspace.core.render.entity.mob.RenderCrawler;
import galaxyspace.core.render.entity.mob.RenderEvolvedBlaze;
import galaxyspace.core.render.entity.mob.RenderEvolvedColdBlaze;
import galaxyspace.core.render.entity.mob.RenderEvolvedEnderman;
import galaxyspace.core.render.entity.mob.RenderEvolvedFireCreeper;
import galaxyspace.core.render.entity.mob.RenderEvolvedFireSkeleton;
import galaxyspace.core.render.entity.mob.RenderEvolvedFireSpider;
import galaxyspace.core.render.entity.mob.RenderEvolvedGuardian;
import galaxyspace.core.render.entity.mob.RenderTentacles;
import galaxyspace.core.render.item.ItemRenderBow;
import galaxyspace.core.render.item.ItemRendererJetPack;
import galaxyspace.core.render.item.ItemRendererRocket;
import galaxyspace.core.render.item.ItemRendererThermalPaddingT2;
import galaxyspace.core.render.tile.TileEntitySolarPanelRenderer;
import galaxyspace.core.render.tile.TileEntitySolarWindPanelRenderer;
import galaxyspace.core.render.tile.TileEntityTreasureChestRendererGS;
import galaxyspace.core.tile.chest.TileEntityTreasureChestT4;
import galaxyspace.core.tile.chest.TileEntityTreasureChestT5;
import galaxyspace.core.tile.chest.TileEntityTreasureChestT6;
import galaxyspace.core.tile.chest.TileEntityTreasureChestT7;
import galaxyspace.core.tile.chest.TileEntityTreasureChestT8;
import galaxyspace.core.tile.machine.TileEntitySolarPanel;
import galaxyspace.core.tile.machine.TileEntitySolarWind;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.client.render.block.BlockRendererMachine;
import micdoodle8.mods.galacticraft.core.client.render.item.ItemRendererKey;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    public static final Map<String, String> CAPES_NAME2URL = new HashMap<String, String>();
    public static final Map<String, ResourceLocation> CAPES_URL2TEXTURE = new HashMap<String, ResourceLocation>();
    private static int ceresMachineRenderID;
    private static int geothermalGeneratorRenderID;
    private static int fuelGeneratorRenderID;
    private static int solarWindPanelRenderID;
    private static int convertersurfaceRenderID;
    private static int storagemoduleRenderID;
    private static int oxstoragemoduleRenderID;
    private static int solarPanelRenderID;
    private static int ceresTreasureChestRenderID;
    private static int ioTreasureChestRenderID;
    private static int enceladusTreasureChestRenderID;
    private static int proteusTreasureChestRenderID;
    private static int plutoTreasureChestRenderID;
    private static int renderIndexJetpackArmor;
    private static int renderIndexLeadArmor;

    @Override
    public void preload() {
        FMLCommonHandler.instance().bus().register((Object)new GSSkyProviderHandler());
        this.registerEventHandler(new GSClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new GSPlanetFogHandler());
        MinecraftForge.EVENT_BUS.register((Object)new GSColorRingClient());
        MinecraftForge.EVENT_BUS.register((Object)new GSSpaceSuitHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FluidTexturesGS());
        renderIndexJetpackArmor = RenderingRegistry.addNewArmourRendererPrefix((String)"Jetpack");
        renderIndexLeadArmor = RenderingRegistry.addNewArmourRendererPrefix((String)"Lead");
        if (GSConfigCore.enableCapes) {
            ClientProxy.setupCapes();
        }
    }

    @Override
    public void load() {
        ClientProxy.registerEntityRenderers();
        ClientProxy.registerItemRenderers();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTreasureChestT4.class, (TileEntitySpecialRenderer)new TileEntityTreasureChestRendererGS("ceresTreasureChest", "ceresLargeTreasureChest"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTreasureChestT5.class, (TileEntitySpecialRenderer)new TileEntityTreasureChestRendererGS("ioTreasureChest", "ioLargeTreasureChest"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTreasureChestT6.class, (TileEntitySpecialRenderer)new TileEntityTreasureChestRendererGS("enceladusTreasureChest", "enceladusLargeTreasureChest"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTreasureChestT7.class, (TileEntitySpecialRenderer)new TileEntityTreasureChestRendererGS("proteusTreasureChest", "proteusLargeTreasureChest"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTreasureChestT8.class, (TileEntitySpecialRenderer)new TileEntityTreasureChestRendererGS("plutoTreasureChest", "plutoLargeTreasureChest"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySolarWind.class, (TileEntitySpecialRenderer)new TileEntitySolarWindPanelRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySolarPanel.class, (TileEntitySpecialRenderer)new TileEntitySolarPanelRenderer());
    }

    @Override
    public void spawnParticle(String particleID, Vector3 position, Vector3 motion, Object ... otherInfo) {
        GSEffectHandler.spawnParticle(particleID, position, motion, otherInfo);
    }

    public static void registerEntityRenderers() {
        ceresMachineRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(ceresMachineRenderID));
        storagemoduleRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(storagemoduleRenderID));
        geothermalGeneratorRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(geothermalGeneratorRenderID));
        fuelGeneratorRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(fuelGeneratorRenderID));
        solarWindPanelRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(solarWindPanelRenderID));
        convertersurfaceRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(convertersurfaceRenderID));
        oxstoragemoduleRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(oxstoragemoduleRenderID));
        solarPanelRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(solarPanelRenderID));
        ceresTreasureChestRenderID = RenderingRegistry.getNextAvailableRenderId();
        ioTreasureChestRenderID = RenderingRegistry.getNextAvailableRenderId();
        enceladusTreasureChestRenderID = RenderingRegistry.getNextAvailableRenderId();
        proteusTreasureChestRenderID = RenderingRegistry.getNextAvailableRenderId();
        plutoTreasureChestRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererTreasureChestGS(ceresTreasureChestRenderID, GSBlocks.CeresTChestT4));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererTreasureChestGS(ioTreasureChestRenderID, GSBlocks.IoTChestT5));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererTreasureChestGS(enceladusTreasureChestRenderID, GSBlocks.EnceladusTChestT6));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererTreasureChestGS(proteusTreasureChestRenderID, GSBlocks.ProteusTChestT7));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererTreasureChestGS(plutoTreasureChestRenderID, GSBlocks.PlutoTChestT8));
        RenderingRegistry.registerEntityRenderingHandler(EntityBlazeBoss.class, (Render)new RenderBossBlaze());
        RenderingRegistry.registerEntityRenderingHandler(EntityGhastBoss.class, (Render)new RenderBossGhast());
        RenderingRegistry.registerEntityRenderingHandler(EntityCrystalBoss.class, (Render)new RenderBossCrystal());
        RenderingRegistry.registerEntityRenderingHandler(EntitySlimeBoss.class, (Render)new RenderBossSlime((ModelBase)new ModelSlime(16), (ModelBase)new ModelSlime(0)));
        RenderingRegistry.registerEntityRenderingHandler(EntityWolfBoss.class, (Render)new RenderBossWolf());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedFireCreeper.class, (Render)new RenderEvolvedFireCreeper());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedFireSkeleton.class, (Render)new RenderEvolvedFireSkeleton());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedFireSpider.class, (Render)new RenderEvolvedFireSpider());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedEnderman.class, (Render)new RenderEvolvedEnderman());
        if (GSConfigCore.enableBarnarda) {
            RenderingRegistry.registerEntityRenderingHandler(EntityTentacles.class, (Render)new RenderTentacles());
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedColdBlaze.class, (Render)new RenderEvolvedColdBlaze());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedGuardian.class, (Render)new RenderEvolvedGuardian(new ModelEvolvedGuardian(), 1.0f));
        if (GSConfigCore.enableBarnarda) {
            RenderingRegistry.registerEntityRenderingHandler(EntityCrawler.class, (Render)new RenderCrawler());
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedBlaze.class, (Render)new RenderEvolvedBlaze());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBlockCrystallTE.class, (TileEntitySpecialRenderer)new TileEntityBlockCrystall());
        if (GSConfigCore.enableBarnarda) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBlockCrystalBTE.class, (TileEntitySpecialRenderer)new TileEntityBlockCrystalB());
        }
    }

    public static void registerItemRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityTier4Rocket.class, (Render)new RenderRocket(4, 2.2));
        RenderingRegistry.registerEntityRenderingHandler(EntityTier5Rocket.class, (Render)new RenderRocket(5, 1.7));
        RenderingRegistry.registerEntityRenderingHandler(EntityTier6Rocket.class, (Render)new RenderRocket(6, 1.5));
        RenderingRegistry.registerEntityRenderingHandler(EntityTier7Rocket.class, (Render)new RenderRocket(7, 1.8));
        RenderingRegistry.registerEntityRenderingHandler(EntityTier8Rocket.class, (Render)new RenderRocket(8, 2.0));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier4Rocket, (IItemRenderer)new ItemRendererRocket(4, EntityTier4Rocket.class, -0.8f, -8.2f, 8.5f, 5.9f, 0.5f, 0.5f));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier4Key, (IItemRenderer)new ItemRendererKey(new ResourceLocation("galaxyspace", "textures/model/ceresTreasureChest.png")));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier5Rocket, (IItemRenderer)new ItemRendererRocket(5, EntityTier5Rocket.class, -0.8f, -9.2f, 8.5f, 7.2f, 0.4f, 0.5f));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier5Key, (IItemRenderer)new ItemRendererKey(new ResourceLocation("galaxyspace", "textures/model/ioTreasureChest.png")));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier6Rocket, (IItemRenderer)new ItemRendererRocket(6, EntityTier6Rocket.class, -0.8f, -8.2f, 2.5f, 6.9f, 0.4f, 0.5f));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier6Key, (IItemRenderer)new ItemRendererKey(new ResourceLocation("galaxyspace", "textures/model/enceladusTreasureChest.png")));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier7Rocket, (IItemRenderer)new ItemRendererRocket(7, EntityTier7Rocket.class, -1.2f, -8.2f, 2.5f, 6.9f, 0.4f, 0.5f));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier7Key, (IItemRenderer)new ItemRendererKey(new ResourceLocation("galaxyspace", "textures/model/proteusTreasureChest.png")));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier8Key, (IItemRenderer)new ItemRendererKey(new ResourceLocation("galaxyspace", "textures/model/plutoTreasureChest.png")));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier8Rocket, (IItemRenderer)new ItemRendererRocket(8, EntityTier8Rocket.class, -0.8f, -8.2f, 8.5f, 5.9f, 0.4f, 0.4f));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.ThermalPaddingTier2, (IItemRenderer)new ItemRendererThermalPaddingT2());
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.JetPack, (IItemRenderer)new ItemRendererJetPack());
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.QuantBow, (IItemRenderer)new ItemRenderBow());
    }

    @Override
    public int getBlockRender(Block block) {
        if (block == GSBlocks.AssemblyMachine) {
            return ceresMachineRenderID;
        }
        if (block == GSBlocks.GeothermalGenerator) {
            return geothermalGeneratorRenderID;
        }
        if (block == GSBlocks.StorageModuleT3) {
            return storagemoduleRenderID;
        }
        if (block == GSBlocks.FuelGenerator) {
            return fuelGeneratorRenderID;
        }
        if (block == GSBlocks.SolarWindPanel) {
            return solarWindPanelRenderID;
        }
        if (block == GSBlocks.ConverterSurface) {
            return convertersurfaceRenderID;
        }
        if (block == GSBlocks.CeresTChestT4) {
            return ceresTreasureChestRenderID;
        }
        if (block == GSBlocks.IoTChestT5) {
            return ioTreasureChestRenderID;
        }
        if (block == GSBlocks.EnceladusTChestT6) {
            return enceladusTreasureChestRenderID;
        }
        if (block == GSBlocks.ProteusTChestT7) {
            return proteusTreasureChestRenderID;
        }
        if (block == GSBlocks.PlutoTChestT8) {
            return plutoTreasureChestRenderID;
        }
        if (block == GSBlocks.OxStorageModuleT2) {
            return oxstoragemoduleRenderID;
        }
        if (block == GSBlocks.SolarPanel) {
            return solarPanelRenderID;
        }
        return -1;
    }

    @Override
    public int getJetpackArmorRenderIndex() {
        return renderIndexJetpackArmor;
    }

    @Override
    public int getLeadArmorRenderIndex() {
        return renderIndexLeadArmor;
    }

    public static void setupCapes() {
        try {
            ClientProxy.updateCapeList();
        }
        catch (Exception e) {
            GalaxySpace.LOGGER.error("Error while setting up Galaxy Space capes/skins", (Throwable)e);
        }
    }

    private static void updateCapeList() {
        URLConnection connection;
        int timeout = 10000;
        try {
            connection = new URL("https://demigods.at.ua/capes.txt").openConnection();
        }
        catch (Exception e) {
            GalaxySpace.LOGGER.error("Error getting capes list", (Throwable)e);
            return;
        }
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(":")) continue;
                int splitLocation = line.indexOf(":");
                String username = line.substring(0, splitLocation);
                String capeUrl = "https://raw.githubusercontent.com/BlesseNtumble/GalaxySpace/master/capes/" + line.substring(splitLocation + 1) + ".png";
                CAPES_NAME2URL.put(username, capeUrl);
            }
        }
        catch (IOException e) {
            GalaxySpace.LOGGER.error("Error reading line", (Throwable)e);
        }
    }

    public static int getWorldHeight(World world) {
        return world.func_72800_K();
    }
}

