/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class RocketRecipeHandler
extends TemplateRecipeHandler {
    private Set<Pair<List<PositionedStack>, PositionedStack>> recipes = new HashSet<Pair<List<PositionedStack>, PositionedStack>>();
    private final String textureSuffix;
    private final ResourceLocation guiTexture;
    private final int tier;
    final int y;
    private final int h;

    public RocketRecipeHandler(int tier, String textureSuffix, int y, int h) {
        this.textureSuffix = textureSuffix;
        this.guiTexture = new ResourceLocation("galaxyspace", "textures/gui/schematic_rocket_GS1_T" + tier + textureSuffix + ".png");
        this.tier = tier;
        this.y = y;
        this.h = h;
    }

    public RocketRecipeHandler(int tier, int y, int h) {
        this(tier, "", y, h);
    }

    void addRecipe(List<PositionedStack> inputs, PositionedStack output) {
        this.recipes.add((Pair<List<PositionedStack>, PositionedStack>)Pair.of(inputs, (Object)output));
    }

    private String getRecipeId() {
        return "galacticraft.rocketT" + this.tier;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)this.guiTexture);
        GuiDraw.drawTexturedModalRect((int)-1, (int)this.y, (int)3, (int)4, (int)168, (int)this.h);
    }

    public void drawForeground(int recipe) {
    }

    public String getGuiTexture() {
        return this.guiTexture.toString();
    }

    public String getHandlerId() {
        return "galaxyspace.core.nei.rocket.RocketT" + this.tier + "RecipeHandler";
    }

    public String getRecipeName() {
        return EnumChatFormatting.BLUE + "NASA Workbench";
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Pair<List<PositionedStack>, PositionedStack> recipe : this.recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((PositionedStack)recipe.getValue()).item, (ItemStack)result)) continue;
            this.arecipes.add(new CachedRocketRecipe(recipe));
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Pair<List<PositionedStack>, PositionedStack> recipe : this.recipes) {
                this.arecipes.add(new CachedRocketRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Pair<List<PositionedStack>, PositionedStack> recipe : this.recipes) {
            for (PositionedStack input : (List)recipe.getKey()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)input.item)) continue;
                this.arecipes.add(new CachedRocketRecipe(recipe));
            }
        }
    }

    public TemplateRecipeHandler newInstance() {
        RocketRecipeHandler recipeHandler = new RocketRecipeHandler(this.tier, this.textureSuffix, this.y, this.h);
        recipeHandler.recipes = this.recipes;
        return recipeHandler;
    }

    public int recipiesPerPage() {
        return 1;
    }

    private class CachedRocketRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> input;
        private final PositionedStack output;

        private CachedRocketRecipe(List<PositionedStack> input, PositionedStack output) {
            super((TemplateRecipeHandler)RocketRecipeHandler.this);
            this.input = input;
            this.output = output;
        }

        private CachedRocketRecipe(Pair<List<PositionedStack>, PositionedStack> recipe) {
            this((List)recipe.getLeft(), (PositionedStack)recipe.getRight());
        }

        public List<PositionedStack> getIngredients() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

