/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.handler;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import galaxyspace.ACentauriSystem.ACentauriPlanets;
import galaxyspace.BarnardsSystem.BarnardsPlanets;
import galaxyspace.SolarSystem.SolarSystemPlanets;
import galaxyspace.TCetiSystem.TCetiPlanets;
import galaxyspace.VegaSystem.VegaPlanets;
import galaxyspace.core.proxy.ClientProxy;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.client.render.ThreadDownloadImageDataGC;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class GSColorRingClient {
    private static final ResourceLocation SATURN_RING_TEXTURE = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/saturnRings.png");
    private static final ResourceLocation URANUS_RING_TEXTURE = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/uranusRings.png");
    private static final ResourceLocation BARNARDA_RING_TEXTURE = new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/barnardaRings.png");
    private static final ResourceLocation BARNARDA_RING_TEXTURE_2 = new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/barnardaRings2.png");
    private final Minecraft minecraft = FMLClientHandler.instance().getClient();

    @SubscribeEvent
    public void onRingRender(CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre renderEvent) {
        if (renderEvent.celestialBody.equals((Object)SolarSystemPlanets.planetKuiperBelt) || renderEvent.celestialBody.equals((Object)BarnardsPlanets.planetBarnardaAsteroids) || renderEvent.celestialBody.equals((Object)VegaPlanets.planetVegaasteroids2) || renderEvent.celestialBody.getRingColorR() == 1.1f) {
            this.renderRing(renderEvent, renderEvent.celestialBody, 0.7f, 0.0f, 0.0f);
        }
        if (renderEvent.celestialBody.equals((Object)VegaPlanets.planetVegaasteroids)) {
            this.renderRing(renderEvent, renderEvent.celestialBody, 0.7f, 0.0f, 0.0f);
        }
        if (renderEvent.celestialBody.equals((Object)GalacticraftCore.planetOverworld) || renderEvent.celestialBody.equals((Object)BarnardsPlanets.planetBarnarda2) || renderEvent.celestialBody.getRingColorG() == 1.1f) {
            this.renderRing(renderEvent, renderEvent.celestialBody, 0.0f, 0.7f, 0.0f);
        }
        if (renderEvent.celestialBody.equals((Object)ACentauriPlanets.centauriB) || renderEvent.celestialBody.equals((Object)ACentauriPlanets.proxima) || renderEvent.celestialBody.getRingColorR() == 0.0f) {
            renderEvent.setCanceled(true);
        }
    }

    private void renderRing(CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre renderEvent, CelestialBody aroundBody, float r, float g, float b) {
        float temp;
        int i;
        float max;
        float min;
        Vector3f mapPos = renderEvent.parentOffset;
        float xOffset = mapPos.x;
        float yOffset = mapPos.y;
        if (FMLClientHandler.instance().getClient().field_71462_r instanceof GuiCelestialSelection) {
            GL11.glColor4f((float)r, (float)g, (float)b, (float)0.5f);
        } else {
            GL11.glColor4f((float)0.3f, (float)0.1f, (float)0.1f, (float)1.0f);
        }
        renderEvent.setCanceled(true);
        GL11.glBegin((int)2);
        float cos = (float)Math.cos(0.06981316953897476);
        float sin = (float)Math.sin(0.06981316953897476);
        if (aroundBody instanceof Moon) {
            min = 0.5263158f;
            max = 0.6666667f;
        } else {
            min = 72.0f;
            max = 78.0f;
        }
        float x = max * renderEvent.celestialBody.getRelativeDistanceFromCenter().unScaledDistance;
        float y = 0.0f;
        for (i = 0; i < 90; ++i) {
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
        }
        GL11.glEnd();
        GL11.glBegin((int)2);
        x = min * renderEvent.celestialBody.getRelativeDistanceFromCenter().scaledDistance;
        y = 0.0f;
        for (i = 0; i < 90; ++i) {
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
        }
        GL11.glEnd();
        GL11.glColor4f((float)r, (float)g, (float)b, (float)0.1f);
        GL11.glBegin((int)7);
        x = min * renderEvent.celestialBody.getRelativeDistanceFromCenter().scaledDistance;
        y = 0.0f;
        float x2 = max * renderEvent.celestialBody.getRelativeDistanceFromCenter().unScaledDistance;
        float y2 = 0.0f;
        for (int j = 0; j < 90; ++j) {
            GL11.glVertex2f((float)(x2 + xOffset), (float)(y2 + yOffset));
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            float temp2 = x;
            x = cos * x - sin * y;
            y = sin * temp2 + cos * y;
            temp2 = x2;
            x2 = cos * x2 - sin * y2;
            y2 = sin * temp2 + cos * y2;
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            GL11.glVertex2f((float)(x2 + xOffset), (float)(y2 + yOffset));
        }
        GL11.glEnd();
    }

    @SubscribeEvent
    public void onBodyRender(CelestialBodyRenderEvent.Pre renderEvent) {
        if (renderEvent.celestialBody.equals((Object)SolarSystemPlanets.planetKuiperBelt) || renderEvent.celestialBody.equals((Object)VegaPlanets.planetVegaasteroids) || renderEvent.celestialBody.equals((Object)BarnardsPlanets.planetBarnardaAsteroids) || renderEvent.celestialBody.equals((Object)VegaPlanets.planetVegaasteroids2) || renderEvent.celestialBody.equals((Object)TCetiPlanets.tcetiAsteroids)) {
            GL11.glRotatef((float)((float)Sys.getTime() / 10.0f % 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    @SubscribeEvent
    public void onRenderPlanetPost(CelestialBodyRenderEvent.Post event) {
        GuiScreen guiScreen = this.minecraft.field_71462_r;
        if (guiScreen instanceof GuiCelestialSelection) {
            GuiCelestialSelection gui = (GuiCelestialSelection)guiScreen;
            float size = (float)GuiCelestialSelection.getWidthForCelestialBodyStatic((CelestialBody)event.celestialBody) / 6.0f;
            if (event.celestialBody == SolarSystemPlanets.planetSaturn) {
                this.minecraft.field_71446_o.func_110577_a(SATURN_RING_TEXTURE);
                gui.drawTexturedModalRect(-7.5f * size, -1.75f * size, 15.0f * size, 3.5f * size, 0.0f, 0.0f, 30.0f, 7.0f, false, false, 30.0f, 7.0f);
            } else if (event.celestialBody == SolarSystemPlanets.planetUranus) {
                this.minecraft.field_71446_o.func_110577_a(URANUS_RING_TEXTURE);
                gui.drawTexturedModalRect(-1.75f * size, -7.0f * size, 3.5f * size, 14.0f * size, 0.0f, 0.0f, 28.0f, 7.0f, false, false, 28.0f, 7.0f);
            } else if (event.celestialBody == BarnardsPlanets.planetBarnarda5) {
                GL11.glEnable((int)3042);
                this.minecraft.field_71446_o.func_110577_a(BARNARDA_RING_TEXTURE);
                gui.drawTexturedModalRect(-11.0f * size, -1.75f * size, 22.0f * size, 3.5f * size, 0.0f, 0.0f, 32.0f, 7.0f, false, false, 32.0f, 7.0f);
            } else if (event.celestialBody == BarnardsPlanets.planetBarnarda6) {
                GL11.glEnable((int)3042);
                this.minecraft.field_71446_o.func_110577_a(BARNARDA_RING_TEXTURE_2);
                gui.drawTexturedModalRect(-11.4f * size, -1.75f * size, 23.4f * size, 3.5f * size, 0.0f, 0.0f, 32.0f, 7.0f, false, false, 32.0f, 7.0f);
            }
        }
    }

    @SubscribeEvent
    public void onPostRender(RenderPlayerEvent.Specials.Post event) {
        AbstractClientPlayer player = (AbstractClientPlayer)event.entityPlayer;
        boolean flag = ClientProxy.CAPES_NAME2URL.containsKey(event.entityPlayer.func_70005_c_());
        if (flag && !player.func_82150_aj() && !player.func_82238_cc()) {
            String url = ClientProxy.CAPES_NAME2URL.get(player.func_70005_c_());
            ResourceLocation capeLoc = ClientProxy.CAPES_URL2TEXTURE.get(url);
            if (!ClientProxy.CAPES_URL2TEXTURE.containsKey(url)) {
                try {
                    String dirName = Minecraft.func_71410_x().field_71412_D.getAbsolutePath();
                    File directory = new File(dirName, "assets");
                    boolean success = true;
                    if (!directory.exists()) {
                        success = directory.mkdir();
                    }
                    if (success) {
                        if (!(directory = new File(directory, "gcCapes")).exists()) {
                            success = directory.mkdir();
                        }
                        if (success) {
                            String hash = String.valueOf(player.func_70005_c_().hashCode());
                            File file1 = new File(directory, hash.substring(0, 2));
                            File file2 = new File(file1, hash);
                            ResourceLocation resourcelocation = new ResourceLocation("gcCapes/" + hash);
                            ThreadDownloadImageDataGC threaddownloadimagedata = new ThreadDownloadImageDataGC(file2, url, (ResourceLocation)null, new IImageBuffer(){

                                public BufferedImage func_78432_a(BufferedImage p_78432_1_) {
                                    if (p_78432_1_ == null) {
                                        return null;
                                    }
                                    BufferedImage bufferedimage1 = new BufferedImage(512, 256, 2);
                                    Graphics graphics = bufferedimage1.getGraphics();
                                    graphics.drawImage(p_78432_1_, 0, 0, null);
                                    graphics.dispose();
                                    return bufferedimage1;
                                }

                                public void func_152634_a() {
                                }
                            });
                            if (this.minecraft.func_110434_K().func_110579_a(resourcelocation, (ITextureObject)threaddownloadimagedata)) {
                                capeLoc = resourcelocation;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ClientProxy.CAPES_URL2TEXTURE.put(url, capeLoc);
            }
            if (capeLoc != null) {
                this.minecraft.func_110434_K().func_110577_a(capeLoc);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
                double d3 = player.field_71091_bM + (player.field_71094_bP - player.field_71091_bM) * (double)event.partialRenderTick - (player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.partialRenderTick);
                double d4 = player.field_71096_bN + (player.field_71095_bQ - player.field_71096_bN) * (double)event.partialRenderTick - (player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.partialRenderTick);
                double d5 = player.field_71097_bO + (player.field_71085_bR - player.field_71097_bO) * (double)event.partialRenderTick - (player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.partialRenderTick);
                float f4 = (player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * event.partialRenderTick) / 57.295776f;
                double d6 = MathHelper.func_76126_a((float)f4);
                double d7 = -MathHelper.func_76134_b((float)f4);
                float f5 = (float)d4 * 10.0f;
                if (f5 < -6.0f) {
                    f5 = -6.0f;
                }
                if (f5 > 32.0f) {
                    f5 = 32.0f;
                }
                float f6 = (float)(d3 * d6 + d5 * d7) * 100.0f;
                float f7 = (float)(d3 * d7 - d5 * d6) * 100.0f;
                if (f6 < 0.0f) {
                    f6 = 0.0f;
                }
                float f8 = player.field_71107_bF + (player.field_71109_bG - player.field_71107_bF) * event.partialRenderTick;
                f5 += MathHelper.func_76126_a((float)((player.field_70141_P + (player.field_70140_Q - player.field_70141_P) * event.partialRenderTick) * 6.0f)) * 32.0f * f8;
                if (player.func_70093_af()) {
                    f5 += 25.0f;
                }
                GL11.glRotatef((float)(6.0f + f6 / 2.0f + f5), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(f7 / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(-f7 / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                event.renderer.field_77109_a.func_78111_c(0.0625f);
                GL11.glPopMatrix();
            }
        }
    }
}

